<?php
/*
 * Este arquivo cria o modal que tem como objetivo a edição de um registro de
 * agendamento do google apps.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_gsuite == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}
?>
<script>
function valida_cpf(cpf){var numeros, digitos, soma, i, resultado, digitos_iguais;digitos_iguais = 1;cpf = cpf.replace('.', '');cpf = cpf.replace('.', '');cpf = cpf.replace('-', '');if (cpf.length < 11)return false;for (i = 0; i < cpf.length - 1; i++)if (cpf.charAt(i) != cpf.charAt(i + 1)){digitos_iguais = 0;break;}if (!digitos_iguais){numeros = cpf.substring(0,9);digitos = cpf.substring(9);soma = 0;for (i = 10; i > 1; i--)soma += numeros.charAt(10 - i) * i;resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;if (resultado != digitos.charAt(0))return false;numeros = cpf.substring(0,10);soma = 0;for (i = 11; i > 1; i--)soma += numeros.charAt(11 - i) * i;resultado = soma % 11 < 2 ? 0 : 11 - soma % 11;if (resultado != digitos.charAt(1))return false;return true;}else return false;}
function valida_cnpj(a){if(a=a.replace(/[^\d]+/g,""),""==a)return!1;if(14!=a.length)return!1;if("00000000000000"==a||"11111111111111"==a||"22222222222222"==a||"33333333333333"==a||"44444444444444"==a||"55555555555555"==a||"66666666666666"==a||"77777777777777"==a||"88888888888888"==a||"99999999999999"==a)return!1;for(tamanho=a.length-2,numeros=a.substring(0,tamanho),digitos=a.substring(tamanho),soma=0,pos=tamanho-7,i=tamanho;i>=1;i--)soma+=numeros.charAt(tamanho-i)*pos--,pos<2&&(pos=9);if(resultado=soma%11<2?0:11-soma%11,resultado!=digitos.charAt(0))return!1;for(tamanho+=1,numeros=a.substring(0,tamanho),soma=0,pos=tamanho-7,i=tamanho;i>=1;i--)soma+=numeros.charAt(tamanho-i)*pos--,pos<2&&(pos=9);return resultado=soma%11<2?0:11-soma%11,resultado==digitos.charAt(1)}

function validarForm(){
	var cpf = $('#cpf').val().replace(/[^\d]+/g,"");
	if(cpf.length <= 11){
		if(valida_cpf($('#cpf').val())){
			return true;
		}
		else{
			toastr.clear(); toastr.error("CPF Inválido"); return;
			return false;
		}
	}
	else{
		if(valida_cnpj($('#cpf').val())){
			return true;
		}
		else{
			toastr.clear(); toastr.error("CNPJ Inválido"); return;
			return false;
		}
	}
}

function salvarDados(){
	if(!validarForm()){
		return;
	}
	var dados = jQuery('#formDados').serialize()+"&id=<?php echo $_POST['id']; ?>";
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_novo_agendamento_gsuite",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				adicionar_linhas(JSON.parse(data));
				toastr.clear(); toastr.success("Agendamento criado com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao salvar."); return;
			}
		});
	});
}
$(document).ready(function(){
	$('#formDados').submit(function(){
		salvarDados();
		return false;
	})
});
</script>

<form name="formDados" action="" method="POST" id="formDados">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Adicionar Agendamento</b></h4>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12 col-md-4">
				<div class="form-group">
					<div class="checkbox">
						<label>
							<input type="checkbox" name="ativado" id="ativado" value="Sim" checked="checked" >
							Ativar Agendamento
						</label>
					</div>
				</div>
			</div>
			<div class="col-xs-12 col-md-8">
				<div class="form-group">
					<div class="checkbox">
						<label>
							<input type="checkbox" name="taxa30mensal" id="taxa30mensal" value="Sim" title="Taxa aplicada apenas nos planos em reais" >
							Ativar taxa 30% mensal (planos em R$)
						</label>
					</div>
				</div>
			</div>
		</div>

		<div class="row">
			<div class="col-xs-12 col-md-5"><div class="form-group">
				<label>Nome:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="nome" name="nome" alt="Nome" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Email:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
					<input type="text" class="form-control pull-right"  id="email" name="email" alt="Email" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Telefone:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-phone"></i></div>
					<input type="text" class="form-control pull-right"  id="telefone" name="telefone" alt="Telefone" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-md-7">
				<div class="row">
					<div class="col-xs-12 col-sm-6 col-md-6"><div class="form-group">
						<label>CPF/CNPJ:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-lock"></i></div>
							<input type="text" class="form-control pull-right"  id="cpf" name="cpf" alt="CPF/CNPJ" onkeydown='mascaraMutuario(this,cpfCnpj)' onchange='mascaraMutuario(this,cpfCnpj)' required/>
						</div>
					</div></div>

					<div class="col-xs-12 col-sm-6 col-md-6"><div class="form-group">
						<label>Quantidade:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-plus"></i></div>
							<input type="number" class="form-control pull-right"id="quantidade" name="quantidade" alt="Quantidade" value="1" min="1" required/>
						</div>
					</div></div>

					<div class="col-xs-12 col-sm-6 col-md-6"><div class="form-group">
						<label>Pagamento:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-cog"></i></div>
							<select name="tipo" id="tipo" class="form-control pull-right">
								<option value="Mensal">Mensal</option>
								<option value="Anual">Anual</option>
							</select>
						</div>
					</div></div>

					<div class="col-xs-12 col-sm-6 col-md-6"><div class="form-group">
						<label>Venc. (DD/MM):</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
							<input type="text" class="form-control pull-right"  id="vencimento" name="vencimento" alt="Data de Vencimento" placeholder="apenas dias entre 1-28" required/>
						</div>
							<!-- <label for="">Apenas do dia 0-28</label> -->
					</div></div>
				</div>
			</div>

			<div class="col-xs-12 col-md-5">
				<div class="form-group">
					<label>Anotações:</label>
					<textarea name="anotacoes" id="anotacoes" class="form-control" rows="5"></textarea>
				</div>
			</div>

			<div class="col-xs-12 col-sm-3 col-md-3">
				<div class="form-group">
					<label>Moeda:</label>
					<div class="form-group" style="margin-top: -13px;">
						<div class="radio">
							<label>
								<input type="radio" name="moeda" value="real" checked="checked">
								Real&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
							</label>
							<label>
								<input type="radio" name="moeda" value="dolar" >
								Dólar&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
							</label>
						</div>
					</div>
				</div>
			</div>

			<div class="col-xs-12 col-sm-3 col-md-3">
				<div class="form-group">
					<label>Valor:</label>
					<div class="input-group">
						<div class="input-group-addon custom-padding" ><i class="iconeDolar flagBrazil"></i></div>
						<input type="text" class="form-control pull-right dinheiro"  id="valor" name="valor" alt="Valor" value="0,00" required/>
					</div>
				</div>
			</div>

			<div class="col-xs-12 col-sm-6 col-md-6"><div class="form-group">
				<label>Plano (SKU):</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-cog"></i></div>
					<select name="plano" id="plano" class="form-control pull-right" required>
						<option value="Basic" selected>Basic (até 15/Jan/2021)</option>
						<option value="Business">Business (até 15/Jan/2021)</option>
						<option value="Business Starter">Business Starter ("novo basic")</option>
						<option value="Business Standard">Business Standard ("novo business")</option>
						<option value="Business Plus">Business Plus</option>
						<!-- <option value="Enterprise">Enterprise</option> -->
						<option value="Personalizado">Personalizado</option>
					</select>
				</div>
			</div></div>

		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<button type="submit" name="action" class="btn btn-primary">Criar Agendamento</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>
<script>
var maskBehavior = function (val) {
	return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
},
options = {onKeyPress: function(val, e, field, options) {
	field.mask(maskBehavior.apply({}, arguments), options);}
};
$(document).ready(function(){
	$('#telefone').mask(maskBehavior, options);
	$('#vencimento').mask("00/00");
	$('#quantidade').mask("0000");
	$('.dinheiro').mask('000.000.000.000.000,00', {reverse: true});
});

mascaraMutuario(document.getElementById("cpf"), cpfCnpj);

function mascaraMutuario(o,f){
	v_obj=o
	v_fun=f
	setTimeout('execmascara()',1)
}

function execmascara(){
	v_obj.value=v_fun(v_obj.value)
}

function cpfCnpj(v){

	v=v.replace(/\D/g,"")
	if (v.length <= 11) {
		v=v.replace(/(\d{3})(\d)/,"$1.$2")
		v=v.replace(/(\d{3})(\d)/,"$1.$2")
		v=v.replace(/(\d{3})(\d{1,2})$/,"$1-$2")

	} else {
		v= v.length>14?v.substring(0,14):v;
		v=v.replace(/^(\d{2})(\d)/,"$1.$2")
		v=v.replace(/^(\d{2})\.(\d{3})(\d)/,"$1.$2.$3")
		v=v.replace(/\.(\d{3})(\d)/,".$1/$2")
		v=v.replace(/(\d{4})(\d)/,"$1-$2")

	}
	return v
}

$(document).ready(function() {
	var moeda = $('input[name=moeda]:checked').val();
	var tipo = $('#tipo').val();
	alterarIconeMoeda(moeda);
	alterarValorPlano(moeda, tipo);
	$('input[name=moeda]').change(function(){
		var moeda = $('input[name=moeda]:checked').val();
		var tipo = $('#tipo').val();
		alterarIconeMoeda(moeda);
		alterarValorPlano(moeda, tipo);
	});
});


$('#tipo').change(function(){
	var moeda = $('input[name=moeda]:checked').val();
	var tipo = $('#tipo').val();
	
	alterarValorPlano(moeda, tipo);
});

$('#plano').change(function(){
	var moeda = $('input[name=moeda]:checked').val();
	var tipo = $('#tipo').val();
	
	alterarValorPlano(moeda, tipo);
});

function alterarValorPlano(moeda, tipo) {

	switch ($('#plano').val()) {
		case 'Basic':
			if (moeda === "real") {
				if (tipo === 'Mensal') {
					$('.dinheiro').val('27,00');
				}else{
					$('.dinheiro').val('324,00');
				}
			}else {
				if (tipo === 'Mensal') {
					$('.dinheiro').val('6,00');
				}else{
					$('.dinheiro').val('72,00');
				}
			}
			break;

		case 'Business':
			if (moeda === "real") {
				if (tipo === 'Mensal') {
					$('.dinheiro').val('54,00');
				}else{
					$('.dinheiro').val('648,00');
				}
			}else {
				if (tipo === 'Mensal') {
					$('.dinheiro').val('12,00');
				}else{
					$('.dinheiro').val('144,00');
				}
			}
			break;

		case 'Business Starter':
			if (moeda === "real") {
				if (tipo === 'Mensal') {
					$('.dinheiro').val('27,00');
				}else{
					$('.dinheiro').val('324,00');
				}
			}else {
				if (tipo === 'Mensal') {
					$('.dinheiro').val('6,00');
				}else{
					$('.dinheiro').val('72,00');
				}
			}
			break;

		case 'Business Standard':
			if (moeda === "real") {
				if (tipo === 'Mensal') {
					$('.dinheiro').val('54,00');
				}else{
					$('.dinheiro').val('648,00');
				}
			}else {
				if (tipo === 'Mensal') {
					$('.dinheiro').val('12,00');
				}else{
					$('.dinheiro').val('144,00');
				}
			}
			break;

		case 'Business Plus':
			if (moeda === "real") {
				if (tipo === 'Mensal') {
					$('.dinheiro').val('81,00');
				}else{
					$('.dinheiro').val('972,00');
				}
			}else {
				$('.dinheiro').val('apenas em real');
			}
			break;

			case 'Enterprise':
					$('.dinheiro').val('0,00');
					$('.dinheiro').focus();
				break;

			case 'Personalizado':
					$('.dinheiro').val('0,00');
					$('.dinheiro').focus();
				break;

		default:
				$('.dinheiro').val('0,00');
			break;
	}
}

function alterarIconeMoeda(moeda){
	if (moeda === "dolar") {
		// $(".iconeDolar").addClass( "fa-money" );
		// $(".iconeDolar").removeClass( "fa-dollar" );
		$(".iconeDolar").addClass( "flagUnitedStates" );
		$(".iconeDolar").removeClass( "flagBrazil" );
	}else{
		// $(".iconeDolar").addClass( "fa-dollar" );
		// $(".iconeDolar").removeClass( "fa-money" );
		$(".iconeDolar").addClass( "flagBrazil" );
		$(".iconeDolar").removeClass( "flagUnitedStates" );
	}
}

</script>
<style>
	input[name=moeda]{
		width: 20px;
    height: 20px;
    bottom: -6px;
    margin-right: 4px;
    position: relative !important;
		cursor: pointer;
	}
</style>