<?php
/*
 * Este arquivo cria o modal que tem como objetivo a criação do registro de um novo
 * cliente na agência.
 */

require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Seta um modelo de numero inicial
$whatsAppsNumerosArray = [''];

try {
    // Faz a consulta dos seguimentos salvos
    $todosSeguimentos = $sistema->obter_seguimentos();
} catch (Exception $e) {
    echo "-2Houve um erro com o servidor";
    exit;
}

?>
<script>
    function salvarDados() {

        // Checa se o select de seguimento foi marcado
        if (document.getElementById('sqlSeguimento').value == '') {
            toastr.clear();
            toastr.error('Selecione um seguimento!');
            return false;
        }

        // Checa se pelo meno o campo whats1 esta preechido
        if (document.getElementById('whatsapp').checked) {

            // Checa de o whatsapp esta marcado
            if ($('input[name="whatsBanco"]:checked').val() == 'sim') {

                if ($('#whats1').val() == null || $('#whats1').val() == '') {

                    $('ul.nav-tabs > li:nth-child(1)').removeClass('active');
                    $('ul.nav-tabs > li:nth-child(2)').removeClass('active');
                    $('ul.nav-tabs > li:nth-child(3)').removeClass('active');
                    $('ul.nav-tabs > li:nth-child(4)').removeClass('active');
                    $('ul.nav-tabs > li:nth-child(5)').removeClass('active');
                    $('ul.nav-tabs > li:nth-child(6)').addClass('active');

                    $('#tab_1').removeClass('active');
                    $('#tab_2').removeClass('active');
                    $('#tab_3').removeClass('active');
                    $('#tab_5').removeClass('active');
                    $('#tab_4').removeClass('active');
                    $('#tab_6').addClass('active');

                    $('#whats1').focus();

                    toastr.clear();
                    toastr.error('O usuário precisa ter pelo menos um WhatsApp configurado!');
                    return false;

                } else {
                    let contador = 0;
                    $('input[name=\'whatsappInput[]\']').each(function() {
                        if ($(this).val() == '') {
                            contador++;
                        }
                    });
                    if (contador > 0) {
                        toastr.clear();
                        toastr.error('Preencha ou Exclua o(s) campo(s) de WhatsApp em branco!');
                        return false;
                    }
                }
            }
        }

        var dados = jQuery('#formDados').serialize() + "&id=<?php echo $_POST['id']; ?>";
        $(document).ready(function() {
            jQuery.ajax({
                type: 'POST',
                url: 'action/salvar_modal_novo_cliente',
                data: dados,
                success: function(data) {
                    $('.preloader').css({
                        display: 'none',
                    });
                    if (data == '-1') {
                        window.location.href = './';
                        return;
                    }
                    if (data.substring(0, 2) == '-2') {
                        toastr.clear();
                        toastr.error(data.substring(2));
                        return;
                    }
                    fechar_modal();
                    adicionar_linhas(JSON.parse(data));
                    toastr.clear();
                    toastr.success('Cliente criado com sucesso.');
                    return;
                },
                beforeSend: function() {
                    $('.preloader').css({
                        display: 'block',
                    });
                },
                complete: function() {
                    $('.preloader').css({
                        display: 'none',
                    });
                },
                error: function() {
                    $('.preloader').css({
                        display: 'none',
                    });
                    toastr.clear();
                    toastr.error('Houve um erro ao salvar.');
                    return;
                },
            });
        });
    }

    $(document).ready(function() {
        $('#formDados').submit(function() {
            salvarDados();
            return false;
        });
    });

    function adicionarSubusuario() {
        contadorUsuarios++;
        document.getElementById('qtdUsuarios').value = contadorUsuarios;
        $('#tab_2').append('\
		<input id="idUsuario' + contadorUsuarios + '" name="idUsuario' + contadorUsuarios + '" type="hidden" value="-1">\
		<div class="panel panel-default"><div class="panel-heading">Subusuário ' + contadorUsuarios + '</div><div class="panel-body"><div class="row">\
			<div class="col-xs-12"><div class="form-group">\
				<div class="checkbox">\
					<label>\
						<input type="checkbox" name="adwordsPerm' + contadorUsuarios + '" id="adwordsPerm' + contadorUsuarios + '" value="Sim" checked="checked" >\
						Permitir Acesso ao Adwords&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\
					</label>\
					<label>\
						<input type="checkbox" name="logPerm' + contadorUsuarios + '" id="logPerm' + contadorUsuarios + '" value="Sim">\
						Permitir Acesso ao Log&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\
					</label>\
					<label>\
						<input type="checkbox" name="win7fonePerm' + contadorUsuarios + '" id="win7fonePerm' + contadorUsuarios + '" value="Sim" checked="checked">\
						Permitir Acesso ao Win7 Fone&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\
					</label>\
					<label>\
						<input type="checkbox" name="dadosgerais' + contadorUsuarios + '" id="dadosgerais' + contadorUsuarios + '" value="Sim" checked="checked">\
						Permitir Acesso aos Dados Gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;\
					</label>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Nome:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-user"></i></div>\
					<input type="text" class="form-control pull-right" id="subusuarioNome' + contadorUsuarios + '" name="subusuarioNome' + contadorUsuarios + '" required/>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Login:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-user"></i></div>\
					<input type="text" class="form-control pull-right" id="subusuarioLogin' + contadorUsuarios + '" name="subusuarioLogin' + contadorUsuarios + '" required/>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Senha:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-lock"></i></div>\
					<input type="text" class="form-control pull-right" id="subusuarioSenha' + contadorUsuarios + '" name="subusuarioSenha' + contadorUsuarios + '"/>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Indicações:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-smile-o"></i></div>\
					<select name="indicacoesPerm' + contadorUsuarios + '" id="indicacoesPerm' + contadorUsuarios + '" class="form-control pull-right">\
						<option value="0" >Permitir Leitura</option>\
						<option value="1" >Permitir Modificação</option>\
						<option value="2" >Não Permitir</option>\
					</select>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Contatos:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-users"></i></div>\
					<select name="contatosPerm' + contadorUsuarios + '" id="contatosPerm' + contadorUsuarios + '" class="form-control pull-right">\
						<option value="0" >Permitir Leitura</option>\
						<option value="1" >Permitir Modificação</option>\
						<option value="2" >>Não Permitir</option>\
					</select>\
				</div>\
			</div></div>\
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">\
				<label>Página Inicial:</label>\
				<div class="input-group">\
					<div class="input-group-addon"><i class="fa fa-home"></i></div>\
					<select name="inicioSubusuario' + contadorUsuarios + '" id="inicioSubusuario' + contadorUsuarios + '" class="form-control pull-right">\
						<?php $sistema->layout->select_home("contatos"); ?>\
					</select>\
				</div>\
			</div></div>\
		</div></div></div>\
	');
    }

    function adicionarNumeroWhatsApp() {
        contadorNumerosWhatsApp++;
        document.getElementById('qtdWhatApps').value = contadorNumerosWhatsApp;
        $('#whatsapp-tab').append('<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>WhatsApp ' + contadorNumerosWhatsApp + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarWhats(' + contadorNumerosWhatsApp + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right" id="whats' + contadorNumerosWhatsApp + '" name="whatsappInput[]" /></div></div></div>');

        $('#whats' + contadorNumerosWhatsApp).inputmasks(maskOpts);
    }

    function recriarWhats(index) {
        let strHTML = '';
        let counter = 0;
        for (let i = 1; i <= contadorNumerosWhatsApp; i++) {
            if (i == index) {
                continue;
            }
            counter++;
            let campo1 = document.getElementById('whats' + i).value;
            strHTML += '<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>WhatsApp ' + counter + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarWhats(' + counter + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right" id="whats' + counter + '" name="whatsappInput[]" value="' + campo1 + '" /></div></div></div>';
        }
        contadorNumerosWhatsApp--;
        document.getElementById('qtdWhatApps').value = contadorNumerosWhatsApp;
        document.getElementById('whatsapp-tab').innerHTML = strHTML;

        // seta novamente as mascaras
        for (let i = 1; i <= contadorNumerosWhatsApp; i++) {
            $('#whats' + i).inputmasks(maskOpts);
        }
    }

    function adicionarID() {
        contadorVono++;
        document.getElementById('qtdVono').value = contadorVono;
        $('#vono-tab').append('<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>Ramal ' + contadorVono + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriar(' + contadorVono + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right" id="vono' + contadorVono + '" name="vono' + contadorVono + '" required/></div></div></div><div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>Nome ' + contadorVono + ':</label><div class="input-group"><div class="input-group-addon"><i class="fa fa-phone"></i></div><input type="text" class="form-control pull-right" id="vonoNome' + contadorVono + '" name="vonoNome' + contadorVono + '" required/></div></div></div>');
    }

    function recriar(index) {
        var strHTML = '';
        var counter = 0;
        for (var i = 1; i <= contadorVono; i++) {
            if (i == index) {
                continue;
            }
            counter++;
            var campo1 = document.getElementById('vono' + i).value;
            var campo2 = document.getElementById('vonoNome' + i).value;
            strHTML += '<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>Ramal ' + counter + ':</label><div class="input-group"><div class="input-group-addon"><a href="javascript:void(0);" onClick="recriar(' + counter + ')" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div><input type="text" class="form-control pull-right" id="vono' + counter + '" name="vono' + counter + '" value="' + campo1 + '" required/></div></div></div><div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group"><label>Nome ' + counter + ':</label><div class="input-group"><div class="input-group-addon"><i class="fa fa-phone"></i></div><input type="text" class="form-control pull-right" id="vonoNome' + counter + '" name="vonoNome' + counter + '" value="' + campo2 + '" required/></div></div></div>';
        }
        contadorVono--;
        document.getElementById('qtdVono').value = contadorVono;
        document.getElementById('vono-tab').innerHTML = strHTML;
    }

    function adicionarCampanha() {
        contadorCampanhas++;
        document.getElementById('qtdCampanhas').value = contadorCampanhas;
        $('#lista-campanhas').append(stringCampanha(contadorCampanhas, '-1'));

        // Marca a opção de mostrar apenas as campanhas listadas
        checkMCP1();
    }

    function checkMCP0() {
        $('input[name=mostrarapenascampanhas][value=\'0\']').prop('checked', true);
        $('#mcp0').attr('checked', true);
        $('#mcp1').attr('checked', false);
        $('#mcp2').attr('checked', false);
    }

    function checkMCP1() {
        $('input[name=mostrarapenascampanhas][value=\'1\']').prop('checked', true);
        $('#mcp0').attr('checked', false);
        $('#mcp1').attr('checked', true);
        $('#mcp2').attr('checked', false);
    }

    function checkMCP2() {
        $('input[name=mostrarapenascampanhas][value=\'2\']').prop('checked', true);
        $('#mcp0').attr('checked', false);
        $('#mcp1').attr('checked', false);
        $('#mcp2').attr('checked', true);
    }

    function recriarCampanhas(index) {
        var strHTML = '';
        var counter = 0;
        for (var i = 1; i <= contadorCampanhas; i++) {
            if (i == index) {
                continue;
            }
            counter++;
            var id = document.getElementById('idCampanha' + i).value;
            var idReal = document.getElementById('idCampanhaReal' + i).value;
            var nomeCampanha = document.getElementById('nomeCampanha' + i).value;
            strHTML += stringCampanha(counter, id, idReal, nomeCampanha);
        }
        contadorCampanhas--;
        document.getElementById('qtdCampanhas').value = contadorCampanhas;
        document.getElementById('lista-campanhas').innerHTML = strHTML;

        // Se não tiver nenhuma campanha a ser listada, marca a primeira opção
        if (contadorCampanhas == '0') {
            checkMCP0();
        }
    }

    function stringCampanha(numero, id = '-1', idReal = '', nomeCampanha = 'Exemplo') {
        return '\
	<input id="idCampanha' + numero + '" name="idCampanha' + numero + '" type="hidden" value="' + id + '">\
	<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">\
		<label>ID da Campanha ' + numero + ':</label>\
		<div class="input-group">\
			<div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarCampanhas(' + numero + ')" title="Clique para deletar"><i class="fa fa-trash text-red"></i></a></div>\
			<input type="text" class="form-control pull-right"  id="idCampanhaReal' + numero + '" name="idCampanhaReal' + numero + '" alt="ID da Campanha" value="' + idReal + '" maxlength="40" required />\
		</div>\
	</div></div>\
	<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">\
		<label>Nome da Campanha <?php echo $counter; ?>:</label>\
		<div class="input-group">\
			<div class="input-group-addon"><i class="fa fa-google"></i></div>\
			<input type="text" class="form-control pull-right"  id="nomeCampanha' + numero + '" name="nomeCampanha' + numero + '" alt="Nome da Campanha" value="' + nomeCampanha + '" required />\
		</div>\
	</div></div>';
    }
</script>

<form name="formDados" action="" method="POST" id="formDados">
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
            <span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title"><b>Criar Novo Cliente</b></h4>
    </div>
    <div class="modal-body">
        <div class="nav-tabs-custom">
            <ul class="nav nav-tabs">
                <li class="active"><a href="#tab_1" data-toggle="tab">Geral</a></li>
                <li><a href="#tab_2" data-toggle="tab">Subusuários</a></li>
                <li><a href="#tab_3" data-toggle="tab">Google Ads</a></li>
                <li><a href="#tab_5" data-toggle="tab">Win7 Fone</a></li>
                <li><a href="#tab_4" data-toggle="tab">Permissões</a></li>
                <li><a href="#tab_6" data-toggle="tab">LP WhatsApp</a></li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab_1">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="clienteativo" id="clienteativo" value="Sim">
                                        Cliente Ativo&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="clienteimportante" id="clienteimportante" value="Sim" checked>
                                        Cliente Importante&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="win7phoneativo" id="win7phoneativo" value="Sim">
                                        Win7 Fone Ativo&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-3">
                            <div class="form-group">
                                <label>Nome:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control pull-right" id="nome" name="nome" alt="Nome" required />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-3">
                            <div class="form-group">
                                <label>Login:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-user"></i></div>
                                    <input type="text" class="form-control pull-right" id="login" name="login" alt="Login" required />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-3">
                            <div class="form-group">
                                <label>Empresa:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-building"></i></div>
                                    <input type="text" class="form-control pull-right" id="empresa" name="empresa" alt="Empresa" required />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-3">
                            <div class="form-group">
                                <label>Senha:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-lock"></i></div>
                                    <input type="text" class="form-control pull-right" id="senha" name="senha" alt="Senha" value="123456" required />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-4">
                            <div class="form-group">
                                <label>Atendente 1:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope"></i></div>
                                    <input type="text" class="form-control pull-right" id="email1" name="email1" alt="Atendente 1" />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-6 col-md-4">
                            <div class="form-group">
                                <label>Atendente 2:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-envelope"></i></div>
                                    <input type="text" class="form-control pull-right" id="email2" name="email2" alt="Atendente 2" />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-4">
                            <div class="form-group">
                                <label>Tags:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-tag"></i></div>
                                    <input type="text" class="form-control pull-right" id="tags" name="tags" alt="Tags" />
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
						<div class="col-xs-12 col-sm-12 col-md-5">
                            <div class="form-group">
                                <div style="display: flex; justify-content: space-between; align-items: center;">
                                    <label>Seguimento: </label>
                                    <small class="label bg-blue" style="cursor: pointer;" onclick="modalAdicionarSeguimentos()">adicionar</small>
                                </div>
                                <div class="input-group" style="width: 100%;">
                                    <!-- <div class="input-group-addon"><i class="fa fa-edit"></i></div> -->
                                    <select name="sqlSeguimento" for="slct" id="sqlSeguimento" class="js-example-basic-multiple">
                                        <option value="" selected disabled>Selecione:</option>
                                        <?php
                                        foreach ($todosSeguimentos as $seguimento) {
                                            echo '<option value="' . $seguimento['ID'] . '">' . $seguimento['TXT_SEGUIMENTO'] . '</option>';
                                        }
                                        ?>
                                    </select>
                                </div>
                            </div>
						</div>

						<div class="col-xs-12 col-sm-12 col-md-7">
							<div class="form-group">
								<label title="A string #TELEFONE# será substituída pelo telefone">URL Botão Contato: </label>
								<div class="input-group">
									<div class="input-group-addon"><i class="fa fa-edit"></i></div>
									<input type="text" class="form-control pull-right" id="txturlbtncontato" name="txturlbtncontato" alt="Url botão contato" value="https://wa.me/+55#TELEFONE#" />
								</div>
							</div>
						</div>
					</div>

                    <div class="row">
                        <div class="col-xs-12 col-md-5">
                            <div class="row">
                                <div class="col-xs-12 col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label>Telefone 1:</label>
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-phone"></i></div>
                                            <input type="text" class="form-control pull-right" id="telefone1" name="telefone1" alt="Telefone 1" />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-6 col-md-6">
                                    <div class="form-group">
                                        <label>Telefone 2:</label>
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-phone"></i></div>
                                            <input type="text" class="form-control pull-right" id="telefone2" name="telefone2" alt="Telefone 2" />
                                        </div>
                                    </div>
                                </div>
                                <div class="col-xs-12 col-sm-12 col-md-12">
                                    <div class="form-group">
                                        <label>ID do Tag Manager:</label>
                                        <div class="input-group">
                                            <div class="input-group-addon"><i class="fa fa-edit"></i></div>
                                            <input type="text" class="form-control pull-right" id="tagforms" name="tagforms" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-md-7">
                            <div class="row">
                                <div class="col-xs-12">
                                    <div class="form-group">
                                        <label>Anotações:</label>
                                        <textarea name="anotacoes" id="anotacoes" class="form-control" rows="5"></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab_2">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <input id="qtdUsuarios" name="qtdUsuarios" type="hidden" value="0">
                                <a href="javascript:void(0);" onclick="adicionarSubusuario();" class="btn btn-primary">Adicionar
                                    Subusuário</a>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab_3">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="permpausarcampanhas" id="permpausarcampanhas" value="Sim">
                                        Permitir Pausamento de Campanhas&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="consultoria" id="consultoria" value="Sim" checked='checked'>
                                        Ativar Consultoria&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <!-- <label>
                                        <input type="checkbox" name="mostrarapenascampanhas" id="mostrarapenascampanhas" value="Sim">
                                        Mostrar Apenas Campanhas Listadas&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label> -->
                                    <label>
                                        <input type="checkbox" name="mostrarcpl" id="mostrarcpl" value="Sim" checked='checked'>
                                        Permitir visualização do CPL&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-sm-4 col-md-3">
                            <div class="form-group">
                                <label>Google Ads:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-google"></i></div>
                                    <input type="text" class="form-control pull-right" id="adwords" name="adwords" alt="Adwords" />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-4 col-md-3">
                            <div class="form-group">
                                <label>Limite do CPL:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-google"></i></div>
                                    <input type="text" class="form-control pull-right dinheiro" id="limitecpl" name="limitecpl" alt="Limite do CPL" value="20,00" />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-4 col-md-3">
                            <div class="form-group">
                                <label>Moeda do Ads:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-dollar"></i></div>
                                    <select name="moedaadwords" id="moedaadwords" class="form-control pull-right">
                                        <?php $sistema->layout->select_moedas(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-4 col-md-3">
                            <div class="form-group">
                                <label>Data Inicial:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
                                    <input type="text" class="form-control pull-right datepicker" id="datainicialads" name="datainicialads" alt="Data Inicial" value="01/01/2019" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <input id="qtdCampanhas" name="qtdCampanhas" type="hidden" value="0">
                                <button type="button" onClick='adicionarCampanha()' class="btn btn-primary" style="float: left; margin-right: 14px">Adicionar Campanha
                                </button>
                                <div class="switch-toggle">
                                    <input id="mcp0" name="mostrarapenascampanhas" value="0" type="radio" checked />
                                    <label for="mcp0" onclick="checkMCP0()" title="Ignora as campanhas abaixo e busca todas as campanhas.">Todas</label>
                                    <input id="mcp1" name="mostrarapenascampanhas" value="1" type="radio" />
                                    <label for="mcp1" onclick="checkMCP1()" title="Busca apenas as campanhas abaixo.">Apenas
                                        estas</label>
                                    <input id="mcp2" name="mostrarapenascampanhas" value="2" type="radio" />
                                    <label for="mcp2" onclick="checkMCP2()" title="Busca todas as campanhas, menos as de abaixo.">Todas menos
                                        estas</label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row lista-campanhas" id="lista-campanhas">

                    </div>
                </div>
                <div class="tab-pane" id="tab_4">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="logativo" id="logativo" value="Sim">
                                        Ativar Log&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="dadosgeraisativo" id="dadosgeraisativo" value="Sim" checked='checked'>
                                        Ativar Dados Gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="google" id="google" value="Sim" checked='checked'>
                                        Ativar Campanhas&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="ligacoes" id="ligacoes" value="Sim" checked='checked'>
                                        Ativar Win7 Fone&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="leads" id="leads" value="Sim" checked='checked'>
                                        Ativar Leads&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="comparacao" id="comparacao" value="Sim">
                                        Ativar Comparação Dados Gerais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="btnaddlead" id="btnaddlead" value="Nao">
                                        Ocultar botão "Adicionar Contato"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-4">
                            <div class="form-group">
                                <label>Página Inicial:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-home"></i></div>
                                    <select name="paginainicial" id="paginainicial" class="form-control pull-right">
                                        <?php $sistema->layout->select_home(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="tab-pane" id="tab_5">
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="mostrartotalligacoes" id="mostrartotalligacoes" value="Sim">
                                        Mostrar total real de ligações&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="agruparligacoes" id="agruparligacoes" value="Sim" checked="checked">
                                        Agrupar ligações de mesma origem&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                    <label>
                                        <input type="checkbox" name="esconderligacoesefetuadas" id="esconderligacoesefetuadas" value="Sim" checked="checked">
                                        Esconder ligações efetuadas&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12 col-md-4">
                            <div class="form-group">
                                <label>Valor das Ligações:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-dollar"></i></div>
                                    <input type="text" class="form-control pull-right" id="valor-ligacoes" name="valor-ligacoes" alt="Valor das Ligações" value="0.49, 0.29" />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-md-4">
                            <div class="form-group">
                                <label>Data Inicial:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
                                    <input type="text" class="form-control pull-right" id="datainicial" name="datainicial" alt="Data Inicial" />
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-md-4">
                            <div class="form-group">
                                <label>Data Final:</label>
                                <div class="input-group">
                                    <div class="input-group-addon"><i class="fa fa-calendar"></i></div>
                                    <input type="text" class="form-control pull-right" id="datafinal" name="datafinal" alt="Data Final" />
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <input id="qtdVono" name="qtdVono" type="hidden" value="0">
                                <a href="javascript:void(0);" onClick='adicionarID()' class="btn btn-primary">Adicionar
                                    Registro</a>
                            </div>
                        </div>
                    </div>
                    <div class="row" id="vono-tab">
                    </div>
                </div>


                <div class="tab-pane" id="tab_6">

                    <div class="row">
                        <div class="col-xs-12">
                            <div class="form-group">
                                <div class="checkbox">
                                    <label>
                                        <input type="checkbox" name="whatsapp" id="whatsapp" value="Sim">
                                        Ativar Whatsapp&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="whatsAppContainerBanco">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <hr>
                                    <label>Buscar os números de WhatsApp no banco? </label>
                                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                                    <label>
                                        <input type="radio" name="whatsBanco" id="whatsRadioBanco1" value="sim" checked>
                                        Sim
                                    </label>
                                    &nbsp;&nbsp;&nbsp;&nbsp;
                                    <label>
                                        <input type="radio" name="whatsBanco" id="whatsRadioBanco2" value="nao"> Não
                                    </label>
                                    <br>
                                    <span style="color:red;">Obs.: Se marcado o "Não" daí será usado o telefone que tem nos links de WhatsApp da página. (CONFIRA OS LINKS DA PÁGINA!) </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="whatsAppContainerNumbers">
                        <div class="row">
                            <div class="col-xs-12">
                                <div class="form-group">
                                    <hr>
                                    <label>NÚMEROS DE WHATSAPP:</label><br>
                                    <span>* O primeiro número abaixo é o próximo a receber o contato do LEAD (no caso de 2 ou mais números)</span><br>
                                    <span style="color:red;">** Digitar os números respeitando as máscaras. Elas se adaptam inicialmente ao código do país.</span><br>
                                    <span style="color:red;">Exemplos: +55(61)90000-0000 ou +55(61)0000-0000 ou +1(000)000-0000</span><br>
                                    <input id="qtdWhatApps" name="qtdWhatApps" type="hidden" value="<?php echo count($whatsAppsNumerosArray); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="row" id="whatsapp-tab">
                            <?php
                            $numero_de_ids = count($whatsAppsNumerosArray);
                            for ($index = 0; $index < $numero_de_ids; $index++) {
                                $counter = $index + 1;
                                $campo1  = $whatsAppsNumerosArray[$index]; ?>

                                <div class="col-xs-12 col-sm-6 col-md-3">
                                    <div class="form-group">
                                        <label>WhatsApp <?php echo $counter; ?>:</label>
                                        <div class="input-group">
                                            <div class="input-group-addon"><a href="javascript:void(0);" onClick="recriarWhats(<?php echo $counter; ?>)" title="Clique para deletar"><i class="fa fa-trash-o text-red"></i></a></div>
                                            <input type="text" class="form-control pull-right numerosWhatsApp" id="whats<?php echo $counter; ?>" name="whatsappInput[]" value="<?php echo $campo1; ?>" />
                                        </div>
                                    </div>
                                </div>

                            <?php } ?>
                        </div>

                        <div class="row">
                            <div class="col-xs-12">
                                <a href="javascript:void(0);" onClick='adicionarNumeroWhatsApp()' class="btn btn-primary">Adicionar WhatsApp</a>
                            </div>
                        </div>
                    </div>


                </div>


            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
        <button type="submit" name="action" class="btn btn-primary">Criar Cliente</button>
    </div>
    <div class="overlay preloader">
        <i class="fa fa-refresh fa-spin"></i>
    </div>
</form>

<script>
    var maskBehavior = function(val) {
            return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
        },
        options = {
            onKeyPress: function(val, e, field, options) {
                field.mask(maskBehavior.apply({}, arguments), options);
            },
        };
    $(document).ready(function() {
        $('#telefone1').mask(maskBehavior, options);
        $('#telefone2').mask(maskBehavior, options);
        $('#datainicial').mask('00/00/0000');
        $('#datainicialads').mask("00/00/0000");
        $('#adwords').mask('000-000-0000');
        $('#datafinal').mask('00/00/0000');
        // $('.numerosWhatsApp').mask("00 (00) 00000-0000");
    });
    $('.dinheiro').mask('000.000.000.000.000,00', {
        reverse: true,
    });
    var contadorVono = document.getElementById('qtdVono').value;
    var contadorNumerosWhatsApp = document.getElementById('qtdWhatApps').value;
    var contadorCampanhas = document.getElementById('qtdCampanhas').value;
    var contadorUsuarios = document.getElementById('qtdUsuarios').value;

    // Checa de o whatsapp esta marcado
    if (document.getElementById('whatsapp').checked) {
        $('.whatsAppContainerBanco').fadeIn('500');
    } else {
        $('.whatsAppContainerBanco').hide();
        $('.whatsAppContainerNumbers').hide();
    }

    $('#whatsapp').click(function() {
        if (document.getElementById('whatsapp').checked) {
            $('.whatsAppContainerBanco').fadeIn('500');

            if (document.getElementById('whatsRadioBanco1').checked) {
                $('.whatsAppContainerNumbers').fadeIn('500');
            } else {
                $('.whatsAppContainerNumbers').hide();
            }

        } else {
            $('.whatsAppContainerBanco').hide();
            $('.whatsAppContainerNumbers').hide();
        }
    });

    $('input[name="whatsBanco"]').change(function() {
        if (document.getElementById('whatsRadioBanco1').checked) {
            $('.whatsAppContainerNumbers').fadeIn('500');
        } else {
            $('.whatsAppContainerNumbers').hide();
        }
    });
</script>
<script>
    var maskList = $.masksSort($.masksLoad('../js/country-masks/data/phone-codes.json'), ['#'], /[0-9]|#/, 'mask');
    var maskOpts = {
        inputmask: {
            definitions: {
                '#': {
                    validator: '[0-9]',
                    cardinality: 1,
                },
            },
            //clearIncomplete: true,
            showMaskOnHover: false,
            autoUnmask: true,
        },
        match: /[0-9]/,
        replace: '#',
        list: maskList,
        listKey: 'mask',
    };

    for (let i = 0; i <= $('#qtdWhatApps').val(); i++) {
        $('#whats' + i).inputmasks(maskOpts);
    }
</script>
<script type="text/javascript">
    $(document).ready(function() {
        $('.js-example-basic-multiple').select2({
            placeholder: 'Selecione:',
        });
    });
</script>