<?php
/*
 * Este arquivo é responsável por montar a modal de
 * confirmação de saque do sistema de indicações.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_gsuite == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$dados = $sistema->bd->executar("SELECT * FROM TBL_GOOGLEAPPS WHERE ID = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){
		echo "-2ID inválida!";
		exit;
	}
	
	if(empty($dados['TXT_ID_TRANSACAO'])){
		echo "-2Não há boletos gerados!";
		exit;
	}
	
	$vencimento = $dados['DT_ULTIMA_EXECUCAO'];
	$vencimento = explode('-', $vencimento);
	$vencimento = $vencimento[2]."/".$vencimento[1]."/".$vencimento[0];
	$email = $dados['TXT_EMAIL'];
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<script>
function salvarDados(){
	var dados = jQuery('#formDados').serialize()+"&id=<?php echo $_POST['id']; ?>";
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_reenvio_boleto",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				toastr.clear(); toastr.success("Reenvio feito com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao reenviar."); return;
			}
		});
	});
}
$(document).ready(function(){
	$('#formDados').submit(function(){
		salvarDados();
		return false;
	})
});
</script>
<form name="formDados" action="" method="POST" id="formDados">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Reenviar Último Boleto</b></h4>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Email:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
					<input type="text" class="form-control pull-right"  id="email" name="email" alt="Email" value="<?php echo $email; ?>" required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-3"><div class="form-group">
				<label>Vencimento:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
					<input type="text" class="form-control pull-right"  id="vencimento" name="vencimento" alt="Data de Vencimento" value="<?php echo $vencimento; ?>" required/>
				</div>
			</div></div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<button type="submit" name="action" class="btn btn-primary">Reenviar Boleto</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>
<script>
$(document).ready(function(){
	$('#vencimento').mask("00/00/0000");
});
</script>