<?php
/*
 * Este arquivo é responsável por montar a modal de
 * confirmação de saque do sistema de indicações.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_indicacoes_geral == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	/* Verificamos se o cliente existe e obtemos seu nome/id */
	$dados = $sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);
	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado no banco, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}
	
	$nome = $dados['TXT_NOME'];
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
	<span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title"><b>Confirmação</b></h4>
</div>

<div class="modal-body">
	Tem certeza de que deseja zerar o sistema do cliente <b><?php echo $nome;?></b>? <br><br> <span class="text-red">Esta ação <b>NÃO PODE SER DESFEITA</b> e retornará o sistema ao seu estado inicial, porém manterá os indicados/indicadores já registrados e os prêmios.</span>
</div>
<div class="modal-footer">
	<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Não</button>
	<a class="btn btn-primary" href="javascript:void(0);" onclick="salvar_zerar_sistema();">Sim</a>
</div>
<div class="overlay preloader">
	<i class="fa fa-refresh fa-spin"></i>
</div>

<script>
function salvar_zerar_sistema(){
	var dados = "id=<?php echo $_POST['id']; ?>";
	jQuery.ajax({
		type: "POST",
		url: "action/salvar_modal_zerar_sistema",
		data: dados,
		success: function(data){
			$('.preloader').css({display:"none"});
			if(data == '-1') {window.location.href = "./"; return;}
			if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
			fechar_modal_confirmacao();
			atualizar_indicacoes(JSON.parse(data));
			toastr.clear(); toastr.success("Sistema zerado com sucesso."); return;
		},
		beforeSend: function(){
			$('.preloader').css({display:"block"});
		},
		complete: function(){
			$('.preloader').css({display:"none"});
		},
		error: function(){
			$('.preloader').css({display:"none"});
			toastr.clear(); toastr.error("Houve um erro ao zerar o sistema."); return;
		}
	});
}
</script>