<?php
/*
 * Este arquivo é responsável por atualizar a página do G Suite do sistema.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_gsuite == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

try{
	// Fazemos aqui a consulta dos contatos
	$dados = $sistema->bd->executar("SELECT * FROM TBL_GOOGLEAPPS", array(), Banco_Dados::FETCH_ALL);
	
	// Finalmente, montamos uma array que conterá todos os contatos em um formato fácil de ser lido por JSON
	$resultado = array();
	
	foreach($dados as $linha){
		$status = $linha['ATIVADO'] == "1" ? "Ativos" : "Inativo";
		$nome = $linha['TXT_NOME'];

		if ($linha['TXT_MOEDA'] == "real") {
			$linha['NU_VALOR'] = Mascara::converter_para_real($linha['NU_VALOR']);
		}else{
			$linha['NU_VALOR'] = Mascara::converter_para_dolar($linha['NU_VALOR']);
		}

		$resultado[] = array(
			'id' => $linha['ID'],
			'nome' => $nome,
			'email' => $linha['TXT_EMAIL'],
			'cpf_cnpj' => Mascara::mascara_cpf_cnpj($linha['NU_CPF_CNPJ']),
			'quantidade' => $linha['NU_QUANTIDADE'],
			'valor' => $linha['NU_TAXA_TRINTA_MENSAL'] == '0' ? $linha['NU_VALOR'] : $linha['NU_VALOR']." (+30%)",
			'tipo' => $linha['TXT_TIPO'],
			'vencimento' => $linha['DT_VENCIMENTO'],
			'telefone' => $linha['TXT_TELEFONE'],
			'status' => $status,
			'pesquisa' => $linha['TXT_NOME']
		);
	}
	
	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>