<?php 
/*
 * Este arquivo é responsável por montar um arquivo excel contendo todos os leads do nosso cliente,
 * considerando um determinado período.
 */

ini_set('memory_limit','512M');
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, false, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_leads_adm == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_todos_contatos == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Cell\Coordinate;
use PhpOffice\PhpSpreadsheet\IOFactory;

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	$_SESSION['erro-todos-contatos'] = "Filtro de pesquisa inválido";
	$sistema->redirecionar("../baixar-todos-contatos");
}

try{
	$sistema->iniciar_bd_leads();

	$filtro = Filtro::filtrar_data($_POST['data'], "DT_ATUAL", $_POST['datainicial'], $_POST['datafinal']); // Montamos o filtro SQL de data
	
	$dados = "ID_LEAD, TXT_NOME, TXT_LEAD_CLIENTE";
	if (isset($_POST['email'])){
		$dados .= ", TXT_EMAIL";
	}
	if (isset($_POST['telefone'])) {
		$dados .= ", NU_TELEFONE1";
	}
	if (isset($_POST['datacontato'])){
		$dados .= ", DT_ATUAL";
	}
	if (isset($_POST['mensagem'])){
		$dados .= ", TXT_MENSAGEM";
	}
	if (isset($_POST['status'])){
		$dados .= ", TXT_SITUACAO";
	}

	$sql = empty($filtro) ? 
	"SELECT ".$dados." FROM TBL_LEADS ORDER BY DT_ATUAL DESC" :
	"SELECT ".$dados." FROM TBL_LEADS WHERE ".$filtro." ORDER BY DT_ATUAL DESC";
	
	// Fazemos aqui a consulta dos contatos
	$dados = $sistema->bd_leads->executar($sql, array(),Banco_Dados::FETCH_ALL);

	// Inicializa o excel
	$arquivo = $sistema->usuario->nome_adm.' - Contatos Recebidos - '.trim(Filtro::texto($_POST['data']));
	
	$spreadsheet = new Spreadsheet();

	$spreadsheet->getProperties()
	    ->setCreator('Agência Win7')
	    ->setLastModifiedBy('Agência Win7')
	    ->setTitle('Relatório de Indicações')
	    ->setSubject('Relatório de Indicações')
	    ->setDescription('Relatório de Indicações gerado pelo Sistema Win7')
	    ->setKeywords('sistemawin7');

	// Configura as colunas fixas do excel
	$sheet = $spreadsheet->setActiveSheetIndex(0);
	$sheet->setCellValue('A1', 'Cliente');
	$sheet->getStyle("A1")->getFont()->setBold(true);
	$sheet->getColumnDimension('A')->setWidth("20");

	$sheet->setCellValue('B1', 'Nome');
	$sheet->getStyle("B1")->getFont()->setBold(true);
	$sheet->getColumnDimension('B')->setWidth("50");

	$indice_letra = 3;

	if (isset($_POST['email'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Email');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("40");
	}
	if (isset($_POST['telefone'])) {
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Telefone');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}
	if (isset($_POST['datacontato'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Data do Contato');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}
	if (isset($_POST['mensagem'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Mensagem');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("50");
	}
	if (isset($_POST['status'])){
		$letra = Coordinate::stringFromColumnIndex($indice_letra);
		$indice_letra++;
		$sheet->setCellValue($letra.'1', 'Status');
		$sheet->getStyle($letra.'1')->getFont()->setBold(true);
		$sheet->getColumnDimension($letra)->setWidth("20");
	}

	// Adiciona todos os contatos ao excel
	$i = 2;
	foreach($dados as $row){
		$data_alteracao = $row['DT_ATUAL'];
		$data_alteracao = strtotime($data_alteracao);
		$data_alteracao = date('d/m/Y H:i:s', $data_alteracao);
		
		$indice_letra = 3;

		$sheet->setCellValue('A'.$i, $row['TXT_LEAD_CLIENTE']);
		$sheet->setCellValue('B'.$i, $row['TXT_NOME']);
		if (isset($_POST['email']) & mb_check_encoding($row['TXT_EMAIL'],'UTF-8')) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$i, $row['TXT_EMAIL']); $indice_letra++;}
		if (isset($_POST['telefone']) & mb_check_encoding($row['NU_TELEFONE1'],'UTF-8')) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$i, $row['NU_TELEFONE1']); $indice_letra++;}
		if (isset($_POST['datacontato'])) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$i, $data_alteracao); $indice_letra++;}
		if (isset($_POST['mensagem']) & mb_check_encoding($row['TXT_MENSAGEM'],'UTF-8')){
			$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$i, $row['TXT_MENSAGEM']);
			//$sheet->getStyle(Coordinate::stringFromColumnIndex($indice_letra).$i)->getAlignment()->setWrapText(true);
			$indice_letra++;
		}
		if (isset($_POST['status']) & mb_check_encoding($row['TXT_SITUACAO'],'UTF-8')) {$sheet->setCellValue(Coordinate::stringFromColumnIndex($indice_letra).$i, $row['TXT_SITUACAO']); $indice_letra++;}
		$i++;
	}

	$sistema->logs->adicionar_log_geracao_relatorio_todos_contatos();
	
	// Cria os headers
	header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
	header('Content-Disposition: attachment;filename="'.$arquivo.'.xlsx"');
	header('Cache-Control: max-age=1');
	header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
	header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
	header ('Cache-Control: cache, must-revalidate');
	header ('Pragma: public');

	$spreadsheet->getActiveSheet()->setTitle('Relatório de Contatos');

	// Envia o excel para o usuário
	$writer = IOFactory::createWriter($spreadsheet, 'Xlsx');
	$writer->save('php://output');
}
catch(Exception $e){
	$_SESSION['erro-todos-contatos'] = 1;
	$sistema->redirecionar("../baixar-todos-contatos");
}
?>