<?php
/*
 * Este arquivo cria um novo cliente da agência baseado nas informações disponibilizadas.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

/* Verifica se os dados essenciais do cliente não estão vazios */
if(empty($_POST['seguimento'])){
	echo "-2Dados inválidos!";
	exit;
}

/* Lê todos os dados do formulário */
$seguimento = $_POST['seguimento'];

/* Monta array com os parâmetros para salvar no banco */
$parametros = array(':seguimento' => $seguimento);

try{
	/* Salva os dados no banco */
	$sql = 'INSERT INTO TBL_SEGUIMENTOS (TXT_SEGUIMENTO) VALUES (:seguimento)';
	$sistema->bd->executar($sql, $parametros);
	
	// Salva a transação no log
	$sistema->logs->adicionar_log_salvar_novo_seguimento($_POST['seguimento']);

	// retorna vazio mostrando que houve sucesso na transacao
	echo json_encode_alt('');
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>