<?php
/*
 * Este arquivo salva os dados do administrador
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!$sistema->usuario->super_adm_adm) {
	echo "-2Permissão Insuficiente";
	exit;
}

if(!ctype_digit($_POST['id'])){ // Verifica se a ID é um número
	echo "-2ID inválida!";
	exit;
}

/* Verifica se os dados básicos são válidos */
if(empty($_POST['nome']) || empty($_POST['login']) || empty($_POST['email'])){
	echo "-2Dados inválidos!";
	exit;
}

try{
	$dados_adm = $sistema->bd->executar("SELECT * FROM TBL_ADM WHERE ID_ADM = :ID", array(":ID" => $_POST['id']), Banco_Dados::FETCH);
	
	if($sistema->bd->quantidade() == 0){
		echo "-2ID inválida!";
		exit;
	}

	/* Lê todos os dados do formulário */
	$nome = $_POST['nome'];
	$login = $_POST['login'];
	$senha = $_POST['senha'];
	$superadm = $_POST['superadm'] == "Sim" ? 1 : 0;
	$whatsapp = $_POST['whatsapp'];
	$email = $_POST['email'];

	// Permissões
	$perm_clientes = $_POST['permclientes'] == "Sim" ? 1 : 0;
	$perm_email = $_POST['permemail'] == "Sim" ? 1 : 0;
	$perm_indicacoes_adm = $_POST['permindicacoes1'] == "Sim" ? 1 : 0;
	$perm_resultados_gerais = $_POST['permresultados'] == "Sim" ? 1 : 0;
	$perm_todos_contatos = $_POST['permtodoscontatos'] == "Sim" ? 1 : 0;
	$perm_log = $_POST['permlog'] == "Sim" ? 1 : 0;
	$perm_win7fone = $_POST['permwin7fone'] == "Sim" ? 1 : 0;
	$perm_adwords = $_POST['permadwords'] == "Sim" ? 1 : 0;
	$permissao_contatos = intval($_POST['permcontatos']);
	$permissao_indicacoes = intval($_POST['permindicacoes2']);
	$permissao_arquivos = $_POST['permarquivos'] == "Sim" ? 1 : 0;
	$permissao_gsuite = $_POST['permgsuite'] == "Sim" ? 1 : 0;
	$permissao_comparacao = $_POST['comparacao'] == "Sim" ? 1 : 0;

	// Salva os daods principais no banco
	if(empty($senha)){
		$sql = 'UPDATE TBL_ADM SET TXT_NOME = :nome, TXT_EMAIL = :email, TXT_LOGIN = :login, NU_SUPER_ADM = :superadm, TXT_WHATSAPP = :whatsapp, NU_PERM_SISTEMA_CLIENTES = :permclientes, NU_PERM_SISTEMA_EMAIL = :permemail, NU_PERM_INDICACOES_GERAL = :permindicacoes1, NU_PERM_RESULTADOS_GERAIS = :permresultados, NU_PERM_TODOS_CONTATOS = :permtodoscontatos, NU_PERM_LOG_USUARIOS = :permlog, NU_PERM_WIN7FONE = :permwin7fone, NU_PERM_ADWORDS = :permadwords, NU_PERM_CONTATOS = :permcontatos, NU_PERM_INDICACOES = :permindicacoes2, NU_PERM_ARQUIVOS = :permarquivos, NU_PERM_GSUITE = :permgsuite, NU_PERM_COMPARACAO = :comparacao WHERE ID_ADM = :id';
		$parametros = array(
			":nome" => $nome,
			":id" => $_POST['id'],
			":email" => $email,
			":superadm" => $superadm,
			":whatsapp" => $whatsapp,
			":login" => $login,
			":permclientes" => $perm_clientes,
			":permemail" => $perm_email,
			":permindicacoes1" => $perm_indicacoes_adm,
			":permresultados" => $perm_resultados_gerais,
			":permtodoscontatos" => $perm_todos_contatos,
			":permlog" => $perm_log,
			":permwin7fone" => $perm_win7fone,
			":permadwords" => $perm_adwords,
			":permcontatos" => $permissao_contatos,
			":permindicacoes2" => $permissao_indicacoes,
			":permarquivos" => $permissao_arquivos,
			":permgsuite" => $permissao_gsuite,
			":comparacao" => $permissao_comparacao
		);
	}
	else{
		$sql = "UPDATE TBL_ADM SET TXT_NOME = :nome, TXT_EMAIL = :email, TXT_LOGIN = :login, NU_SUPER_ADM = :superadm, TXT_WHATSAPP = :whatsapp, NU_PERM_SISTEMA_CLIENTES = :permclientes, NU_PERM_SISTEMA_EMAIL = :permemail, NU_PERM_INDICACOES_GERAL = :permindicacoes1, NU_PERM_RESULTADOS_GERAIS = :permresultados, NU_PERM_TODOS_CONTATOS = :permtodoscontatos, NU_PERM_LOG_USUARIOS = :permlog, NU_PERM_WIN7FONE = :permwin7fone, NU_PERM_ADWORDS = :permadwords, NU_PERM_CONTATOS = :permcontatos, NU_PERM_INDICACOES = :permindicacoes2, NU_PERM_ARQUIVOS = :permarquivos, NU_PERM_GSUITE = :permgsuite , TXT_SENHA_NOVA = :senha, TXT_SENHA = '', NU_PERM_COMPARACAO = :comparacao WHERE ID_ADM = :id";
		$parametros = array(
			":nome" => $nome,
			":id" => $_POST['id'],
			":email" => $email,
			":superadm" => $superadm,
			":whatsapp" => $whatsapp,
			":login" => $login,
			":permclientes" => $perm_clientes,
			":permemail" => $perm_email,
			":permindicacoes1" => $perm_indicacoes_adm,
			":permresultados" => $perm_resultados_gerais,
			":permtodoscontatos" => $perm_todos_contatos,
			":permlog" => $perm_log,
			":permwin7fone" => $perm_win7fone,
			":permadwords" => $perm_adwords,
			":permcontatos" => $permissao_contatos,
			":permindicacoes2" => $permissao_indicacoes,
			":permarquivos" => $permissao_arquivos,
			":permgsuite" => $permissao_gsuite,
			":comparacao" => $permissao_comparacao,
			":senha" => Utilitarios::hash_str($senha)
		);
	}
	$sistema->bd->executar($sql, $parametros);

	$resultado = array();
	$resultado[] = array(
		"nome" => $nome,
		"id" => $_POST['id'],
		"email" => $email,
		"superadm" => $superadm == 1 ? "Sim" : "Não",
		"whatsapp" => $whatsapp,
		"login" => $login,
	);

	$dados_adm = $sistema->bd->executar("SELECT * FROM TBL_ADM WHERE ID_ADM = :ID", array(":ID" => $_POST['id']), Banco_Dados::FETCH);
	$sistema->logs->adicionar_log_alteracao_admin($dados_adm);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>