<?php
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_gsuite == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$dados = $sistema->bd->executar("SELECT * FROM TBL_GOOGLEAPPS WHERE ID = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){
		echo "-2ID inválida!";
		exit;
	}

	$nome = $dados['TXT_NOME'];

	$sistema->logs->adicionar_log_delecao_agendamento_gsuite($nome, $_POST['id']);

	$sistema->bd->executar("DELETE FROM TBL_GOOGLEAPPS WHERE ID = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>