<?php 
/*
 * Este arquivo é responsável por salvar os dados de um contato específico,
 * que foi editado na modal de contato.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_leads_adm != Usuario::PERM_ESCRITA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_todos_contatos == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

/* Verifica-se se a qualidade especificada está dentro das qualidades possíveis */
if(!in_array($_POST['qualidade'],$sistema->layout->qualidades_cliente)){ 
	echo "-2Dados inválidos!";
	exit;
}

/* Verifica-se se o status especificado está dentro dos status possíveis */
if(!in_array($_POST['status'],$sistema->layout->status_cliente)){
	echo "-2Dados inválidos!";
	exit;
}

if(empty($_POST['nome'])){
	echo "-2Nome Inválido!";
	exit;
}

try{
	$sistema->iniciar_bd_leads();

	// Prepara-se todos os dados para serem guardados no banco
	$telefone1 = $_POST['telefone1'];
	$telefone2 = $_POST['telefone2'];
	$email = $_POST['email'];
	$qualidade = $_POST['qualidade'];
	$status = $_POST['status'];
	$anotacoes = $_POST['anotacoes'];
	$valor_combinado = preg_replace('/[^0-9]+/','',strip_tags($_POST['valorcombinado']));
	$valor_fechado = preg_replace('/[^0-9]+/','',strip_tags($_POST['valorfechado']));
	$nome = $_POST['nome'];
	
	// Calcula-se a data atual, para ser a data de alteração do contato
	$timestamp = time();
	date_default_timezone_set('America/Sao_Paulo');
	$data_alteracao = date('Y-m-d H:i:s', $timestamp);
	
	// Salva os daods principais no banco
	$sql = 'UPDATE TBL_LEADS SET TXT_NOME = :nome, NU_TELEFONE1 = :telefone1, NU_TELEFONE2 = :telefone2, TXT_EMAIL = :email, TXT_SITUACAO = :status, TXT_QUALI = :qualidade, TXT_ANOTACOES = :anotacoes, TXT_PRECO_FECHADO = :fechado, TXT_PRECO = :combinado, DT_ANOTACOES_DATA = :dataanotacoes WHERE ID_LEAD = :id';

	$parametros = array(
		":telefone1" => $telefone1,
		":telefone2" => $telefone2,
		":email" => $email,
		":status" => $status,
		":qualidade" => $qualidade,
		":anotacoes" => $anotacoes,
		":fechado" => $valor_fechado,
		":combinado" => $valor_combinado,
		":dataanotacoes" => $data_alteracao,
		":id" => $_POST['id'],
		":nome" => $nome
	);

	$sistema->bd_leads->executar($sql, $parametros);
	
	/* Salva os campos extras */
	$sistema->bd_leads->executar("SELECT * FROM TBL_LEADS_CAMPOS WHERE NU_ID_LEAD = :id", array( ':id' => $_POST['id'] ));
	
	$qtd = $sistema->bd_leads->quantidade();
	for($i = 1;$i <= $qtd;$i++){
		$sql = "UPDATE TBL_LEADS_CAMPOS SET TXT_CONTEUDO = :conteudo WHERE NU_ID_LEAD = :id AND NU_ORDEM = :ordem";
		$parametros = array(
			':id' => $_POST['id'],
			':conteudo' => $_POST['campo'.$i],
			':ordem' => $i
		);
		$sistema->bd_leads->executar($sql, $parametros);
	}

	/* Monta um JSON com os novos dados do contato*/
	$linha = $sistema->bd_leads->executar("SELECT * FROM TBL_LEADS WHERE ID_LEAD = :id",array(":id" => $_POST['id']),Banco_Dados::FETCH);
	$resultado = array();
	$resultado[] = array(
		'id' => $linha['ID_LEAD'],
		'nome' => $linha['TXT_NOME'],
		'email' => $linha['TXT_EMAIL'],
		'telefone' => $linha['NU_TELEFONE1'],
		'data' => $linha['DT_ATUAL'],
		'cliente' => $linha['TXT_LEAD_CLIENTE'],
		'status' => empty($linha['TXT_SITUACAO']) ? "--" : $linha['TXT_SITUACAO'],
		'qualidade' => empty($linha['TXT_QUALI']) ? "--" : $linha['TXT_QUALI'],
		'valorfechado' => number_format(floatval($linha['TXT_PRECO_FECHADO']/100),2,',','.'),
		'valororcado' => number_format(floatval($linha['TXT_PRECO']/100),2,',','.')
	);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>