<?php
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_indicacoes_geral == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!"; 
	exit;
}

try{
	$dados_sistema = $sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado no banco, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	$dados_cliente = $sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);
	$login = $dados_cliente['TXT_LOGIN'] . Utilitarios::gerar_token();

	$sistema->bd->executar("INSERT INTO TBL_CLIENTE (TXT_NOME, TXT_LOGIN, TXT_EMAIL, TXT_NOME_EMPRESA, TXT_RAMO, NU_ADWORDS, NU_TELEFONE_1, NU_TELEFONE_2, TXT_EMAIL_2, TXT_ANOTACOES, TXT_CONSULTORIA, NU_VONOID, DT_VONOINICIO, DT_VONOFIM, TXT_GOOGLE, TXT_FONE, TXT_LEADS, TXT_HOME, TXT_SENHA_NOVA, NU_ACESSOS_SISTEMA_DATA, TXT_NOTIFICACAO_FECHAMENTO, NU_PRECO_LIGACAO, NU_WHATSAPP, NU_CLIENTE_ATIVO, NU_POSSUI_WIN7FONE, TXT_LOG, NU_ATIVAR_DADOS_GERAIS, TXT_ID_TAG_FORMS, NU_PERM_PAUSAR_CAMPANHAS, NU_MOSTRAR_TOTAL_REAL_LIGACOES, NU_AGRUPAR_LIGACOES, NU_MOEDA_ADWORDS, NU_MOSTRAR_SOMENTE_CAMPANHAS) SELECT TXT_NOME, '".$login."', TXT_EMAIL, TXT_NOME_EMPRESA, TXT_RAMO, NU_ADWORDS, NU_TELEFONE_1, NU_TELEFONE_2, TXT_EMAIL_2, TXT_ANOTACOES, TXT_CONSULTORIA, NU_VONOID, DT_VONOINICIO, DT_VONOFIM, TXT_GOOGLE, TXT_FONE, TXT_LEADS, TXT_HOME, TXT_SENHA_NOVA, NU_ACESSOS_SISTEMA_DATA, TXT_NOTIFICACAO_FECHAMENTO, NU_PRECO_LIGACAO, NU_WHATSAPP, NU_CLIENTE_ATIVO, NU_POSSUI_WIN7FONE, TXT_LOG, NU_ATIVAR_DADOS_GERAIS, TXT_ID_TAG_FORMS, NU_PERM_PAUSAR_CAMPANHAS, NU_MOSTRAR_TOTAL_REAL_LIGACOES, NU_AGRUPAR_LIGACOES, NU_MOEDA_ADWORDS, NU_MOSTRAR_SOMENTE_CAMPANHAS FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $_POST['id']));
	$ultima_id = $sistema->bd->ultima_id();
	$_POST['id'] = $ultima_id;
	$duplicando = true;

	$sistema->logs->adicionar_log_duplicar_sistema_indicacoes($dados_sistema['TXT_NOME'],$dados_sistema['ID_FK']);

	require_once(__DIR__ . "/salvar_modal_cliente_indicacoes.php");

	// Faz a consulta no banco
	$dados = $sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :id", array("id" => $ultima_id), Banco_Dados::FETCH_ALL);
	
	$resultado = array();
	
	foreach($dados as $linha){
		$id = $linha['ID_FK'];
		$saldo_win7 = Mascara::converter_para_real($linha['TXT_SALDO_AGENCIA']);

		// Obtém os dados originais do cliente
		$dado = $sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $id), Banco_Dados::FETCH);

		$data_alteracao = $dado['NU_ACESSOS_SISTEMA_DATA'];
		if(Utilitarios::data_padrao_valida($data_alteracao)){
			$data_alteracao = strtotime($data_alteracao);
			$data_alteracao = date('d/m/Y H:i:s', $data_alteracao);
		}
		else{
			$data_alteracao = "Nunca";
		}

		// Calcula a soma do saldo de todos os indicadores
		$total_saldo = 0;
		$indicadores = $sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_CLIENTE = :id AND NU_TIPO = 1", array(':id' => $id), Banco_Dados::FETCH_ALL);
		foreach($indicadores as $row){
			$total_saldo += intval($row['TXT_SALDO']);
		}
		
		// Calcula a quantidade total que já foi paga
		$total = 0;
		$total_pago = 0;
		$indicadores = $sistema->bd->executar("SELECT * FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :id AND (NU_PROCESSADO = 1 OR NU_PROCESSADO = 0)", array(':id' => $id), Banco_Dados::FETCH_ALL);
		foreach($indicadores as $row){
			if($row['NU_PROCESSADO'] == 0)
				$total += intval($row['TXT_VALOR']);
			else if($row['NU_PROCESSADO'] == 1)
				$total_pago += intval($row['TXT_VALOR']);
		}
		
		// Monta o JSON final
		$resultado[] = array(
			"id" => $id,
			"nome" => $linha['TXT_NOME'],
			"nomeempresa" => $dado['TXT_NOME_EMPRESA'],
			"login" => $dado['TXT_LOGIN'],
			"saldowin" => $saldo_win7,
			"saldoind" => Mascara::converter_para_real(strval($total_saldo)),
			"bonuspagos" => Mascara::converter_para_real(strval($total_pago)),
			"bonuspendentes" => Mascara::converter_para_real(strval($total)),
			"ramo" => $dado['TXT_RAMO'],
			"acesso" => $data_alteracao
		);
	}
	
	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>