<?php
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_envio_email == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$resultado = $sistema->obter_email($_POST['id']);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado, ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	if($resultado['NU_STATUS'] != "2"){
		echo "-2E-mail não é editável!";
		exit;
	}

	$assunto = $_POST['assunto'];
	$nome = $_POST['nome'];
	$email = $_POST['remetente'];
	$mensagem = $_POST['mensagem'];

	$destinatarios = "";
	$counter = 1;
	while(!empty($_POST['destinatarioNome'.$counter])){
		if($counter > 1) $destinatarios .= " |$| ";
		$destinatarios .= $_POST['destinatarioNome'.$counter];
		$counter++;
	}

	if($counter > 1) $destinatarios .= " |$| ";
	$counter = 1;
	while(!empty($_POST['destinatarioNome'.$counter])){
		if($counter > 1) $destinatarios .= " |$| ";
		$destinatarios .= $_POST['destinatario'.$counter];
		$counter++;
	}

	$ocultas = "";
	$counter = 1;
	while(!empty($_POST['ocultaNome'.$counter])){
		if($counter > 1) $ocultas .= " |$| ";
		$ocultas .= $_POST['ocultaNome'.$counter];
		$counter++;
	}

	if($counter > 1) $ocultas .= " |$| ";
	$counter = 1;
	while(!empty($_POST['ocultaNome'.$counter])){
		if($counter > 1) $ocultas .= " |$| ";
		$ocultas .= $_POST['oculta'.$counter];
		$counter++;
	}

	$sql = "UPDATE TBL_ENVIO_EMAIL SET TXT_ASSUNTO = :ASSUNTO, TXT_NOME = :NOME, TXT_EMAIL = :EMAIL, TXT_DESTINATARIOS = :DEST, TXT_COPIAS_OCULTAS = :OCULTAS, TXT_MENSAGEM = :MENSAGEM WHERE NU_ID = :ID";
	$params = array(
		":ID" => $_POST['id'],
		":ASSUNTO" => $assunto,
		":EMAIL" => $email,
		":NOME" => $nome,
		":MENSAGEM" => $mensagem,
		":OCULTAS" => $ocultas,
		":DEST" => $destinatarios
	);
	$sistema->bd->executar($sql, $params);

	$resultado = array(
		"id" => $_POST['id'],
		"assunto" => $assunto,
		"nomeremetente" => $nome,
		"remetente" => $email
	);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>