<?php
/*
 * Este arquivo salva os dados do administrador
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!$sistema->usuario->super_adm_adm) {
	echo "-2Permissão Insuficiente";
	exit;
}


/* Verifica se os dados básicos são válidos */
if(empty($_POST['nome']) || empty($_POST['login']) || empty($_POST['email']) || empty($_POST['senha']) ){
	echo "-2Dados inválidos!";
	exit;
}

try{
	/* Lê todos os dados do formulário */
	$nome = $_POST['nome'];
	$login = $_POST['login'];
	$senha = $_POST['senha'];
	$superadm = $_POST['superadm'] == "Sim" ? 1 : 0;;
	$whatsapp = $_POST['whatsapp'];
	$email = $_POST['email'];

	// Permissões
	$perm_clientes = $_POST['permclientes'] == "Sim" ? 1 : 0;
	$perm_email = $_POST['permemail'] == "Sim" ? 1 : 0;
	$perm_indicacoes_adm = $_POST['permindicacoes1'] == "Sim" ? 1 : 0;
	$perm_resultados_gerais = $_POST['permresultados'] == "Sim" ? 1 : 0;
	$perm_todos_contatos = $_POST['permtodoscontatos'] == "Sim" ? 1 : 0;
	$perm_log = $_POST['permlog'] == "Sim" ? 1 : 0;
	$perm_win7fone = $_POST['permwin7fone'] == "Sim" ? 1 : 0;
	$perm_adwords = $_POST['permadwords'] == "Sim" ? 1 : 0;
	$permissao_contatos = intval($_POST['permcontatos']);
	$permissao_indicacoes = intval($_POST['permindicacoes2']);
	$permissao_arquivos = $_POST['permarquivos'] == "Sim" ? 1 : 0;
	$permissao_gsuite = $_POST['permgsuite'] == "Sim" ? 1 : 0;
	$permissao_comparacao = $_POST['comparacao'] == "Sim" ? 1 : 0;

	// Salva os daods principais no banco
	$sql = 'INSERT INTO TBL_ADM (TXT_NOME, TXT_EMAIL, TXT_LOGIN, NU_SUPER_ADM, TXT_WHATSAPP, TXT_SENHA_NOVA, NU_PERM_SISTEMA_CLIENTES, NU_PERM_SISTEMA_EMAIL, NU_PERM_INDICACOES_GERAL, NU_PERM_RESULTADOS_GERAIS, NU_PERM_TODOS_CONTATOS, NU_PERM_LOG_USUARIOS, NU_PERM_WIN7FONE, NU_PERM_ADWORDS, NU_PERM_CONTATOS, NU_PERM_INDICACOES, NU_PERM_ARQUIVOS, NU_PERM_GSUITE, NU_PERM_COMPARACAO) VALUES (:nome, :email, :login, :superadm, :whatsapp, :senha, :permclientes, :permemail, :permindicacoes1, :permresultados, :permtodoscontatos, :permlog, :permwin7fone, :permadwords, :permcontatos, :permindicacoes2, :permarquivos, :permgsuite, :comparacao)';
	$parametros = array(
		":nome" => $nome,
		":email" => $email,
		":superadm" => $superadm,
		":whatsapp" => $whatsapp,
		":login" => $login,
		":permclientes" => $perm_clientes,
		":permemail" => $perm_email,
		":permindicacoes1" => $perm_indicacoes_adm,
		":permresultados" => $perm_resultados_gerais,
		":permtodoscontatos" => $perm_todos_contatos,
		":permlog" => $perm_log,
		":permwin7fone" => $perm_win7fone,
		":permadwords" => $perm_adwords,
		":permcontatos" => $permissao_contatos,
		":permindicacoes2" => $permissao_indicacoes,
		":permarquivos" => $permissao_arquivos,
		":permgsuite" => $permissao_gsuite,
		":comparacao" => $permissao_comparacao,
		":senha" => Utilitarios::hash_str($senha)
	);
	$sistema->bd->executar($sql, $parametros);
	$ultima_id = $sistema->bd->ultima_id();

	$dados_adm = $sistema->bd->executar("SELECT * FROM TBL_ADM WHERE ID_ADM = :ID", array(":ID" => $ultima_id), Banco_Dados::FETCH);
	$sistema->logs->adicionar_log_novo_admin($dados_adm);
	$resultado = array();
	$resultado[] = array(
		"id" => $dados_adm['ID_ADM'],
		"nome" => $dados_adm['TXT_NOME'],
		"login" => $dados_adm['TXT_LOGIN'],
		"acesso" => "Nunca",
		"email" => $dados_adm['TXT_EMAIL'],
		"whatsapp" => empty($dados_adm['TXT_WHATSAPP']) ? "Não Possui" : $dados_adm['TXT_WHATSAPP'],
		"superadm" => $dados_adm['NU_SUPER_ADM'] == "1" ? "Sim" : "Não"
	);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>