<?php
/*
 * Este arquivo cria um novo cliente da agência baseado nas informações disponibilizadas.
 */

require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

/* Verifica se os dados essenciais do cliente não estão vazios */
if (empty($_POST['nome']) || empty($_POST['login']) || empty($_POST['empresa']) || empty($_POST['senha'])) {
	echo "-2Dados inválidos!";
	exit;
}

/* Verifica se a quantidade de ramais do vono é um número */
if (!ctype_digit($_POST['qtdVono'])) {
	echo "-2Dados inválidos!";
	exit;
}

/* Verifica se a quantidade de ramais do vono é um número */
if (!ctype_digit($_POST['qtdCampanhas'])) {
	echo "-2Dados inválidos!";
	exit;
}

/* Verifica se a data inicial do vono é inválida */
if (!empty($_POST['datainicial']) & !Utilitarios::data_valida($_POST['datainicial'])) {
	echo "-2Data Inicial Inválida!";
	exit;
}

/* Verifica se a data final do vono é inválida */
if (!empty($_POST['datafinal']) & !Utilitarios::data_valida($_POST['datafinal'])) {
	echo "-2Data Final Inválida!";
	exit;
}

/* Verifica se a página home especificada é válida */
$textos = array_keys($sistema->layout->possiveis_home);
if (!in_array($_POST['paginainicial'], $textos)) {
	echo "-2Dados inválidos!";
	exit;
}

/* Lê todos os dados do formulário */
$nome = $_POST['nome'];
$empresa = $_POST['empresa'];
$login = $_POST['login'];
$senha = Utilitarios::hash_str($_POST['senha']);
$email1 = $_POST['email1'];
$email2 = $_POST['email2'];
$telefone1 = $_POST['telefone1'];
$telefone2 = $_POST['telefone2'];
$tags = $_POST['tags'];
$seguimento = $_POST['sqlSeguimento'];
$txturlbtncontato = $_POST['txturlbtncontato'];
$adwords = $_POST['adwords'];
$home = $_POST['paginainicial'];
$consultoria = $_POST['consultoria'] == "Sim" ? 1 : 0;
$campanhas_ativadas = $_POST['google'] == "Sim" ? 1 : 0;
$win7fone_ativado = $_POST['ligacoes'] == "Sim" ? 1 : 0;
$cliente_ativo = $_POST['clienteativo'] == "Sim" ? 1 : 0;
$cliente_importante = $_POST['clienteimportante'] == "Sim" ? 1 : 0;
$win7phone_ativo = $_POST['win7phoneativo'] == "Sim" ? 1 : 0;
$leads_ativados = $_POST['leads'] == "Sim" ? 1 : 0;
$comparacao_ativada = $_POST['comparacao'] == "Sim" ? 1 : 0;
$whatsapp_ativado = $_POST['whatsapp'] == "Sim" ? 1 : 0;
$notificacao_fechamento = $_POST['notificacao-fechamento'] == "Sim" ? 1 : 0;
$btnaddlead = $_POST['btnaddlead'] == "Sim" ? 0 : 1;
$dados_gerais = $_POST['dadosgeraisativo'] == "Sim" ? 1 : 0;
$vonoinicio = $_POST['datainicial'];
$vonofim = $_POST['datafinal'];
$anotacoes = $_POST['anotacoes'];
date_default_timezone_set('America/Sao_Paulo');
$acesso = date('Y-m-d H:i:s', time());
$valor_ligacoes = $_POST['valor-ligacoes'];
$conversao_whatsapp = $_POST['conversao-whats'];
$tag_global = $_POST['tag-global'];
$log_ativo = $_POST['logativo'] == "Sim" ? 1 : 0;
$tag_forms = trim($_POST['tagforms']);
$perm_pausar_campanhas = $_POST['permpausarcampanhas'] == "Sim" ? 1 : 0;
$mostrar_total_ligacoes = $_POST['mostrartotalligacoes'] == "Sim" ? 1 : 0;
$agrupar_ligacoes = $_POST['agruparligacoes'] == "Sim" ? 1 : 0;
// $mostrar_apenas_campanhas = $_POST['mostrarapenascampanhas'] == "Sim" ? 1 : 0;
$mostrar_apenas_campanhas = $_POST['mostrarapenascampanhas'];
$mostrar_cpl = $_POST['mostrarcpl'] == "Sim" ? 1 : 0;
$ligacoes_efetuadas = $_POST['esconderligacoesefetuadas'] == "Sim" ? 1 : 0;
$moeda = intval($_POST['moedaadwords']);
$whatsBanco = $_POST['whatsBanco'] == "sim" ? 0 : 1;
$limite_custo_lead = preg_replace('/[^0-9]+/', '', strip_tags($_POST['limitecpl']));
if ($moeda > Sistema::MAXIMO_MOEDAS_ADWORDS || $moeda < 0) $moeda = 0;

/* Verifica se a página home selecionada é válida */
if ((($_POST['paginainicial'] == "contatos") & $leads_ativados == 0) ||
	(($_POST['paginainicial'] == "geral" || $_POST['paginainicial'] == "grupos" || $_POST['paginainicial'] == "grafico") & $campanhas_ativadas == 0) ||
	(($_POST['paginainicial'] == "ligacoes") & $win7fone_ativado == 0)
) {
	echo "-2Página inicial inválida!";
	exit;
}

/* Monta uma string contendo as ids do vono */
$vono_ids = '';
$quantidade_vono = intval($_POST['qtdVono']);
for ($counterVono = 1; $counterVono <= $quantidade_vono; $counterVono++) {
	$vonoid = $_POST['vono' . $counterVono];
	$vono_ids .= $vonoid;
	if ($counterVono < $quantidade_vono) {
		$vono_ids .= ',';
	}
}

/* Trata o POST com os numeros do WhatsApp */
$whatsappInput = $_POST['whatsappInput'];
$qtdWhats = count($whatsappInput);

$caracteresEspeciais = array(" ", "-", "(", ")", "+");

for ($i = 0; $i < $qtdWhats; $i++) {
	if ($i == $qtdWhats - 1) {
		$whatsappInputString  .= str_replace($caracteresEspeciais, '', $whatsappInput[$i]);
	} else {
		$whatsappInputString  .= str_replace($caracteresEspeciais, '', $whatsappInput[$i]) . "|%|";
	}
}


/* Monta array com os parâmetros para salvar no banco */
$parametros = array(
	':nome' => $nome,
	':login' => $login,
	':email1' => $email1,
	':email2' => $email2,
	':senha' => $senha,
	':empresa' => $empresa,
	':tags' => $tags,
	':seguimento' => $seguimento,
	':txturlbtncontato' => $txturlbtncontato,
	':adwords' => $adwords,
	':telefone1' => $telefone1,
	':telefone2' => $telefone2,
	':anotacoes' => $anotacoes,
	':consultoria' => $consultoria,
	':vonoid' => $vono_ids,
	':vonoinicio' => $vonoinicio,
	':vonofim' => $vonofim,
	':google' => $campanhas_ativadas,
	':ligacoes' => $win7fone_ativado,
	':leads' => $leads_ativados,
	':comparacao' => $comparacao_ativada,
	':home' => $home,
	':acesso' => $acesso,
	':fechamento' => $notificacao_fechamento,
	':btnaddlead' => $btnaddlead,
	':valorligacoes' => $valor_ligacoes,
	':whatsapp' => $whatsapp_ativado,
	':clienteativo' => $cliente_ativo,
	':clienteimportante' => $cliente_importante,
	':win7foneativo' => $win7phone_ativo,
	':logativo' => $log_ativo,
	':dadosgerais' => $dados_gerais,
	':tagforms' => $tag_forms,
	':permpausarcampanhas' => $perm_pausar_campanhas,
	":mostrartotalligacoes" => $mostrar_total_ligacoes,
	':agruparligacoes' => $agrupar_ligacoes,
	":moedaadwords" => $moeda,
	':mostrarapenascampanhas' => $mostrar_apenas_campanhas,
	":limitecustolead" => $limite_custo_lead,
	':mostrarcpl' => $mostrar_cpl,
	':esconderligacoesefetuadas' => $ligacoes_efetuadas,
	':numeroswhatsapp' => $whatsappInputString,
	':whatsbancolink' => $whatsBanco,
	':datainicialads' => $_POST['datainicialads']
);

try {
	/* Salva os dados no banco */
	$sql = 'INSERT INTO TBL_CLIENTE (DT_INICIOADS, NU_ESCONDER_LIGACOES_EFETUADAS, TXT_NOME, TXT_LOGIN, TXT_EMAIL, TXT_NOME_EMPRESA, TXT_RAMO, NU_ADWORDS, NU_TELEFONE_1, NU_TELEFONE_2, TXT_EMAIL_2, TXT_ANOTACOES, TXT_CONSULTORIA, NU_VONOID, DT_VONOINICIO, DT_VONOFIM, TXT_GOOGLE, TXT_FONE, TXT_LEADS, TXT_HOME, TXT_SENHA_NOVA, NU_ACESSOS_SISTEMA_DATA, TXT_NOTIFICACAO_FECHAMENTO, NU_PERM_BTN_ADICIONAR_LEAD, NU_PRECO_LIGACAO, NU_WHATSAPP, NU_CLIENTE_ATIVO, NU_CLIENTE_IMPORTANTE, NU_POSSUI_WIN7FONE, TXT_LOG, NU_ATIVAR_DADOS_GERAIS, TXT_ID_TAG_FORMS, NU_PERM_PAUSAR_CAMPANHAS, NU_MOSTRAR_TOTAL_REAL_LIGACOES, NU_AGRUPAR_LIGACOES, NU_MOEDA_ADWORDS, NU_MOSTRAR_SOMENTE_CAMPANHAS, TXT_LIMITE_CUSTO_LEAD, NU_MOSTRAR_CPL, NU_WHATSAPPS, TXT_WHATSAPP_LINK, TXT_SEGUIMENTO, TXT_URL_BTN_CONTATO, TXT_COMPARACAO) VALUES (:datainicialads, :esconderligacoesefetuadas, :nome, :login, :email1, :empresa, :tags, :adwords, :telefone1, :telefone2, :email2, :anotacoes, :consultoria, :vonoid, :vonoinicio, :vonofim, :google, :ligacoes, :leads, :home, :senha, :acesso, :fechamento, :btnaddlead, :valorligacoes, :whatsapp, :clienteativo, :clienteimportante, :win7foneativo, :logativo, :dadosgerais, :tagforms, :permpausarcampanhas, :mostrartotalligacoes, :agruparligacoes, :moedaadwords, :mostrarapenascampanhas, :limitecustolead, :mostrarcpl, :numeroswhatsapp, :whatsbancolink, :seguimento, :txturlbtncontato, :comparacao)';
	$sistema->bd->executar($sql, $parametros);

	$rowid = $sistema->bd->ultima_id();

	/* Salva os nomes dos ramais no banco */
	$sistema->bd->executar("DELETE FROM TBL_VONOIDS WHERE NU_IDCLIENTE = '$rowid'");
	for ($counterVono = 1; $counterVono <= $quantidade_vono; $counterVono++) {
		$vonoid = $_POST['vono' . $counterVono];
		$vononome = $_POST['vonoNome' . $counterVono];
		if (empty($vononome)) {
			$vononome = $_POST['vono' . $counterVono];
		}
		$sistema->bd->executar('INSERT INTO TBL_VONOIDS (NU_IDCLIENTE, NU_VONOID, TXT_NOME) VALUES(:NU_IDCLIENTE, :NU_VONOID, :TXT_NOME)', array(':NU_IDCLIENTE' => $rowid, ':NU_VONOID' => $vonoid, ':TXT_NOME' => $vononome));
	}

	// Inicia o processo de salvar os subusuários
	$quantidade_usuarios = intval($_POST['qtdUsuarios']);
	for ($counterUsuarios = 1; $counterUsuarios <= $quantidade_usuarios; $counterUsuarios++) {
		// Obtém todos os dados do subusuário
		$id_usuario = $_POST['idUsuario' . $counterUsuarios];
		$nome = $_POST['subusuarioNome' . $counterUsuarios];
		$login = $_POST['subusuarioLogin' . $counterUsuarios];
		$senha = empty($_POST['subusuarioSenha' . $counterUsuarios]) ? false : Utilitarios::hash_str($_POST['subusuarioSenha' . $counterUsuarios]);
		$permissao_indicacoes = intval($_POST['indicacoesPerm' . $counterUsuarios]);
		$permissao_contatos = intval($_POST['contatosPerm' . $counterUsuarios]);
		$permissao_adwords = $_POST['adwordsPerm' . $counterUsuarios] == "Sim" ? 0 : 2;
		$permissao_log = $_POST['logPerm' . $counterUsuarios] == "Sim" ? 0 : 2;
		$permissao_win7fone = $_POST['win7fonePerm' . $counterUsuarios] == "Sim" ? 0 : 2;
		$permissao_indicacoes = ($permissao_indicacoes > 2 || $permissao_indicacoes < 0) ? 0 : $permissao_indicacoes;
		$permissao_contatos = ($permissao_contatos > 2 || $permissao_contatos < 0) ? 0 : $permissao_contatos;
		$pag_home = $_POST['inicioSubusuario' . $counterUsuarios];
		$dados_gerais_sub = $_POST['dadosgerais' . $counterUsuarios] == "Sim" ? 1 : 0;

		// Verifica se já existe o subusuário
		$dados = $sistema->bd->executar('SELECT NU_ID FROM TBL_SUBUSUARIOS WHERE NU_ID = :ID AND ID_CLIENTE_FK = :ID2', array(':ID2' => $rowid, ':ID' => $id_usuario), Banco_Dados::FETCH_ALL);

		if (count($dados) > 0) { // Subusuário já existe, então só atualiza ele
			if (empty($senha)) { // Senha nova não foi informada, então salva apenas os outros dados
				$sql = 'UPDATE TBL_SUBUSUARIOS SET TXT_NOME = :NOME, TXT_LOGIN = :LOGIN, NU_PERM_INDICACOES = :PERM1, NU_PERM_CONTATOS = :PERM2, NU_PERM_ADWORDS = :PERM3, NU_PERM_LOG = :PERM4, NU_PERM_WIN7FONE = :PERM5, NU_ATIVAR_DADOS_GERAIS = :PERM6, TXT_HOME = :HOME WHERE NU_ID = :ID AND ID_CLIENTE_FK = :ID2';
				$params = array(
					":NOME" => $nome,
					":LOGIN" => $login,
					":PERM1" => $permissao_indicacoes,
					":PERM2" => $permissao_contatos,
					":PERM3" => $permissao_adwords,
					":PERM4" => $permissao_log,
					":PERM5" => $permissao_win7fone,
					":PERM6" => $dados_gerais_sub,
					':ID2' => $rowid,
					':ID' => $id_usuario,
					":HOME" => $pag_home
				);
			} else { // Se uma senha nova foi informada, salva ela junto
				$sql = "UPDATE TBL_SUBUSUARIOS SET TXT_NOME = :NOME, TXT_LOGIN = :LOGIN, NU_PERM_INDICACOES = :PERM1, NU_PERM_CONTATOS = :PERM2, NU_PERM_ADWORDS = :PERM3, NU_PERM_LOG = :PERM4, NU_PERM_WIN7FONE = :PERM5, NU_ATIVAR_DADOS_GERAIS = :PERM6, TXT_SENHA_NOVA = :SENHA, TXT_SENHA = '', TXT_HOME = :HOME WHERE NU_ID = :ID AND ID_CLIENTE_FK = :ID2";
				$params = array(
					":NOME" => $nome,
					":LOGIN" => $login,
					":PERM1" => $permissao_indicacoes,
					":PERM2" => $permissao_contatos,
					":PERM3" => $permissao_adwords,
					":PERM4" => $permissao_log,
					":PERM5" => $permissao_win7fone,
					":PERM6" => $dados_gerais_sub,
					':ID2' => $rowid,
					':ID' => $id_usuario,
					":SENHA" => $senha,
					":HOME" => $pag_home
				);
			}
			$sistema->bd->executar($sql, $params);
		} else { // Subusuário não existe, então insere ele no banco
			if (empty($senha)) { // Se a senha está vazia, então cria uma padrão
				$senha = Utilitarios::hash_str("123456");
			}
			$sql = 'INSERT INTO TBL_SUBUSUARIOS (TXT_NOME, TXT_LOGIN, NU_PERM_INDICACOES, NU_PERM_CONTATOS, NU_PERM_ADWORDS, NU_PERM_LOG, NU_PERM_WIN7FONE, NU_ATIVAR_DADOS_GERAIS,
			 TXT_SENHA_NOVA, ID_CLIENTE_FK, TXT_HOME) VALUES (:NOME,:LOGIN,:PERM1,:PERM2,:PERM3,:PERM4,:PERM5, :PERM6,:SENHA,:ID, :HOME)';
			$params = array(
				":NOME" => $nome,
				":LOGIN" => $login,
				":PERM1" => $permissao_indicacoes,
				":PERM2" => $permissao_contatos,
				":PERM3" => $permissao_adwords,
				":PERM4" => $permissao_log,
				":PERM5" => $permissao_win7fone,
				":PERM6" => $dados_gerais_sub,
				':ID' => $rowid,
				":SENHA" => $senha,
				":HOME" => $pag_home
			);

			$sistema->bd->executar($sql, $params);
		}
	}

	$quantidade_campanhas = intval($_POST['qtdCampanhas']);
	$ids_campanhas = array();

	for ($counterCampanhas = 1; $counterCampanhas <= $quantidade_campanhas; $counterCampanhas++) {
		$id_campanha = $_POST['idCampanha' . $counterCampanhas];
		$id_real = trim($_POST['idCampanhaReal' . $counterCampanhas]);
		$nome_campanha = trim($_POST['nomeCampanha' . $counterCampanhas]);

		if ($id_campanha == "-1") {
			$sistema->bd->executar('INSERT INTO TBL_CAMPANHAS_CLIENTE (TXT_NOME, ID_CAMPANHA, ID_CLIENTE_FK) VALUES (:nome, :campanha, :id)', array(
				':nome' => $nome_campanha,
				':campanha' => $id_real,
				':id' => $rowid
			));
			$ids_campanhas[] = intval($sistema->bd->ultima_id());
		} else {
			if (!ctype_digit($id_campanha)) {
				continue;
			}
			$sistema->bd->executar('UPDATE TBL_CAMPANHAS_CLIENTE SET TXT_NOME = :nome, ID_CAMPANHA = :campanha WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2', array(
				':nome' => $nome_campanha,
				':campanha' => $id_real,
				':id' => $id_campanha,
				':id2' => $rowid
			));
			$ids_campanhas[] = intval($id_campanha);
		}
	}
	if (count($ids_campanhas) == 1) {
		$sql = "DELETE FROM TBL_CAMPANHAS_CLIENTE WHERE ID_CLIENTE_FK = :id AND NU_ID != '" . $ids_campanhas[0] . "'";
		$sistema->bd->executar($sql, array(':id' => $rowid));
	} else if (count($ids_campanhas) > 1) {
		$sql = "DELETE FROM TBL_CAMPANHAS_CLIENTE WHERE ID_CLIENTE_FK = :id AND NU_ID != '" . $ids_campanhas[0] . "'";
		$total = count($ids_campanhas);
		for ($i = 1; $i < $total; $i++) {
			$sql .= " AND NU_ID != '" . $ids_campanhas[$i] . "'";
		}
		$sistema->bd->executar($sql, array(':id' => $rowid));
	} else if (count($ids_campanhas) == 0) {
		$sql = "DELETE FROM TBL_CAMPANHAS_CLIENTE WHERE ID_CLIENTE_FK = :id";
		$sistema->bd->executar($sql, array(':id' => $rowid));
	}

	// Monta os novos dados do cliente para atualizar a tabela
	$resultado = array();

	$cliente = $sistema->obter_cliente($rowid);

	$adwords = $cliente['NU_ADWORDS'] == "" ? "--" : $cliente['NU_ADWORDS'];

	$data_alteracao = $cliente['NU_ACESSOS_SISTEMA_DATA'];
	if (Utilitarios::data_padrao_valida($data_alteracao)) {
		$data_alteracao = strtotime($data_alteracao);
		$data_alteracao = date('d/m/Y H:i:s', $data_alteracao);
	} else {
		$data_alteracao = "Nunca";
	}

	$sistema->logs->adicionar_log_novo_cliente_adm($cliente['TXT_NOME_EMPRESA'], $cliente['ID_CLIENTE']);

	// Adiciona o cliente na array que será enviada por meio de JSON
	$resultado[] = array(
		"id" => $cliente['ID_CLIENTE'],
		"nome" => $cliente['TXT_NOME_EMPRESA'],
		"login" => $cliente['TXT_LOGIN'],
		"adwords" => $adwords,
		"ramo" => $cliente['TXT_RAMO'],
		"acesso" => $data_alteracao,
		"consultoria" => $cliente['TXT_CONSULTORIA'] == "0" ? "Não" : "Sim",
		"email" => empty($cliente['TXT_EMAIL']) ? "--" : $cliente['TXT_EMAIL'],
		"telefone" => empty($cliente['NU_TELEFONE_1']) ? "--" : $cliente['NU_TELEFONE_1'],
		"whatsapp" => $cliente['NU_WHATSAPP'] == "0" ? "Inativo" : "Ativo",
		"ativo" =>  $cliente['NU_CLIENTE_ATIVO'] == "0" ? "Não" : "Sim",
		"possuiwin7phone" => $cliente['NU_POSSUI_WIN7FONE'] == "0" ? "Não" : "Sim"
	);

	echo json_encode_alt($resultado);
} catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}
