<?php 
/*
 * Este arquivo salva um agendamento do google apps.
 */

require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_gsuite == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

require_once(__DIR__ . "/../../classes/Sistema_Gerencianet.php");

if(empty($_POST['vencimento']) || !Utilitarios::data_valida($_POST['vencimento'])){
	echo "-2Vencimento inválido!";
	exit;
}

if(empty($_POST['email'])){
	echo "-2Email inválido!";
	exit;
}

try{

	$dados = $sistema->bd->executar('SELECT * FROM TBL_GOOGLEAPPS WHERE ID = :id', array(":id" => $_POST['id']), Banco_Dados::FETCH);
	$id_transacao = intval($dados['TXT_ID_TRANSACAO']);
	$execucao = $dados['DT_ULTIMA_EXECUCAO'];
	$vencimento = $_POST['vencimento'];
	$vencimento = explode('/', $vencimento);
	$vencimento = $vencimento[2]."-".$vencimento[1]."-".$vencimento[0];
	$email = $_POST['email'];
	
	$sistema_gerencianet = new Sistema_Gerencianet($sistema->modo_sandbox, $sistema->bd);
	$resultado = $sistema_gerencianet->reenviar_boleto($email, $vencimento, $id_transacao, ($execucao != $vencimento));

	if($resultado == false){
		echo "-2".$sistema_gerencianet->last_err;
	}
	else{
		$sistema->logs->adicionar_log_reenvio_boleto_gsuite($dados['TXT_NOME']);
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>