<?php
/*
 * Este arquivo é responsável por enviar um contato especificado para a lixeira.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!"; 
	exit;
}

try{
	$dados_sistema = $sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado no banco, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	$valor = $dados_sistema['TXT_SALDO_AGENCIA'];
	
	// Insere o pagamento na tabela de pagamentos pendentes
	$sistema->bd->executar("INSERT INTO TBL_PAG_PENDENTES (ID_CLIENTE, CPF_INDICADOR, TXT_VALOR) VALUES (:ID_CLIENTE, :CPF_INDICADOR, :TXT_VALOR)", array(':ID_CLIENTE' => $_POST['id'], ':CPF_INDICADOR' => "-1", ':TXT_VALOR' => $valor));
	
	// Zera o saldo da Win7
	$sistema->bd->executar("UPDATE TBL_CLI_DADOS SET TXT_SALDO_AGENCIA = 0 WHERE ID_FK = :id", array(':id' => $_POST['id']));
	
	// Calcula os dados de bônus do sistema
	$total = 0;
	$total_pago = 0;
	$dados = $sistema->bd->executar("SELECT * FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :ID AND (NU_PROCESSADO = 1 OR NU_PROCESSADO = 0)", array(':ID' => $_POST['id']), Banco_Dados::FETCH_ALL);
	foreach($dados as $row){
		if($row['NU_PROCESSADO'] == 0)
			$total += intval($row['TXT_VALOR']);
		else if($row['NU_PROCESSADO'] == 1)
			$total_pago += intval($row['TXT_VALOR']);
	}
	$bonus_pagos = Mascara::converter_para_real(strval($total_pago));
	$bonus_pendentes = Mascara::converter_para_real(strval($total));
	
	// Calcula o saldo total e a quantidade de clientes fechados
	$dados = $sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_CLIENTE = :ID", array(':ID' => $_POST['id']), Banco_Dados::FETCH_ALL);
	$clientes_captados = count($dados);
	$clientes_fechados = 0;
	$total = 0;
	foreach($dados as $row){
		$total += intval($row['TXT_SALDO']); // Adiciona o saldo da indicação no saldo total
		if($row['TXT_STATUS'] == 'Fechado') $clientes_fechados++;
	}
	$saldo_total = Mascara::converter_para_real(strval($total));
	$valor = Mascara::converter_para_real(strval($valor));
	
	date_default_timezone_set('America/Sao_Paulo');
	$data_assunto = " - ". date('d/m/Y H:i:s');

	$sistema->enviar_email_sistema('<p style="color: #000;">Olá, '.$dados_sistema['TXT_NOME'].'!</p><p style="color: #000;">Requeremos o pagamento da nossa comissão no valor de '.$valor.', pelo uso do sistema de indicações. Tal valor foi subtraído do nosso saldo, favor dar baixa na área "Financeiro" no sistema Win7, quando o pagamento for feito. </p><p style="color: #000;">Agradecemos pela preferência em usar nosso sistema!</p><p style="color: #000;"><b>Dados de contato:</b><br>Email: contato@win7.com.br<br> Telefone: (61) 3028-4940</p><p style="color: #000;"><b>Dados Bancários:</b><br>Banco Bradesco<br>Ag 879<br>CC 15664-7<br>CNPJ: 13.762.777/0001­35<br>LEAD NEGOCIOS INTELIGENTES LTDA ­ ME</p><p style="color: #000;"></p>',"Pedido de pagamento de comissão".$data_assunto, $sistema->email_adm($dados_sistema['TXT_EMAIL']), "Agência Win7");

	$sistema->logs->adicionar_log_saque_sistema_indicacoes($dados_sistema['TXT_NOME'],$dados_sistema['ID_FK']);
	
	$resultado = array(
		"id" => $_POST['id'],
		"saldowin" => "R$ 0,00",
		"bonuspendentes" => $bonus_pendentes
	);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>