<?php
/*
 * Este arquivo é responsável por enviar um contato especificado para a lixeira.
 */
 
require_once(__DIR__ . "/../../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso
if($sistema->usuario->permissao_indicacoes_geral == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!"; 
	exit;
}

try{
	$dados_sistema = $sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :id", array(':id' => $_POST['id']), Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado no banco, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	Sistema_Indicacoes::zerar_sistema($sistema->bd, $_POST['id']);

	$sistema->logs->adicionar_log_zeramento_sistema_indicacoes($dados_sistema['TXT_NOME'],$dados_sistema['ID_FK']);

	$resultado = array(
		"id" => $_POST['id'],
		"saldowin" => "R$ 0,00",
		"bonuspendentes" => "R$ 0,00",
		"bonuspagos" => "R$ 0,00",
		"saldoindicadores" => "R$ 0,00"
	);

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>