<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, false, false);

$valor_atividade = 0;

if($sistema->usuario->acao == 'exibir-clientes-frequentes'){
	$sistema->usuario->zerar_acao($sistema->bd);
	$valor_atividade = 1;
}
else if($sistema->usuario->acao == 'exibir-clientes-nao-frequentes'){
	$sistema->usuario->zerar_acao($sistema->bd);
	$valor_atividade = 2;
}

try{
	// Faz a consulta dos seguimentos salvos
	$todosSeguimentos = $sistema->obter_seguimentos();
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}

?>
<!DOCTYPE html>
<html>
<head><!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
<script>
    (function() {
      try {
        var theme = localStorage.getItem('theme');
        if (!theme) {
          theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
        }
        document.documentElement.setAttribute('data-theme', theme);
      } catch (e) {}
    })();
  </script>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<title>Home - Sistema Win7</title>
	<link rel="icon" type="image/ico" href="favicon.png" />
	<link rel="stylesheet" href="../css/bootstrap.min.css">
	<link rel="stylesheet" href="../css/datatables.min.css"/>
	<link rel="stylesheet" href="../css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="../css/font-awesome.min.css">
	<link rel="stylesheet" href="../css/ionicons.min.css">
	<link rel="stylesheet" href="../css/AdminLTE.min.css">
	<link rel="stylesheet" href="../css/skin-blue.min.css">
	<link rel="stylesheet" href="css/custom2.0.1.css">
	<link rel="stylesheet" href="../css/toastr.min.css">
    <link rel="stylesheet" href="../css/bootstrap-datepicker.min.css">
    <link rel="stylesheet" href="../css/select2.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
</head>

<body data-theme="dark" class="hold-transition skin-blue sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<div class="modal fade" id="modal-confirmacao">
    <div class="modal-dialog">
        <div class="modal-content" id="modal-confirmacao-conteudo">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                    <span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title"><b>Confirmação</b></h4>
            </div>

            <div class="modal-body">
                Tem certeza de que deseja deletar os leads falsos? <b>Esta ação não é reversível.</b>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">Não</button>
                <a class="btn btn-primary" href="javascript:void(0);" onclick="deletarFalsoLead();">Sim</a>
            </div>
            <div class="overlay preloader">
                <i class="fa fa-refresh fa-spin"></i>
            </div>
        </div>
    </div>
</div>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('home');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Clientes da Agência
			<small>Visualize todos os clientes da Win7</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="home"><i class="fa green-text fa-home"></i> Home</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xs-12">
					<div class="box collapsed-box">
          				<div class="box-header with-border">
          					<h3 class="box-title">Filtrar Clientes Por</h3>
							<div class="box-tools pull-right">
								<button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i>
								</button>
							</div>
          				</div>
          				<div class="box-body">
          					<form action="" method="POST" id="formClientes">
                                <div class="row">
                                    <div class="col-xs-12">
                                        <div class="checkbox">
                                            <label style="margin-right: 10px;">
                                                <input type="checkbox" name="contatos" id="contatos" value="s" class="check-leads" <?php if(isset($sistema->usuario->filtro_clientes['contatos']) && $sistema->usuario->filtro_clientes['contatos'] == "s") {echo "checked";}?>>
                                                Exibir clientes sem formulários
                                            </label>
                                            <label style="margin-right: 10px;">
                                                <input type="checkbox" name="whatsapp" id="whatsapp" value="s" class="check-leads" <?php if(isset($sistema->usuario->filtro_clientes['whatsapp']) && $sistema->usuario->filtro_clientes['whatsapp'] == "s") {echo "checked";}?>>
                                                Exibir clientes sem WhatsApp
                                            </label>
                                            <label style="margin-right: 10px;">
                                                <input type="checkbox" name="ligacoes" id="ligacoes" value="s" class="check-leads" <?php if(isset($sistema->usuario->filtro_clientes['ligacoes']) && $sistema->usuario->filtro_clientes['ligacoes'] == "s") {echo "checked";}?>>
                                                Exibir clientes sem ligações
                                            </label>
                                            <label style="margin-right: 10px;">
                                                <input type="checkbox" name="ligacoesnaoatendidas" id="ligacoesnaoatendidas" value="s" class="check-leads" <?php if(isset($sistema->usuario->filtro_clientes['ligacoesnaoatendidas']) && $sistema->usuario->filtro_clientes['ligacoesnaoatendidas'] == "s") {echo "checked";}?>>
                                                Exibir clientes com ligações não atendidas
                                            </label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label>Atividade:</label>
                                            <select name="atividade" id="atividade" class="form-control filtragem" title="Selecione a filtragem por atividade desejada">
                                                <option value="todos" <?php if($valor_atividade == 0) { echo "selected"; } ?>>Sem Restrição</option>
                                                <option value="ativos" >Exibir Apenas Ativos</option>
                                                <option value="inativos" >Exibir Apenas Inativos</option>
                                                <option value="nao-frequentes" <?php if($valor_atividade == 2) { echo "selected"; } ?>>Exibir Apenas Ativos Não Frequentes</option>
                                                <option value="frequentes" <?php if($valor_atividade == 1) { echo "selected"; } ?>>Exibir Apenas Inativos Frequentes</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label>Win7 Fone:</label>
                                            <select name="win7fone" id="win7fone" class="form-control filtragem" title="Selecione a filtragem por win7 fone desejada">
                                                <option value="todos" <?php if($valor_atividade == 0) { echo "selected"; } ?>>Sem Restrição</option>
                                                <option value="possui" >Exibir Apenas Ativos</option>
                                                <option value="nao-possui" >Exibir Apenas Inativos</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <label>Data dos leads:</label>
                                            <select name="data-leads" id="data-leads" class="form-control" title="Selecione a filtragem de data para os leads">
                                                <option value="--">--</option>
                                                <option value="hoje" <?php if(isset($sistema->usuario->filtro_clientes['data']) && $sistema->usuario->filtro_clientes['data'] == "hoje") {echo "selected";} ?>>Hoje</option>
                                                <option value="ontem" <?php if(isset($sistema->usuario->filtro_clientes['data']) && $sistema->usuario->filtro_clientes['data'] == "ontem") {echo "selected";} ?>>Ontem</option>
                                                <option value="essa-semana" <?php if(isset($sistema->usuario->filtro_clientes['data']) && $sistema->usuario->filtro_clientes['data'] == "essa-semana") {echo "selected";} ?>>Essa Semana</option>
                                                <option value="semana-passada" <?php if(isset($sistema->usuario->filtro_clientes['data']) && $sistema->usuario->filtro_clientes['data'] == "semana-passada") {echo "selected";} ?>>Semana Passada</option>
                                                <option value="esse-mes" <?php if(isset($sistema->usuario->filtro_clientes['data']) && $sistema->usuario->filtro_clientes['data'] == "esse-mes") {echo "selected";} ?>>Esse Mês</option>
                                                <option value="mes-passado" <?php if(isset($sistema->usuario->filtro_clientes['data']) && $sistema->usuario->filtro_clientes['data'] == "mes-passado") {echo "selected";} ?>>Mês Passado</option>
                                                <option value="personalizado" <?php if(isset($sistema->usuario->filtro_clientes['data']) && $sistema->usuario->filtro_clientes['data'] == "personalizado") {echo "selected";} ?>>Personalizado</option>
                                            </select>
                                        </div>
                                    </div>


                                    <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 col-xs-12">
                                        <div class="form-group">
                                            <div style="display: flex; justify-content: space-between; align-items: center;">
                                                <label>Seguimento: </label>
                                                <small class="label bg-blue" id="btnTodos" style="cursor: pointer;padding: 5px 10px;margin-right: 1px;" > Filtrar TODOS</small>
                                            </div>
                                            <div class="input-group" style="width: 100%;">
                                                <!-- <div class="input-group-addon"><i class="fa fa-edit"></i></div> -->
                                                <select name="slqSeguimento" for="slct" class="js-example-basic-multiple filtragem">
 
                                                    <option value="" selected disabled>Selecione:</option>

                                                    <?php                                                         
                                                        foreach ($todosSeguimentos as $seguimento) {
                                                            if ($seguimento['ID'] == $sistema->usuario->filtro_clientes['seguimento']) {
                                                                echo '<option value="'.$seguimento['ID'].'" selected >'.$seguimento['TXT_SEGUIMENTO'].'</option>';
                                                            } else {
                                                                echo '<option value="'.$seguimento['ID'].'">'.$seguimento['TXT_SEGUIMENTO'].'</option>';
                                                            }
                                                        }
                                                    ?>
                                                    <option value="todos" >TODOS</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="<?php if(!isset($sistema->usuario->filtro_clientes['data']) || $sistema->usuario->filtro_clientes['data'] != "personalizado") {echo "hide";} ?> datadiv">
                                        <div class="col-xl-2 col-lg-4 col-md-4 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Data Inicial:</label>
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" name="datainicial" id="datainicial" value="<?php if(isset($sistema->usuario->filtro_clientes['datainicial'])) {echo $sistema->usuario->filtro_clientes['datainicial'];} ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-2 col-lg-4 col-md-4 col-sm-6 col-xs-12">
                                            <div class="form-group">
                                                <label>Data Final:</label>
                                                <div class="input-group date">
                                                    <div class="input-group-addon">
                                                        <i class="fa fa-calendar"></i>
                                                    </div>
                                                    <input type="text" class="form-control pull-right datepicker" name="datafinal" id="datafinal" value="<?php if(isset($sistema->usuario->filtro_clientes['datafinal'])) {echo $sistema->usuario->filtro_clientes['datafinal'];} ?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-2 col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                            <label> </label>
                                            <div class="form-group">
                                                <a id="datapersonalizada" class="btn btn-block btn-primary btn-flat">Pesquisar</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
							</form>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
					<div class="box">
						<div class="box-header with-border">
							<a href="javascript:void(0);" onclick="modalNovoCliente();" class="btn btn-primary" >Adicionar Cliente</a>
                            <a href="javascript:void(0);" onclick="modalDeletarFalsoLead();" class="btn btn-danger" >Deletar Leads Falsos</a>
          				</div>
          				<div class="box-body">
          					<div id="tabelaClientes" class="tabela">
          						<table id="tbClientes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
          					</div>
          				</div>
          				<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          			</div>
				</div>
			</div>
		</section>
	</div>

	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="../js/jquery.min.js"></script>
<script src="../js/datatables.min.js"></script>
<script src="../js/bootstrap.min.js"></script>
<script src="../js/adminlte.min.js"></script>
<script src="../js/bootstrap-datepicker.min.js"></script>
<script src="../js/bootstrap-datepicker.pt-BR.min.js"></script>
<script src="../js/toastr.min.js"></script>
<script src="../js/jquery.mask.min.js"></script>
<script src="../js/moment.min.js"></script>
<script src="../js/datetime-moment.js"></script>
<script src="../js/date.js"></script>
<script src="../js/country-masks/jquery.inputmask-multi.min.js"></script>
<script src="../js/country-masks/jquery.inputmask.bundle.min.js"></script>
<script src="../js/select2.min.js"></script>
<script src="js/home3-0-2"></script>

</body>
</html>