<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, false, false);

if (!$sistema->usuario->super_adm_adm) {
    $sistema->redirecionar("home");
}
/** @var \Usuario_Adm $usuario */
$usuario      = $sistema->usuario;
$falsos_leads = $usuario->obter_falsos_leads($sistema->bd);
?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-MFFM5J3');</script>
<!-- End Google Tag Manager -->
<script>
    (function() {
      try {
        var theme = localStorage.getItem('theme');
        if (!theme) {
          theme = window.matchMedia('(prefers-color-scheme: dark)').matches ? 'dark' : 'light';
        }
        document.documentElement.setAttribute('data-theme', theme);
      } catch (e) {}
    })();
  </script>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <title>Parâmetros - Sistema Win7</title>
    <link rel="icon" type="image/ico" href="favicon.png"/>
    <link rel="stylesheet" href="../css/bootstrap.min.css">
    <link rel="stylesheet" href="../css/datatables.min.css"/>
    <link rel="stylesheet" href="../css/bootstrap-xl-xxl.css">
    <link rel="stylesheet" href="../css/font-awesome.min.css">
    <link rel="stylesheet" href="../css/ionicons.min.css">
    <link rel="stylesheet" href="../css/AdminLTE.min.css">
    <link rel="stylesheet" href="../css/skin-blue.min.css">
    <link rel="stylesheet" href="css/custom2.0.1.css">
    <link rel="stylesheet" href="../css/toastr.min.css">
    <link rel="stylesheet" href="../css/bootstrap-datepicker.min.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
    <?php $sistema->layout->criar_meta_tags(); ?>
</head>

<body data-theme="dark" class="hold-transition skin-blue sidebar-mini <?php if ($sistema->usuario->sidebar) {
    echo "sidebar-collapse";
} ?>"><!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-MFFM5J3"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema">
    <div class="modal-dialog modal-lg">
        <div class="modal-content" id="modal-sistema-conteudo"></div>
    </div>
</div>
<div class="modal fade" id="modal-confirmacao">
    <div class="modal-dialog">
        <div class="modal-content" id="modal-confirmacao-conteudo"></div>
    </div>
</div>
<div class="wrapper">
    <?php $sistema->layout->exibir_cabecalho_adm('parametros'); ?>

    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <section class="content-header">
            <h1>
                Parâmetros
                <small>Personalize o funcionamento do sistema</small>
            </h1>
            <ol class="breadcrumb">
                <li><a href="parametros"><i class="fa green-text fa-cog"></i> Parâmetros</a></li>
            </ol>
        </section>

        <section class="content container-fluid">
            <div class="row">
                <div class="col-xs-12">
                    <div class="box">
                        <div class="box-header with-border">
                            <button type="button" class="btn btn-box-tool" id="adicionar-falso-lead-btn"><i class="fa fa-plus text-green"></i></button>
                            <h3 class="box-title"><b>Leads Falsos</b></h3>
                            - Especifique os leads que devem ser deletados ao clicar no botão "Deletar Leads Falsos"

                        </div>
                        <div class="box-body">
                            <div id="base-falso-lead" class="col-xs-12 col-sm-6 col-md-3 col-xl-2 hidden falso-lead">
                                <div class="form-group">
                                    <div class="input-group">
                                        <div class="input-group-addon">
                                            <a href="javascript:void(0);" class="deletar-falso-lead-btn" title="Clique para deletar">
                                                <i class="fa fa-trash-o text-red"></i>
                                            </a>
                                        </div>
                                        <input type="text" class="form-control pull-right falso-lead-input" data-deletar="0" required/>
                                    </div>
                                </div>
                            </div>
                            <div id="falsos-leads" class="row">
                                <?php
                                $counter = -1;
                                foreach ($falsos_leads as $lead) {
                                    $counter++;
                                    ?>
                                    <div id="base-falso-lead" class="col-xs-12 col-sm-6 col-md-3 col-xl-2 falso-lead">
                                        <div class="form-group">
                                            <div class="input-group">
                                                <div class="input-group-addon">
                                                    <a href="javascript:void(0);" class="deletar-falso-lead-btn" title="Clique para deletar">
                                                        <i class="fa fa-trash-o text-red"></i>
                                                    </a>
                                                </div>
                                                <input type="text" class="form-control pull-right falso-lead-input" data-deletar="0" data-id="<?=$lead['id']?>" id="falso-lead-<?=$counter?>" value="<?=$lead['valor']?>" required/>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <button type="button" class="btn btn-primary pull-left" id="salvar-falsos-leads">Salvar</button>
                        </div>
                        <div class="overlay preloader">
                            <i class="fa fa-refresh fa-spin"></i>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>

    <?php $sistema->layout->exibir_rodape(); ?>
</div>

<script src="../js/jquery.min.js"></script>
<script src="../js/datatables.min.js"></script>
<script src="../js/bootstrap.min.js"></script>
<script src="../js/adminlte.min.js"></script>
<script src="../js/bootstrap-datepicker.min.js"></script>
<script src="../js/bootstrap-datepicker.pt-BR.min.js"></script>
<script src="../js/toastr.min.js"></script>
<script src="../js/jquery.mask.min.js"></script>
<script src="../js/moment.min.js"></script>
<script src="../js/datetime-moment.js"></script>
<script src="../js/date.js"></script>
<script src="js/falso-lead1.0.0.js"></script>

</body>
</html>