<?php

/***
 * Esta classe é responsável por guarda os dados de filtro do sistema.
 ***/
class Filtro
{

    private $data_inicio;
    private $data_fim;
    private $data_3;
    private $data_4;
    private $data_5;
    private $data_6;
    private $data_7;
    private $data_8;
    private $valor;
    private static $possiveis_valores = [
        "ALL_TIME",
        "TODAY",
        "YESTERDAY",
        "THIS_WEEK_SUN_TODAY",
        "THIS_WEEK_MON_TODAY",
        "LAST_BUSINESS_WEEK",
        "LAST_WEEK",
        "LAST_WEEK_SUN_SAT",
        "LAST_7_DAYS",
        "LAST_7_DAYS_TODAY",
        "LAST_14_DAYS",
        "LAST_14_DAYS_TODAY",
        "LAST_30_DAYS",
        "LAST_30_DAYS_TODAY",
        "THIS_MONTH",
        "LAST_MONTH",
        "CUSTOM_DATE",
    ];

    function __construct()
    {
        $this->valor = "TODAY";
    }

    /* Muda a data inicial do filtro personalizado */
    function set_data_inicio($data)
    {
        if (Utilitarios::data_valida($data)) {
            $this->data_inicio = $data;
        }
    }

    /* Muda a data final do filtro personalizado */
    function set_data_fim($data)
    {
        if (Utilitarios::data_valida($data)) {
            $this->data_fim = $data;
        }
    }

    /* Muda o valor do filtro */
    function set_valor($valor)
    {
        if (in_array($valor, self::$possiveis_valores)) {
            $this->valor = $valor;
        }
    }

    /* Muda a data 3 do filtro personalizado */
    function set_data_3($data)
    {
        if (empty($data)) {
            $this->data_3 = "";

            return;
        }
        if (Utilitarios::data_valida($data)) {
            $this->data_3 = $data;
        }
    }

    /* Muda a data 4 do filtro personalizado */
    function set_data_4($data)
    {
        if (empty($data)) {
            $this->data_4 = "";

            return;
        }
        if (Utilitarios::data_valida($data)) {
            $this->data_4 = $data;
        }
    }

    /* Muda a data 5 do filtro personalizado */
    function set_data_5($data)
    {
        if (empty($data)) {
            $this->data_5 = "";

            return;
        }
        if (Utilitarios::data_valida($data)) {
            $this->data_5 = $data;
        }
    }

    /* Muda a data 6 do filtro personalizado */
    function set_data_6($data)
    {
        if (empty($data)) {
            $this->data_6 = "";

            return;
        }
        if (Utilitarios::data_valida($data)) {
            $this->data_6 = $data;
        }
    }

    /* Muda a data 7 do filtro personalizado */
    function set_data_7($data)
    {
        if (empty($data)) {
            $this->data_7 = "";

            return;
        }
        if (Utilitarios::data_valida($data)) {
            $this->data_7 = $data;
        }
    }

    /* Muda a data 8 do filtro personalizado */
    function set_data_8($data)
    {
        if (empty($data)) {
            $this->data_8 = "";

            return;
        }
        if (Utilitarios::data_valida($data)) {
            $this->data_8 = $data;
        }
    }

    /* Retorna a data inicial do filtro personalizado */
    function data_inicio()
    {
        return $this->data_inicio;
    }

    /* Retorna a data inicial do filtro personalizado */
    function data_fim()
    {
        return $this->data_fim;
    }

    /* Retorna a data 3 do filtro personalizado */
    function data_3()
    {
        return $this->data_3;
    }

    /* Retorna a data 4 do filtro personalizado */
    function data_4()
    {
        return $this->data_4;
    }

    /* Retorna a data 5 do filtro personalizado */
    function data_5()
    {
        return $this->data_5;
    }

    /* Retorna a data 6 do filtro personalizado */
    function data_6()
    {
        return $this->data_6;
    }

    /* Retorna a data 7 do filtro personalizado */
    function data_7()
    {
        return $this->data_7;
    }

    /* Retorna a data 8 do filtro personalizado */
    function data_8()
    {
        return $this->data_8;
    }

    /* Retorna o valor do filtro */
    function valor()
    {
        return $this->valor;
    }

    /* Verifica se o filtro especificado */
    static function validar($valor, $data1, $data2)
    {
        if (!in_array($valor, self::$possiveis_valores)) {
            return false;
        }
        if ($valor == "CUSTOM_DATE" & (!Utilitarios::data_valida($data1) || !Utilitarios::data_valida($data2))) {
            return false;
        }
        if ($valor == "CUSTOM_DATE") {
            if (Utilitarios::comparar_datas($data1, $data2) > 0) {
                return false;
            }
        }

        return true;
    }

    /* Retorna uma condição SQL que restringe a data de uma pesquisa no banco */
    static function filtrar_data($valor, $campo, $inicial, $final)
    {
        switch ($valor) {
            case 'ALL_TIME':
                $str = '';
                break;
            case 'TODAY':
                $datahj = date('Y-m-d', time());
                $str    = "DATE(" . $campo . ") = '$datahj'";
                break;
            case 'YESTERDAY':
                $dataOntem = date('Y-m-d', time() - (24 * 3600));
                $str       = "DATE(" . $campo . ") = '$dataOntem'";
                break;
            case 'THIS_WEEK_SUN_TODAY':
                $dtInicial = date('Y-m-d', strtotime('last sunday', strtotime('tomorrow')));
                $dtFinal   = date('Y-m-d', time());
                $str       = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'THIS_WEEK_MON_TODAY':
                $dtInicial = date('Y-m-d', strtotime('last monday', strtotime('tomorrow')));
                $dtFinal   = date('Y-m-d', time());
                $str       = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_BUSINESS_WEEK':
                $previous_week = strtotime("-1 week +1 day");
                $start_week    = strtotime("last monday midnight", $previous_week);
                $end_week      = strtotime("next saturday", $start_week);
                $start_week    = date("Y-m-d", $start_week);
                $end_week      = date("Y-m-d", $end_week);
                $dtInicial     = $start_week;
                $dtFinal       = $end_week;
                $str           = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_WEEK':
                // de segunda a domingo
                $previous_week = strtotime("-1 week +1 day");
                $start_week    = strtotime("last monday midnight", $previous_week);
                $end_week      = strtotime("next sunday", $start_week);
                $start_week    = date("Y-m-d", $start_week);
                $end_week      = date("Y-m-d", $end_week);
                $dtInicial     = $start_week;
                $dtFinal       = $end_week;
                $str           = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_WEEK_SUN_SAT':
                // de domingo a sabado
                $previous_week = strtotime("-1 week +1 day");
                $start_week    = strtotime("last sunday midnight", $previous_week);
                $end_week      = strtotime("next saturday", $start_week);
                $start_week    = date("Y-m-d", $start_week);
                $end_week      = date("Y-m-d", $end_week);
                $dtInicial     = $start_week;
                $dtFinal       = $end_week;
                $str           = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_7_DAYS':
                $start_week = strtotime("-7 days");
                $end_week   = strtotime("-1 day");
                $start_week = date("Y-m-d", $start_week);
                $end_week   = date("Y-m-d", $end_week);
                $dtInicial  = $start_week;
                $dtFinal    = $end_week;
                $str        = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_7_DAYS_TODAY':
                $start_week = strtotime("-7 days");
                $end_week   = time();
                $start_week = date("Y-m-d", $start_week);
                $end_week   = date("Y-m-d", $end_week);
                $dtInicial  = $start_week;
                $dtFinal    = $end_week;
                $str        = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_14_DAYS':
                $start_week = strtotime("-14 days");
                $end_week   = strtotime("-1 day");
                $start_week = date("Y-m-d", $start_week);
                $end_week   = date("Y-m-d", $end_week);
                $dtInicial  = $start_week;
                $dtFinal    = $end_week;
                $str        = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_14_DAYS_TODAY':
                $start_week = strtotime("-14 days");
                $end_week   = time();
                $start_week = date("Y-m-d", $start_week);
                $end_week   = date("Y-m-d", $end_week);
                $dtInicial  = $start_week;
                $dtFinal    = $end_week;
                $str        = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_30_DAYS':
                $start_week = strtotime("-30 days");
                $end_week   = strtotime("-1 day");
                $start_week = date("Y-m-d", $start_week);
                $end_week   = date("Y-m-d", $end_week);
                $dtInicial  = $start_week;
                $dtFinal    = $end_week;
                $str        = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_30_DAYS_TODAY':
                $start_week = strtotime("-30 days");
                $end_week   = time();
                $start_week = date("Y-m-d", $start_week);
                $end_week   = date("Y-m-d", $end_week);
                $dtInicial  = $start_week;
                $dtFinal    = $end_week;
                $str        = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'THIS_MONTH':
                $dataMesAtual = date('m', time());
                $dataAnoAtual = date('Y', time());
                $str          = "MONTH(" . $campo . ") = '$dataMesAtual' AND YEAR(" . $campo . ") = '$dataAnoAtual'";
                break;
            case 'LAST_MONTH':
                // Ao inves de usar o -1 month ou last month, pegamos o ultimo dia do ultimo mesdo
                // O -1 month estava dando erro quando alguém fazia uma busca no dia 31 do mês
                // Com o last day of last month, esse erro não acontece
                // Alteramos para uma forma personalizada com o first e last day
                $str = "DATE(" . $campo . ") BETWEEN '" . date('Y-m-d',
                        strtotime('first day of last month')) . "' AND '" . date('Y-m-d',
                        strtotime('last day of last month')) . "'";
                break;
            case 'CUSTOM_DATE':
                $dtInicial = $inicial;
                $dtFinal   = $final;
                $dtInicial = str_replace(['/'], '-', $dtInicial);
                $dtInicial = new DateTime($dtInicial);
                $dtInicial = $dtInicial->format('Y-m-d');
                $dtFinal   = str_replace(['/'], '-', $dtFinal);
                $dtFinal   = new DateTime($dtFinal);
                $dtFinal   = $dtFinal->format('Y-m-d');
                $str       = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            default:
                $str = "DATE(" . $campo . ") = " . date("Y-m-d", time());
                break;
        }

        return $str;
    }

    /* Retorna a quantidade de dias entre as datas */
    static function filtrar_data_qtd_dias($valor, $campo, $inicial, $final)
    {
        switch ($valor) {
            case 'ALL_TIME':
                $str = 1; // Melhorar
                break;
            case 'TODAY':
                $str = 1;
                break;
            case 'YESTERDAY':
                $str = 1;
                break;
            case 'THIS_WEEK_SUN_TODAY':

                $dtInicial = date('Y-m-d', strtotime('last sunday', strtotime('tomorrow')));
                $dtFinal   = date('Y-m-d', time());

                // Calcula a diferença em segundos entre as datas
                $diferenca = strtotime($dtInicial) - strtotime($dtFinal);
                //Calcula a diferença em dias
                $str = floor($diferenca / (60 * 60 * 24 * (-1))) + 1;

                // $str       = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'THIS_WEEK_MON_TODAY':

                $dtInicial = date('Y-m-d', strtotime('last monday', strtotime('tomorrow')));
                $dtFinal   = date('Y-m-d', time());

                // Calcula a diferença em segundos entre as datas
                $diferenca = strtotime($dtInicial) - strtotime($dtFinal);
                //Calcula a diferença em dias
                $str = floor($diferenca / (60 * 60 * 24 * (-1))) + 1;

                // $str       = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            case 'LAST_BUSINESS_WEEK':
                $str = 5;
                break;
            case 'LAST_WEEK':
                $str = 7;
                break;
            case 'LAST_WEEK_SUN_SAT':
                $str = 7;
                break;
            case 'LAST_7_DAYS':
                $str = 7;
                break;
            case 'LAST_7_DAYS_TODAY':
                $str = 8;
                break;
            case 'LAST_14_DAYS':
                $str = 14;
                break;
            case 'LAST_14_DAYS_TODAY':
                $str = 15;
                break;
            case 'LAST_30_DAYS':
                $str = 30;
                break;
            case 'LAST_30_DAYS_TODAY':
                $str = 31;
                break;
            case 'THIS_MONTH':
                // Pega o dia de hoje
                $str = date("d");
                break;
            case 'LAST_MONTH':
                // Pega o ultimo dia do mes passado
                $str = date('d', strtotime('last day of last month'));
                break;
            case 'CUSTOM_DATE':

                $dtInicial = $inicial;
                $dtFinal   = $final;

                $dtInicial = str_replace(['/'], '-', $dtInicial);
                $dtInicial = new DateTime($dtInicial);
                $dtInicial = $dtInicial->format('Y-m-d');

                $dtFinal = str_replace(['/'], '-', $dtFinal);
                $dtFinal = new DateTime($dtFinal);
                $dtFinal = $dtFinal->format('Y-m-d');

                // Calcula a diferença em segundos entre as datas
                $diferenca = strtotime($dtInicial) - strtotime($dtFinal);
                //Calcula a diferença em dias
                $str = floor($diferenca / (60 * 60 * 24 * (-1))) + 1;

                // Se as datas forem do mesmo dia, ele retorna 0, dai somo mais 1
                if ($str == '0') {
                    $str = 1;
                }

                // $str = "DATE(" . $campo . ") BETWEEN '$dtInicial' AND '$dtFinal'";
                break;
            default:
                $str = 1;
                break;
        }

        return $str;
    }

    static function filtrar_3cx($valor, $inicial, $final)
    {
        date_default_timezone_set('America/Sao_Paulo');
        switch ($valor) {
            case 'ALL_TIME':
                $inicio = '2014-01-01 00:00:00-03';
                $fim    = date('Y-m-d H:i:s-03', time());
                break;
            case 'TODAY':
                $inicio = date('Y-m-d 00:00:00-03', time());
                $fim    = date('Y-m-d H:i:s-03', time());
                break;
            case 'YESTERDAY':
                $inicio = date('Y-m-d 00:00:00-03', time() - (24 * 3600));
                $fim    = date('Y-m-d 23:59:59-03', time() - (24 * 3600));
                break;
            case 'THIS_WEEK_SUN_TODAY':
                $inicio = date('Y-m-d 00:00:00-03', strtotime('last sunday', strtotime('tomorrow')));
                $fim    = date('Y-m-d H:i:s-03', time());
                break;
            case 'THIS_WEEK_MON_TODAY':
                $inicio = date('Y-m-d 00:00:00-03', strtotime('last monday', strtotime('tomorrow')));
                $fim    = date('Y-m-d H:i:s-03', time());
                break;
            case 'LAST_BUSINESS_WEEK':
                $previous_week = strtotime("-1 week +1 day");
                $start_week    = strtotime("last sunday midnight", $previous_week);
                $end_week      = strtotime("next saturday", $start_week);
                $inicio        = date("Y-m-d 00:00:00-03", $start_week);
                $fim           = date("Y-m-d 23:59:59-03", $end_week);
                break;
            case 'LAST_WEEK':
                $previous_week = strtotime("-1 week +1 day");
                $start_week    = strtotime("last sunday midnight", $previous_week);
                $end_week      = strtotime("next saturday", $start_week);
                $inicio        = date("Y-m-d 00:00:00-03", $start_week);
                $fim           = date("Y-m-d 23:59:59-03", $end_week);
                break;
            case 'LAST_WEEK_SUN_SAT':
                $previous_week = strtotime("-1 week +1 day");
                $start_week    = strtotime("last sunday midnight", $previous_week);
                $end_week      = strtotime("next saturday", $start_week);
                $inicio        = date("Y-m-d 00:00:00-03", $start_week);
                $fim           = date("Y-m-d 23:59:59-03", $end_week);
                break;
            case 'LAST_7_DAYS':
                $start_week = strtotime("-7 days");
                $end_week   = strtotime("-1 day");
                $inicio     = date("Y-m-d 00:00:00-03", $start_week);
                $fim        = date("Y-m-d 23:59:59-03", $end_week);
                break;
            case 'LAST_7_DAYS_TODAY':
                $start_week = strtotime("-7 days");
                $end_week   = time();
                $inicio     = date("Y-m-d 00:00:00-03", $start_week);
                $fim        = date("Y-m-d 23:59:59-03", $end_week);
                break;
            case 'LAST_14_DAYS':
                $start_week = strtotime("-14 days");
                $end_week   = strtotime("-1 day");
                $inicio     = date("Y-m-d 00:00:00-03", $start_week);
                $fim        = date("Y-m-d 23:59:59-03", $end_week);
                break;
            case 'LAST_14_DAYS_TODAY':
                $start_week = strtotime("-14 days");
                $end_week   = time();
                $inicio     = date("Y-m-d 00:00:00-03", $start_week);
                $fim        = date("Y-m-d 23:59:59-03", $end_week);
                break;
            case 'LAST_30_DAYS':
                $start_week = strtotime("-30 days");
                $end_week   = strtotime("-1 day");
                $inicio     = date("Y-m-d 00:00:00-03", $start_week);
                $fim        = date("Y-m-d 23:59:59-03", $end_week);
                break;
            case 'LAST_30_DAYS_TODAY':
                $start_week = strtotime("-30 days");
                $end_week   = time();
                $inicio     = date("Y-m-d 00:00:00-03", $start_week);
                $fim        = date("Y-m-d 23:59:59-03", $end_week);
                break;
            case 'THIS_MONTH':
                $inicio = date("Y-m-01 00:00:00-03", time());
                $fim    = date('Y-m-d H:i:s-03', time());
                break;
            case 'LAST_MONTH':
                $passado = strtotime("last day of previous month");
                $inicio  = date("Y-m-01 00:00:00-03", $passado);
                $fim     = date('Y-m-d 23:59:59-03', strtotime('last day of previous month'));
                break;
            case 'CUSTOM_DATE':
                $dtInicial = $inicial;
                $dtFinal   = $final;
                $dtInicial = str_replace(['/'], '-', $dtInicial);
                $dtInicial = new DateTime($dtInicial);
                $inicio    = $dtInicial->format('Y-m-d 00:00:00-03');
                $dtFinal   = str_replace(['/'], '-', $dtFinal);
                $dtFinal   = new DateTime($dtFinal);
                $fim       = $dtFinal->format('Y-m-d 23:59:59-03');
                break;
            default:
                $inicio = date('Y-m-d 00:00:00-03', time());
                $fim    = date('Y-m-d H:i:s-03', time());
                break;
        }

        return [$inicio, $fim];
    }

    static function filtrar_ads($valor, $inicial, $final)
    {
        date_default_timezone_set('America/Sao_Paulo');
        switch ($valor) {
            case 'ALL_TIME':
                $inicio = '2014-01-01';
                $fim    = date('Y-m-d', time());
                break;
            case 'YESTERDAY':
                $inicio = date('Y-m-d', time() - (24 * 3600));
                $fim    = date('Y-m-d', time() - (24 * 3600));
                break;
            case 'THIS_WEEK_SUN_TODAY':
                $inicio = date('Y-m-d', strtotime('last sunday', strtotime('tomorrow')));
                $fim    = date('Y-m-d', time());
                break;
            case 'THIS_WEEK_MON_TODAY':
                $inicio = date('Y-m-d', strtotime('last monday', strtotime('tomorrow')));
                $fim    = date('Y-m-d', time());
                break;
            case 'LAST_BUSINESS_WEEK':
                $previous_week = strtotime("-1 week +1 day");
                $start_week    = strtotime("last monday midnight", $previous_week);
                $end_week      = strtotime("next saturday", $start_week);
                $inicio        = date("Y-m-d", $start_week);
                $fim           = date("Y-m-d", $end_week);
                break;
            case 'LAST_WEEK':
                $previous_week = strtotime("-1 week +1 day");
                $start_week    = strtotime("last monday midnight", $previous_week);
                $end_week      = strtotime("next sunday", $start_week);
                $inicio        = date("Y-m-d", $start_week);
                $fim           = date("Y-m-d", $end_week);
                break;
            case 'LAST_WEEK_SUN_SAT':
                $previous_week = strtotime("-1 week +1 day");
                $start_week    = strtotime("last sunday midnight", $previous_week);
                $end_week      = strtotime("next saturday", $start_week);
                $inicio        = date("Y-m-d", $start_week);
                $fim           = date("Y-m-d", $end_week);
                break;
            case 'LAST_7_DAYS':
                $start_week = strtotime("-7 days");
                $end_week   = strtotime("-1 day");
                $inicio     = date("Y-m-d", $start_week);
                $fim        = date("Y-m-d", $end_week);
                break;
            case 'LAST_7_DAYS_TODAY':
                $start_week = strtotime("-7 days");
                $end_week   = time();
                $inicio     = date("Y-m-d", $start_week);
                $fim        = date("Y-m-d", $end_week);
                break;
            case 'LAST_14_DAYS':
                $start_week = strtotime("-14 days");
                $end_week   = strtotime("-1 day");
                $inicio     = date("Y-m-d", $start_week);
                $fim        = date("Y-m-d", $end_week);
                break;
            case 'LAST_14_DAYS_TODAY':
                $start_week = strtotime("-14 days");
                $end_week   = time();
                $inicio     = date("Y-m-d", $start_week);
                $fim        = date("Y-m-d", $end_week);
                break;
            case 'LAST_30_DAYS':
                $start_week = strtotime("-30 days");
                $end_week   = strtotime("-1 day");
                $inicio     = date("Y-m-d", $start_week);
                $fim        = date("Y-m-d", $end_week);
                break;
            case 'LAST_30_DAYS_TODAY':
                $start_week = strtotime("-30 days");
                $end_week   = time();
                $inicio     = date("Y-m-d", $start_week);
                $fim        = date("Y-m-d", $end_week);
                break;
            case 'THIS_MONTH':
                $inicio = date("Y-m-01", time());
                $fim    = date('Y-m-d', time());
                break;
            case 'LAST_MONTH':
                $passado = strtotime("last day of previous month");
                $inicio  = date("Y-m-01", $passado);
                $fim     = date('Y-m-d', strtotime('last day of previous month'));
                break;
            case 'CUSTOM_DATE':
                $dtInicial = $inicial;
                $dtFinal   = $final;
                $dtInicial = str_replace(['/'], '-', $dtInicial);
                $dtInicial = new DateTime($dtInicial);
                $inicio    = $dtInicial->format('Y-m-d');
                $dtFinal   = str_replace(['/'], '-', $dtFinal);
                $dtFinal   = new DateTime($dtFinal);
                $fim       = $dtFinal->format('Y-m-d');
                break;
            default:
                $inicio = date('Y-m-d', time());
                $fim    = date('Y-m-d', time());
                break;
        }

        return [$inicio, $fim];
    }

    /* Retorna o texto correspondente ao filtro */
    static function texto($ft)
    {
        $texto = '';
        switch ($ft) {
            case 'ALL_TIME':
                $texto = "Desde o Início";
                break;
            case 'TODAY':
                $texto = "Hoje";
                break;
            case 'YESTERDAY':
                $texto = "Ontem";
                break;
            case 'THIS_WEEK_SUN_TODAY':
                $texto = "Dom até Hoje";
                break;
            case 'THIS_WEEK_MON_TODAY':
                $texto = "Seg até Hoje";
                break;
            case 'LAST_BUSINESS_WEEK':
                $texto = "Última semana útil";
                break;
            case 'LAST_WEEK':
                $texto = "Semana Passada - de Seg até Dom";
                break;
            case 'LAST_WEEK_SUN_SAT':
                $texto = "Semana Passada - de Dom até Sáb";
                break;
            case 'LAST_7_DAYS':
                $texto = "Últimos 7 dias";
                break;
            case 'LAST_7_DAYS_TODAY':
                $texto = "Últimos 7 dias + Hoje";
                break;
            case 'LAST_14_DAYS':
                $texto = "Últimos 14 dias";
                break;
            case 'LAST_14_DAYS_TODAY':
                $texto = "Últimos 14 dias + Hoje";
                break;
            case 'LAST_30_DAYS':
                $texto = "Últimos 30 dias";
                break;
            case 'LAST_30_DAYS_TODAY':
                $texto = "Últimos 30 dias + Hoje";
                break;
            case 'THIS_MONTH':
                $texto = "Esse mês";
                break;
            case 'LAST_MONTH':
                $texto = "Mês passado";
                break;
            case 'CUSTOM_DATE':
                $texto = "Personalizado";
                break;
        }

        return $texto;
    }
}

?>