<?php

/***
	Esta classe é responsável por cuidar de funções básicas do layout das páginas do sistema.
 ***/

class Layout_Sistema
{
	private $sistema;
	private $paginas_adm;
	public $possiveis_home;
	public $tipos_sistema_indicacao;
	public $qualidades_cliente;
	public $status_cliente;
	public $lista_emails_ocultos_win7;

	function __construct(&$sistema)
	{
		$this->sistema = $sistema;
		$this->paginas_adm = array("home", "admins", "todos-contatos", "baixar-todos-contatos", "gsuite", "indicacoes-adm", "email-adm", "resultados-gerais", "log-adm", "bi");
		$this->possiveis_home = array(
			"geral" => "Dados Gerais",
			"geral-comparacao" => "Dados Gerais Comparação",
			"indicacoes" => "Indicações",
			"contatos" => "Ver Contatos",
			"grupos" => "Grupos de Anúncios",
			"grafico" => "Gráfico Geral",
			"ligacoes" => "Win7 Fone",
			"arquivos" => "Arquivos"
		);
		$this->tipos_sistema_indicacao = array("Padrão", "Faculdades");
		$this->status_cliente = array("Novo", "Agendou", "Aguardando Pagamento", "Cirurgia", "Convênio", "Em negociação", "Emergência", "Exames", "Fechado", "Futuro", "Informações Enviadas", "Item Fora de Linha", "Já é Cliente", "Ligar", "Liguei", "Não Agendou", "Não Atende", "Não Compareceu", "Não é Cliente", "Orçamento Enviado", "Pago", "Perdeu", "Procedimento", "Produto ou Marca Indisponível", "Produtos", "Quase Fechado", "Retornar Contato", "Sem Viabilidade", "Unidades", "Vacinas", "Visita Feita", "Whatsapp Enviado");
		$this->qualidades_cliente = array("Bom", "Médio", "Ruim");
		$this->moedas = array("Real", "Dólar", "Euro");

		// Lista de e-mails ocultos que aparecem na parte de LP Formularios do cliente
		$this->lista_emails_ocultos_win7 = array(
			'desenvolvimento@grupolead.com.br',
			'alan@grupolead.com.br',
			'googleads@grupolead.com.br',
			'googleads@win7.com.br',
			'vinicius.dourado@win7.com.br',
			'patricia.cantanhede@win7.com.br',
			'financeiro@win7.com.br',
			// 'ana.eugenia@win7.com.br',
			// 'cursos@win7.com.br',
			// 'emilly@win7.com.br',
			// 'estagiarios@win7.com.br',
			// 'gsuite@win7.com.br',
			// 'grafica@win7.com.br',
			// 'rafaela.martins@win7.com.br',
			// 'contato@win7.com.br'
		);
	}

	/* Essa função cria o select de todas as home page possíveis para o cliente da agência */
	function select_home($selected = "")
	{
		foreach ($this->possiveis_home as $valor => $texto) {
			$sel = $selected == $valor ? "selected" : "";
			echo '<option value="' . $valor . '" ' . $sel . ' >' . $texto . '</option>';
		}
	}

	function select_moedas($selected = "")
	{
		$counter = 0;
		foreach ($this->moedas as $valor) {
			$sel = $selected == $counter ? "selected" : "";
			echo '<option value="' . $counter . '" ' . $sel . ' >' . $valor . '</option>';
			$counter++;
		}
	}

	/* Retorna os tipos do sistema de indicação. */
	function tipos_funcionario_faculdade()
	{
		return array("Aluno", "Público Externo", "Diretor", "Coordenador", "Professor", "Funcionário");
	}

	function select_periodo($carregar_usuario = true)
	{
		$valor = $carregar_usuario == true ? $this->sistema->filtro->valor() : "ALL_TIME";
?>
		<option value="ALL_TIME" <?php if ($valor == "ALL_TIME") {
																echo "selected";
															} ?>>Desde o Início</option>
		<option value="TODAY" <?php if ($valor == "TODAY") {
														echo "selected";
													} ?>>Hoje</option>
		<option value="YESTERDAY" <?php if ($valor == "YESTERDAY") {
																echo "selected";
															} ?>>Ontem</option>
		<option value="THIS_WEEK_SUN_TODAY" <?php if ($valor == "THIS_WEEK_SUN_TODAY") {
																					echo "selected";
																				} ?>>Esta Semana (Dom até Hoje)</option>
		<option value="THIS_WEEK_MON_TODAY" <?php if ($valor == "THIS_WEEK_MON_TODAY") {
																					echo "selected";
																				} ?>>Esta Semana (Seg até Hoje)</option>
		<option value="LAST_BUSINESS_WEEK" <?php if ($valor == "LAST_BUSINESS_WEEK") {
																					echo "selected";
																				} ?>>Última semana útil de Seg à Sex</option>
		<option value="LAST_WEEK_SUN_SAT" <?php if ($valor == "LAST_WEEK_SUN_SAT") {
																				echo "selected";
																			} ?>>Semana Passada (Dom a Sáb)</option>
		<option value="LAST_WEEK" <?php if ($valor == "LAST_WEEK") {
																echo "selected";
															} ?>>Semana Passada (Seg a Dom)</option>
		<option value="LAST_7_DAYS" <?php if ($valor == "LAST_7_DAYS") {
																	echo "selected";
																} ?>>Últimos 7 dias</option>
		<option value="LAST_7_DAYS_TODAY" <?php if ($valor == "LAST_7_DAYS_TODAY") {
																				echo "selected";
																			} ?>>Últimos 7 dias + Hoje</option>
		<option value="LAST_14_DAYS" <?php if ($valor == "LAST_14_DAYS") {
																		echo "selected";
																	} ?>>Últimos 14 dias</option>
		<option value="LAST_14_DAYS_TODAY" <?php if ($valor == "LAST_14_DAYS_TODAY") {
																					echo "selected";
																				} ?>>Últimos 14 dias + Hoje</option>
		<option value="LAST_30_DAYS" <?php if ($valor == "LAST_30_DAYS") {
																		echo "selected";
																	} ?>>Últimos 30 dias</option>
		<option value="LAST_30_DAYS_TODAY" <?php if ($valor == "LAST_30_DAYS_TODAY") {
																					echo "selected";
																				} ?>>Últimos 30 dias + Hoje</option>
		<option value="THIS_MONTH" <?php if ($valor == "THIS_MONTH") {
																	echo "selected";
																} ?>>Esse Mês</option>
		<option value="LAST_MONTH" <?php if ($valor == "LAST_MONTH") {
																	echo "selected";
																} ?>>Mês Passado</option>
		<option value="CUSTOM_DATE" <?php if ($valor == "CUSTOM_DATE") {
																	echo "selected";
																} ?>>Personalizado</option>
	<?php
	}

	static function redirecionar_indicado($sistema)
	{
		$titulo = $sistema->indicacoes->vocabulario[20];
		$titulo = str_replace("#NOME-CLIENTE#", $sistema->indicacoes->nome, $titulo);
		$imagem_social = empty($sistema->indicacoes->imagem_social) ? $sistema->indicacoes->logo : $sistema->indicacoes->imagem_social;
	?>
		<!DOCTYPE html>
		<html>

		<head>
			<meta charset="utf-8">
			<meta http-equiv="X-UA-Compatible" content="IE=edge">
			<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
			<meta name="description" content="<?php echo $sistema->indicacoes->vocabulario[22]; ?>" />
			<meta property="og:title" content="<?php echo $titulo; ?>" />
			<meta property="og:type" content="website" />
			<meta property="og:image" content="<?php echo $imagem_social; ?>" />
			<meta property="og:description" content="<?php echo $sistema->indicacoes->vocabulario[22]; ?>" />
			<title><?php echo $titulo; ?></title>
		</head>

		<body>
			<script type="text/javascript">
				window.location = "https://<?php echo $sistema->indicacoes->dominio . "/indicado"; ?>";
			</script>
		</body>

		</html>
	<?php
	}

	static function redirecionar_indicador($sistema)
	{
		$titulo = $sistema->indicacoes->vocabulario[20];
		$titulo = str_replace("#NOME-CLIENTE#", $sistema->indicacoes->nome, $titulo);
		$imagem_social = empty($sistema->indicacoes->imagem_social) ? $sistema->indicacoes->logo : $sistema->indicacoes->imagem_social;
	?>
		<!DOCTYPE html>
		<html>

		<head>
			<meta charset="utf-8">
			<meta http-equiv="X-UA-Compatible" content="IE=edge">
			<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
			<meta name="description" content="<?php echo $sistema->indicacoes->vocabulario[21]; ?>" />
			<meta property="og:title" content="<?php echo $titulo; ?>" />
			<meta property="og:type" content="website" />
			<meta property="og:image" content="<?php echo $imagem_social; ?>" />
			<meta property="og:description" content="<?php echo $sistema->indicacoes->vocabulario[21]; ?>" />
			<title><?php echo $titulo; ?></title>
		</head>

		<body>
			<script type="text/javascript">
				window.location = "https://<?php echo $sistema->indicacoes->dominio . "/indicador"; ?>";
			</script>
		</body>

		</html>
	<?php
	}

	/* Retorna os tipos do sistema de indicação. */
	function select_tipos_funcionario_faculdade()
	{
		$textos = $this->tipos_funcionario_faculdade();
		$contador = 0;
		foreach ($textos as $texto) {
			$sel = $selected == $contador ? "selected" : "";
			echo '<option value="' . $contador . '" ' . $sel . ' >' . $texto . '</option>';
			$contador++;
		}
	}

	/* Cria um select com todos os possíveis sistemas de indicação */
	function select_sistema($selected)
	{
		$contador = 0;
		foreach ($this->tipos_sistema_indicacao as $texto) {
			$sel = $selected == $contador ? "selected" : "";
			echo '<option value="' . $contador . '" ' . $sel . ' >' . $texto . '</option>';
			$contador++;
		}
	}

	/* Cria um select com todos as qualidades possíveis para o cliente */
	function select_qualidade($selected)
	{
		foreach ($this->qualidades_cliente as $texto) {
			$sel = $selected == $texto ? "selected" : "";
			echo '<option value="' . $texto . '" ' . $sel . ' >' . $texto . '</option>';
		}
	}

	/* Cria um select com todos os status possíveis para o cliente */
	function select_status($selected)
	{
		foreach ($this->status_cliente as $texto) {
			if ($texto == "Fechado")
				$sel = 'style="color: green;"';
			else if ($texto == "Novo")
				$sel = 'style="color: #3a62d7;"';
			else if ($texto == "Perdeu")
				$sel = 'style="color: red;"';
			else if ($texto == "Não é Cliente")
				$sel = 'style="color: red;"';
			else if ($texto == "Não Compareceu")
				$sel = 'style="color: red;"';
			else if ($texto == "Em negociação")
				$sel = 'style="color: orange;"';
			else
				$sel = 'style="color: var(--text);"';
			$sel .= $selected == $texto ? " selected" : "";
			echo '<option value="' . $texto . '" ' . $sel . ' >' . $texto . '</option>';
		}
	}

	/* Monta o select dos grupos de anúncios */
	function select_grupos($grupos)
	{

		echo '<option value="todos">Todos</option>';
		$selected = isset($_SESSION['palavras']) ? $_SESSION['palavras'] : "";

		foreach ($grupos as $grupo) {
			$campanhasId[] = $grupo['campanhaNome'];
		}

		$campanhasId = array_unique($campanhasId);

		foreach ($campanhasId as $campanha) {
			echo '<optgroup label="' . $campanha . '" >';
			foreach ($grupos as $grupo) {
				if ($campanha === $grupo['campanhaNome']) {
					$sel = $selected == $grupo['id'] ? "selected" : "";
					echo '<option value="' . $grupo['id'] . '|%|' . $grupo['campanhaId'] . '" ' . $sel . ' >' . $grupo['nome'] . '</option>';
				}
			}
			echo '</optgroup>';
		}
	}

	/* Método que cria as meta tags do layout */
	function criar_meta_tags()
	{
		switch ($this->sistema->tipo()) {
			case Sistema::WIN7: {
					echo '<meta name="theme-color" content="#00a65a">';
					echo '<link rel="manifest" href="manifest.json">';
					break;
				}
			case Sistema::WIN7_ADM: {
					echo '<meta name="theme-color" content="#3c8dbc">';
					echo '<link rel="manifest" href="manifest.json">';
					break;
				}
			case Sistema::INDICACOES: {
					echo '<meta name="theme-color" content="' . $this->sistema->indicacoes->cor2 . '">';
				}
			case Sistema::GOOGLE_DRIVE: {
					echo '<meta name="theme-color" content="' . $this->sistema->drive->cor2 . '">';
				}
		}
	}

	/* Exibe o cabeçalho para usuários administradores do sistema win7 */
	function exibir_cabecalho_adm($menu_selecionado)
	{
		$qdt_notificacoes = 0;
		$avisos = array();
		if ($this->sistema->usuario->frequentes > 0) {
			$texto_aviso = $this->sistema->usuario->frequentes == 1 ? "1 Cliente Inativo usa o sistema." : $this->sistema->usuario->frequentes . " Clientes Inativos usam o sistema.";
			$icone = "fa-users";
			$cor = "text-aqua";
			$link = "executar_acao?acao=exibir-clientes-frequentes";
			$avisos[] = array($texto_aviso, $icone, $cor, $link);
			$qdt_notificacoes++;
		}
		if ($this->sistema->usuario->nao_frequentes > 0) {
			$texto_aviso = $this->sistema->usuario->nao_frequentes == 1 ? "1 Cliente Ativo não usa o sistema." : $this->sistema->usuario->nao_frequentes . " Clientes Ativos não usam o sistema.";
			$icone = "fa-users";
			$cor = "text-aqua";
			$link = "executar_acao?acao=exibir-clientes-nao-frequentes";
			$avisos[] = array($texto_aviso, $icone, $cor, $link);
			$qdt_notificacoes++;
		}
	?>
		<header class="main-header">
			<a href="./" class="logo">
				<span class="logo-mini"><img src="img/logo-mini.png"></span>
				<span class="logo-lg"><img src="img/logo.png" width="100"></span>
				<span class="logo-lg-branca"><img src="img/logoBranca.png" width="100"></span>
			</a>

			<nav class="navbar navbar-static-top" role="navigation">

				<a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
					<span class="sr-only">Mudar Navegação</span>
				</a>

				<div class="navbar-custom-menu">
					<ul class="nav navbar-nav">
						<li>
							<a class="dropdown-toggle" id="darkModeToggle" data-toggle="tooltip" title="Alterar Tema">
								<span class="toggle-icon" id="icon">🌙</span>
							</a>
						</li>
						<li class="dropdown notifications-menu">
							<a href="#" class="dropdown-toggle" data-toggle="dropdown">
								<i class="fa fa-bell-o"></i>
								<?php if ($qdt_notificacoes > 0) { ?><span class="label label-danger"><?php echo $qdt_notificacoes; ?></span><?php } ?>
							</a>
							<ul class="dropdown-menu">
								<li class="header"><?php if ($qdt_notificacoes == 0) {
																			echo "Você não possui avisos.";
																		} else {
																			echo "Você possui " . $qdt_notificacoes . " avisos.";
																		} ?></li>
								<?php if ($qdt_notificacoes > 0) { ?>
									<li>
										<ul class="menu">
											<?php
											for ($i = 0; $i < $qdt_notificacoes; $i++) {
												$aviso = $avisos[$i];
												$texto = $aviso[0];
												$icone = $aviso[1];
												$cor = $aviso[2];
												$link = $aviso[3];
											?>
												<li>
													<a href="<?php echo $link; ?>">
														<i class="fa <?php echo $icone; ?> <?php echo $cor; ?>"></i> <?php echo $texto; ?>
													</a>
												</li>
											<?php
											}
											?>
										</ul>
									</li>
								<?php } ?>
							</ul>
						</li>
						<li class="dropdown user user-menu">
							<a href="#" class="dropdown-toggle" data-toggle="dropdown">
								<img src="img/usuario-padrao.jpg" class="user-image" alt="Imagem de Usuário">
								<span class="hidden-xs"><?php echo $this->sistema->usuario->nome_adm; ?></span>
							</a>

							<ul class="dropdown-menu">
								<li class="user-header">
									<img src="img/usuario-padrao.jpg" class="img-circle" alt="Imagem de Usuário">
									<p>
										<?php echo $this->sistema->usuario->nome_adm; ?>
									</p>
								</li>

								<li class="user-footer">
									<div class="pull-right">
										<a href="action/logout" class="btn btn-danger btn-flat">Sair</a>
									</div>
								</li>
							</ul>
						</li>
					</ul>
				</div>
			</nav>
		</header>

		<aside class="main-sidebar">
			<section class="sidebar">
				<ul class="sidebar-menu" data-widget="tree">
					<li class="header">MENU</li>
					<li <?php if ($menu_selecionado == "home") { ?> class="active" <?php } ?>><a href="./"><i class="fa fa-home"></i> <span>Home</span></a></li>
					<?php if ($this->sistema->usuario->super_adm_adm) { ?><li <?php if ($menu_selecionado == "admins") { ?> class="active" <?php } ?>><a href="admins"><i class="fa fa-lock"></i> <span>Administradores</span></a></li><?php } ?>
					<?php if ($this->sistema->usuario->super_adm_adm) { ?><li <?php if ($menu_selecionado == "log-adm") { ?> class="active" <?php } ?>><a href="log-adm"><i class="fa fa-list"></i> <span>Log de Administradores</span></a></li><?php } ?>
					<?php if ($this->sistema->usuario->cliente_carregado() && $this->sistema->usuario->permissao_sistema_clientes != Usuario::PERM_NENHUMA) { ?>
						<li><a href="home_cliente"><i class="fa fa-user"></i> <span><?php echo $this->sistema->usuario->nome; ?></span></a></li>
					<?php } ?>
					<?php if ($this->sistema->usuario->permissao_todos_contatos != Usuario::PERM_NENHUMA) { ?><li class="treeview<?php if ($menu_selecionado == "todos-contatos" || $menu_selecionado == "baixar-todos-contatos") { ?> active menu-open<?php } ?>">
							<a href="javascript:void(0)"><i class="fa fa-users"></i> <span>Todos os Contatos</span>
								<span class="pull-right-container">
									<i class="fa fa-angle-left pull-right"></i>
								</span>
							</a>
							<ul class="treeview-menu">
								<li <?php if ($menu_selecionado == "todos-contatos") { ?> class="active" <?php } ?>><a href="todos-contatos"><i class="fa fa-circle-o"></i>Histórico</a></li>
								<li <?php if ($menu_selecionado == "baixar-todos-contatos") { ?> class="active" <?php } ?>><a href="baixar-todos-contatos"><i class="fa fa-circle-o"></i>Relatórios</a></li>
							</ul>
						</li>
					<?php } ?>
					<?php if ($this->sistema->usuario->permissao_gsuite != Usuario::PERM_NENHUMA) { ?><li <?php if ($menu_selecionado == "gsuite") { ?> class="active" <?php } ?>><a href="gsuite"><i class="fa fa-google"></i> <span>Agendamentos do G Suite</span></a></li><?php } ?>
					<?php if ($this->sistema->usuario->permissao_envio_email != Usuario::PERM_NENHUMA) { ?><li <?php if ($menu_selecionado == "email-adm") { ?> class="active" <?php } ?>><a href="email-adm"><i class="fa fa-envelope"></i> <span>Envio de E-mail</span></a></li><?php } ?>
					<?php if ($this->sistema->usuario->permissao_indicacoes_geral != Usuario::PERM_NENHUMA) { ?><li <?php if ($menu_selecionado == "indicacoes-adm") { ?> class="active" <?php } ?>><a href="indicacoes-adm"><i class="fa fa-smile-o"></i> <span>Sistema de Indicações</span></a></li><?php } ?>
					<?php if ($this->sistema->usuario->permissao_resultados != Usuario::PERM_NENHUMA) { ?><li <?php if ($menu_selecionado == "resultados-gerais") { ?> class="active" <?php } ?>><a href="resultados-gerais"><i class="fa fa-bar-chart"></i> <span>Resultados Gerais</span></a></li><?php } ?>
					<?php if ($this->sistema->usuario->super_adm_adm) { ?><li <?php if ($menu_selecionado == "parametros") { ?> class="active" <?php } ?>><a href="parametros"><i class="fa fa-cog"></i> <span>Parâmetros</span></a></li><?php } ?>

					<?php if ($this->sistema->usuario->super_adm_adm) { ?><li class="treeview<?php if ($menu_selecionado == "bi") { ?> active menu-open<?php } ?>">
							<a href="javascript:void(0)"><i class="fa fa-database"></i> <span>BI</span>
								<span class="pull-right-container">
									<i class="fa fa-angle-left pull-right"></i>
								</span>
							</a>
							<ul class="treeview-menu">
								<li <?php if ($menu_selecionado == "bi") { ?> class="active" <?php } ?>><a href="bi"><i class="fa fa-circle-o"></i>Ativos/Importantes</a></li>
							</ul>
						</li>
					<?php } ?>

					<li><a href="action/logout"><i class="fa fa-arrow-left"></i> <span>Sair do Sistema</span></a></li>
				</ul>
			</section>
		</aside>
	<?php
	}

	/* Exibe o cabeçalho para usuários comuns do sistema win7 */
	function exibir_cabecalho_cliente($menu_selecionado)
	{
	?>
		<header class="main-header">
			<a href="./" class="logo">
				<span class="logo-mini"><img src="img/logo-mini.png"></span>
				<span class="logo-lg"><img src="img/logo.png" width="100"></span>
				<span class="logo-lg-branca"><img src="img/logoBranca.png" width="100"></span>
			</a>

            <?php if ($this->sistema->tipo() == Sistema::WIN7_ADM): ?>
                <script>
                    const ID_USUARIO = <?=$_SESSION["usuario"]->id?>;
                </script>
            <?php endif; ?>

			<nav class="navbar navbar-static-top" role="navigation">

				<a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
					<span class="sr-only">Mudar Navegação</span>
				</a>

				<div class="navbar-custom-menu">
					<ul class="nav navbar-nav">
						<li>
							<a class="dropdown-toggle" id="darkModeToggle">
								<span class="toggle-icon" id="icon">🌙</span>
							</a>
						</li>
						<li class="dropdown notifications-menu">
							<a href="#" class="dropdown-toggle" data-toggle="dropdown" title="Clique para obter ajuda">
								<i class="fa fa-question-circle"></i>
							</a>
							<ul class="dropdown-menu">
								<li>
									<ul class="menu">
										<li>
											<a href="https://docs.google.com/document/d/1DHQ7_eIGJYPCicpOQv9L-ii_2RPIlrJeHYGJTBo_ZTU/edit?ts=5afd5651" target="_blank"><i class="fa fa-book text-blue"></i> Manual de Uso Geral</a>
										</li>
									</ul>
								</li>
							</ul>
						</li>

						<li class="dropdown user user-menu">
							<a href="#" class="dropdown-toggle" data-toggle="dropdown">
								<img src="img/usuario-padrao.jpg" class="user-image" alt="Imagem de Usuário">
								<span class="hidden-xs"><?php if ($this->sistema->usuario instanceof Subusuario_Win7) {
																					echo $this->sistema->usuario->nome_subusuario;
																				} else {
																					echo $this->sistema->usuario->nome;
																				} ?><?php if ($this->sistema->usuario instanceof Usuario_Adm) { ?><b style="color: #ffffff;">*</b><?php } ?></span>
							</a>

							<ul class="dropdown-menu">
								<li class="user-header">
									<img src="img/usuario-padrao.jpg" class="img-circle" alt="Imagem de Usuário">
									<p>
										<?php if ($this->sistema->usuario instanceof Subusuario_Win7) {
											echo $this->sistema->usuario->nome_subusuario;
										} else {
											echo $this->sistema->usuario->nome;
										} ?>
										<?php if ($this->sistema->usuario instanceof Usuario_Adm) { ?>
											<small>Logado como administrador <b><?php echo $this->sistema->usuario->nome_adm; ?></b></small>
										<?php } ?>
									</p>
								</li>

								<li class="user-footer">
									<?php if (!$this->sistema->usuario instanceof Usuario_Adm) { ?>
										<div class="pull-left">
											<a href="mudar-senha" class="btn btn-default btn-flat">Mudar Senha</a>
										</div>
									<?php } else { ?>
										<div class="pull-left">
											<a href="./" class="btn btn-default btn-flat">Retornar ao Admin</a>
										</div>
									<?php } ?>
									<div class="pull-right">
										<a href="action/logout" class="btn btn-default btn-flat">Sair</a>
									</div>
								</li>
							</ul>
						</li>
					</ul>
				</div>
			</nav>
		</header>

		<aside class="main-sidebar">
			<section class="sidebar">
				<ul class="sidebar-menu" data-widget="tree">
					<li class="header">MENU</li>
					<li style="background-color: #21444f;"><a href="https://indique.win7.com.br" target="_blank" style="color: #ffffff;font-size: 12px"><i class="fa fa-external-link"></i> <span>Indique a Win7 e ganhe prêmios</span></a></li>
					<li><a href="./"><i class="fa fa-home"></i> <span>Home</span></a></li>

					<?php if ($this->sistema->usuario->permissao_google != Usuario::PERM_NENHUMA && $this->sistema->usuario->permissao_dados_gerais != Usuario::PERM_NENHUMA) { ?><li <?php if ($menu_selecionado == "geral") { ?> class="active" <?php } ?>><a href="./geral"><i class="fa fa-bar-chart"></i> <span>Dados Gerais</span></a></li><?php } ?>

					<?php if ((isset($this->sistema->usuario->permissao_comparacao_adm) && $this->sistema->usuario->permissao_comparacao_adm != Usuario::PERM_NENHUMA) || ($this->sistema->usuario->permissao_comparacao != Usuario::PERM_NENHUMA && $this->sistema->usuario->permissao_dados_gerais != Usuario::PERM_NENHUMA)) { ?><li <?php if ($menu_selecionado == "geral-comparacao") { ?> class="active" <?php } ?>><a href="./geral-comparacao"><i class="fa fa-exchange"></i> <span>Dados Gerais Comparação</span></a></li><?php } ?>

					<?php if ($this->sistema->usuario->permissao_drive != Usuario::PERM_NENHUMA) { ?><li <?php if ($menu_selecionado == "arquivos") { ?> class="active" <?php } ?>><a href="arquivos"><i class="fa fa-file"></i> <span>Arquivos</span></a></li><?php } ?>
					<?php if ($this->sistema->usuario->permissao_indicacoes != Usuario::PERM_NENHUMA) { ?>
						<li class="treeview<?php if ($menu_selecionado == "baixar-indicacoes" || $menu_selecionado == "indicacoes-financeiro" || $menu_selecionado == "indicacoes" || $menu_selecionado == "premios") { ?> active menu-open<?php } ?>">
							<a href="javascript:void(0)"><i class="fa fa-smile-o"></i> <span>Indicações</span>
								<span class="pull-right-container">
									<i class="fa fa-angle-left pull-right"></i>
								</span>
							</a>
							<ul class="treeview-menu">
								<li <?php if ($menu_selecionado == "indicacoes") { ?> class="active" <?php } ?>><a href="indicacoes"><i class="fa fa-circle-o"></i>Usuários</a></li>
								<?php if ($this->sistema->indicacoes->usa_pontos == "1") { ?><li <?php if ($menu_selecionado == "premios") { ?> class="active" <?php } ?>><a href="premios"><i class="fa fa-circle-o"></i>Prêmios</a></li><?php } ?>
								<?php if ($this->sistema->usuario->permissao_indicacoes == Usuario::PERM_ESCRITA) { ?><li <?php if ($menu_selecionado == "indicacoes-financeiro") { ?> class="active" <?php } ?>><a href="indicacoes-financeiro"><i class="fa fa-circle-o"></i>Resgates/Financeiro</a></li><?php } ?>
								<li <?php if ($menu_selecionado == "baixar-indicacoes") { ?> class="active" <?php } ?>><a href="baixar-indicacoes"><i class="fa fa-circle-o"></i>Relatórios</a></li>
							</ul>
						</li>
					<?php } ?>
					<?php if ($this->sistema->usuario->permissao_leads != Usuario::PERM_NENHUMA) { ?>
						<li class="treeview<?php if ($menu_selecionado == "contatos" || $menu_selecionado == "lixeira" || $menu_selecionado == "baixar-contatos") { ?> active menu-open<?php } ?>">
							<a href="javascript:void(0)"><i class="fa fa-users"></i> <span>Contatos</span>
								<span class="pull-right-container">
									<i class="fa fa-angle-left pull-right"></i>
								</span>
							</a>
							<ul class="treeview-menu">
								<li <?php if ($menu_selecionado == "contatos") { ?> class="active" <?php } ?>><a href="contatos"><i class="fa fa-circle-o"></i>Histórico</a></li>
								<?php if ($this->sistema->usuario->permissao_leads == Usuario::PERM_ESCRITA) { ?><li <?php if ($menu_selecionado == "lixeira") { ?> class="active" <?php } ?>><a href="lixeira"><i class="fa fa-circle-o"></i>Lixeira</a></li><?php } ?>
								<li <?php if ($menu_selecionado == "baixar-contatos") { ?> class="active" <?php } ?>><a href="baixar-contatos"><i class="fa fa-circle-o"></i>Relatórios</a></li>
							</ul>
						</li>
					<?php } ?>
					<?php if ($this->sistema->usuario->permissao_google != Usuario::PERM_NENHUMA) { ?>
						<li class="treeview<?php if ($menu_selecionado == "grupos" || $menu_selecionado == "grafico" || $menu_selecionado == "palavras" || $menu_selecionado == "campanhas" || $menu_selecionado == "termos-pesquisa" || $menu_selecionado == "palavras-negativas") { ?> active menu-open<?php } ?>">
							<a href="javascript:void(0)"><i class="fa fa-google"></i> <span>Anúncios Google</span>
								<span class="pull-right-container">
									<i class="fa fa-angle-left pull-right"></i>
								</span>
							</a>
							<ul class="treeview-menu">
								<li <?php if ($menu_selecionado == "campanhas") { ?> class="active" <?php } ?>><a href="campanhas"><i class="fa fa-circle-o"></i>Campanhas</a></li>
								<li <?php if ($menu_selecionado == "grupos") { ?> class="active" <?php } ?>><a href="grupos"><i class="fa fa-circle-o"></i>Grupos de Anúncios</a></li>
								<li <?php if ($menu_selecionado == "palavras") { ?> class="active" <?php } ?>><a href="palavras"><i class="fa fa-circle-o"></i>Palavras-chave</a></li>
								<li <?php if ($menu_selecionado == "palavras-negativas") { ?> class="active" <?php } ?>><a href="palavras-negativas"><i class="fa fa-circle-o"></i>Palavras-chave negativas</a></li>
								<li <?php if ($menu_selecionado == "termos-pesquisa") { ?> class="active" <?php } ?>><a href="termos-pesquisa"><i class="fa fa-circle-o"></i>Termos de Pesquisa</a></li>
								<li <?php if ($menu_selecionado == "grafico") { ?> class="active" <?php } ?>><a href="grafico"><i class="fa fa-circle-o"></i>Gráfico Geral</a></li>
							</ul>
						</li>
					<?php } ?>
					<?php if ($this->sistema->usuario->permissao_3cx != Usuario::PERM_NENHUMA) { ?>
						<li class="treeview<?php if ($menu_selecionado == "ligacoes-geral" || $menu_selecionado == "ligacoes" || $menu_selecionado == "baixar-ligacoes") { ?> active menu-open<?php } ?>">
							<a href="javascript:void(0)"><i class="fa fa-phone"></i> <span>Win7 Fone</span>
								<span class="pull-right-container">
									<i class="fa fa-angle-left pull-right"></i>
								</span>
							</a>
							<ul class="treeview-menu">
								<li <?php if ($menu_selecionado == "ligacoes") { ?> class="active" <?php } ?>><a href="ligacoes"><i class="fa fa-circle-o"></i>Histórico</a></li>
								<li <?php if ($menu_selecionado == "baixar-ligacoes") { ?> class="active" <?php } ?>><a href="baixar-ligacoes"><i class="fa fa-circle-o"></i>Relatórios</a></li>
								<li <?php if ($menu_selecionado == "ligacoes-geral") { ?> class="active" <?php } ?>><a href="ligacoes-geral"><i class="fa fa-circle-o"></i>Gráfico Geral</a></li>
							</ul>
						</li>
					<?php } ?>
					<?php if ($this->sistema->usuario->permissao_log != Usuario::PERM_NENHUMA) { ?><li <?php if ($menu_selecionado == "log") { ?> class="active" <?php } ?>><a href="./log"><i class="fa fa-list"></i> <span>Log de Usuários</span></a></li><?php } ?>
					<?php if (!$this->sistema->usuario instanceof Usuario_Adm) { ?><li <?php if ($menu_selecionado == "mudar-senha") { ?> class="active" <?php } ?>><a href="mudar-senha"><i class="fa fa-lock"></i> <span>Mudar Senha</span></a></li><?php } ?>
					<li><a href="action/logout"><i class="fa fa-arrow-left"></i> <span>Sair do Sistema</span></a></li>
				</ul>
			</section>
		</aside>
	<?php
	}

	function exibir_cabecalho_indicador($menu_selecionado)
	{
	?>
		<header class="main-header">
			<a href="./" class="logo">
				<span class="logo-mini"><img src="<?php echo $this->sistema->indicacoes->favicon; ?>" width="16"></span>
				<span class="logo-lg"><img src="<?php echo $this->sistema->indicacoes->logo; ?>" width="100"></span>
				<span class="logo-lg-branca"><img src="img/logoBranca.png" width="100"></span>
			</a>

			<nav class="navbar navbar-static-top" role="navigation">
				<a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
					<span class="sr-only">Mudar Navegação</span>
				</a>

				<div class="navbar-custom-menu">
					<span class="nome-indicado-cabecalho"><?php echo $this->sistema->usuario->nome; ?></span>
				</div>
			</nav>
		</header>

		<aside class="main-sidebar">
			<section class="sidebar">
				<ul class="sidebar-menu" data-widget="tree">

					<?php if ($this->sistema->indicacoes->link_site_menu != "") {
						echo '<li style="background-color: #59e885;min-height: 40px" class="menuLinkPersonalizado"><a href="' . $this->sistema->indicacoes->link_site_menu . '" target="_blank" style="padding-right: 16px;"><i class="fa fa-external-link-square" style="float:left;"></i><span class="textoPersonalizado">' . $this->sistema->indicacoes->link_site_menu_label . '</span></a></li>';
					} ?>

					<li <?php if ($menu_selecionado == "home") { ?> class="active" <?php } ?>><a href="./"><i class="fa fa-smile-o"></i> <span>Painel Geral</span></a></li>
					<?php if ($this->sistema->indicacoes->cadastro_indicado == "0") { ?>
						<li class="treeview">
							<a href="javascript:void(0)"><i class="fa fa-plus-circle"></i> <span>Adicionar Indicado</span>
								<span class="pull-right-container">
									<i class="fa fa-angle-left pull-right"></i>
								</span>
							</a>

							<ul class="treeview-menu">
								<li><a href="javascript:void(0);" onclick="abrir_modal_adicionar_indicado();"><i class="fa fa-circle-o"></i><?php echo $this->sistema->indicacoes->vocabulario[0]; ?></a></li>
								<li><a href="javascript:void(0);" onclick="abrir_modal_adicionar_indicador();"><i class="fa fa-circle-o"></i><?php echo $this->sistema->indicacoes->vocabulario[30]; ?></a></li>
								<li><a href="javascript:void(0);" onclick="abrir_modal_adicionar_manual();"><i class="fa fa-circle-o"></i><?php echo $this->sistema->indicacoes->vocabulario[1]; ?></a></li>
							</ul>
						</li>
					<?php } else { ?>
						<li><a href="javascript:void(0);" onclick="abrir_modal_adicionar_indicador();"><i class="fa fa-plus-circle"></i> <span><?php echo $this->sistema->indicacoes->vocabulario[30]; ?></span></a></li>
					<?php } ?>
					<li <?php if ($menu_selecionado == "historico") { ?> class="active" <?php } ?>><a href="historico"><i class="fa fa-bars"></i> <span>Histórico</span></a></li>
					<li <?php if ($menu_selecionado == "dados") { ?> class="active" <?php } ?>><a href="dados"><i class="fa fa-user"></i> <span>Meus Dados</span></a></li>
					<?php if ($this->sistema->indicacoes->permissao_transferencias == "1") { ?><li <?php if ($menu_selecionado == "transferencia") { ?> class="active" <?php } ?>><a href="transferencia"><i class="fa fa-exchange"></i> <span>Transferência</span></a></li><?php } ?>
					<li <?php if ($menu_selecionado == "resgate") { ?> class="active" <?php } ?>><a href="<?php if ($this->sistema->indicacoes->usa_pontos == "1") {
																																																	echo "premios";
																																																} else {
																																																	echo "resgate";
																																																} ?>"><i class="fa fa-gift"></i> <span>Resgate de Bônus</span></a></li>
					<li><a href="action/logout" style="color: #e41a1a;"><i class="fa fa-arrow-left"></i> <span>Sair do Sistema</span></a></li>
				</ul>
			</section>
		</aside>
	<?php
	}

	function exibir_cabecalho_arquivos($menu_selecionado)
	{
	?>
		<header class="main-header">
			<a href="./" class="logo">
				<span class="logo-mini"><img src="<?php echo $this->sistema->drive->favicon; ?>" width="16"></span>
				<span class="logo-lg"><img src="<?php echo $this->sistema->drive->logo; ?>" width="100"></span>
				<span class="logo-lg-branca"><img src="img/logoBranca.png" width="100"></span>
			</a>

			<nav class="navbar navbar-static-top" role="navigation">
				<a href="#" class="sidebar-toggle" data-toggle="push-menu" role="button">
					<span class="sr-only">Mudar Navegação</span>
				</a>

				<div class="navbar-custom-menu">
					<span class="nome-indicado-cabecalho"><?php echo $this->sistema->usuario->nome; ?></span>
				</div>
			</nav>
		</header>

		<aside class="main-sidebar">
			<section class="sidebar">
				<ul class="sidebar-menu" data-widget="tree">
					<li <?php if ($menu_selecionado == "home") { ?> class="active" <?php } ?>><a href="./"><i class="fa fa-home"></i> <span>Home</span></a></li>
					<li><a href="action/logout"><i class="fa fa-arrow-left"></i> <span>Sair do Sistema</span></a></li>
				</ul>
			</section>
		</aside>
		<?php
	}

	/* Exibe o cabeçalho da página */
	function exibir_cabecalho($menu_selecionado)
	{
		switch ($this->sistema->tipo()) {
			case Sistema::WIN7: {
					$this->exibir_cabecalho_cliente($menu_selecionado);
					break;
				}
			case Sistema::WIN7_ADM: {
					if (in_array($menu_selecionado, $this->paginas_adm))
						$this->exibir_cabecalho_adm($menu_selecionado);
					else
						$this->exibir_cabecalho_cliente($menu_selecionado);
					break;
				}
			case Sistema::INDICACOES: {
					$this->exibir_cabecalho_indicador($menu_selecionado);
					break;
				}
			case Sistema::GOOGLE_DRIVE: {
					$this->exibir_cabecalho_arquivos($menu_selecionado);
					break;
				}
		}
	}

	/* Exibe o cabeçalho da página */
	function exibir_rodape()
	{
		switch ($this->sistema->tipo()) {
			case Sistema::WIN7:
			case Sistema::WIN7_ADM: {
		?>
					<script src="https://www.gstatic.com/firebasejs/5.4.2/firebase-app.js"></script>
					<script src="https://www.gstatic.com/firebasejs/5.4.2/firebase-messaging.js"></script>
					<script src="js/notificacoes.js"></script>
					<footer class="main-footer">
						<strong>Copyright &copy; <?php echo date("Y"); ?> <a href="https://win7.com.br" target="_blank">Agência Win7</a> • </strong> Todos os direitos reservados.
					</footer>
					<script src="js/custom.js"></script>
				<?php
					break;
				}
			case Sistema::INDICACOES: {
					$rodape1 = $this->sistema->indicacoes->vocabulario[2];
					$rodape1 = str_replace("#NOME-CLIENTE#", $this->sistema->indicacoes->nome, $rodape1);
					$rodape2 = $this->sistema->indicacoes->vocabulario[3];
					$rodape2 = str_replace("#TELEFONE#", $this->sistema->indicacoes->telefone, $rodape2);
					$rodape2 = str_replace("#SITE#", $this->sistema->indicacoes->contato, $rodape2);
				?>
					<footer class="main-footer">
						<div class="row">
							<div class="col-xs-12 rodape">
								<?php echo $rodape2; ?>&nbsp;&nbsp;&nbsp;-&nbsp;&nbsp;&nbsp;<span style="color: <?php echo $this->sistema->indicacoes->cor5; ?>;">

									<?php if ($this->sistema->indicacoes->numero_whatsapp_contato_rodape != '') { ?>
										Quer um sistema como este? Entre em contato pelo WhatsApp: <a href="https://wa.me/<?php echo $this->sistema->indicacoes->numero_whatsapp_contato_rodape; ?>" target="_blank" style="color: <?php echo $this->sistema->indicacoes->cor5; ?>;"> <u>clique aqui</u></a>
									<?php } else { ?>
										Quer um sistema como este? Acesse: <a href="https://www.win7.com.br" target="_blank" style="color: <?php echo $this->sistema->indicacoes->cor5; ?>;"> <u>Win7.com.br</u></a>
									<?php } ?>

								</span>
							</div>
						</div>
					</footer>
					<script src="js/jquery.min.js"></script>
					<script src="js/jquery.mask.min.js"></script>
					<script src="js/modal-adicionar-indicado"></script>
					<?php if ($this->sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES) { ?><script src="js/bootstrap-datepicker.min.js"></script>
						<script src="js/bootstrap-datepicker.pt-BR.min.js"></script>
					<?php }
					if ($this->sistema->indicacoes->permissao_inscricoes == "1" && $this->sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES & ($this->sistema->indicacoes->id == "282" || $this->sistema->indicacoes->id == "356" || $this->sistema->indicacoes->id == "205")) { ?><script src="js/basico-faculdade-indicado"></script>
					<?php }
					break;
				}
			case Sistema::GOOGLE_DRIVE: { ?>
					<footer class="main-footer">
						<div class="row">
							<div class="col-xs-12 rodape">
								Quer um sistema como este? Acesse: <a href="https://www.win7.com.br" target="_blank" style="color: <?php echo $this->sistema->drive->cor5; ?>;"> <u>Win7.com.br</u></a></span>
							</div>
						</div>
					</footer>
					<script src="js/jquery.min.js"></script> <?php
																										break;
																									}
																							}
																						}

																						/* Retorna o texto de exibição dos filtros. */
																						function filtro_texto($ft)
																						{
																							$texto = '';
																							switch ($ft) {
																								case 'ALL_TIME':
																									$texto = "Desde o Início";
																									break;
																								case 'TODAY':
																									$texto = "Hoje";
																									break;
																								case 'YESTERDAY':
																									$texto = "Ontem";
																									break;
																								case 'THIS_WEEK_SUN_TODAY':
																									$texto = "Dom até Hoje";
																									break;
																								case 'THIS_WEEK_MON_TODAY':
																									$texto = "Seg até Hoje";
																									break;
																								case 'LAST_BUSINESS_WEEK':
																									$texto = "Última semana útil";
																									break;
																								case 'LAST_WEEK':
																									$texto = "Semana Passada - de Seg até Dom";
																									break;
																								case 'LAST_WEEK_SUN_SAT':
																									$texto = "Semana Passada - de Dom até Sáb";
																									break;
																								case 'LAST_7_DAYS':
																									$texto = "Últimos 7 dias";
																									break;
																								case 'LAST_7_DAYS_TODAY':
																									$texto = "Últimos 7 dias e Hoje";
																									break;
																								case 'LAST_14_DAYS':
																									$texto = "Últimos 14 dias";
																									break;
																								case 'LAST_14_DAYS_TODAY':
																									$texto = "Últimos 14 dias e Hoje";
																									break;
																								case 'LAST_30_DAYS':
																									$texto = "Últimos 30 dias";
																									break;
																								case 'LAST_30_DAYS_TODAY':
																									$texto = "Últimos 30 dias e Hoje";
																									break;
																								case 'THIS_MONTH':
																									$texto = "Esse mês";
																									break;
																								case 'LAST_MONTH':
																									$texto = "Mês passado";
																									break;
																								case 'CUSTOM_DATE':
																									$texto = "Personalizado";
																									break;
																							}
																							return $texto;
																						}

																						// Converte hex para rgb
																						function hex2rgb($hex)
																						{
																							$hex = str_replace("#", "", $hex);
																							if (strlen($hex) == 3) {
																								$r = hexdec(substr($hex, 0, 1) . substr($hex, 0, 1));
																								$g = hexdec(substr($hex, 1, 1) . substr($hex, 1, 1));
																								$b = hexdec(substr($hex, 2, 1) . substr($hex, 2, 1));
																							} else {
																								$r = hexdec(substr($hex, 0, 2));
																								$g = hexdec(substr($hex, 2, 2));
																								$b = hexdec(substr($hex, 4, 2));
																							}
																							return $b + ($g << 0x8) + ($r << 0x10);
																						}

																						// Converte rgb para hex
																						function rgb2hex($rgb)
																						{
																							$hex = "#";
																							$hex .= str_pad(dechex($rgb[0]), 2, "0", STR_PAD_LEFT);
																							$hex .= str_pad(dechex($rgb[1]), 2, "0", STR_PAD_LEFT);
																							$hex .= str_pad(dechex($rgb[2]), 2, "0", STR_PAD_LEFT);

																							return $hex;
																						}

																						// Converte rgb para hsl
																						function rgb2hsl($RGB)
																						{
																							$r = 0xFF & ($RGB >> 0x10);
																							$g = 0xFF & ($RGB >> 0x8);
																							$b = 0xFF & $RGB;

																							$r = ((float)$r) / 255.0;
																							$g = ((float)$g) / 255.0;
																							$b = ((float)$b) / 255.0;

																							$maxC = max($r, $g, $b);
																							$minC = min($r, $g, $b);

																							$l = ($maxC + $minC) / 2.0;

																							if ($maxC == $minC) {
																								$s = 0;
																								$h = 0;
																							} else {
																								if ($l < .5) {
																									$s = ($maxC - $minC) / ($maxC + $minC);
																								} else {
																									$s = ($maxC - $minC) / (2.0 - $maxC - $minC);
																								}
																								if ($r == $maxC)
																									$h = ($g - $b) / ($maxC - $minC);
																								if ($g == $maxC)
																									$h = 2.0 + ($b - $r) / ($maxC - $minC);
																								if ($b == $maxC)
																									$h = 4.0 + ($r - $g) / ($maxC - $minC);
																								$h = $h / 6.0;
																							}

																							$h = (int)round(255.0 * $h);
																							$s = (int)round(255.0 * $s);
																							$l = (int)round(255.0 * $l);

																							return (object) array('hue' => $h, 'saturation' => $s, 'lightness' => $l);
																						}

																						/* Ajusta o brilho da cor para fazer contraste em botões*/
																						function ajustar_brilho($hex, $steps)
																						{
																							$rgb = $this->hex2rgb($hex);
																							$hsl = $this->rgb2hsl($rgb);

																							if ($hsl->lightness > 200) {
																								$steps = -$steps;
																							}

																							$steps = max(-255, min(255, $steps));

																							$hex = str_replace('#', '', $hex);
																							if (strlen($hex) == 3) {
																								$hex = str_repeat(substr($hex, 0, 1), 2) . str_repeat(substr($hex, 1, 1), 2) . str_repeat(substr($hex, 2, 1), 2);
																							}

																							$color_parts = str_split($hex, 2);
																							$return = '#';

																							foreach ($color_parts as $color) {
																								$color   = hexdec($color);
																								$color   = max(0, min(255, $color + $steps));
																								$return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT);
																							}

																							return $return;
																						}

																						/* Cria o css que é utilizado no sistema de indicação para mudar as cores */
																						function exibir_css_indicacao()
																						{
																										?>
		<style>
			.sidebar-toggle {
				color: <?php echo $this->sistema->indicacoes->cor4; ?> !important;
			}

			.skin-blue-light .main-header .navbar {
				background-color: <?php echo $this->sistema->indicacoes->cor2; ?> !important;
				color: <?php echo $this->sistema->indicacoes->cor4; ?> !important;
			}

			.skin-blue-light .main-header .navbar .sidebar-toggle:hover {
				background-color: <?php echo $this->ajustar_brilho($this->sistema->indicacoes->cor2, 30); ?> !important;
				color: <?php echo $this->sistema->indicacoes->cor4; ?> !important;
			}

			.main-header .navbar-custom-menu,
			.main-header .navbar-right {
				color: <?php echo $this->sistema->indicacoes->cor4; ?> !important;
			}

			.main-footer {
				background-color: <?php echo $this->sistema->indicacoes->cor3; ?> !important;
				color: <?php echo $this->sistema->indicacoes->cor5; ?> !important;
			}

			.main-footer a {
				color: <?php echo $this->sistema->indicacoes->cor5; ?> !important;
			}

			.btn-primary:not(.botao-social) {
				background-color: <?php echo $this->sistema->indicacoes->cor1; ?>;
				border-color: <?php echo $this->ajustar_brilho($this->sistema->indicacoes->cor1, -40); ?>;
			}

			.btn-primary:not(.botao-social):hover {
				background-color: <?php echo $this->ajustar_brilho($this->sistema->indicacoes->cor1, -20); ?>;
			}
		</style>
	<?php
																						}

																						/* Cria o css que é utilizado no sistema de arquivos para mudar as cores */
																						function exibir_css_drive()
																						{
	?>
		<style>
			.sidebar-toggle {
				color: <?php echo $this->sistema->drive->cor4; ?> !important;
			}

			.skin-blue-light .main-header .navbar {
				background-color: <?php echo $this->sistema->drive->cor2; ?> !important;
				color: <?php echo $this->sistema->drive->cor4; ?> !important;
			}

			.skin-blue-light .main-header .navbar .sidebar-toggle:hover {
				background-color: <?php echo $this->ajustar_brilho($this->sistema->drive->cor2, 30); ?> !important;
				color: <?php echo $this->sistema->drive->cor4; ?> !important;
			}

			.main-header .navbar-custom-menu,
			.main-header .navbar-right {
				color: <?php echo $this->sistema->drive->cor4; ?> !important;
			}

			.main-footer {
				background-color: <?php echo $this->sistema->drive->cor3; ?> !important;
				color: <?php echo $this->sistema->drive->cor5; ?> !important;
			}

			.main-footer a {
				color: <?php echo $this->sistema->drive->cor5; ?> !important;
			}

			.btn-primary:not(.botao-social) {
				background-color: <?php echo $this->sistema->drive->cor1; ?>;
				border-color: <?php echo $this->ajustar_brilho($this->sistema->drive->cor1, -40); ?>;
			}

			.btn-primary:not(.botao-social):hover {
				background-color: <?php echo $this->ajustar_brilho($this->sistema->drive->cor1, -20); ?>;
			}
		</style>
	<?php
																						}

																						/* Cria o css que é utilizado no sistema de indicação para mudar as cores de páginas não logadas */
																						function exibir_css_indicacao_index()
																						{
	?>
		<style>
			.btn-primary:not(.botao-social) {
				background-color: <?php echo $this->sistema->indicacoes->cor1; ?>;
				border-color: <?php echo $this->ajustar_brilho($this->sistema->indicacoes->cor1, -40); ?>;
			}

			.btn-primary:not(.botao-social):hover {
				background-color: <?php echo $this->ajustar_brilho($this->sistema->indicacoes->cor1, -20); ?>;
			}
		</style>
	<?php
																						}

																						/* Cria o css que é utilizado no sistema de arquivos para mudar as cores de páginas não logadas */
																						function exibir_css_drive_index()
																						{
	?>
		<style>
			.btn-primary:not(.botao-social) {
				background-color: <?php echo $this->sistema->drive->cor1; ?>;
				border-color: <?php echo $this->ajustar_brilho($this->sistema->drive->cor1, -40); ?>;
			}

			.btn-primary:not(.botao-social):hover {
				background-color: <?php echo $this->ajustar_brilho($this->sistema->drive->cor1, -20); ?>;
			}
		</style>
		<?php
																						}

																						/* Exibe a modal de adicionar indicado */
																						function exibir_modal_adicionar_indicado()
																						{
																							if ($this->sistema->indicacoes->cadastro_indicado == "0") {
		?>
			<form method="post" id="formAddIndicado" enctype="multipart/form-data">
				<div class="modal fade" id="modal-adicionar-manual">
					<div class="modal-dialog modal-lg">
						<div class="modal-content" id="modal-adicionar-indicado-conteudo">
							<div class="modal-header">
								<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
									<span aria-hidden="true">&times;</span></button>
								<h4 class="modal-title"><b><?php echo $this->sistema->indicacoes->vocabulario[1]; ?></b></h4>
							</div>
							<div class="modal-body">
								<div class="row">
									<?php if ($this->sistema->indicacoes->permissao_inscricoes == "0") {
																									$erro_cadastro = $this->sistema->indicacoes->vocabulario[23];
																									$erro_cadastro = str_replace("#TELEFONE#", $this->sistema->indicacoes->telefone, $erro_cadastro);
									?>
										<div class="col-xs-12">
											<?php echo $erro_cadastro; ?>
										</div>
									<?php } else { ?>
										<div class="col-xs-12">
											<?php echo $this->sistema->indicacoes->vocabulario[8]; ?>
											<hr>
										</div>
										<div class="col-xs-12 col-sm-6 col-md-3">
											<div class="form-group">
												<label>Nome Completo:</label>
												<div class="input-group">
													<div class="input-group-addon"><i class="fa fa-user"></i></div>
													<input type="text" class="form-control pull-right" id="nome-indicado" name="nome-indicado" alt="Nome" required />
												</div>
											</div>
										</div>
										<div class="col-xs-12 col-sm-6 col-md-3">
											<div class="form-group">
												<label>Email:</label>
												<div class="input-group">
													<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
													<input type="text" class="form-control pull-right" id="email-indicado" name="email-indicado" alt="Email" placeholder="exemplo@gmail.com" required />
												</div>
											</div>
										</div>
										<div class="col-xs-12 col-sm-6 col-md-3">
											<div class="form-group">
												<label>Telefone:</label>
												<div class="input-group">
													<div class="input-group-addon"><i class="fa fa-phone"></i></div>
													<input type="text" class="form-control pull-right telefone" id="telefone-indicado" name="telefone-indicado" alt="Telefone" required />
												</div>
											</div>
										</div>
										<div class="col-xs-12 col-sm-6 col-md-3">
											<div class="form-group">
												<label><?php if ($this->sistema->indicacoes->permissao_cnpj_indicado == "1") {
																										echo "CPF ou CNPJ:";
																									} else {
																										echo "CPF:";
																									} ?></label>
												<div class="input-group">
													<div class="input-group-addon"><i class="fa fa-user"></i></div>
													<input id="usuario-indicado" name="usuario-indicado" type="text" class="form-control" alt="Usuário" onkeydown='mascaraMutuario(this,cpfCnpj)' onchange='mascaraMutuario(this,cpfCnpj)' autocomplete="off" autocorrect="off" autocapitalize="off" required>
												</div>
											</div>
										</div>
										<?php if ($this->sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES & ($this->sistema->indicacoes->id == "282" || $this->sistema->indicacoes->id == "356" || $this->sistema->indicacoes->id == "205")) { ?>
											<div class="col-xs-12 col-sm-6 col-md-4">
												<div class="form-group">
													<label>Bairro:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-building"></i></div>
														<input type="text" class="form-control pull-right" id="bairro-indicado" name="bairro-indicado" alt="Bairro" required />
													</div>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6 col-md-4">
												<div class="form-group">
													<label>Cidade:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-building"></i></div>
														<input type="text" class="form-control pull-right" id="cidade-indicado" name="cidade-indicado" alt="Cidade" required />
													</div>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6 col-md-4">
												<div class="form-group">
													<label>Data da Prova:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
														<input type="text" class="form-control pull-right datepicker" id="data-prova-indicado" name="data-prova-indicado" alt="Cidade" required />
													</div>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6">
												<div class="form-group">
													<label>Curso:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-certificate"></i></div>
														<select name="curso-indicado" id="curso-indicado" class="form-control pull-right" required>
															<option value="" disabled="true" selected>Não Selecionado</option>
															<option value="Administração">Administração</option>
															<option value="Análise e Desenvolvimento de Sistemas">Análise e Desenvolvimento de Sistemas</option>
															<option value="Contabilidade">Contabilidade</option>
															<option value="Enfermagem">Enfermagem</option>
															<option value="Fisioterapia">Fisioterapia</option>
															<option value="Gestão Financeira">Gestão Financeira</option>
															<option value="História">História</option>
															<option value="Letras">Letras</option>
															<option value="Logística">Logística</option>
															<option value="Marketing">Marketing</option>
															<option value="Pedagogia">Pedagogia</option>
															<option value="Pilotagem">Pilotagem</option>
															<option value="Publicidade e Propaganda">Publicidade e Propaganda</option>
															<option value="Radiologia">Radiologia</option>
															<option value="Recursos Humanos">Recursos Humanos</option>
															<option value="Redes de Computadores">Redes de Computadores</option>
															<option value="Segurança da Informação">Segurança da Informação</option>
															<option value="Sistemas de Informação">Sistemas de Informação</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6">
												<div class="form-group">
													<label>Unidade:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-building"></i></div>
														<select name="unidade-indicado" id="unidade-indicado" class="form-control pull-right" required>
															<option value="" disabled="true" selected>Não Selecionado</option>
														</select>
													</div>
												</div>
											</div>
										<?php } ?>
										<?php if ($this->sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES & ($this->sistema->indicacoes->id == "298")) { ?>
											<div class="col-xs-12 col-sm-6 col-md-4">
												<div class="form-group">
													<label>Bairro:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-building"></i></div>
														<input type="text" class="form-control pull-right" id="bairro-indicado" name="bairro-indicado" alt="Bairro" required />
													</div>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6 col-md-4">
												<div class="form-group">
													<label>Cidade:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-building"></i></div>
														<input type="text" class="form-control pull-right" id="cidade-indicado" name="cidade-indicado" alt="Cidade" required />
													</div>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6 col-md-4">
												<div class="form-group">
													<label>Data da Prova:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
														<input type="text" class="form-control pull-right datepicker" id="data-prova-indicado" name="data-prova-indicado" alt="Cidade" required />
													</div>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6">
												<div class="form-group">
													<label>Curso:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-certificate"></i></div>
														<select name="curso-indicado" id="curso-indicado" class="form-control pull-right" required>
															<option value="" disabled="true" selected>Não Selecionado</option>
															<option value="Administração">Administração</option>
															<option value="Administração Pública">Administração Pública</option>
															<option value="Análise e Desenvolvimento de Sistemas">Análise e Desenvolvimento de Sistemas</option>
															<option value="Ciências Contábeis">Ciências Contábeis</option>
															<option value="Enfermagem">Enfermagem</option>
															<option value="Gestão Ambiental">Gestão Ambiental</option>
															<option value="Gestão Financeira">Gestão Financeira</option>
															<option value="História">História</option>
															<option value="Letras">Letras</option>
															<option value="Lógistica">Lógistica</option>
															<option value="Pedagogia">Pedagogia</option>
															<option value="Publicidade e Propaganda">Publicidade e Propaganda</option>
															<option value="Radiologia">Radiologia</option>
															<option value="Recursos Humanos">Recursos Humanos</option>
															<option value="Redes de Computadores">Redes de Computadores</option>
															<option value="Segurança da Informação">Segurança da Informação</option>
															<option value="Sistemas de Informação">Sistemas de Informação</option>
														</select>
													</div>
												</div>
											</div>
											<div class="col-xs-12 col-sm-6">
												<div class="form-group">
													<label>Unidade:</label>
													<div class="input-group">
														<div class="input-group-addon"><i class="fa fa-building"></i></div>
														<select name="unidade-indicado" id="unidade-indicado" class="form-control pull-right" required>
															<option value="" disabled="true" selected>Não Selecionado</option>
															<option value="504 Sul">504 Sul</option>
														</select>
													</div>
												</div>
											</div>
										<?php } ?>
									<?php } ?>
								</div>
							</div>
							<div class="modal-footer">
								<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
								<?php if ($this->sistema->indicacoes->permissao_inscricoes != "0") { ?><button type="submit" class="btn btn-primary">Cadastrar Indicado</button><?php } ?>
							</div>
							<div class="overlay preloader">
								<i class="fa fa-refresh fa-spin"></i>
							</div>
						</div>
					</div>
				</div>
			</form>
		<?php } ?>
		<div class="modal fade" id="modal-adicionar-indicado">
			<div class="modal-dialog modal-lg">
				<div class="modal-content" id="modal-adicionar-indicado-conteudo">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
							<span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title"><b><?php echo $this->sistema->indicacoes->vocabulario[0]; ?></b></h4>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-xs-12 col-md-6">
								<?php echo $this->sistema->indicacoes->vocabulario[6]; ?><p><b id="pLinkIndicacao1">https://<?php echo $this->sistema->indicacoes->dominio; ?>/i/<?php echo $this->sistema->usuario->id; ?></b></p>
							</div>
							<div class="col-xs-12 col-md-6" style="border-left: 1px solid #e5e5e5;">
								<p>Ou compartilhe nas redes sociais:</p>
								<a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo rawurlencode("https://" . $this->sistema->indicacoes->dominio . "/i/" . $this->sistema->usuario->id); ?>" class="btn btn-primary botao-social btn-facebook" style="margin-right: 4px; margin-bottom: 4px;" title="Compartilhe no Facebook"><i class="fa fa-facebook"></i></a><a target="_blank" href="https://api.whatsapp.com/send?text=<?php echo rawurlencode("https://" . $this->sistema->indicacoes->dominio . "/i/" . $this->sistema->usuario->id); ?>" class="btn btn-primary botao-social btn-whatsapp" style="margin-right: 4px; margin-bottom: 4px;" title="Compartilhe no Whatsapp"><i class="fa fa-whatsapp"></i></a><a target="_blank" href="https://twitter.com/intent/tweet?text=<?php echo rawurlencode("https://" . $this->sistema->indicacoes->dominio . "/i/" . $this->sistema->usuario->id); ?>" class="btn btn-primary botao-social btn-twitter" style="margin-right: 4px; margin-bottom: 4px;" title="Compartilhe no Twitter"><i class="fa fa-twitter"></i></a><a target="_blank" href="https://plus.google.com/share?url=<?php echo rawurlencode("https://" . $this->sistema->indicacoes->dominio . "/i/" . $this->sistema->usuario->id); ?>" class="btn btn-primary botao-social btn-google" style="margin-right: 4px; margin-bottom: 4px;" title="Compartilhe no Google+"><i class="fa fa-google-plus"></i></a>
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
						<button class="btn btn-primary text-center" style="margin-right: 4px; margin-bottom: 4px;" onclick="copiarLink1();">Copiar Link</button>
					</div>
					<div class="overlay preloader">
						<i class="fa fa-refresh fa-spin"></i>
					</div>
				</div>
			</div>
		</div>
		<div class="modal fade" id="modal-adicionar-indicador">
			<div class="modal-dialog modal-lg">
				<div class="modal-content" id="modal-adicionar-indicado-conteudo">
					<div class="modal-header">
						<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
							<span aria-hidden="true">&times;</span></button>
						<h4 class="modal-title"><b><?php echo $this->sistema->indicacoes->vocabulario[30]; ?></b></h4>
					</div>
					<div class="modal-body">
						<div class="row">
							<div class="col-xs-12 col-md-6">
								<?php echo $this->sistema->indicacoes->vocabulario[7]; ?><p><b id="pLinkIndicacao2">https://<?php echo $this->sistema->indicacoes->dominio; ?>/r/<?php echo $this->sistema->usuario->id; ?></b></p>
							</div>
							<div class="col-xs-12 col-md-6" style="border-left: 1px solid #e5e5e5;">
								<p>Ou compartilhe nas redes sociais:</p>
								<a target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo rawurlencode("https://" . $this->sistema->indicacoes->dominio . "/r/" . $this->sistema->usuario->id); ?>" class="btn btn-primary botao-social btn-facebook" style="margin-right: 4px; margin-bottom: 4px;" title="Compartilhe no Facebook"><i class="fa fa-facebook"></i></a><a target="_blank" href="https://api.whatsapp.com/send?text=<?php echo rawurlencode("https://" . $this->sistema->indicacoes->dominio . "/r/" . $this->sistema->usuario->id); ?>" class="btn btn-primary botao-social btn-whatsapp" style="margin-right: 4px; margin-bottom: 4px;" title="Compartilhe no Whatsapp"><i class="fa fa-whatsapp"></i></a><a target="_blank" href="https://twitter.com/intent/tweet?text=<?php echo rawurlencode("https://" . $this->sistema->indicacoes->dominio . "/r/" . $this->sistema->usuario->id); ?>" class="btn btn-primary botao-social btn-twitter" style="margin-right: 4px; margin-bottom: 4px;" title="Compartilhe no Twitter"><i class="fa fa-twitter"></i></a><a target="_blank" href="https://plus.google.com/share?url=<?php echo rawurlencode("https://" . $this->sistema->indicacoes->dominio . "/r/" . $this->sistema->usuario->id); ?>" class="btn btn-primary botao-social btn-google" style="margin-right: 4px; margin-bottom: 4px;" title="Compartilhe no Google+"><i class="fa fa-google-plus"></i></a>
							</div>
						</div>
					</div>
					<div class="modal-footer">
						<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
						<button class="btn btn-primary text-center" style="margin-right: 4px; margin-bottom: 4px;" onclick="copiarLink2();">Copiar Link</button>
					</div>
					<div class="overlay preloader">
						<i class="fa fa-refresh fa-spin"></i>
					</div>
				</div>
			</div>
		</div>
<?php
																						}
																					}
?>