<?php

/***
 * Esta classe é responsável por controlar funções gerais de funcionamento do sistema.
 * Por esse motivo, deve ser inicializada em todas as páginas do sistema, sejam páginas
 * de front-end ou back-end.
 *
 * MODO SANDBOX - Modo no qual o sistema não utiliza os bancos de dados principais,
 * usando apenas cópias desses bancos, para não afetar o funcionamento do sistema original.
 ***/

date_default_timezone_set('America/Sao_Paulo');

error_reporting(0); // Desabilita a exibição de erros

require_once(__DIR__ . '/../../sistemawin7lib/vendor/autoload.php');
require_once(__DIR__ . "/Banco_Dados.php");
require_once(__DIR__ . "/Banco_Dados_Leads.php");
require_once(__DIR__ . "/Sessao.php");
require_once(__DIR__ . "/Utilitarios.php");
require_once(__DIR__ . "/Usuario.php");
require_once(__DIR__ . "/Usuario_Win7.php");
require_once(__DIR__ . "/Usuario_Arquivos.php");
require_once(__DIR__ . "/Usuario_Indicador.php");
require_once(__DIR__ . "/Usuario_Adm.php");
require_once(__DIR__ . "/Sistema_Indicacoes.php");
require_once(__DIR__ . "/Sistema_Google_Drive.php");
require_once(__DIR__ . "/Layout_Sistema.php");
require_once(__DIR__ . "/Filtro.php");
require_once(__DIR__ . "/Sistema_Adwords.php");
require_once(__DIR__ . "/Sistema_Contatos.php");
require_once(__DIR__ . "/Subusuario_Win7.php");
require_once(__DIR__ . "/Mascara.php");
require_once(__DIR__ . "/Sistema_Win7Fone.php");
require_once(__DIR__ . "/Sistema_Zoho.php");
require_once(__DIR__ . "/Sistema_Logs.php");

use PHPMailer\PHPMailer\PHPMailer;
use Win7\Ads\Entity\CustomerFilter;

class Sistema
{

    // Array que guarda os domínios do modo sandbox
    private $dominios_sandbox;
    // Array que guarda os domínio do sistema
    private $dominios_sistema;
    // Variável que guarda o domínio sendo usado
    private $dominio;
    // Variável que indica se o modo sandbox está ativo
    public $modo_sandbox;
    // Variável que indica qual o tipo do sistema aberto no momento
    public $tipo;
    // Variável que guarda o banco de dados
    public $bd;
    // Variável que guarda o banco de dados dos leads
    public $bd_leads;
    // Variável que guarda os dados sa sessao
    public $sessao;
    /**
     * Variável que guarda o usuário atual
     *
     * @var \Usuario_Win7|\Usuario_Adm|\Usuario
     */
    public $usuario;
    // Variável que guarda o layout atual
    public $layout;
    // Variável que guarda o layout atual
    public $filtro;
    // Variável que guarda o sistema do adwords
    public $adwords;
    // Variável que guarda os emails padrões de notificação
    public $email_notificacao;

    /* As constantes a seguir informam qual o tipo de sistema está sendo carregado */
    const WIN7 = 0;
    const WIN7_ADM = 1;
    const INDICACOES = 2;
    const GOOGLE_DRIVE = 3;
    const LEADS = 4;

    const SUCESSO = 0;
    const FALHA = 1;
    const ERRO_CONEXAO = 2;

    const TIPO_EMAIL_CLIENTE = 0;
    const TIPO_EMAIL_LEAD = 1;
    const TIPO_EMAIL_SISTEMA = 2;

    const MAXIMO_MOEDAS_ADWORDS = 2;
    const MOEDA_REAL = 0;
    const MOEDA_DOLAR = 1;
    const MOEDA_EURO = 2;

    /*
        Construtor padrão da classe.
        É importante sempre especificar qual o tipo de sistema está sendo acessado.
        A flag $restringir serve para verificar se o usuário está logado antes de continuar.
    */
    function __construct($restringir = false, $ajax = false, $cliente = true)
    {
        global $tipo_sistema;
        if (strstr(strtolower($_SERVER['HTTP_USER_AGENT']), 'mobile') || strstr(
            strtolower($_SERVER['HTTP_USER_AGENT']),
            'android'
        )) {
            $this->maquina_usuario = 'SMARTPHONE';
        } else {
            $this->maquina_usuario = 'COMPUTADOR';
        }
        $this->dominio          = $_SERVER['SERVER_NAME'];
        $this->dominios_sandbox = [
            "indicacoesteste.win7.com.br",
            "teste5.win7.com.br",
            "teste5drive.win7.com.br",
            "sistemadev.win7.com.br",
        ];
        $this->dominios_sistema = ["google.win7.com.br", "sistema.win7.com.br"];
        $this->modo_sandbox     = in_array($this->dominio, $this->dominios_sandbox) & $tipo_sistema != Sistema::LEADS;
        $app_env = getenv('APP_ENV');


        // $this->modo_sandbox = true;
        if ($this->modo_sandbox || ($app_env === 'desenvolvimento')) { // necessário para funcionar na máquina local do Thiago (não afeta produção)
            error_reporting(E_ALL ^ E_NOTICE ^ E_WARNING);
        } // Se estiver no modo sandbox, ativamos exibição de erros
        else {
            error_reporting(0); // Se não estiver no modo sandbox, desativamos a exibição de erros
            ignore_user_abort(true);
            set_time_limit(0);
        }

        if ($this->dominio == 'local.sistemawin7dev' || $this->dominio == 'local.sistemawin7devs') {
            error_reporting(E_ALL ^ E_NOTICE); // Se estiver no modo sandbox, ativamos exibição de erros
        }

        $this->bd     = new Banco_Dados($this->modo_sandbox);
        $this->tipo   = $tipo_sistema;
        $this->layout = new Layout_Sistema($this);
        $this->logs   = new Sistema_logs($this);

        if ($tipo_sistema == Sistema::INDICACOES) {
            $this->indicacoes = new Sistema_Indicacoes($this);
            $this->sessao     = new Sessao($this);
            if ($this->sessao->logado()) {
                $this->usuario = $_SESSION["usuario"];
                $this->usuario->carregar($this);
                $this->filtro = $_SESSION['filtro'];
                if (!isset($_SESSION['filtro'])) {
                    $_SESSION['filtro'] = new Filtro($this);
                }
            } else {
                if ($restringir) {
                    $_SESSION['errologin'] = 3;
                    if ($ajax) {
                        echo "-1";
                        exit;
                    } else {
                        $this->redirecionar('./');
                    }
                }
            }
        } else {
            if ($tipo_sistema == Sistema::GOOGLE_DRIVE) {
                $this->drive  = new Sistema_Google_Drive($this);
                $this->sessao = new Sessao($this);
                if ($this->sessao->logado()) {
                    $this->usuario = $_SESSION["usuario"];
                    $this->usuario->carregar($this);
                    $this->filtro = $_SESSION['filtro'];
                    if (!isset($_SESSION['filtro'])) {
                        $_SESSION['filtro'] = new Filtro($this);
                    }
                } else {
                    if ($restringir) {
                        $_SESSION['errologin'] = 3;
                        if ($ajax) {
                            echo "-1";
                            exit;
                        } else {
                            $this->redirecionar('./');
                        }
                    }
                }
            } else {
                if ($tipo_sistema == Sistema::LEADS) {
                    $this->contatos = new Sistema_Contatos($this);
                    $this->sessao   = new Sessao($this);
                } else {
                    $this->sessao = new Sessao($this);
                    if ($this->sessao->logado()) {
                        $this->usuario = $_SESSION["usuario"];

                        if ($cliente & ($this->usuario instanceof Usuario_Adm) & $this->usuario->id == -1) {
                            $this->redirecionar("./");
                        }

                        if ($tipo_sistema === Sistema::WIN7_ADM && isset($_GET['idClienteSistema'])) {
                            $this->usuario->id = $_GET['idClienteSistema'];
                        } elseif ($tipo_sistema === Sistema::WIN7_ADM && isset($_POST['idClienteSistema'])) {
                            $this->usuario->id = $_POST['idClienteSistema'];
                        }

                        $this->usuario->carregar($this->bd);
                        if ($cliente == true && $this->usuario instanceof Usuario_Adm && $this->usuario->permissao_sistema_clientes == Usuario::PERM_NENHUMA) {
                            if ($ajax == true) {
                                echo "-2Permissão insuficiente para ver esta página!";
                                exit;
                            } else {
                                $this->redirecionar("home");
                            }
                        }
                        $this->filtro = $_SESSION['filtro'];
                        if (!isset($_SESSION['filtro'])) {
                            $_SESSION['filtro'] = new Filtro($this);
                        }
                        $this->email_notificacao = ["alan@grupolead.com.br", "desenvolvimento@grupolead.com.br"];
                        //$this->contatos = new Sistema_Contatos($this);
                        if ($tipo_sistema == Sistema::WIN7 || ($tipo_sistema == Sistema::WIN7_ADM & $this->usuario->cliente_carregado())) {
                            if ($usuario->permissao_indicacoes != Usuario::PERM_NENHUMA) {
                                $this->indicacoes = new Sistema_Indicacoes($this);
                            }
                            if ($usuario->permissao_drive != Usuario::PERM_NENHUMA) {
                                $this->drive = new Sistema_Google_Drive($this);
                            }
                            $this->adwords = new Sistema_Adwords($this->bd);
                        }
                    } else {
                        if ($restringir) {
                            $_SESSION['errologin'] = 2;
                            if ($ajax) {
                                echo "-1";
                                exit;
                            } else {
                                $this->redirecionar('./');
                            }
                        }
                    }
                }
            }
        }
    }

    function simbolo_moeda($moeda)
    {
        $moedas = ["R$", "$", "€"];

        return $moedas[$moeda];
    }

    function moeda_vazia($moeda)
    {
        $moedas = ["R$ 0,00", "$ 0.00", "€ 0.00"];

        return $moedas[$moeda];
    }

    function inicializar_zoho()
    {
        $this->zoho = new Sistema_Zoho($this);
    }

    // Sai do sistema caso a ID não seja válida para o cliente que possui o whatsapp
    static function validar_whatsapp($id)
    {
        $id_dec    = self::descriptografar($id);
        $bd        = new Banco_Dados(false);
        $resultado = $bd->executar(
            "SELECT ID_CLIENTE FROM TBL_CLIENTE WHERE ID_CLIENTE = :id AND NU_WHATSAPP = 1",
            [":id" => $id_dec],
            Banco_Dados::FETCH
        );
        if ($bd->quantidade() == 0) {
            exit;
        }
    }

    // Sai do sistema caso a ID não seja válida para o cliente que possui o sms
    static function validar_sms($id)
    {
        $id_dec    = self::descriptografar($id);
        $bd        = new Banco_Dados(false);
        $resultado = $bd->executar(
            "SELECT ID_CLIENTE FROM TBL_CLIENTE WHERE ID_CLIENTE = :id AND NU_SMS = 1",
            [":id" => $id_dec],
            Banco_Dados::FETCH
        );
        if ($bd->quantidade() == 0) {
            exit;
        }
    }

    // Criptografa uma string
    static function criptografar($string)
    {
        return self::dec_enc("encrypt", $string);
    }

    // Descriptografa uma string
    static function descriptografar($string)
    {
        return self::dec_enc("decrypt", $string);
    }

    private static function dec_enc($action, $string)
    {
        $output = false;

        $encrypt_method = "AES-256-CBC";
        $secret_key     = 'WIN7ADMIN1162817';
        $secret_iv      = 'APQNHTIUXEZMNFRG';

        // hash
        $key = hash('sha256', $secret_key);

        // iv - encrypt method AES-256-CBC expects 16 bytes - else you will get a warning
        $iv = substr(hash('sha256', $secret_iv), 0, 16);

        if ($action == 'encrypt') {
            $output = openssl_encrypt($string, $encrypt_method, $key, 0, $iv);
            $output = base64_encode($output);
        } else {
            if ($action == 'decrypt') {
                $output = openssl_decrypt(base64_decode($string), $encrypt_method, $key, 0, $iv);
            }
        }

        return $output;
    }

    /* Registra um novo email para envio através de rotina */
    static function registrar_email(
        $mensagem,
        $assunto,
        $destinatarios,
        $copias_ocultas,
        $nome,
        $email,
        $arquivo,
        $tipo,
        $anexo = null,
        $nome_anexo = ""
    ) {
        $bd = new Banco_Dados(false);

        if (count($destinatarios) > 0) {
            $destinos = implode(' |$| ', $destinatarios);
            $destinos .= " |$| " . implode(' |$| ', array_keys($destinatarios));
        } else {
            return;
        }
        if (count($copias_ocultas) > 0) {
            $ocultas = implode(' |$| ', $copias_ocultas);
            $ocultas .= " |$| " . implode(' |$| ', array_keys($copias_ocultas));
        } else {
            $ocultas = "";
        }

        if ($anexo == null) {
            $anexo_ativado = "0";
            $texto_anexo   = "";
        } else {
            $anexo_ativado = "1";
            $texto_anexo   = $anexo;
        }

        $sql    = "INSERT INTO TBL_ENVIO_EMAIL (TXT_ASSUNTO, TXT_MENSAGEM, TXT_DESTINATARIOS, TXT_COPIAS_OCULTAS, TXT_NOME, TXT_EMAIL, NU_TIPO, TXT_ARQUIVO, NU_ATIVAR_ANEXO, TXT_ANEXO, TXT_NOME_ANEXO) VALUES  (:assunto, :mensagem, :destinatarios, :copias, :nome, :email, :tipo, :arquivo, :ativaranexo, :anexo, :nomeanexo)";
        $params = [
            ":assunto"       => $assunto,
            ":mensagem"      => $mensagem,
            ":destinatarios" => $destinos,
            ":copias"        => $ocultas,
            ":nome"          => $nome,
            ":email"         => $email,
            ":arquivo"       => $arquivo,
            ":tipo"          => $tipo,
            ":ativaranexo"   => $anexo_ativado,
            ":anexo"         => $texto_anexo,
            ":nomeanexo"     => $nome_anexo,
        ];

        $bd->executar($sql, $params);

        return $bd->ultima_id();
    }

    static function obter_resultados_gerais_fixo($data, $data_inicial, $data_final)
    {
        $bd       = new Banco_Dados(false);
        $bd_leads = new Banco_Dados_Leads(false);

        $clientes = $bd->executar(
            "SELECT ID_CLIENTE, TXT_NOME FROM TBL_CLIENTE WHERE NU_CLIENTE_ATIVO = 1",
            [],
            Banco_Dados::FETCH_ALL
        );
        $sql      = "SELECT ";
        $sql2     = "SELECT ";
        $counter  = 0;
        $filtro   = Filtro::filtrar_data($data, "DT_ATUAL", $data_inicial, $data_final);
        $filtro2  = Filtro::filtrar_data($data, "DT_DIA", $data_inicial, $data_final);
        foreach ($clientes as $cliente) {
            if ($counter == 0) {
                if (empty($filtro)) {
                    $sql .= "(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'Formulário') as forms" . $cliente['ID_CLIENTE'] . ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'WhatsApp') as whatsapp" . $cliente['ID_CLIENTE'];
                } else {
                    $sql .= "(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'Formulário' AND " . $filtro . ") as forms" . $cliente['ID_CLIENTE'] . ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'WhatsApp' AND " . $filtro . ") as whatsapp" . $cliente['ID_CLIENTE'];
                }
                if (empty($filtro2)) {
                    $sql2 .= "(SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . ") as ligacoes" . $cliente['ID_CLIENTE'] . ", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . ") as cliques" . $cliente['ID_CLIENTE'];
                } else {
                    $sql2 .= "(SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . " AND " . $filtro2 . ") as ligacoes" . $cliente['ID_CLIENTE'] . ", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . " AND " . $filtro2 . ") as cliques" . $cliente['ID_CLIENTE'];
                }
            } else {
                if (empty($filtro)) {
                    $sql .= ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'Formulário') as forms" . $cliente['ID_CLIENTE'] . ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'WhatsApp') as whatsapp" . $cliente['ID_CLIENTE'];
                } else {
                    $sql .= ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'Formulário' AND " . $filtro . ") as forms" . $cliente['ID_CLIENTE'] . ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'WhatsApp' AND " . $filtro . ") as whatsapp" . $cliente['ID_CLIENTE'];
                }
                if (empty($filtro2)) {
                    $sql2 .= ", (SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . ") as ligacoes" . $cliente['ID_CLIENTE'] . ", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . ") as cliques" . $cliente['ID_CLIENTE'];
                } else {
                    $sql2 .= ", (SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . " AND " . $filtro2 . ") as ligacoes" . $cliente['ID_CLIENTE'] . ", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . " AND " . $filtro2 . ") as cliques" . $cliente['ID_CLIENTE'];
                }
            }
            $counter++;
        }

        /*
         foreach($clientes as $cliente){
            if($counter == 0){
                if(empty($filtro)){
                    $sql .= "(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$cliente['ID_CLIENTE']." AND TXT_LEADTIPO = 'Formulário' AND NU_LIXEIRA = 0) as forms".$cliente['ID_CLIENTE'].", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$cliente['ID_CLIENTE']." AND TXT_LEADTIPO = 'WhatsApp' AND NU_LIXEIRA = 0) as whatsapp".$cliente['ID_CLIENTE'];
                }
                else{
                    $sql .= "(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$cliente['ID_CLIENTE']." AND TXT_LEADTIPO = 'Formulário' AND NU_LIXEIRA = 0 AND ".$filtro.") as forms".$cliente['ID_CLIENTE'].", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$cliente['ID_CLIENTE']." AND TXT_LEADTIPO = 'WhatsApp' AND NU_LIXEIRA = 0 AND ".$filtro.") as whatsapp".$cliente['ID_CLIENTE'];
                }
                if(empty($filtro2)){
                    $sql2 .= "(SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$cliente['ID_CLIENTE'].") as ligacoes".$cliente['ID_CLIENTE'].", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$cliente['ID_CLIENTE'].") as cliques".$cliente['ID_CLIENTE'];
                }
                else{
                    $sql2 .= "(SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$cliente['ID_CLIENTE']." AND ".$filtro2.") as ligacoes".$cliente['ID_CLIENTE'].", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$cliente['ID_CLIENTE']." AND ".$filtro2.") as cliques".$cliente['ID_CLIENTE'];
                }
            }
            else{
                if(empty($filtro)){
                    $sql .= ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$cliente['ID_CLIENTE']." AND TXT_LEADTIPO = 'Formulário' AND NU_LIXEIRA = 0) as forms".$cliente['ID_CLIENTE'].", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$cliente['ID_CLIENTE']." AND TXT_LEADTIPO = 'WhatsApp' AND NU_LIXEIRA = 0) as whatsapp".$cliente['ID_CLIENTE'];
                }
                else{
                    $sql .= ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$cliente['ID_CLIENTE']." AND TXT_LEADTIPO = 'Formulário' AND NU_LIXEIRA = 0 AND ".$filtro.") as forms".$cliente['ID_CLIENTE'].", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = ".$cliente['ID_CLIENTE']." AND TXT_LEADTIPO = 'WhatsApp' AND NU_LIXEIRA = 0 AND ".$filtro.") as whatsapp".$cliente['ID_CLIENTE'];
                }
                if(empty($filtro2)){
                    $sql2 .= ", (SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$cliente['ID_CLIENTE'].") as ligacoes".$cliente['ID_CLIENTE'].", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$cliente['ID_CLIENTE'].") as cliques".$cliente['ID_CLIENTE'];
                }
                else{
                    $sql2 .= ", (SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$cliente['ID_CLIENTE']." AND ".$filtro2.") as ligacoes".$cliente['ID_CLIENTE'].", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = ".$cliente['ID_CLIENTE']." AND ".$filtro2.") as cliques".$cliente['ID_CLIENTE'];
                }

            }
            $counter++;
        }
         */

        $rows = [];

        $resultado  = $bd_leads->executar($sql, [], Banco_Dados::FETCH);
        $resultado2 = $bd->executar($sql2, [], Banco_Dados::FETCH);

        foreach ($clientes as $cliente) {
            $id   = $cliente['ID_CLIENTE'];
            $nome = $cliente['TXT_NOME'];

            $forms    = $resultado['forms' . $id];
            $whatsapp = $resultado['whatsapp' . $id];
            $cliques  = $resultado2['cliques' . $id];
            $ligacoes = $resultado2['ligacoes' . $id];
            if (empty($cliques)) {
                $cliques = "0";
            }
            if (empty($ligacoes)) {
                $ligacoes = "0";
            }

            $rows[] = [
                "nome"     => $nome,
                "id"       => $id,
                "forms"    => $forms,
                "whatsapp" => $whatsapp,
                "ligacoes" => $ligacoes,
                "cliques"  => $cliques,
            ];
        }

        return $rows;
    }

    /* Obtém o resultado geral de todos os clientes, organizado para utilização no gráfico*/
    function obter_resultados_gerais($data, $data_inicial, $data_final, $inputSearch)
    {
        $bd       = new Banco_Dados(false);
        $bd_leads = new Banco_Dados_Leads(false);

        $clientes = $bd->executar(
            "SELECT ID_CLIENTE, TXT_NOME FROM TBL_CLIENTE WHERE NU_CLIENTE_ATIVO = 1",
            [],
            Banco_Dados::FETCH_ALL
        );
        $sql      = "SELECT ";
        $sql2     = "SELECT ";
        $counter  = 0;
        $filtro   = Filtro::filtrar_data($data, "DT_ATUAL", $data_inicial, $data_final);
        $filtro2  = Filtro::filtrar_data($data, "DT_DIA", $data_inicial, $data_final);

        foreach ($clientes as $cliente) {
            if ($counter == 0) {
                if (empty($filtro)) {
                    $sql .= "(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'Formulário') as forms" . $cliente['ID_CLIENTE'] . ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'WhatsApp') as whatsapp" . $cliente['ID_CLIENTE'];
                } else {
                    $sql .= "(SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'Formulário' AND " . $filtro . ") as forms" . $cliente['ID_CLIENTE'] . ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'WhatsApp' AND " . $filtro . ") as whatsapp" . $cliente['ID_CLIENTE'];
                }
                if (empty($filtro2)) {
                    $sql2 .= "(SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . ") as ligacoes" . $cliente['ID_CLIENTE'] . ", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . ") as cliques" . $cliente['ID_CLIENTE'];
                } else {
                    $sql2 .= "(SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . " AND " . $filtro2 . ") as ligacoes" . $cliente['ID_CLIENTE'] . ", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . " AND " . $filtro2 . ") as cliques" . $cliente['ID_CLIENTE'];
                }
            } else {
                if (empty($filtro)) {
                    $sql .= ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'Formulário') as forms" . $cliente['ID_CLIENTE'] . ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'WhatsApp') as whatsapp" . $cliente['ID_CLIENTE'];
                } else {
                    $sql .= ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'Formulário' AND " . $filtro . ") as forms" . $cliente['ID_CLIENTE'] . ", (SELECT count(*) FROM TBL_LEADS WHERE ID_CLIENTE_FK = " . $cliente['ID_CLIENTE'] . " AND TXT_LEADTIPO = 'WhatsApp' AND " . $filtro . ") as whatsapp" . $cliente['ID_CLIENTE'];
                }
                if (empty($filtro2)) {
                    $sql2 .= ", (SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . ") as ligacoes" . $cliente['ID_CLIENTE'] . ", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . ") as cliques" . $cliente['ID_CLIENTE'];
                } else {
                    $sql2 .= ", (SELECT sum(NU_LIGACOES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . " AND " . $filtro2 . ") as ligacoes" . $cliente['ID_CLIENTE'] . ", (SELECT sum(NU_CLIQUES) FROM TBL_DADOS_RESULTADOS WHERE ID_FK = " . $cliente['ID_CLIENTE'] . " AND " . $filtro2 . ") as cliques" . $cliente['ID_CLIENTE'];
                }
            }
            $counter++;
        }

        $rows = [];

        $resultado  = $bd_leads->executar($sql, [], Banco_Dados::FETCH);
        $resultado2 = $bd->executar($sql2, [], Banco_Dados::FETCH);

        if (!empty($inputSearch)) {
            foreach ($clientes as $cliente) {
                /* Ve se a pesquisa acha algum cliente */
                if (preg_match(strtolower(trim("/" . $inputSearch . "/")), strtolower(trim($cliente['TXT_NOME'])))) {

                    $id   = $cliente['ID_CLIENTE'];
                    $nome = $cliente['TXT_NOME'];

                    $forms    = $resultado['forms' . $id];
                    $whatsapp = $resultado['whatsapp' . $id];
                    $cliques  = $resultado2['cliques' . $id];
                    $ligacoes = $resultado2['ligacoes' . $id];
                    if (empty($cliques)) {
                        $cliques = "0";
                    }
                    if (empty($ligacoes)) {
                        $ligacoes = "0";
                    }

                    $rows[] = [
                        "nome"     => $nome,
                        "id"       => $id,
                        "forms"    => $forms,
                        "whatsapp" => $whatsapp,
                        "ligacoes" => $ligacoes,
                        "cliques"  => $cliques,
                    ];
                } else {
                    $rows[] = [];
                }
            }
        } else {
            foreach ($clientes as $cliente) {
                $id   = $cliente['ID_CLIENTE'];
                $nome = $cliente['TXT_NOME'];

                $forms    = $resultado['forms' . $id];
                $whatsapp = $resultado['whatsapp' . $id];
                $cliques  = $resultado2['cliques' . $id];
                $ligacoes = $resultado2['ligacoes' . $id];
                if (empty($cliques)) {
                    $cliques = "0";
                }
                if (empty($ligacoes)) {
                    $ligacoes = "0";
                }

                $rows[] = [
                    "nome"     => $nome,
                    "id"       => $id,
                    "forms"    => $forms,
                    "whatsapp" => $whatsapp,
                    "ligacoes" => $ligacoes,
                    "cliques"  => $cliques,
                ];
            }
        }

        return $rows;
    }

    /* Obtém uma lista de todos os emails */
    function obter_email($id)
    {
        $sql       = "SELECT * FROM TBL_ENVIO_EMAIL WHERE NU_ID = :id";
        $resultado = $this->bd->executar($sql, [":id" => $id], Banco_Dados::FETCH);

        return $resultado;
    }

    /* Obtém uma lista de todos os emails */
    function obter_emails($data, $data_inicial, $data_final, $status)
    {
        $filtro = Filtro::filtrar_data($data, "DT_ADICAO", $data_inicial, $data_final); // Montamos o filtro SQL de data

        $filtro_status = "";
        if ($status != "0") {
            switch ($status) {
                case "1":
                    $filtro_status = "NU_STATUS = 0";
                    break;
                case "2":
                    $filtro_status = "NU_STATUS = 1";
                    break;
                case "3":
                    $filtro_status = "NU_STATUS = 2";
                    break;
                case "4":
                    $filtro_status = "NU_STATUS = 3";
                    break;
                case "5":
                    $filtro_status = "NU_STATUS = 4";
                    break;
            }
        }

        if (empty($filtro)) {
            $sql = empty($filtro_status) ?
                "SELECT * FROM TBL_ENVIO_EMAIL" :
                "SELECT * FROM TBL_ENVIO_EMAIL WHERE " . $filtro_status;
        } else {
            $sql = empty($filtro_status) ?
                "SELECT * FROM TBL_ENVIO_EMAIL WHERE " . $filtro :
                "SELECT * FROM TBL_ENVIO_EMAIL WHERE " . $filtro_status . " AND " . $filtro;
        }

        $resultado = $this->bd->executar($sql, [], Banco_Dados::FETCH_ALL);

        $rows = [];

        $enviados  = 0;
        $pendentes = 0;
        $falhos    = 0;

        foreach ($resultado as $row) {
            switch ($row['NU_STATUS']) {
                case "0":
                    $status = "Pendente";
                    $pendentes++;
                    break;
                case "1":
                    $status = "Enviado";
                    $enviados++;
                    break;
                case "2":
                    $status = "Não Enviado";
                    $falhos++;
                    break;
                case "3":
                    $status = "Arquivado";
                    $falhos++;
                    break;
                case "4":
                    $status = "Marcado para Reenvio";
                    $pendentes++;
                    break;
            }

            switch ($row['NU_TIPO']) {
                case "0":
                    $tipo = "Envio de Formulário";
                    break;
                case "1":
                    $tipo = "Resposta ao Lead";
                    break;
                case "2":
                    $tipo = "Aviso do Sistema";
                    break;
            }

            $assunto = $row['TXT_ASSUNTO'];

            $rows[] = [
                "id"            => $row['NU_ID'],
                "status"        => $status,
                "assunto"       => $assunto,
                "nomeremetente" => $row['TXT_NOME'],
                "remetente"     => $row['TXT_EMAIL'],
                "tipo"          => $tipo,
                "data"          => $row['DT_ADICAO'],
            ];
        }

        $sql       = "SELECT * FROM TBL_PROCESSO_EMAIL WHERE NU_ID = 1";
        $resultado = $this->bd->executar($sql, [], Banco_Dados::FETCH);
        $rotina    = $resultado['NU_EXECUTANDO'] == "1" ? "Executando" : "Parada";

        array_unshift($rows, [
            "pendentes" => $pendentes,
            "enviados"  => $enviados,
            "falhos"    => $falhos,
            "rotina"    => $rotina,
        ]);

        return $rows;
    }

    // Inicia o Banco de Dados de leads
    function iniciar_bd_leads()
    {
        $this->bd_leads = new Banco_Dados_Leads($this->modo_sandbox);
    }

    // Tenta enviar os email não enviados
    // Caso algum email falhe nesse processo novamente, ele é arquivado
    function enviar_emails_nao_enviados($data, $data_inicial, $data_final)
    {
        $filtro = Filtro::filtrar_data($data, "DT_ADICAO", $data_inicial, $data_final); // Montamos o filtro SQL de data
        if (empty($filtro)) {
            $sql = "UPDATE TBL_ENVIO_EMAIL SET NU_STATUS = 4 WHERE NU_STATUS = 2";
        } else {
            $sql = "UPDATE TBL_ENVIO_EMAIL SET NU_STATUS = 4 WHERE NU_STATUS = 2 AND " . $filtro;
        }
        $resultado = $this->bd->executar($sql, []);
    }

    // Marca o e-mail para reenvio
    function reenviar_email($id)
    {
        $sql       = "UPDATE TBL_ENVIO_EMAIL SET NU_STATUS = 4 WHERE NU_STATUS = 2 AND NU_ID = :id";
        $resultado = $this->bd->executar($sql, [":id" => $id]);
    }

    // Retorna uma array com emails
    static function email_adm($m = "")
    {
        $email   = [];
        $email[] = "desenvolvimento@grupolead.com.br";
        // $email[] = "desenvolvimento1@grupolead.com.br";
        if (!empty($m)) {
            $email[] = $m;
        }

        return $email;
    }

    /* Envia o email com assunto e mensagens especificadas para o destinatário com email e nome especificados */
    static function enviar_email($msg, $assunto, $destino, $nome)
    {
        if (is_array($destino)) {
            $destinatarios = [];
            foreach ($destino as $d) {
                $pre_email         = strstr($d, '@', true);
                $destinatarios[$d] = $pre_email;
            }
        } else {
            $pre_email     = strstr($destino, '@', true);
            $destinatarios = [
                $destino => $pre_email,
            ];
        }

        self::registrar_email(
            $msg,
            $assunto,
            $destinatarios,
            [],
            $nome,
            "nao-responda@win7.com.br",
            __FILE__,
            Sistema::TIPO_EMAIL_SISTEMA
        );
    }

    static function enviar_email_sistema($msg, $assunto, $destino, $nome)
    {
        $mensagem = '<html><head><style></style><title>' . $assunto . '</title></head><body><table align="center" width="700" style="padding: 50px 0px 50px 0px" cellpadding="25px"><tr valign="top" style="text-align: center; background-color: white;"><td style="padding-bottom:20px;"><a href="https://win7.com.br/"><img alt="Logo" style="display: block;" src="https://google.win7.com.br/img/logo.png"></a></td></tr><tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px;">' . $msg . '</td></tr></table></body></html>';

        self::enviar_email($mensagem, $assunto, $destino, $nome);
    }

    /* Envia um email no padrão do sistema de indicações */
    function enviar_email_indicacao_fechamento($msg, $assunto, $destino, $nome)
    {
        $mensagem = $this->mensagem_indicacao_fechamento($msg, $assunto, $destino, $nome);

        self::enviar_email($mensagem, $assunto, $destino, $nome);
    }

    /* Envia um email no padrão do sistema de indicações */
    function enviar_email_indicacao($msg, $assunto, $destino, $nome)
    {
        $mensagem = $this->mensagem_indicacao($msg, $assunto, $destino, $nome);

        self::enviar_email($mensagem, $assunto, $destino, $nome);
    }

    /* Função que monta a mensagem dos email do sistema de indicações */
    function mensagem_indicacao_fechamento($msg, $assunto, $destino, $nome)
    {
        $mensagem = '<html><head><style></style><title>' . $assunto . '</title></head><body><table align="center" width="700" style="center" width="700" style="padding: 20px 0px 20px 0px;border: 1px solid #e2e2e2;border-radius: 17px;box-shadow: 0px 6px 10px 3px #ececec;border-top: 3px solid #616161;border-bottom: 3px solid #616161;" cellpadding="15px"><tr valign="top" style="text-align: center; background-color: white;"><td style="padding-bottom:20px;"><a href="http://' . $this->indicacoes->dominio . '/"><img alt="Logo" style="display: block; margin: 0 auto;" src="' . $this->indicacoes->logo . '"></a></td></tr>' . $msg . '</table></body></html>';

        return $mensagem;
    }

    /* Função que monta a mensagem dos email do sistema de indicações */
    function mensagem_indicacao($msg, $assunto, $destino, $nome)
    {
        $mensagem = '<html><head><style></style><title>' . $assunto . '</title></head><body><table align="center" width="700" style="center" width="700" style="padding: 20px 0px 20px 0px;border: 1px solid #e2e2e2;border-radius: 17px;box-shadow: 0px 6px 10px 3px #ececec;border-top: 3px solid #616161;border-bottom: 3px solid #616161;" cellpadding="25px"><tr valign="top" style="text-align: center; background-color: white;"><td style="padding-bottom:20px;"><a href="http://' . $this->indicacoes->dominio . '/"><img alt="Logo" style="display: block; margin: 0 auto;" src="' . $this->indicacoes->logo . '"></a></td></tr><tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px; text-align: center;">' . $msg . '</td></tr></table></body></html>';

        return $mensagem;
    }

    /* Carrega as classes necessárias para utilizar a API do gerencianet */
    private function carregar_gerencianet()
    {
        require_once(__DIR__ . "/Sistema_Gerencianet.php");
        Sistema_Gerencianet::$sandbox = $this->modo_sandbox;
    }

    // Método que indica se o modo sandbox está ativo
    public function modo_sandbox()
    {
        return $this->modo_sandbox;
    }

    // Método que retorna o tipo do sistema
    public function tipo()
    {
        return $this->tipo;
    }

    // Redireciona para outra página e encerra o script
    function redirecionar($caminho)
    {
        header('Location: ' . $caminho);
        exit;
    }

    // Obtém todos os clientes através do banco de dados
    function obter_clientes()
    {
        return $this->bd->executar("SELECT * FROM TBL_CLIENTE", [], Banco_Dados::FETCH_ALL);
    }

    // Obtém o cliente especificado através do banco de dados
    function obter_cliente($id)
    {
        return $this->bd->executar(
            "SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id",
            [":id" => $id],
            Banco_Dados::FETCH
        );
    }

    // Obtém todos os seguimentos através do banco de dados
    function obter_seguimentos()
    {
        return $this->bd->executar(
            "SELECT * FROM TBL_SEGUIMENTOS ORDER BY TXT_SEGUIMENTO ASC",
            [],
            Banco_Dados::FETCH_ALL
        );
    }

    /**
     * Retorna as configurações de filtragem de campanha do usuário logado.
     *
     * @return \Win7\Ads\Entity\CustomerFilter
     * @throws \Exception
     */
    public function get_filtro_ads(): CustomerFilter
    {
        $filter = new CustomerFilter();
        $filter->setCustomerId($this->usuario->id_adwords);
        $filter->setMinimumDate($this->usuario->data_inicio_ads);
        $filter->setShowOnlySearch(!isset($_POST['display']) || $_POST['display'] != 's');
        $filter->setDateFilter($_POST['data'] ?? '');
        $filter->setStartDate($_POST['datainicial'] ?? '');
        $filter->setEndDate($_POST['datafinal'] ?? '');
        $filter->setCampaignMode($this->usuario->mostrar_somente_campanhas);
        $filter->setCampaignIds($this->usuario->campanhas_visiveis);
        $filter->setCampaignPauseAllowed($this->usuario->permissao_pausar_campanhas);

        return $filter;
    }
}

function set_sistema($sys)
{
    global $tipo_sistema;
    if (!isset($tipo_sistema)) {
        $tipo_sistema = $sys;
    }
}

function json_encode_alt($a = false)
{
    if (is_null($a)) {
        return 'null';
    }
    if ($a === false) {
        return 'false';
    }
    if ($a === true) {
        return 'true';
    }

    if (is_scalar($a)) {
        if (is_float($a)) {
            return floatval(str_replace(",", ".", strval($a)));
        }
        if (is_string($a)) {
            static $jsonReplaces = [
                ["\\", "/", "\n", "\t", "\r", "\b", "\f", '"'],
                ['\\\\', '\\/', '\\n', '\\t', '\\r', '\\b', '\\f', '\"'],
            ];

            return '"' . str_replace($jsonReplaces[0], $jsonReplaces[1], $a) . '"';
        } else {
            return $a;
        }
    }

    $isList = true;
    for ($i = 0, reset($a); $i < count($a); $i++, next($a)) {
        if (key($a) !== $i) {
            $isList = false;
            break;
        }
    }
    $result = [];
    if ($isList) {
        foreach ($a as $v) {
            $result[] = json_encode_alt($v);
        }

        return '[' . join(',', $result) . ']';
    } else {
        foreach ($a as $k => $v) {
            $result[] = json_encode_alt($k) . ':' . json_encode_alt($v);
        }

        return '{' . join(',', $result) . '}';
    }
}
