<?php
/***
	Esta classe é responsável por guardar e manipular os dados do
	sistema do google drive.
***/

class Sistema_Google_Drive{
	private $sistema;

	function __construct($sistema){
		$this->sistema = $sistema;
		if($sistema->tipo == Sistema::GOOGLE_DRIVE){
			try{
				$dominio = $_SERVER['SERVER_NAME'];
				$dados = $this->sistema->bd->executar("SELECT * FROM TBL_CLI_GDRIVE WHERE TXT_HOST = :dominio AND NU_ATIVADO = '1'", array(':dominio' => $dominio), Banco_Dados::FETCH);
				if($this->sistema->bd->quantidade() == 1){
					$this->id = $dados['ID_FK'];
					$this->sessao = $dados['TXT_SESSION'];
					$this->dominio = $dominio;
					$this->cor1 = $dados['TXT_COR1'];
					$this->cor2 = $dados['TXT_COR2'];
					$this->cor3 = $dados['TXT_COR3'];
					$this->cor4 = $dados['TXT_COR4'];
					$this->cor5 = $dados['TXT_COR5'];
					$this->nome = $dados['TXT_NOME'];
					$this->nome_sistema = $dados['TTXT_NOME_SISTEMA'];
					$this->email = $dados['TXT_EMAIL'];
					$this->favicon = $dados['TXT_FAVICON'];
					$this->logo = $dados['TXT_LOGO'];
					$this->telefone = $dados['TXT_TELEFONE'];
					$this->contato = $dados['TXT_CONTATO'];

					$dados = $this->sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->id), Banco_Dados::FETCH);
					$this->ramo = $dados['TXT_RAMO'];
					$this->cliente = $dados['TXT_LOGIN'];
				}
				else{
					header("HTTP/1.0 404 Not Found");
					exit;
				}
			}
			catch(Exception $e){
				header("HTTP/1.0 404 Not Found");
				exit;
			}
		}
		
	}

	/* Obtém os usuários do sistema do drive que se registraram no período especificado */
	public function obter_usuarios($data, $inicio, $fim){
		$filtro = Filtro::filtrar_data($data,"DT_CRIACAO" ,$inicio, $fim); // Montamos o filtro SQL de data 

		// Obtém os usuários
		$sql = empty($filtro) ?
		"SELECT * FROM TBL_GDRIVE_USUARIOS WHERE ID_FK = :ID" :
		"SELECT * FROM TBL_GDRIVE_USUARIOS WHERE ".$filtro." AND ID_FK = :ID";
		$dados = $this->sistema->bd->executar($sql, array(":ID" => $this->sistema->usuario->id), Banco_Dados::FETCH_ALL);
		
		/* Organiza todos os dados para enviar por json. */
		$rows = array();
		foreach($dados as $row){
			$rows[] = array(
				'id' => $row['NU_ID'],
				'nome' => $row['TXT_NOME'],
				'data2' => $row['DT_CRIACAO'],
				'data' => $row['DT_ULTIMO_LOGIN'],
				'login' => $row['TXT_LOGIN'],
				'link' => $row['TXT_LINK']
			);
		}

		return $rows;
	}

	/* Obtém o usuário que possui a ID especificada */
	public function obter_usuario($id){
		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_GDRIVE_USUARIOS WHERE NU_ID = :id AND ID_FK = :id2", array(":id" => $id, ":id2" => $this->sistema->usuario->id), Banco_Dados::FETCH);
		if($this->sistema->bd->quantidade() == 0)
			return -1;

		return array(
			'id' => $id,
			"nome" => $dados['TXT_NOME'],
			"link" => $dados['TXT_LINK'],
			"login" => $dados['TXT_LOGIN'],
			'data2' => $dados['DT_CRIACAO'],
			'data' => $dados['DT_ULTIMO_LOGIN']
		);
	}

	/* Salva os dados do usuário no banco, e retorna um json com os novos dados */
	public function salvar_usuario($id, $nome, $login, $link, $senha){
		$timestamp = time();
		date_default_timezone_set('America/Sao_Paulo');
		$data_alteracao = date('Y-m-d H:i:s', $timestamp);
		
		// Agora, cria-se o novo contato no banco
		$this->sistema->bd->executar("SELECT * FROM TBL_GDRIVE_USUARIOS WHERE TXT_LOGIN = :id AND ID_FK = :id2 AND NU_ID <> :id3", array(
			':id' => $login,
			':id2' => $this->sistema->usuario->id,
			':id3' => $id
		));

		if($this->sistema->bd->quantidade() > 0){
			return -1;
		}
		
		if(empty($senha)){
			$this->sistema->bd->executar('UPDATE TBL_GDRIVE_USUARIOS SET TXT_NOME = :nome, TXT_LINK = :link, TXT_LOGIN = :login WHERE NU_ID = :id2 AND ID_FK = :id', array(
				":nome" => $nome,
				":link" => $link,
				":login" => $login,
				":id2" => $id,
				":id" => $this->sistema->usuario->id
			));
		}
		else{
			$this->sistema->bd->executar('UPDATE TBL_GDRIVE_USUARIOS SET TXT_NOME = :nome, TXT_LINK = :link, TXT_LOGIN = :login, TXT_SENHA = :senha WHERE NU_ID = :id2 AND ID_FK = :id', array(
				":nome" => $nome,
				":link" => $link,
				":login" => $login,
				":senha" => Utilitarios::hash_str($senha),
				":id2" => $id,
				":id" => $this->sistema->usuario->id
			));
		}

		return array(
			"id" => $id,
			"link" => $link,
			"login" => $login,
			"nome" => $nome
		);
	}

	/* Cria um novo usuário, e retorna um json com os novos dados */
	public function criar_usuario($nome, $login, $link, $senha){
		$timestamp = time();
		date_default_timezone_set('America/Sao_Paulo');
		$data_alteracao = date('Y-m-d H:i:s', $timestamp);
		
		// Agora, cria-se o novo contato no banco
		$this->sistema->bd->executar("SELECT * FROM TBL_GDRIVE_USUARIOS WHERE TXT_LOGIN = :id AND ID_FK = :id2", array(
			':id' => $login,
			':id2' => $this->sistema->usuario->id
		));

		if($this->sistema->bd->quantidade() > 0){
			return -2;
		}
		
		$this->sistema->bd->executar('INSERT INTO TBL_GDRIVE_USUARIOS (TXT_NOME, TXT_LINK, TXT_LOGIN, TXT_SENHA, DT_ULTIMO_LOGIN, ID_FK) VALUES (:nome, :link, :login, :senha, :ultimologin, :id)', array(
			":nome" => $nome,
			":link" => $link,
			":login" => $login,
			":senha" => Utilitarios::hash_str($senha),
			":ultimologin" => $data_alteracao,
			":id" => $this->sistema->usuario->id
		));

		$id = $this->sistema->bd->ultima_id();

		return array($this->obter_usuario($id));
	}

	/* Deleta o usuário que possui a ID especificada */
	public function deletar_usuario($id){
		$this->sistema->bd->executar('DELETE FROM TBL_GDRIVE_USUARIOS WHERE NU_ID = :id AND ID_FK = :id2', array(
			":id" => $id,
			":id2" => $this->sistema->usuario->id
		));
	}
}
?>