<?php
/***
	Esta classe é responsável por guardar e manipular os dados do
	sistema de indicações.
***/

class Sistema_Indicacoes{
	private $sistema;
	public $tipo;
	public $comissoes;
	public $niveis;
	public $vocabulario;
	public $dominio;
	public $sessao;
	public $cor1;
	public $cor2;
	public $cor3;
	public $cor4;
	public $cor5;
	public $nome;
	public $email;
	public $favicon;
	public $logo;
	public $telefone;
	public $contato;
	public $comissao_fixa;
	public $distribuir_comissoes;

	const NORMAL = 0;
	const FACULDADES = 1;

	function __construct($sistema){
		$this->sistema = $sistema;
		if($sistema->tipo == Sistema::INDICACOES){
			try{
				$dominio = $_SERVER['SERVER_NAME'];
				$dados = $this->sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE TXT_HOST = :dominio AND NU_ATIVADO = '1'", array(':dominio' => $dominio), Banco_Dados::FETCH);
				if($this->sistema->bd->quantidade() == 1){
					$this->id = $dados['ID_FK'];
					$this->sessao = $dados['TXT_SESSION'];
					$this->dominio = $dominio;
					$this->cor1 = $dados['TXT_COR1'];
					$this->cor2 = $dados['TXT_COR2'];
					$this->cor3 = $dados['TXT_COR3'];
					$this->cor4 = $dados['TXT_COR4'];
					$this->cor5 = $dados['TXT_COR5'];
					$this->nome = $dados['TXT_NOME'];
					$this->email = $dados['TXT_EMAIL'];
					$this->favicon = $dados['TXT_FAVICON'];
					$this->link_site_menu = $dados['TXT_LINK_SITE_MENU'];
					$this->link_site_menu_label = $dados['TXT_LABEL_SITE_MENU'];
					$this->logo = $dados['TXT_LOGO'];
					$this->telefone = $dados['TXT_TELEFONE'];
					$this->contato = $dados['TXT_CONTATO'];
					$this->tipo = $dados['TXT_TIPO_SISTEMA_INDICACAO'];
					$this->adicionar_contato = $dados['NU_ADICIONAR_CONTATO'];
					$this->ativar_termos = $dados['NU_ATIVAR_TERMOS'];
					$this->termos = $dados['TXT_LINK_TERMOS'];
					$this->proibir_cpf = $dados['NU_PROIBIR_CPF'];
					$this->comissao = $dados['TXT_BONUS'];
					$this->ativar_termos = $dados['NU_ATIVAR_TERMOS'];
					$this->downlines = $dados['NU_DOWNLINES'];
					$this->upline = $dados['NU_UPLINE'];
					$this->simbolo_dinheiro = $dados['TXT_DINHEIRO_SIMBOLO'];
					$this->mascara_dinheiro = $dados['TXT_DINHEIRO_MASCARA'];
					$this->text_cpf_cnpj_alternativo = $dados['TXT_CPFCNPJ_ALTERNATIVO'];
					$this->numero_whatsapp_contato_rodape = $dados['NU_WHATSAPP_RODAPE'];
					$this->permissao_cnpj_indicado = $dados['NU_PERM_CNPJ_INDICADO'];
					$this->permissao_cnpj_indicador = $dados['NU_PERM_CNPJ_INDICADOR'];
					$this->permissao_transferencias = $dados['NU_PERM_TRANSFERENCIAS'];
					$this->imagem_social = $dados['TXT_IMAGEM_SOCIAL'];
					$this->permissao_inscricoes = $dados['NU_PERMITIR_INSCRICOES'];
					$this->comissao_fixa = $dados['NU_COMISSAO_FIXA'];
					$this->usa_pontos = $dados['NU_FLAG_PONTOS'];
					$this->ajuste = floatval($dados['TXT_AJUSTE']);
					$this->comissao_multipla = $dados['NU_COMISSAO_MULTIPLA'];
					$this->comissao_agencia = $dados['NU_COMISSAO_AGENCIA'];
					$this->ativar_recorrencia = $dados['NU_PERM_RECORRENCIA'];
					$this->cadastro_indicado = $dados['NU_PERM_CADASTRO_INDICADO'];

					$this->comissao_fidelidade = $dados['NU_COMISSAO_FIDELIDADE'];
					$this->comissao_fidelidade = preg_replace('/\s+/', '', $this->comissao_fidelidade);
					$this->comissao_fidelidade = floatval($this->comissao_fidelidade);

					$this->comissao_cadastro = $dados['NU_COMISSAO_CADASTRO'];
					$this->comissao_cadastro = preg_replace('/\s+/', '', $this->comissao_cadastro);
					$this->comissao_cadastro = floatval($this->comissao_cadastro);

					$exploded = explode(",", $dados['TXT_BONUS']);
					$comissoes = array();
					foreach($exploded as $comissao){
						$comissao = preg_replace('/\s+/', '', $comissao);
						$comissoes[] = floatval($comissao);
					}
					$this->comissoes = $comissoes;

					$dados = $this->sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->id), Banco_Dados::FETCH);
					$this->ramo = $dados['TXT_RAMO'];
					$this->cliente = $dados['TXT_LOGIN'];

					// Obtêm-se os dados de vocabulário
					$dados_vocab = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_VOCAB WHERE ID_CLIENTE = :idcliente", array(
						":idcliente" => $this->id
					), Banco_Dados::FETCH_ALL);
					$vocab = array();
					foreach($dados_vocab as $row){
						$vocab[intval($row['NU_ORDEM'])] = $row['TXT_CONTEUDO'];
					}
					$this->vocabulario = $vocab;
				}
				else{
					header("HTTP/1.0 404 Not Found");
					exit;
				}
			}
			catch(Exception $e){
				header("HTTP/1.0 404 Not Found");
				exit;
			}
		}
		else{
			$this->tipo = intval($sistema->usuario->tipo_indicacoes);

			$exploded = explode(",", $sistema->usuario->comissao);
			$comissoes = array();
			foreach($exploded as $comissao){
				$comissao = preg_replace('/\s+/', '', $comissao);
				$comissoes[] = floatval($comissao);
			}
			$this->comissoes = $comissoes;

			$niveis = array(); // Array que guarda os níveis de comissão, exceto o primeiro
			for($count = 1;$count < count($comissoes);$count++){
				$niveis[] = $comissoes[$count];
			}
			$this->niveis = $niveis;

			$this->comissao_fixa = $sistema->usuario->comissao_fixa;
			$this->distribuir_comissoes = $sistema->usuario->distribuir_comissoes;
			$this->id = $this->sistema->usuario->id;

			// Obtêm-se os dados de vocabulário
			$dados_vocab = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_VOCAB WHERE ID_CLIENTE = :idcliente", array(
				":idcliente" => $this->id
			), Banco_Dados::FETCH_ALL);
			$vocab = array();
			foreach($dados_vocab as $row){
				$vocab[intval($row['NU_ORDEM'])] = $row['TXT_CONTEUDO'];
			}
			$this->vocabulario = $vocab;

			$this->dominio = $sistema->usuario->dados_indicacoes['TXT_HOST'];
			$this->sessao = $sistema->usuario->dados_indicacoes['TXT_SESSION'];
			$this->cor1 = $sistema->usuario->dados_indicacoes['TXT_COR1'];
			$this->cor2 = $sistema->usuario->dados_indicacoes['TXT_COR2'];
			$this->nome = $sistema->usuario->dados_indicacoes['TXT_NOME'];
			$this->email = $sistema->usuario->dados_indicacoes['TXT_EMAIL'];
			$this->favicon = $sistema->usuario->dados_indicacoes['TXT_FAVICON'];
			$this->logo = $sistema->usuario->dados_indicacoes['TXT_LOGO'];
			$this->telefone = $sistema->usuario->dados_indicacoes['TXT_TELEFONE'];
			$this->contato = $sistema->usuario->dados_indicacoes['TXT_CONTATO'];
			$this->usa_pontos = $sistema->usuario->dados_indicacoes['NU_FLAG_PONTOS'];
			$this->ajuste = floatval($sistema->usuario->dados_indicacoes['TXT_AJUSTE']);
			$this->comissao_multipla = $sistema->usuario->dados_indicacoes['NU_COMISSAO_MULTIPLA'];
			$this->comissao_agencia = $sistema->usuario->dados_indicacoes['NU_COMISSAO_AGENCIA'];
			$this->ativar_recorrencia = $sistema->usuario->dados_indicacoes['NU_PERM_RECORRENCIA'];
			$this->cadastro_indicado = $sistema->usuario->dados_indicacoes['NU_PERM_CADASTRO_INDICADO'];

			$this->comissao_fidelidade = $sistema->usuario->dados_indicacoes['NU_COMISSAO_FIDELIDADE'];
			$this->comissao_fidelidade = preg_replace('/\s+/', '', $this->comissao_fidelidade);
			$this->comissao_fidelidade = floatval($this->comissao_fidelidade);

			$this->comissao_cadastro = $sistema->usuario->dados_indicacoes['NU_COMISSAO_CADASTRO'];
			$this->comissao_cadastro = preg_replace('/\s+/', '', $this->comissao_cadastro);
			$this->comissao_cadastro = floatval($this->comissao_cadastro);
			
			$this->simbolo_dinheiro = $sistema->usuario->dados_indicacoes['TXT_DINHEIRO_SIMBOLO'];
			$this->mascara_dinheiro = $sistema->usuario->dados_indicacoes['TXT_DINHEIRO_MASCARA'];
			$this->text_cpf_cnpj_alternativo = $sistema->usuario->dados_indicacoes['TXT_CPFCNPJ_ALTERNATIVO'];

		}
	}

	static function zerar_sistema($bd, $id){
		$params = array(":id" => $id);
		$bd->executar("DELETE FROM TBL_INDICACOES_GANHOS WHERE ID_CLIENTE = :id", $params);
		$bd->executar("DELETE FROM TBL_INDICACOES_HIST WHERE NU_CLIENTE = :id", $params);
		$bd->executar("UPDATE TBL_INDICACOES SET TXT_SALDO = 0, TXT_STATUS = 'Novo', VALOR_FECHADO = 0, VALOR_COMBINADO = 0, TXT_ANOTACOES = '', ID_COMISSAO = -1, NU_JA_FECHOU = 0 WHERE NU_CLIENTE = :id", $params);
		$bd->executar("DELETE FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :id", $params);
		$bd->executar("DELETE FROM TBL_INDICACOES_COMISSOES_UNICAS WHERE ID_CLIENTE = :id", $params);
		$bd->executar("UPDATE TBL_CLI_DADOS SET TXT_SALDO_AGENCIA = 0 WHERE ID_FK = :id", $params);
	}

	static function resetar_sistema($bd, $id){
		$params = array(":id" => $id);
		$bd->executar("DELETE FROM TBL_INDICACOES_GANHOS WHERE ID_CLIENTE = :id", $params);
		$bd->executar("DELETE FROM TBL_INDICACOES_HIST WHERE NU_CLIENTE = :id", $params);
		$bd->executar("DELETE FROM TBL_INDICACOES WHERE NU_CLIENTE = :id", $params);
		$bd->executar("DELETE FROM TBL_INDICACOES_PRODUTOS WHERE ID_CLIENTE_FK = :id", $params);
		$bd->executar("DELETE FROM TBL_INDICACOES_COMISSOES_UNICAS WHERE ID_CLIENTE = :id", $params);
		$bd->executar("DELETE FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :id", $params);
		$bd->executar("UPDATE TBL_CLI_DADOS SET TXT_SALDO_AGENCIA = 0 WHERE ID_FK = :id", $params);
	}

	/* Cria o select de comissões */
	function produto_editavel($usuario){
		if(!is_array($usuario)){
			$usuario = $this->obter_usuario($usuario);
		}

		if($this->comissao_multipla == "0"){
			return false;
		}

		return ($usuario['NU_JA_FECHOU'] == "0");
	}

	function obter_quantidade_fechamentos($id){
		$dados = $this->sistema->bd->executar("SELECT (SELECT count(*) FROM TBL_INDICACOES_COMISSOES_UNICAS WHERE ID_INDICADOR = :id) as QTD_FECHAMENTOS", array(
			':id' => $id
		), Banco_Dados::FETCH);

		return intval($dados['QTD_FECHAMENTOS']);
	}

	function obter_fechamento($id, $id_indicado){
		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_COMISSOES_UNICAS WHERE NU_ID = :id AND ID_INDICADOR = :indicador", array(
			':id' => $id,
			':indicador' => $id_indicado
		), Banco_Dados::FETCH);

		return $dados;
	}

	function obter_fechamentos($id){
		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_COMISSOES_UNICAS WHERE ID_INDICADOR = :id", array(
			':id' => $id
		), Banco_Dados::FETCH_ALL);

		$resultado = array();
		foreach ($dados as $row) {
			if($row['ID_COMISSAO'] == "-1"){
				$comissao = "Padrão";
			}
			else{
				$comissao = $this->obter_comissao($row['ID_COMISSAO']);
				$comissao = $comissao['TXT_NOME'];
			}

			if ($this->mascara_dinheiro === 'eua') {
				$valorfechado_formatado = Mascara::converter_para_dolar($row['NU_VALOR_FECHADO']);
			} else {
				$valorfechado_formatado = Mascara::converter_para_real($row['NU_VALOR_FECHADO']);
			}

			$resultado[] = array(
				"id" => $row['NU_ID'],
				"descricao" => $row['TXT_DESCRICAO'],
				"produto" => $comissao,
				"data" => $row['DT_REGISTRO'],
				"valorfechado" => $valorfechado_formatado
			);
		}

		return $resultado;
	}

	/* Obtém uma comissão ativa */
	function obter_comissao_valida($id){
		return $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_COMISSOES WHERE ID_CLIENTE_FK = :id AND NU_DELETADO = 0 AND NU_ID = :id2", array(
			':id' => $this->id,
			':id2' => $id
		), Banco_Dados::FETCH);
	}

	/* Obtém uma comissão ativa */
	function obter_comissao($id){
		return $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_COMISSOES WHERE ID_CLIENTE_FK = :id AND NU_ID = :id2", array(
			':id' => $this->id,
			':id2' => $id
		), Banco_Dados::FETCH);
	}

	/* Cria o select de comissões */
	function select_comissoes($selected){
		$produtos = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_COMISSOES WHERE ID_CLIENTE_FK = :id AND NU_DELETADO = 0", array(
			':id' => $this->id
		), Banco_Dados::FETCH_ALL);

		if($selected == "-1"){
			$selecionado = array();
			$produto_selecionado = false;
		}
		else{
			$selecionado = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_COMISSOES WHERE ID_CLIENTE_FK = :id AND NU_ID = :id2", array(
				':id' => $this->id,
				':id2' => $selected
			), Banco_Dados::FETCH);

			$produto_selecionado = $this->sistema->bd->quantidade() > 0;
		}
		$encontrado = false;
		$select = "";

		foreach($produtos as $produto){
			$sel = "";
			if($produto['NU_ID'] == $selected){
				$encontrado = true;
				$sel = "selected";
			}
			$select .= '<option value="'.$produto['NU_ID'].'" '.$sel.' >'.$produto['TXT_NOME'].'</option>';
		}

		if($this->comissao_multipla == "1"){
			if($encontrado == false && $produto_selecionado == true){
				$select .= '<option value="'.$selected.'" selected >'.$selecionado['TXT_NOME'].'</option>';
			}
		}
		else if($produto_selecionado == true){
			$select = '<option value="'.$selected.'" selected >'.$selecionado['TXT_NOME'].'</option>';
		}
		else{
			$select = '<option value="-1" selected>Padrão</option>';
		}

		return $select;
	}

	/* Obtém o histórico de ganhos de todos os indicadores */
	function obter_historico_total($data, $data_inicial, $data_final){
		$filtro = Filtro::filtrar_data($data, "DT_TRANSACAO", $data_inicial, $data_final);
		$sql = empty($filtro) ? "SELECT * FROM TBL_INDICACOES_GANHOS WHERE ID_CLIENTE = :id" :
		"SELECT * FROM TBL_INDICACOES_GANHOS WHERE ".$filtro." AND ID_CLIENTE = :id";
		$resultado = $this->sistema->bd->executar($sql, array(
			":id" => $this->sistema->usuario->id
		), Banco_Dados::FETCH_ALL);

		if($this->sistema->bd->quantidade() > 750){
			return -1;
		}

		$rows = array();
		$rows[] = "";

		foreach($resultado as $row){
			$indicador = $this->obter_usuario($row['NU_ID_FK']);
			$cpf_original = $indicador['NU_CPF'];
			$nome = $indicador['TXT_NOME'];
			$indicado = $this->obter_usuario($row['NU_ID_INDICADO_FK']);
			$cpf_e = Mascara::mascara_cpf_cnpj($row['NU_CPF']) ;

			if ($this->mascara_dinheiro === 'eua') {
				$valor_fechado = Mascara::converter_para_dolar($row['TXT_VALOR_FECHADO']);
			} else {
				$valor_fechado = Mascara::converter_para_real($row['TXT_VALOR_FECHADO']);
			}

			$this->sistema->bd->executar("SELECT NU_CPF FROM TBL_INDICACOES WHERE NU_CPF_IND = '".$indicado['NU_CPF']."' AND NU_CLIENTE = '".$this->id."'");
			if($this->sistema->bd->quantidade() > 0)
				$sub = "1";
			else
				$sub = "0";

			if($this->tipo == Sistema_Indicacoes::FACULDADES){
				$pesquisa = $indicado['TXT_NOME'] . " " . $indicado['NU_CPF'] . " " . $cpf_e . " " . $indicado['TXT_UNIDADE'] . " " . $indicado['TXT_CIDADE'] . " " . $indicado['TXT_BAIRRO'] . " " . $indicado['TXT_CURSO']. " " . $indicado['TXT_EMAIL'] . " " . $indicado['TEL_CEL'];
				if($row["NU_TIPO"] == "1"){
					$tipo_captador = $this->funcionario_faculdade();
					$tipo_captador = $tipo_captador[intval($indicado['NU_TIPO_FUNC'])];
					$pesquisa .= " " . $tipo_captador;
				}
			}
			else{
				$pesquisa = $indicado['TXT_NOME'] . " " . $indicado['NU_CPF'] . " " . $cpf_e . " " . $indicado['TXT_EMAIL'] . " " . $indicado['TEL_CEL'];
			}

			$tipo = $indicado['NU_TIPO'] == '0' ? "Indicado" : "Indicador";

			$rows[] = array(
				'id' => $row['NU_ID_INDICADO_FK'],
				'nome' => $row['TXT_NOME'],
				'cpf' => $cpf_e,
				'valorfechado' => $valor_fechado,
				'comissao' => $row['TXT_VALOR'],
				'porcentagem' => $row['TXT_PORCENTAGEM'],
				'sub' => $sub,
				'pesquisa' => $pesquisa,
				'tipo' => $tipo,
				'data' => $row['DT_TRANSACAO'],
				'motivo' => $row['TXT_TIPO'],
				'nome-beneficiado' => $nome,
				'dataregistro' => $indicado['DT_PREENCHIMENTO'],
				'telefone' => $indicado['TEL_CEL'],
				'email' => $indicado['TXT_EMAIL']
			);
		}

		return $rows;
	}

	/* Obtêm a lista de prêmios */
	function obter_lista_premios(){
		$resultado = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE ID_CLIENTE_FK = :id AND NU_DELETADO = 0", array(
			':id' => $this->id
		), Banco_Dados::FETCH_ALL);

		$rows = array();
		foreach ($resultado as $row) {
			$rows[] = array(
				'nome' => $row['TXT_NOME'],
				'id' => $row['NU_ID'],
				'estoque' => $row['NU_ESTOQUE_INFINITO'] == "1" ? "--" : $row['NU_ESTOQUE'],
				'pontos' => $row['NU_PONTOS'],
				'data' => $row['DT_CRIACAO'],
				'imagem' => $row['TXT_NOME'],
				'link' => "https://" . $this->dominio . "/arquivos/". $row['TXT_IMAGEM'],
				'trocas' => $row['NU_TROCAS']
			);
		}

		return $rows;
	}

	function obter_premio($id){
		$row = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE ID_CLIENTE_FK = :id AND NU_ID = :id2", array(
			':id' => $this->id,
			':id2' => $id
		), Banco_Dados::FETCH);

		$premio = array(
			'nome' => $row['TXT_NOME'],
			'id' => $row['NU_ID'],
			'estoque' => $row['NU_ESTOQUE_INFINITO'] == "1" ? "--" : $row['NU_ESTOQUE'],
			'pontos' => $row['NU_PONTOS'],
			'data' => $row['DT_CRIACAO'],
			'imagem' => $row['TXT_IMAGEM'],
			'link' => "https://" . $this->dominio . "/arquivos/". $row['TXT_IMAGEM'],
			'trocas' => $row['NU_TROCAS'],
			'resgatenormal' => $row['NU_RESGATE_NORMAL']
		);

		return $premio;
	}

	/* Obtém o histórico de ganhos do indicador */
	function obter_historico($id, $data, $data_inicial, $data_final){
		$resultado = $this->obter_indicador($id);
		if($this->sistema->bd->quantidade() == 0){
			return -1;
		}
		$nome_arquivo = $resultado['TXT_NOME'];

		$filtro = Filtro::filtrar_data($data, "DT_TRANSACAO", $data_inicial, $data_final);
		$sql = empty($filtro) ? "SELECT * FROM TBL_INDICACOES_GANHOS WHERE ID_CLIENTE = :id AND NU_ID_FK = :id2" :
		"SELECT * FROM TBL_INDICACOES_GANHOS WHERE ".$filtro." AND ID_CLIENTE = :id AND NU_ID_FK = :id2";
		$resultado = $this->sistema->bd->executar($sql, array(
			":id" => $this->id,
			":id2" => $id
		), Banco_Dados::FETCH_ALL);

		$rows = array();
		$rows[] = $nome_arquivo;

		foreach($resultado as $row){
			$indicador = $this->obter_usuario($row['NU_ID_FK']);
			$cpf_original = $indicador['NU_CPF'];
			$nome = $indicador['TXT_NOME'];
			$indicado = $this->obter_usuario($row['NU_ID_INDICADO_FK']);
			$cpf_e = Mascara::mascara_cpf_cnpj($row['NU_CPF']) ;

			
			$valor_fechado = $this->mascara_dinheiro === 'eua'
				? Mascara::converter_para_dolar($row['TXT_VALOR_FECHADO'])
				: Mascara::converter_para_real($row['TXT_VALOR_FECHADO']);


			$this->sistema->bd->executar("SELECT NU_CPF FROM TBL_INDICACOES WHERE NU_CPF_IND = '".$indicado['NU_CPF']."' AND NU_CLIENTE = '".$this->id."'");
			if($this->sistema->bd->quantidade() > 0)
				$sub = "1";
			else
				$sub = "0";

			if($this->tipo == Sistema_Indicacoes::FACULDADES){
				$pesquisa = $indicado['TXT_NOME'] . " " . $indicado['NU_CPF'] . " " . $cpf_e . " " . $indicado['TXT_UNIDADE'] . " " . $indicado['TXT_CIDADE'] . " " . $indicado['TXT_BAIRRO'] . " " . $indicado['TXT_CURSO']. " " . $indicado['TXT_EMAIL'] . " " . $indicado['TEL_CEL'];
				if($row["NU_TIPO"] == "1"){
					$tipo_captador = $this->funcionario_faculdade();
					$tipo_captador = $tipo_captador[intval($indicado['NU_TIPO_FUNC'])];
					$pesquisa .= " " . $tipo_captador;
				}
			}
			else{
				$pesquisa = $indicado['TXT_NOME'] . " " . $indicado['NU_CPF'] . " " . $cpf_e . " " . $indicado['TXT_EMAIL'] . " " . $indicado['TEL_CEL'];
			}

			$tipo = $indicado['NU_TIPO'] == '0' ? "Indicado" : "Indicador";

			$rows[] = array(
				'id' => $row['NU_ID_INDICADO_FK'],
				'nome' => $row['TXT_NOME'],
				'cpf' => $cpf_e,
				'valorfechado' => $valor_fechado,
				'comissao' => $row['TXT_VALOR'],
				'porcentagem' => $row['TXT_PORCENTAGEM'],
				'sub' => $sub,
				'pesquisa' => $pesquisa,
				'tipo' => $tipo,
				'data' => $row['DT_TRANSACAO'],
				'motivo' => $row['TXT_TIPO'],
				'nome-beneficiado' => $nome,
				'dataregistro' => $indicado['DT_PREENCHIMENTO'],
				'telefone' => $indicado['TEL_CEL'],
				'email' => $indicado['TXT_EMAIL']
			);
		}

		return $rows;
	}

	/* Método que retorna uma lista de todos os indicados de determinado indicador
	   Caso a ID seja -1, retorna a lista de todos os indicados */
	function obter_lista_indicacoes($id, $filtro_data, $data_inicial, $data_final){
		$filtro =  Filtro::filtrar_data($filtro_data, "TBL_INDICACOES.DT_PREENCHIMENTO", $data_inicial, $data_final);

		if($id != "-1"){ // Caso a pesquisa seja de um indicador específico...

			// Seleciona os dados do indicador no banco
			$resultado = $this->obter_indicador($id);

			// Se não foi encontrado o indicador, a ID é inválida
			if($this->sistema->bd->quantidade() == 0){
				echo "-2ID inválida!";
				exit;
			}

			$cpf_original = $resultado['NU_CPF'];
			$nome = $resultado['TXT_NOME'];

			// Seleciona todos os indicados do indicador desejado
			$sql = empty($filtro) ?
				"SELECT TBL_INDICACOES.*, COUNT(DISTINCT TBL_INDICACOES_COMISSOES_UNICAS.NU_ID) as NU_FECHAMENTOS FROM TBL_INDICACOES LEFT JOIN TBL_INDICACOES_COMISSOES_UNICAS ON TBL_INDICACOES_COMISSOES_UNICAS.ID_INDICADOR = TBL_INDICACOES.NU_ID WHERE TBL_INDICACOES.NU_CLIENTE = :idcliente AND TBL_INDICACOES.NU_CPF_IND = :cpf GROUP BY 1 ORDER BY TBL_INDICACOES.NU_ID" :
				"SELECT TBL_INDICACOES.*, COUNT(DISTINCT TBL_INDICACOES_COMISSOES_UNICAS.NU_ID) as NU_FECHAMENTOS FROM TBL_INDICACOES LEFT JOIN TBL_INDICACOES_COMISSOES_UNICAS ON TBL_INDICACOES_COMISSOES_UNICAS.ID_INDICADOR = TBL_INDICACOES.NU_ID WHERE ".$filtro." AND TBL_INDICACOES.NU_CLIENTE = :idcliente AND TBL_INDICACOES.NU_CPF_IND = :cpf GROUP BY 1 ORDER BY TBL_INDICACOES.NU_ID";
			$dados = $this->sistema->bd->executar($sql, array(
				":idcliente" => $this->id, ':cpf' => $cpf_original
			), Banco_Dados::FETCH_ALL);

			return array("Indicados de ".$nome, $dados);
		}
		else{ // A pesquisa é de todos os usuários

			// Seleciona todos os usuários do sistema
			$sql = empty($filtro) ?
				"SELECT TBL_INDICACOES.*, COUNT(DISTINCT TBL_INDICACOES_COMISSOES_UNICAS.NU_ID) as NU_FECHAMENTOS FROM TBL_INDICACOES LEFT JOIN TBL_INDICACOES_COMISSOES_UNICAS ON TBL_INDICACOES_COMISSOES_UNICAS.ID_INDICADOR = TBL_INDICACOES.NU_ID WHERE TBL_INDICACOES.NU_CLIENTE = :idcliente GROUP BY 1 ORDER BY TBL_INDICACOES.NU_ID" :
				"SELECT TBL_INDICACOES.*, COUNT(DISTINCT TBL_INDICACOES_COMISSOES_UNICAS.NU_ID) as NU_FECHAMENTOS FROM TBL_INDICACOES LEFT JOIN TBL_INDICACOES_COMISSOES_UNICAS ON TBL_INDICACOES_COMISSOES_UNICAS.ID_INDICADOR = TBL_INDICACOES.NU_ID WHERE ".$filtro." AND TBL_INDICACOES.NU_CLIENTE = :idcliente GROUP BY 1 ORDER BY TBL_INDICACOES.NU_ID";
			$dados = $this->sistema->bd->executar($sql, array(
				":idcliente" => $this->id
			), Banco_Dados::FETCH_ALL);

			return array("Todos os Indicados", $dados);
		}
	}

	// Retorna o usuário do sistema que possui determinada ID
	function obter_indicador($id){
		return $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_ID = :id AND NU_CLIENTE = :idcliente AND NU_TIPO = 1", array(
				":id" => $id, ":idcliente" => $this->id
			), Banco_Dados::FETCH);
	}

	// Retorna o indicador que possui o cpf especificado
	function obter_indicador_por_cpf($cpf){
		return $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_CPF = :cpf AND NU_CLIENTE = :idcliente AND NU_TIPO = 1", array(
				":cpf" => $cpf, ":idcliente" => $this->id
			), Banco_Dados::FETCH);
	}

	// Retorna o indicador que possui determinada ID
	function obter_usuario($id){
		return $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_ID = :id AND NU_CLIENTE = :idcliente", array(
				":id" => $id, ":idcliente" => $this->id
			), Banco_Dados::FETCH);
	}

	// Retorna o usuário do sistema que possui determinado CPF
	function obter_usuario_por_cpf($cpf){
		return $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_CPF = :cpf AND NU_CLIENTE = :idcliente", array(
				":cpf" => $cpf, ":idcliente" => $this->id
			), Banco_Dados::FETCH);
	}

	// Verifica se o indicador com determinado cpf possui indicados
	function possui_indicados($cpf){
		$this->sistema->bd->executar("SELECT NU_CPF FROM TBL_INDICACOES WHERE NU_CPF_IND = '".$cpf."' AND NU_CLIENTE = '".$this->id."'", array());
		return ($this->sistema->bd->quantidade() > 0);
	}

	/* Retorna os tipos de funcionários sistema de indicação. */
	function funcionario_faculdade(){
		return array("Aluno","Público Externo","Diretor","Coordenador","Professor","Funcionário");
	}

	/*
		Esta função calcula a comissão da win7 em cima do valor especificado,
		e então adiciona a comissão ao saldo.
		O valor pode ser negativo caso seja necessário remover a comissão.
	*/
	function adicionar_comissao_win7($valor){
		// Obtém-se os dados do cliente no banco de dados, onde o saldo da win7 está armazenado
		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :idcliente", array(
			":idcliente" => $this->id),
		Banco_Dados::FETCH);
		$saldo = intval($dados['TXT_SALDO_AGENCIA']);

		// Calcula-se aqui a comissão devida
		$comissao = $this->comissao_agencia;
		$comissao = preg_replace('/\s+/', '', $comissao);
		$comissao = floatval($comissao);

		// Adiciona-se a comissão ao saldo
		$saldo += intval(strval($valor * $comissao));

		// Salvamos aqui o novo saldo no banco
		$this->sistema->bd->executar("UPDATE TBL_CLI_DADOS SET TXT_SALDO_AGENCIA = :saldo WHERE ID_FK = :idcliente", array(
			":idcliente" => $this->id,':saldo' => strval($saldo))
		);
	}

	/*
		Esta função adiciona o valor especificado ao saldo da win7.
		O valor pode ser negativo caso seja necessário remover o valor.
	*/
	function adicionar_saldo_win7($valor){
		// Obtém-se os dados do cliente no banco de dados, onde o saldo da win7 está armazenado
		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :idcliente", array(
			":idcliente" => $this->id),
		Banco_Dados::FETCH);
		$saldo = intval($dados['TXT_SALDO_AGENCIA']);

		// Adiciona-se o valor ao saldo
		$saldo += intval($valor);

		// Salvamos aqui o novo saldo no banco
		$this->sistema->bd->executar("UPDATE TBL_CLI_DADOS SET TXT_SALDO_AGENCIA = :saldo WHERE ID_FK = :idcliente", array(
			":idcliente" => $this->id,':saldo' => strval($saldo))
		);
	}

	/* Adiciona uma entrada no banco de histórico antigo */
	function adicionar_historico_antigo($cpffk, $nome, $cpf, $saldo, $valor, $data, $tipo, $id_produto = -1){
		$this->sistema->bd->executar("INSERT INTO TBL_INDICACOES_HIST (TXT_CPF_FK, TXT_NOME, TXT_CPF, TXT_SALDO, TXT_VALOR, TXT_DATA, TXT_TIPO, NU_CLIENTE, NU_TIPO, ID_PRODUTO) VALUES (:cpffk, :nome, :cpf, :saldo, :valor, :data, :tipo, :idcliente, :tipopontos, :produto)",
			array(
				':cpffk' => $cpffk,
				':nome' => $nome,
				':cpf' => $cpf,
				':saldo' => $saldo,
				':valor' => $valor,
				':data' => $data,
				':tipo' => $tipo,
				':idcliente' => $this->id,
				':tipopontos' => $this->usa_pontos,
				':produto' => $id_produto
			)
		);
	}

	/* Adiciona uma entrada no banco de histórico novo */
	function adicionar_historico_novo($id_indicador, $id_indicado, $nome_indicado, $cpf_indicado, $valor_fechado, $porcentagem, $valor, $tipo, $data, $id_produto = -1){
		$this->sistema->bd->executar("INSERT INTO TBL_INDICACOES_GANHOS (NU_ID_FK, NU_ID_INDICADO_FK, TXT_NOME, NU_CPF, TXT_VALOR_FECHADO, TXT_PORCENTAGEM, TXT_VALOR, DT_TRANSACAO, TXT_TIPO, ID_CLIENTE, NU_TIPO, ID_PRODUTO) VALUES (:idfk, :idindicadofk, :nome, :cpf, :valorfechado, :porcentagem, :valor, :data, :tipo, :idcliente, :tipopontos, :produto)",
			array(
				':idfk' => $id_indicador,
				':idindicadofk' => $id_indicado,
				':nome' => $nome_indicado,
				':cpf' => $cpf_indicado,
				':valorfechado' => $valor_fechado,
				':porcentagem' => $porcentagem,
				':valor' => $valor,
				':data' => $data,
				':tipo' => $tipo,
				':idcliente' => $this->id,
				':tipopontos' => $this->usa_pontos,
				':produto' => $id_produto
			)
		);
	}

	/*
		Analisa a árvore de comissões do indicador especificado,
		e adiciona a comissão para cada um dos indicadores acima
	*/
	function aplicar_niveis_de_comissao($valor_fechado, $cpf_indicador, $modificador, $titulo_historico, $nome_indicado, $cpf_indicado, $data_exibicao, $data_alteracao, $id_indicado, &$atualizacao, &$emails_a_enviar){

		$indicadores = array();

		/* Primeiro verifica-se se o indicador tem um indicado */
		$dados = $this->obter_usuario_por_cpf($cpf_indicador);
		$indicador = $dados["NU_CPF_IND"];

		/* Itera procurando indicadores de indicadores e monta uma array contendo
		   apenas aqueles indicadores que receberão as comissões */
		while(count($indicadores) < count($this->niveis) & !empty($indicador)){
			$dados = $this->obter_usuario_por_cpf($indicador);
			$indicadores[] = array($indicador,$dados["TXT_SALDO"], $dados['NU_ID'],$dados['TXT_NOME'],$dados['TXT_EMAIL']);
			$indicador = $dados["NU_CPF_IND"];
		}

		/* Agora aplica as devidas comissões para cada um dos indicadores */
		$contador = 0;
		foreach($indicadores as $dados){
			$cpf = $dados[0];
			$saldo = intval($dados[1]);
			$comissao = $this->comissao_fixa == true ? $this->niveis[$contador] * $this->ajuste : (intval($valor_fechado) * $this->niveis[$contador]);
			if($this->comissao_fixa == true){
				if($this->usa_pontos == "1")
					$comissao = $this->niveis[$contador] * $this->ajuste;
				else
					$comissao = $this->niveis[$contador];
			}
			else{
				if($this->usa_pontos == "1")
					$comissao = (intval($valor_fechado) * $this->niveis[$contador] * $this->ajuste);
				else
					$comissao = (intval($valor_fechado) * $this->niveis[$contador]);
			}
			$comissao_porcentagem = $this->comissao_fixa == true ? "--" : (strval(intval($this->niveis[$contador] * 100))."%");
			$valor_string = Mascara::converter_para_real($comissao, !$this->comissao_fixa);
			$comissao = intval(preg_replace("/[^0-9]/","",$valor_string));

			$saldo += $comissao * $modificador;
			$this->mudar_saldo($saldo, $cpf);

			$valor = ($modificador == 1) ? "+" : "-";
			$valor .= $this->usa_pontos == "1" ? number_format($comissao, 0, ',', '.') . " pontos" : Mascara::converter_para_real($comissao);

			$valor2 = $this->usa_pontos == "1" ? number_format($comissao, 0, ',', '.') . " pontos" : Mascara::converter_para_real($comissao);

			$saldo_string = $this->usa_pontos == "1" ? number_format(intval($saldo),0,',','.') : Mascara::converter_para_real($saldo);

			$atualizacao[$dados[2]] = array(
				'id' => $dados[2],
				'saldo' => $saldo_string
			);

			if($this->usa_pontos == "1" && $modificador > 0){
				$key = "4-".$dados[2];
				if(!array_key_exists($key, $emails_a_enviar)){
					$emails_a_enviar[$key] = array(4, $dados[2], $dados[3], $dados[4], 0);
				}
				$emails_a_enviar[$key][4] += $comissao;
			}

			$this->adicionar_historico_novo($dados[2], $id_indicado, $nome_indicado, $cpf_indicado, $valor_fechado, $comissao_porcentagem, $valor, $titulo_historico, $data_alteracao);
			$this->adicionar_historico_antigo($cpf, $nome_indicado, $cpf_indicado, $saldo_string, $valor, $data_exibicao, $titulo_historico);

			$contador++;
		}

		if($this->distribuir_comissoes && $contador < count($this->niveis)){
			while($contador < count($this->niveis)){
				$comissao = $this->comissao_fixa == true ? $this->niveis[$contador] : (intval($valor_fechado) * $this->niveis[$contador]);
				$valor_string = Mascara::converter_para_real($comissao, !$this->comissao_fixa);
				$comissao = intval(preg_replace("/[^0-9]/", "", $valor_string));

				$this->adicionar_saldo_win7($comissao * $modificador);
				$contador++;
			}
		}
	}

	/* Atualiza o saldo do indicador para o valor especificado */
	function mudar_saldo($novo,$cpf){
		if(empty($cpf)) return;

		$this->sistema->bd->executar("UPDATE TBL_INDICACOES SET TXT_SALDO = :saldo WHERE NU_CPF = :cpf AND NU_CLIENTE = :idcliente", array(
				":idcliente" => $this->id,
				":saldo" => intval($novo),
				":cpf" => $cpf
			)
		);
	}

	/* Atualiza o saldo do indicador para o valor especificado */
	function mudar_saldo_cadastro($novo,$cpf){
		if(empty($cpf)) return;

		$this->sistema->bd->executar("UPDATE TBL_INDICACOES SET TXT_SALDO_CADASTRO = :saldo WHERE NU_CPF = :cpf AND NU_CLIENTE = :idcliente", array(
				":idcliente" => $this->id,
				":saldo" => intval($novo),
				":cpf" => $cpf
			)
		);
	}

	/* Obtém produtos para serem exibidos no email */
	function obter_produtos_email($id_usuario){
		$usuario = $this->obter_usuario($id_usuario);
		$saldo = $usuario["TXT_SALDO"];
		$saldo_cadastro = $usuario["TXT_SALDO_CADASTRO"];

		$possiveis = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE ID_CLIENTE_FK = :id AND NU_DELETADO = 0 AND (NU_ESTOQUE > 0 OR NU_ESTOQUE_INFINITO = 1) AND ((NU_RESGATE_NORMAL = 1 AND NU_PONTOS <= :pontos) OR (NU_RESGATE_NORMAL = 0 AND NU_PONTOS <= :pontostotais)) ORDER BY NU_PONTOS DESC", array(
			':id' => $this->id,
			':pontos' => $saldo,
			':pontostotais' => (intval($saldo) + intval($saldo_cadastro))
		), Banco_Dados::FETCH_ALL);

		$impossiveis = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE ID_CLIENTE_FK = :id AND NU_DELETADO = 0 AND (NU_ESTOQUE > 0 OR NU_ESTOQUE_INFINITO = 1) AND ((NU_RESGATE_NORMAL = 1 AND NU_PONTOS > :pontos) OR (NU_RESGATE_NORMAL = 0 AND NU_PONTOS > :pontostotais)) ORDER BY NU_PONTOS ASC", array(
			':id' => $this->id,
			':pontos' => $saldo,
			':pontostotais' => (intval($saldo) + intval($saldo_cadastro))
		), Banco_Dados::FETCH_ALL);

		$total_possiveis = count($possiveis);
		$total_impossiveis = count($impossiveis);

		$html = "";

		for($i = 0; $i < $total_possiveis && $i < 3; $i++){
			$produto = $possiveis[$i];
			$url = 'https://'.$this->dominio.'/arquivos/'.rawurlencode($produto['TXT_IMAGEM']);
			$html .= '<div style="display: inline-block; margin-top: 10px; margin-left: 10px; margin-right: 10px; font-size: 14px;border: 1px solid #e2e2e2;border-radius: 17px;box-shadow: 0px 6px 10px 3px #ececec;width: 150px;">
			<img src="'.$url.'" style="width: 130px; height: 130px; border: solid 1px #d6d4d4;border-radius: 11px;margin-bottom: 10px;margin-top: 10px;margin-left: 10px;margin-right: 10px;">
			<br>
			<div style="background-color: whitesmoke;padding: 7px 7px;display: block;">'.$produto['TXT_NOME'].'</div>
			<div style="background-color: #388e3c;color: white;display: block;border-radius: 0px 0px 10px 10px;padding: 8px 0px;">
			<b>'.$produto['NU_PONTOS'].' pontos</b>
			</div></div>';
		}

		for( $c = 0; $c < $total_impossiveis && $c < 5 && $i < 5; $c++){
			$produto = $impossiveis[$c];
			if($produto['NU_RESGATE_NORMAL'] == "1"){
				$pontos = intval($produto['NU_PONTOS']) - intval($saldo);
			}
			else{
				$pontos = intval($produto['NU_PONTOS']) - intval($saldo) - intval($saldo_cadastro);
			}
			$url = 'https://'.$this->dominio.'/arquivos/'.rawurlencode($produto['TXT_IMAGEM']);
			$html .= '<div style="display: inline-block; margin-top: 10px; margin-left: 10px; margin-right: 10px; font-size: 14px;border: 1px solid #e2e2e2;border-radius: 17px;box-shadow: 0px 6px 10px 3px #ececec;width: 150px;">
				<img src="'.$url.'" style="width: 130px; height: 130px; border: solid 1px #d6d4d4;border-radius: 11px;margin-bottom: 10px;margin-top: 10px;margin-left: 10px;margin-right: 10px;">
				<br>
				<div style="background-color: whitesmoke;padding: 7px 7px;display: block;">'.$produto['TXT_NOME'].'</div>
				<div style="background-color: #f1353d;color: white;display: block;border-radius: 0px 0px 10px 10px;padding: 8px 0px;">
				Por <b>+'.$pontos.' pontos</b>
				</div></div>';
			$i++;
		}

		return $html;
	}

	/* Avalia o status novo do indicado e aplica todas
	   as comissões devidas à win7 e ao indicador*/
	function avaliar_comissoes($id_indicado, $fechamentos, $delecoes){
		date_default_timezone_set('America/Sao_Paulo');

		$usuario = $this->obter_usuario($_POST['id']);

		if($this->sistema->bd->quantidade() == 0){
			return array();
		}

		$saldo = $this->usa_pontos == "1" ? number_format(intval($usuario["TXT_SALDO"]),0,',','.') : Mascara::converter_para_real($usuario["TXT_SALDO"]);

		$atualizacao = array();

		$atualizacao[$id_indicado] = array(
			'id' => $id_indicado,
			'status' => $usuario['TXT_STATUS'],
			'nome' => $usuario['TXT_NOME'],
			'telefone' => $usuario['NU_TELEFONE'],
			'email' => $usuario['TXT_EMAIL'],
			'saldo' => $saldo
		);

		$emails_a_enviar = array();

		$fechamentos_usuario = $this->obter_quantidade_fechamentos($usuario['NU_ID']);

		foreach($fechamentos as $fechamento){
			//Se a recorrência não está ativada, para o processo depois de processar um fechamento
			if($this->ativar_recorrencia != "1" && $fechamentos_usuario == 1) break;

			$fechamento_criado = false;

			$usuario = $this->obter_usuario($_POST['id']);

			// Valida a descrição e o valor
			$descricao = $fechamento->descricao;
			if(mb_strlen($descricao) > 30) continue;
			$valor = $fechamento->valor;
			if(mb_strlen($valor) > 15) continue;

			// Inicializa dados
			$timestamp = time();
			$data_alteracao = date('Y-m-d H:i:s', $timestamp);
			$data_exibicao = date('d/m/Y H:i:s', $timestamp);
			$cpf_indicador = $usuario["NU_CPF_IND"];
			$nome_indicado = $usuario["TXT_NOME"];
			$tipo_indicado = $usuario["NU_TIPO"];
			$cpf_indicado = $usuario["NU_CPF"];
			$email_indicado = $usuario["TXT_EMAIL"];
			$telefone_indicado = $usuario['NU_TELEFONE'];
			$saldo_indicado = intval($usuario["TXT_SALDO"]);
			$status = $usuario['TXT_STATUS'];
			$enviou_email_indicado = $usuario['NU_ENVIOU_EMAIL_RECOMENDACAO'] == "1";
			$valor_fechado = str_replace(".","",$valor);
			$valor_fechado = str_replace(",",".",$valor_fechado);
			$valor_fechado = intval(number_format(floatval($valor_fechado),2,"",""));

			if($this->comissao_multipla == "1"){
				if(intval($fechamento->produto) > 0){
					$comissao = $this->obter_comissao_valida($fechamento->produto);
					if($this->sistema->bd->quantidade() == 0){ // ID Inválida, pula o fechamento
						continue;
					}

					$this->comissao_fixa = $comissao['NU_COMISSAO_FIXA'];
					$this->ajuste = floatval($comissao['TXT_AJUSTE']);
					$this->comissao_agencia = $comissao['NU_COMISSAO_AGENCIA'];

					$this->comissao_fidelidade = $comissao['NU_COMISSAO_FIDELIDADE'];
					$this->comissao_fidelidade = preg_replace('/\s+/', '', $this->comissao_fidelidade);
					$this->comissao_fidelidade = floatval($this->comissao_fidelidade);

					$exploded = explode(",", $comissao['TXT_BONUS']);
					$comissoes = array();
					foreach($exploded as $comissao){
						$comissao = preg_replace('/\s+/', '', $comissao);
						$comissoes[] = floatval($comissao);
					}
					$this->comissoes = $comissoes;
					$niveis = array(); // Array que guarda os níveis de comissão, exceto o primeiro
	    			for($count = 1;$count < count($comissoes);$count++){
	    				$niveis[] = $comissoes[$count];
	    			}

	    			$this->niveis = $niveis;
				}
				else{ // ID Inválida, pula o fechamento
					continue;
				}
			}
			else{
				if($fechamento->produto != "-1"){ // ID Inválida, pula o fechamento
					continue;
				}
			}

			if($this->comissao_fidelidade > 0 && $usuario["NU_TIPO"] == "1"){
				if($this->comissao_fixa == true){
					if($this->usa_pontos == "1")
						$comissao = $this->comissao_fidelidade * $this->ajuste;
					else
						$comissao = $this->comissao_fidelidade;
				}
				else{
					if($this->usa_pontos == "1")
						$comissao = (intval($valor_fechado) * $this->comissao_fidelidade * $this->ajuste);
					else
						$comissao = (intval($valor_fechado) * $this->comissao_fidelidade);
				}
				$valor_string = Mascara::converter_para_real($comissao, !$this->comissao_fixa);
				$comissao = intval(preg_replace("/[^0-9]/", "", $valor_string));
				$saldo_indicado += $comissao;
				$valor_string = $this->usa_pontos == "1" ? number_format($comissao,0,',','.') . " pontos" : $valor_string;
				$comissao_porcentagem = $this->comissao_fixa == true ? "--" : ((number_format($this->comissao_fidelidade * 100, 2, ',', '.'))."%");

				$this->mudar_saldo($saldo_indicado,$cpf_indicado);

				$saldo_string = $this->usa_pontos == "1" ? number_format($saldo_indicado,0,',','.') : Mascara::converter_para_real($saldo_indicado);

				$this->adicionar_historico_novo($id_indicado, $id_indicado, $nome_indicado, $cpf_indicado, $valor_fechado, $comissao_porcentagem, "+".$valor_string, "Fidelidade", $data_alteracao);
				$this->adicionar_historico_antigo($cpf_indicado, $nome_indicado, $cpf_indicado,$saldo_string,"+".$valor_string,$data_exibicao,"Fidelidade");

				$saldo = $this->usa_pontos == "1" ? number_format(intval($saldo_indicado),0,',','.') : Mascara::converter_para_real($saldo_indicado);

				if($this->usa_pontos == "1"){
					$key = "0-".$id_indicado;
					if(!array_key_exists($key, $emails_a_enviar)){
						$emails_a_enviar[$key] = array(0, $id_indicado, $nome_indicado, $email_indicado, 0);
					}
					$emails_a_enviar[$key][4] += $comissao;
				}

				$this->sistema->bd->executar("INSERT INTO TBL_INDICACOES_COMISSOES_UNICAS (NU_VALOR_FECHADO, ID_COMISSAO, TXT_DESCRICAO, ID_INDICADOR, ID_CLIENTE) VALUES (:valorfechado, :idcomissao, :descricao, :idindicador, :idcliente)", array(
					":valorfechado" => $valor_fechado,
					":idcomissao" => $fechamento->produto,
					":descricao" => $descricao,
					":idindicador" => $id_indicado,
					":idcliente" => $this->sistema->usuario->id
				));

				$fechamentos_usuario++;

				$fechamento_criado = true;

				$atualizacao[$id_indicado] = array(
					'id' => $id_indicado,
					'status' => $status,
					'saldo' => $saldo,
					'nome' => $nome_indicado,
					'email' => $email_indicado,
					'telefone' => $telefone_indicado,
					'fechamentos' => $fechamentos_usuario
				);

				// Adiciona a comissão nova ganha pela win7
				$this->adicionar_comissao_win7(intval($valor_fechado));
			}

			$this->aplicar_niveis_de_comissao($valor_fechado, $cpf_indicador, 1, "Fechou Negócio", $nome_indicado, $cpf_indicado, $data_exibicao, $data_alteracao, $id_indicado, $atualizacao, $emails_a_enviar);

			$possui_indicador = true;

			if(!empty($usuario["NU_CPF_IND"])){
				$dados = $this->obter_usuario_por_cpf($cpf_indicador);
				if($this->sistema->bd->quantidade() == 0){
					$possui_indicador = false;
				}
			}
			else{
				$possui_indicador = false;
			}

			if(count($this->comissoes) == 0 || (count($this->comissoes) == 1 && $this->comissoes[0] == 0)){
				continue;
			}

			if($possui_indicador == false){
				if($this->distribuir_comissoes){
					$comissao = $this->comissao_fixa == true ? $this->comissoes[0] : (intval($valor_fechado) * $this->comissoes[0]);
					$valor_string = Mascara::converter_para_real($comissao, !$this->comissao_fixa);
					$comissao = intval(preg_replace("/[^0-9]/", "", $valor_string));
					$this->adicionar_saldo_win7($comissao);
				}
				continue;
			}

			$comissao_porcentagem = $this->comissao_fixa == true ? "--" : ((number_format($this->comissoes[0] * 100, 2, ',', '.'))."%");

			if($this->sistema->bd->quantidade() > 0){
				$nome_indicador = $dados["TXT_NOME"];
				$saldo_indicador = intval($dados["TXT_SALDO"]);
				if(empty($saldo_indicador)) $saldo_indicador = 0;
				$email_indicador = $dados["TXT_EMAIL"];
				$id_indicador = $dados["NU_ID"];
				$status_indicador = $dados["TXT_STATUS"];
			}

			// Adiciona-se a comissão nova ao saldo do indicador
			if($this->comissao_fixa == true){
				if($this->usa_pontos == "1")
					$comissao = $this->comissoes[0] * $this->ajuste;
				else
					$comissao = $this->comissoes[0];
			}
			else{
				if($this->usa_pontos == "1")
					$comissao = (intval($valor_fechado) * $this->comissoes[0] * $this->ajuste);
				else
					$comissao = (intval($valor_fechado) * $this->comissoes[0]);
			}
			$valor_string = Mascara::converter_para_real($comissao, !$this->comissao_fixa);
			$comissao = intval(preg_replace("/[^0-9]/", "", $valor_string));
			$saldo_indicador += $comissao;
			$valor_string = $this->usa_pontos == "1" ? number_format($comissao,0,',','.') . " pontos" : $valor_string;

			// Adiciona a comissão nova ganha pelo indicador e por sua árvore de indicações
			$this->mudar_saldo($saldo_indicador,$cpf_indicador);

			// Guardamos o novo saldo do indicador após a mudança
			$saldo_string = $this->usa_pontos == "1" ? number_format($saldo_indicador,0,',','.') : Mascara::converter_para_real($saldo_indicador);

			$this->adicionar_historico_novo($id_indicador, $id_indicado, $nome_indicado, $cpf_indicado, $valor_fechado, $comissao_porcentagem, "+".$valor_string, "Fechou Negócio", $data_alteracao);
			$this->adicionar_historico_antigo($cpf_indicador, $nome_indicado, $cpf_indicado,$saldo_string,"+".$valor_string,$data_exibicao,"Fechou Negócio");

			if($this->usa_pontos == "1"){
				$key = "1-".$id_indicador;
				if(!array_key_exists($key, $emails_a_enviar)){
					$emails_a_enviar[$key] = array(1, $id_indicador, $nome_indicado, $nome_indicador, $email_indicador, 0);
				}
				$emails_a_enviar[$key][5] += $comissao;
			}
			else{
				$key = "2-".$id_indicador;
				if(!array_key_exists($key, $emails_a_enviar)){
					$emails_a_enviar[$key] = array(2, $id_indicador, $nome_indicado, $nome_indicador, $email_indicador, 0);
				}
				$emails_a_enviar[$key][5] += $comissao;
			}

			// Monta-se aqui o email que será enviado para o indicado agradecendo pelo fechamento
			if(!$enviou_email_indicado && $tipo_indicado != "1"){
				$key = "3-".$id_indicado;
				if(!array_key_exists($key, $emails_a_enviar)){
					$emails_a_enviar[$key] = array(3, $id_indicado, $nome_indicado, $nome_indicador, $email_indicado, 0);
				}
				$emails_a_enviar[$key][5] += $comissao;
			}

			if(!$fechamento_criado){
				$this->sistema->bd->executar("INSERT INTO TBL_INDICACOES_COMISSOES_UNICAS (NU_VALOR_FECHADO, ID_COMISSAO, TXT_DESCRICAO, ID_INDICADOR, ID_CLIENTE) VALUES (:valorfechado, :idcomissao, :descricao, :idindicador, :idcliente)", array(
					":valorfechado" => $valor_fechado,
					":idcomissao" => $fechamento->produto,
					":descricao" => $descricao,
					":idindicador" => $id_indicado,
					":idcliente" => $this->sistema->usuario->id
				));
				$fechamentos_usuario++;

				// Adiciona a comissão nova ganha pela win7
				$this->adicionar_comissao_win7(intval($valor_fechado));
			}

			$this->sistema->logs->adicionar_log_alteracao_fechamento_indicacao($nome_indicado, $id_indicado, Mascara::converter_para_real($valor_fechado));

			$saldo = $this->usa_pontos == "1" ? number_format(intval($saldo_indicado),0,',','.') : Mascara::converter_para_real($saldo_indicado);

			$atualizacao[$id_indicado] = array(
				'id' => $id_indicado,
				'status' => $status,
				'saldo' => $saldo,
				'nome' => $nome_indicado,
				'telefone' => $telefone_indicado,
				'email' => $email_indicado,
				'fechamentos' => $fechamentos_usuario
			);

			$saldo = $this->usa_pontos == "1" ? number_format(intval($saldo_indicador),0,',','.') : Mascara::converter_para_real($saldo_indicador);

			if(isset($id_indicador) & !empty($id_indicador)){
				$atualizacao[$id_indicador] = array(
					'id' => $id_indicador,
					'status' => $status_indicador,
					'saldo' => $saldo
				);
			}
		}

		if($this->sistema->usuario->super_adm_indicacoes == "1"){
			foreach($delecoes as $delecao){
				$fechamento_deletado = false;

				$usuario = $this->obter_usuario($_POST['id']);
				$fechamento = $this->obter_fechamento($delecao, $_POST['id']);

				// Inicializa dados
				$timestamp = time();
				$data_alteracao = date('Y-m-d H:i:s', $timestamp);
				$data_exibicao = date('d/m/Y H:i:s', $timestamp);
				$cpf_indicador = $usuario["NU_CPF_IND"];
				$nome_indicado = $usuario["TXT_NOME"];
				$tipo_indicado = $usuario["NU_TIPO"];
				$cpf_indicado = $usuario["NU_CPF"];
				$email_indicado = $usuario["TXT_EMAIL"];
				$telefone_indicado = $usuario['NU_TELEFONE'];
				$saldo_indicado = intval($usuario["TXT_SALDO"]);
				$status = $usuario['TXT_STATUS'];
				$valor_fechado = $fechamento['NU_VALOR_FECHADO'];

				if($fechamento['ID_COMISSAO'] == "-1"){
					$dados = $this->sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :id", array(':id' => $this->id), Banco_Dados::FETCH);

					$this->comissao_fixa = $dados['NU_COMISSAO_FIXA'];
					$this->ajuste = floatval($dados['TXT_AJUSTE']);
					$this->comissao_agencia = $dados['NU_COMISSAO_AGENCIA'];

					$this->comissao_fidelidade = $dados['NU_COMISSAO_FIDELIDADE'];
					$this->comissao_fidelidade = preg_replace('/\s+/', '', $this->comissao_fidelidade);
					$this->comissao_fidelidade = floatval($this->comissao_fidelidade);

					$exploded = explode(",", $dados['TXT_BONUS']);
					$comissoes = array();
					foreach($exploded as $comissao){
						$comissao = preg_replace('/\s+/', '', $comissao);
						$comissoes[] = floatval($comissao);
					}
					$this->comissoes = $comissoes;

					$niveis = array(); // Array que guarda os níveis de comissão, exceto o primeiro
					for($count = 1;$count < count($comissoes);$count++){
						$niveis[] = $comissoes[$count];
					}
					$this->niveis = $niveis;

				}
				else{
					$comissao = $this->obter_comissao($fechamento['ID_COMISSAO']);

					if($this->sistema->bd->quantidade() == 0){ // ID Inválida, pula o fechamento
						continue;
					}

					$this->comissao_fixa = $comissao['NU_COMISSAO_FIXA'];
					$this->ajuste = floatval($comissao['TXT_AJUSTE']);
					$this->comissao_agencia = $comissao['NU_COMISSAO_AGENCIA'];

					$this->comissao_fidelidade = $comissao['NU_COMISSAO_FIDELIDADE'];
					$this->comissao_fidelidade = preg_replace('/\s+/', '', $this->comissao_fidelidade);
					$this->comissao_fidelidade = floatval($this->comissao_fidelidade);

					$exploded = explode(",", $comissao['TXT_BONUS']);
					$comissoes = array();
					foreach($exploded as $comissao){
						$comissao = preg_replace('/\s+/', '', $comissao);
						$comissoes[] = floatval($comissao);
					}
					$this->comissoes = $comissoes;
					$niveis = array(); // Array que guarda os níveis de comissão, exceto o primeiro
	    			for($count = 1;$count < count($comissoes);$count++){
	    				$niveis[] = $comissoes[$count];
	    			}

	    			$this->niveis = $niveis;
				}

				if($this->comissao_fidelidade > 0 && $usuario["NU_TIPO"] == "1"){
					if($this->comissao_fixa == true){
						if($this->usa_pontos == "1")
							$comissao = $this->comissao_fidelidade * $this->ajuste;
						else
							$comissao = $this->comissao_fidelidade;
					}
					else{
						if($this->usa_pontos == "1")
							$comissao = (intval($valor_fechado) * $this->comissao_fidelidade * $this->ajuste);
						else
							$comissao = (intval($valor_fechado) * $this->comissao_fidelidade);
					}
					$valor_string = Mascara::converter_para_real($comissao, !$this->comissao_fixa);
					$comissao = intval(preg_replace("/[^0-9]/", "", $valor_string));
					$saldo_indicado -= $comissao;
					$valor_string = $this->usa_pontos == "1" ? number_format($comissao,0,',','.') . " pontos" : $valor_string;
					$comissao_porcentagem = $this->comissao_fixa == true ? "--" : ((number_format($this->comissao_fidelidade * 100, 2, ',', '.'))."%");

					$this->mudar_saldo($saldo_indicado, $cpf_indicado);

					$saldo_string = $this->usa_pontos == "1" ? number_format($saldo_indicado,0,',','.') : Mascara::converter_para_real($saldo_indicado);

					$this->adicionar_historico_novo($id_indicado, $id_indicado, $nome_indicado, $cpf_indicado, $valor_fechado, $comissao_porcentagem, "-".$valor_string, "Cancelamento", $data_alteracao);
					$this->adicionar_historico_antigo($cpf_indicado, $nome_indicado, $cpf_indicado,$saldo_string,"-".$valor_string,$data_exibicao,"Cancelamento");

					$saldo = $this->usa_pontos == "1" ? number_format(intval($saldo_indicado),0,',','.') : Mascara::converter_para_real($saldo_indicado);

					$this->adicionar_comissao_win7(-intval($valor_fechado));

					$fechamentos_usuario--;

					$this->sistema->bd->executar("DELETE FROM TBL_INDICACOES_COMISSOES_UNICAS WHERE NU_ID = :id", array(':id' => $delecao), Banco_Dados::FETCH);

					$fechamento_deletado = true;

					$atualizacao[$id_indicado] = array(
						'id' => $id_indicado,
						'status' => $status,
						'saldo' => $saldo,
						'nome' => $nome_indicado,
						'email' => $email_indicado,
						'telefone' => $telefone_indicado,
						'fechamentos' => $fechamentos_usuario
					);
				}

				$this->aplicar_niveis_de_comissao($valor_fechado, $cpf_indicador, -1, "Cancelamento", $nome_indicado, $cpf_indicado, $data_exibicao, $data_alteracao, $id_indicado, $atualizacao, $emails_a_enviar);

				$possui_indicador = true;

				if(!empty($usuario["NU_CPF_IND"])){
					$dados = $this->obter_usuario_por_cpf($cpf_indicador);
					if($this->sistema->bd->quantidade() == 0){
						$possui_indicador = false;
					}
				}
				else{
					$possui_indicador = false;
				}

				if(count($this->comissoes) == 0 || (count($this->comissoes) == 1 && $this->comissoes[0] == 0)){
					continue;
				}

				if($possui_indicador == false){
					if($this->distribuir_comissoes){
						$comissao = $this->comissao_fixa == true ? $this->comissoes[0] : (intval($valor_fechado) * $this->comissoes[0]);
						$valor_string = Mascara::converter_para_real($comissao, !$this->comissao_fixa);
						$comissao = intval(preg_replace("/[^0-9]/", "", $valor_string));
						$this->adicionar_saldo_win7(-$comissao);
					}
					continue;
				}

				$comissao_porcentagem = $this->comissao_fixa == true ? "--" : ((number_format($this->comissoes[0] * 100, 2, ',', '.'))."%");

				if($this->sistema->bd->quantidade() > 0){
					$nome_indicador = $dados["TXT_NOME"];
					$saldo_indicador = intval($dados["TXT_SALDO"]);
					if(empty($saldo_indicador)) $saldo_indicador = 0;
					$email_indicador = $dados["TXT_EMAIL"];
					$id_indicador = $dados["NU_ID"];
					$status_indicador = $dados["TXT_STATUS"];
				}

				// Adiciona-se a comissão nova ao saldo do indicador
				if($this->comissao_fixa == true){
					if($this->usa_pontos == "1")
						$comissao = $this->comissoes[0] * $this->ajuste;
					else
						$comissao = $this->comissoes[0];
				}
				else{
					if($this->usa_pontos == "1")
						$comissao = (intval($valor_fechado) * $this->comissoes[0] * $this->ajuste);
					else
						$comissao = (intval($valor_fechado) * $this->comissoes[0]);
				}
				$valor_string = Mascara::converter_para_real($comissao, !$this->comissao_fixa);
				$comissao = intval(preg_replace("/[^0-9]/", "", $valor_string));
				$saldo_indicador -= $comissao;
				$valor_string = $this->usa_pontos == "1" ? number_format($comissao,0,',','.') . " pontos" : $valor_string;

				// Adiciona a comissão nova ganha pelo indicador e por sua árvore de indicações
				$this->mudar_saldo($saldo_indicador,$cpf_indicador);

				// Guardamos o novo saldo do indicador após a mudança
				$saldo_string = $this->usa_pontos == "1" ? number_format($saldo_indicador,0,',','.') : Mascara::converter_para_real($saldo_indicador);

				$this->adicionar_historico_novo($id_indicador, $id_indicado, $nome_indicado, $cpf_indicado, $valor_fechado, $comissao_porcentagem, "-".$valor_string, "Cancelamento", $data_alteracao);
				$this->adicionar_historico_antigo($cpf_indicador, $nome_indicado, $cpf_indicado,$saldo_string,"-".$valor_string,$data_exibicao,"Cancelamento");

				$this->sistema->logs->adicionar_log_alteracao_fechamento_indicacao($nome_indicado, $id_indicado, Mascara::converter_para_real($valor_fechado));

				$saldo = $this->usa_pontos == "1" ? number_format(intval($saldo_indicado),0,',','.') : Mascara::converter_para_real($saldo_indicado);

				if(!$fechamento_deletado){
					$this->adicionar_comissao_win7(-intval($valor_fechado));
					$fechamentos_usuario--;
					$this->sistema->bd->executar("DELETE FROM TBL_INDICACOES_COMISSOES_UNICAS WHERE NU_ID = :id", array(':id' => $delecao), Banco_Dados::FETCH);
				}

				$atualizacao[$id_indicado] = array(
					'id' => $id_indicado,
					'status' => $status,
					'saldo' => $saldo,
					'nome' => $nome_indicado,
					'telefone' => $telefone_indicado,
					'email' => $email_indicado,
					'fechamentos' => $fechamentos_usuario
				);

				$saldo = $this->usa_pontos == "1" ? number_format(intval($saldo_indicador),0,',','.') : Mascara::converter_para_real($saldo_indicador);

				if(isset($id_indicador) & !empty($id_indicador)){
					$atualizacao[$id_indicador] = array(
						'id' => $id_indicador,
						'status' => $status_indicador,
						'saldo' => $saldo
					);
				}
			}
		}

		foreach($emails_a_enviar as $email){
			switch($email[0]){
				case 0:
					// Obtém dados
					$id_indicado = $email[1];
					$nome_indicado = $email[2];
					$email_indicado = $email[3];
					$comissao = $email[4];
					$valor_string = $this->usa_pontos == "1" ?
						number_format($comissao,0,',','.') . " pontos" :
						Mascara::converter_para_real($comissao, !$this->comissao_fixa);
					$produtos_email = $this->obter_produtos_email($id_indicado);
					$html_produtos = '<tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;background-color: #f7f7f7;"><td style="padding-bottom:20px; text-align: center;">Você sabia que dá para ganhar ainda mais pontos indicando pessoas? <br>Veja alguns dos prêmios que você já pode ganhar:</td></tr><tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px; text-align: center;">';
					$html_produtos .= $produtos_email;
					$html_produtos .= '</tr></td>';

					$login_nome = $this->vocabulario[18];
					$login_nome = str_replace("#NOME-CLIENTE#", $this->nome, $login_nome);
					$mensagem_email = $this->vocabulario[27];
					$mensagem_email = str_replace("#NOME-INDICADO#", $nome_indicado, $mensagem_email);
					$mensagem_email = str_replace("#BONUS-GANHO#", "<b>".$valor_string."</b>", $mensagem_email);
					$mensagem_email = str_replace("#DOMINIO#", $this->dominio, $mensagem_email);
					$mensagem_email = str_replace("#DADOS-PRODUTOS#", $html_produtos, $mensagem_email);
					$this->sistema->enviar_email_indicacao_fechamento($mensagem_email,"Você acaba de ganhar pontos - ".$login_nome,$email_indicado,$this->nome);
					break;
				case 1:
					// Obtém dados
					$id_indicador = $email[1];
					$nome_indicado = $email[2];
					$nome_indicador = $email[3];
					$email_indicador = $email[4];
					$comissao = $email[5];
					$valor_string = $this->usa_pontos == "1" ?
						number_format($comissao,0,',','.') . " pontos" :
						Mascara::converter_para_real($comissao, !$this->comissao_fixa);
					$produtos_email = $this->obter_produtos_email($id_indicador);
					$html_produtos = '<tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px; text-align: center;">Não perca tempo, indique mais pessoas! <br><br>Veja alguns dos prêmios que você pode ganhar:</td></tr><tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px; text-align: center;">';
					$html_produtos .= $produtos_email;
					$html_produtos .= '</tr></td>';

					$login_nome = $this->vocabulario[18];
					$login_nome = str_replace("#NOME-CLIENTE#", $this->nome, $login_nome);
					$mensagem_email = $this->vocabulario[26];
					$mensagem_email = str_replace("#NOME-INDICADOR#", $nome_indicador, $mensagem_email);
					$mensagem_email = str_replace("#NOME-INDICADO#", $nome_indicado, $mensagem_email);
					$mensagem_email = str_replace("#BONUS-GANHO#", "<b>".$valor_string."</b>", $mensagem_email);
					$mensagem_email = str_replace("#DOMINIO#", $this->dominio, $mensagem_email);
					$mensagem_email = str_replace("#DADOS-PRODUTOS#", $html_produtos, $mensagem_email);
					$this->sistema->enviar_email_indicacao_fechamento($mensagem_email,"Você acaba de ganhar pontos - ".$login_nome,$email_indicador,$this->nome);
					break;
				case 2:
					// Obtém dados
					$id_indicador = $email[1];
					$nome_indicado = $email[2];
					$nome_indicador = $email[3];
					$email_indicador = $email[4];
					$comissao = $email[5];
					$valor_string = $this->usa_pontos == "1" ?
						number_format($comissao,0,',','.') . " pontos" :
						Mascara::converter_para_real($comissao, !$this->comissao_fixa);

					$mensagem_email = $this->vocabulario[14];
					$mensagem_email = str_replace("#NOME-INDICADOR#", $nome_indicador, $mensagem_email);
					$mensagem_email = str_replace("#NOME-INDICADO#", $nome_indicado, $mensagem_email);
					$mensagem_email = str_replace("#BONUS-GANHO#", "<b>".$valor_string."</b>", $mensagem_email);
					$mensagem_email = str_replace("#DOMINIO#", $this->dominio, $mensagem_email);
					$this->sistema->enviar_email_indicacao($mensagem_email,"O seu indicado fechou negócio!",$email_indicador,$this->nome);
					break;
				case 3:
					// Obtém dados
					$id_indicado = $email[1];
					$nome_indicado = $email[2];
					$nome_indicador = $email[3];
					$email_indicado = $email[4];
					$comissao = $email[5];
					$valor_string = $this->usa_pontos == "1" ?
						number_format($comissao,0,',','.') . " pontos" :
						Mascara::converter_para_real($comissao, !$this->comissao_fixa);

					$mensagem_email = $this->vocabulario[15];
					$mensagem_email = str_replace("#NOME-INDICADOR#", $nome_indicador, $mensagem_email);
					$mensagem_email = str_replace("#NOME-INDICADO#", $nome_indicado, $mensagem_email);
					$mensagem_email = str_replace("#BONUS-GANHO#", "<b>".$valor_string."</b>", $mensagem_email);
					$mensagem_email = str_replace("#DOMINIO#", $this->dominio, $mensagem_email);
					$mensagem_email = str_replace("#TELEFONE#", $this->telefone, $mensagem_email);
					$this->sistema->enviar_email_indicacao($mensagem_email,"Agradecimentos",$email_indicado,$this->nome);

					$this->sistema->bd->executar("UPDATE TBL_INDICACOES SET NU_ENVIOU_EMAIL_RECOMENDACAO = 1 WHERE NU_ID = :id", array(
						":id" => $id_indicado
					));
					break;
				case 4:
					// Obtém dados
					$comissao = $email[4];
					$valor_string = $this->usa_pontos == "1" ?
						number_format($comissao,0,',','.') . " pontos" :
						Mascara::converter_para_real($comissao, !$this->comissao_fixa);

					$produtos_email = $this->obter_produtos_email($email[1]);
					$html_produtos = '<tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px; text-align: center;">Não perca tempo, indique mais pessoas! <br><br>Veja alguns dos prêmios que você pode ganhar:</td></tr><tr valign="top" style="font-size:16px; color: #000; font-family: Tahoma, sans-serif;"><td style="padding-bottom:20px; text-align: center;">';
					$html_produtos .= $produtos_email;
					$html_produtos .= '</tr></td>';

					$login_nome = $this->vocabulario[18];
					$login_nome = str_replace("#NOME-CLIENTE#", $this->nome, $login_nome);
					$mensagem_email = $this->vocabulario[28];
					$mensagem_email = str_replace("#NOME-INDICADO#", $email[2], $mensagem_email);
					$mensagem_email = str_replace("#BONUS-GANHO#", "<b>".$valor_string."</b>", $mensagem_email);
					$mensagem_email = str_replace("#DOMINIO#", $this->dominio, $mensagem_email);
					$mensagem_email = str_replace("#DADOS-PRODUTOS#", $html_produtos, $mensagem_email);
					$this->sistema->enviar_email_indicacao_fechamento($mensagem_email, "Você acaba de ganhar pontos - ".$login_nome,$email[3],$this->nome);
					break;
			}
		}

		// Converte a array de atualizações e a retorna
		$atualizacao2 = array();
		foreach($atualizacao as $a){
			$atualizacao2[] = $a;
		}
		return $atualizacao2;
	}

	/* Obtém a lista de todos os pagamento */
	function obter_lista_pagamentos($data, $inicio, $fim){
		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :idcliente", array(
			":idcliente" => $this->id),
		Banco_Dados::FETCH);

		
		if ($this->mascara_dinheiro === 'eua') {
			$saldo_agencia = Mascara::converter_para_dolar($dados['TXT_SALDO_AGENCIA']);
		} else {
			$saldo_agencia = Mascara::converter_para_real($dados['TXT_SALDO_AGENCIA']);
		}
		

		$filtro = Filtro::filtrar_data($data,"DT_PEDIDO",$inicio,$fim); // Montamos o filtro SQL de data

		$sql = empty($filtro) ?
		"SELECT * FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :ID" :
		"SELECT * FROM TBL_PAG_PENDENTES WHERE ".$filtro." AND ID_CLIENTE = :ID";

		// Fazemos aqui a consulta das indicações
		$dados = $this->sistema->bd->executar($sql, array(
			':ID' => $this->id
		), Banco_Dados::FETCH_ALL);

		/* Organiza todos os dados para enviar por json. */
		$rows = array();
		$rows[] = array();
		$rows[] = array();
		$rows[] = array();
		foreach($dados as $row){
			$rowID = $row['ID_PRODUTO'] == "-1" ? 1 : 2;
			if($row['CPF_INDICADOR'] == "-1"){
				if($row['NU_PROCESSADO'] == "1"){
					$status = "Pago";
				}else if($row['NU_PROCESSADO'] == "2"){
					$status = "Cancelado";
				}else {
					$status = "Pendente";
				}


				if ($this->mascara_dinheiro === 'eua') {
					$txt_valor_formatado = Mascara::converter_para_dolar($row['TXT_VALOR']);
					$saldo_agencia_formatado = Mascara::converter_para_dolar($saldo_agencia);
				} else {
					$txt_valor_formatado = Mascara::converter_para_real($row['TXT_VALOR']);
					$saldo_agencia_formatado = Mascara::converter_para_real($saldo_agencia);
				}
			

				$rows[$rowID][] = array(
					'id' => $row['NU_ID'],
					'idindicador' => -1,
					'nome' => "Agência Win7",
					'telefone' => "(61) 3028-4940",
					'pesquisa' => "",
					'valor' => $txt_valor_formatado,
					'data' => $row['DT_PEDIDO'],
					'status' => $status,
					'cpf' => "--",
					'saldoatual' => $saldo_agencia_formatado,
					'email' => 'contato@win7.com.br'
				);
				continue;
			}

			$indicador = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_CPF = :CPF AND NU_CLIENTE = :ID",array(
				':ID' => $this->id,
				':CPF' => $row['CPF_INDICADOR']
			), Banco_Dados::FETCH);

			if($row['NU_PROCESSADO'] == "1")
				$status = "Pago";
			else if($row['NU_PROCESSADO'] == "2")
				$status = "Cancelado";
			else
				$status = "Pendente";

			$cpf_e = Mascara::mascara_cpf_cnpj($indicador['NU_CPF']);

			if($this->tipo == Sistema_Indicacoes::FACULDADES){
				$pesquisa = $indicador['TXT_NOME'] . " " . $indicador['NU_CPF'] . " " . $cpf_e . " " . $indicador['TXT_UNIDADE'] . " " . $indicador['TXT_CIDADE'] . " " . $indicador['TXT_BAIRRO'] . " " . $indicador['TXT_CURSO']. " " . $indicador['TXT_EMAIL'] . " " . $indicador['TEL_CEL'];
				$tipo_captador = $this->funcionario_faculdade();
				$tipo_captador = $tipo_captador[intval($indicador['NU_TIPO_FUNC'])];
				$pesquisa .= " " . $tipo_captador;
			}
			else{
				$pesquisa = $indicador['TXT_NOME'] . " " . $indicador['NU_CPF'] . " " . $cpf_e . " " . $indicador['TXT_EMAIL'] . " " . $indicador['TEL_CEL'];
			}

			if($rowID == 2){
				$premio = $this->obter_premio($row['ID_PRODUTO']);
				$premio = $premio['nome'];
			}

			$saldo_atual = $this->usa_pontos == "1" ? number_format($indicador['TXT_SALDO'],0,",","."). " pontos" :  Mascara::converter_para_real($indicador['TXT_SALDO']);


			if ($this->mascara_dinheiro === 'eua') {
				$txt_valor_formatado = Mascara::converter_para_dolar($row['TXT_VALOR']);
				$saldo_atual_formatado = Mascara::converter_para_dolar($saldo_atual);
			} else {
				$txt_valor_formatado = Mascara::converter_para_real($row['TXT_VALOR']);
				$saldo_atual_formatado = Mascara::converter_para_real($saldo_atual);
			}


			// Montamos a array com os dados dessa indicação específica
			$rows[$rowID][] = array(
				'id' => $row['NU_ID'],
				'idindicador' => $indicador['NU_ID'],
				'nome' => $indicador['TXT_NOME'],
				'telefone' => $indicador['TEL_CEL'],
				'pesquisa' => $pesquisa,
				'cpf' => $cpf_e,
				'valor' => $txt_valor_formatado,
				'data' => $row['DT_PEDIDO'],
				'status' => $status,
				'saldoatual' => $saldo_atual_formatado,
				'email' => $indicador['TXT_EMAIL'],
				'idproduto' => $row['ID_PRODUTO'],
				'premio' => $premio
			);
		}

		$rows[0]['quantidade'] = count($rows[1]) + count($rows[2]); // Calculamos a quantidade total de indicações

		$totais = $this->calcular_pendencias();

		$rows[0]['bonuspendentes'] = $totais['bonuspendentes'];
		$rows[0]['bonuspagos'] = $totais['bonuspagos'];
		$rows[0]['saldowin'] = $totais['saldowin'];
		$rows[0]['saldoindicadores'] = $totais['saldoindicadores'];
		$rows[0]['premiosentregues'] = $totais['premiosentregues'];
		$rows[0]['premiospendentes'] = $totais['premiospendentes'];
		$rows[0]['saldocadastro'] = $totais['saldocadastro'];
		$rows[0]['text_cpf_cnpj_alternativo'] = $totais['text_cpf_cnpj_alternativo'] == null ? "" : $totais['text_cpf_cnpj_alternativo'];

		return $rows;
	}

	// Calcula o saldo pendente, o total de saldo, o total pago e o saldo da agência e coloca tudo em um JSON
	function calcular_pendencias(){
		$total = 0;
		$total_pago = 0;
		$premios_entregues = 0;
		$premios_pendentes = 0;

		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :ID AND (NU_PROCESSADO = 1 OR NU_PROCESSADO = 0)", array(':ID' => $this->id), Banco_Dados::FETCH_ALL);

		foreach($dados as $row){
			if($row['ID_PRODUTO'] != "-1"){
				if($row['NU_PROCESSADO'] == 0)
					$premios_pendentes++;
				else if($row['NU_PROCESSADO'] == 1)
					$premios_entregues++;
			}
			else{
				if($row['NU_PROCESSADO'] == 0)
					$total += intval($row['TXT_VALOR']);
				else if($row['NU_PROCESSADO'] == 1)
					$total_pago += intval($row['TXT_VALOR']);
			}
		}

		$total_saldo = 0;
		$total_saldo_cadastro = 0;
		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_CLIENTE = :ID AND NU_TIPO = 1", array(':ID' => $this->id), Banco_Dados::FETCH_ALL);

		foreach($dados as $row){
			$total_saldo += intval($row['TXT_SALDO']);
			$total_saldo_cadastro += intval($row['TXT_SALDO_CADASTRO']);
		}

		if($this->usa_pontos == "0"){

			if ($this->mascara_dinheiro === 'eua') {
				$total_saldo = Mascara::converter_para_dolar(strval($total_saldo));
				$total_saldo_cadastro = Mascara::converter_para_dolar(strval($total_saldo_cadastro));
			} else {
				$total_saldo = Mascara::converter_para_real(strval($total_saldo));
				$total_saldo_cadastro = Mascara::converter_para_real(strval($total_saldo_cadastro));
			}

		}
		else{
			$total_saldo = number_format($total_saldo, 0, ",", ".") . " pontos";
			$total_saldo_cadastro = number_format($total_saldo_cadastro, 0, ",", ".") . " pontos";
		}

		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :idcliente", array(
			":idcliente" => $this->id),
		Banco_Dados::FETCH);
		$saldo_agencia = $dados['TXT_SALDO_AGENCIA'];


		if ($this->mascara_dinheiro === 'eua') {
			$total_formatado = Mascara::converter_para_dolar(strval($total));
			$total_pago_formatado = Mascara::converter_para_dolar(strval($total_pago));
			$saldo_agencia_formatado = Mascara::converter_para_dolar($saldo_agencia);
		} else {
			$total_formatado = Mascara::converter_para_real(strval($total));
			$total_pago_formatado = Mascara::converter_para_real(strval($total_pago));
			$saldo_agencia_formatado = Mascara::converter_para_real($saldo_agencia);
		}


		$resultado = array(
			"bonuspendentes" => $total_formatado,
			"bonuspagos" => $total_pago_formatado,
			"saldowin" => $saldo_agencia_formatado,
			"saldoindicadores" => $total_saldo,
			"premiospendentes" => $premios_pendentes,
			"premiosentregues" => $premios_entregues,
			"saldocadastro" => $total_saldo_cadastro,
			"text_cpf_cnpj_alternativo" => $this->text_cpf_cnpj_alternativo,
		);

		return $resultado;
	}

	/* Obtém um pagamento com ID específica */
	function obter_pagamento($id){
		return $this->sistema->bd->executar("SELECT * FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :ID AND NU_ID = :ID2 AND NU_PROCESSADO = 0", array(
			':ID2' => $id,
			':ID' => $this->id
		), Banco_Dados::FETCH);
	}

	/* Confirma o  pagamento que tem a ID especificada */
	function confirmar_pagamento($id){
		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :ID AND NU_ID = :ID2 AND NU_PROCESSADO = 0", array(
			':ID2' => $id,
			':ID' => $this->id
		), Banco_Dados::FETCH);

		if($this->sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado no banco, então a ID é inválida
			return -1;
		}

		$cpf_indicador = $dados['CPF_INDICADOR'];
		$id_produto = $dados['ID_PRODUTO'];

		// Marca o pagamento como cancelado no banco de dados
		$this->sistema->bd->executar('UPDATE TBL_PAG_PENDENTES SET NU_PROCESSADO = 1 WHERE NU_ID = :id AND ID_CLIENTE = :idcliente', array(
			":idcliente" => $this->id, "id" => $id));

		$valor_ind = $this->sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :idcliente", array(
			":idcliente" => $this->id),
		Banco_Dados::FETCH);


		if ($this->mascara_dinheiro === 'eua') {
			$valor = $dados['TXT_VALOR'];
			$valor = Mascara::converter_para_dolar(strval($valor));
		} else {
			$valor = $dados['TXT_VALOR'];
			$valor = Mascara::converter_para_real(strval($valor));
		}

		if($dados['CPF_INDICADOR'] == "-1"){
			$this->sistema->enviar_email_indicacao('<p style="color: #000;">O cliente '.$valor_ind['TXT_NOME'].' confirmou que pagou nossa comissão no valor de '.$valor.'!</p>', "Pagamento de comissão confirmado", Sistema::email_adm("contato@win7.com.br"), $valor_ind['TXT_NOME']);
		}

		$totais = $this->calcular_pendencias();
		$totais['idproduto'] = $id_produto;
		$totais['id'] = $id;


		if($dados['CPF_INDICADOR'] == "-1"){
			$nome = "Agência Win7";
			$pagamento = $valor;
		}
		else{
			$indicador = $this->obter_indicador_por_cpf($cpf_indicador);
			$nome = $indicador['TXT_NOME'];
			if($id_produto == "-1"){
				$pagamento = $valor;
			}
			else{
				$produto = $this->obter_premio($id_produto);
				$pagamento = $produto['nome'];
			}
		}

		$this->sistema->logs->adicionar_log_confirmacao_pagamento($nome, $pagamento, $id);

		return $totais;
	}

	/* Cancela o  pagamento que tem a ID especificada, retornando ao saldo do cliente o valor cancelado */
	function cancelar_pagamento($id){
		$dados = $this->sistema->bd->executar("SELECT * FROM TBL_PAG_PENDENTES WHERE ID_CLIENTE = :ID AND NU_ID = :ID2 AND NU_PROCESSADO = 0", array(
			':ID2' => $id,
			':ID' => $this->id
		), Banco_Dados::FETCH);

		if($this->sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado no banco, então a ID é inválida
			return -1;
		}

		$id_produto = $dados['ID_PRODUTO'];
		$valor_ind = $this->sistema->bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :idcliente", array(
			":idcliente" => $this->id),
		Banco_Dados::FETCH);
		$valor = intval($dados['TXT_VALOR']);
		$valor_cadastro = intval($dados['TXT_SALDO_CADASTRO']);
		$cpf_indicador = $dados['CPF_INDICADOR'];

		if($cpf_indicador == "-1"){ // Se o CPF é -1, o pagamento cancelado é da win7
			// Soma o saldo atual da win7 com o valor cancelado
			$valor = intval($dados['TXT_VALOR']) + intval($valor_ind['TXT_SALDO_AGENCIA']);

			// Grava o novo valor do saldo da win7 no banco
			$this->sistema->bd->executar("UPDATE TBL_CLI_DADOS SET TXT_SALDO_AGENCIA = :valor WHERE ID_FK = :idcliente", array(
				":idcliente" => $this->id, "valor" => $valor));

			// Marca o pagamento como cancelado no banco de dados
			$this->sistema->bd->executar('UPDATE TBL_PAG_PENDENTES SET NU_PROCESSADO = 2 WHERE NU_ID = :id AND ID_CLIENTE = :idcliente', array(
				":idcliente" => $this->id, "id" => $id));

			// Envia um email para nós avisando do cancelamento
			if ($this->mascara_dinheiro === 'eua') {
				$valor = Mascara::converter_para_dolar(strval($dados['TXT_VALOR']));
			} else {
				$valor = Mascara::converter_para_real(strval($dados['TXT_VALOR']));
			}

			$this->sistema->enviar_email_indicacao('<p style="color: #000;">O nosso pagamento de comissão do cliente '.$valor_ind['TXT_NOME'].' foi cancelado, no valor de '.$valor.' e, portanto, foi restituído ao nosso saldo!</p>',"Cancelamento de pagamento", Sistema::email_adm("contato@win7.com.br"), $valor_ind['TXT_NOME']);
		}
		else{
			if($id_produto == "-1"){

				// Obtém o usuário e soma o valor cancelado ao seu saldo
				$dados = $this->obter_usuario_por_cpf($dados['CPF_INDICADOR']);
				$saldo = intval($dados["TXT_SALDO"]);
				$saldo_cadastro = intval($dados["TXT_SALDO_CADASTRO"]);
				$valor_temp = $valor;
				if($valor_cadastro > 0){
					$saldo_cadastro += $valor_cadastro;
					$valor_temp -= $valor_cadastro;
					$this->mudar_saldo_cadastro($saldo_cadastro, $dados['NU_CPF']);
				}
				$saldo += $valor_temp;

				// Salva o novo saldo no banco
				$this->mudar_saldo($saldo, $dados['NU_CPF']);

				// Prepara os dados principais para enviar por email e adicionar no histórico
				if ($this->mascara_dinheiro === 'eua') {
					$valor_string = Mascara::converter_para_dolar($valor);
					$saldo_string = Mascara::converter_para_dolar($saldo);
				} else {
					$valor_string = Mascara::converter_para_real($valor);
					$saldo_string = Mascara::converter_para_real($saldo);
				}

				date_default_timezone_set('America/Sao_Paulo');
				$timestamp = time();
				$data_exibicao = date('d/m/Y H:i:s', $timestamp);
				$data_alteracao = date('Y-m-d H:i:s', $timestamp);

				// Adiciona a alteração no histórico
				$this->adicionar_historico_novo($dados['NU_ID'], $dados['NU_ID'], $dados['TXT_NOME'], $dados['NU_CPF'], $this->simbolo_dinheiro." 0,00", "--", "+".$valor_string, "Devolução", $data_alteracao);
				$this->adicionar_historico_antigo($dados['NU_CPF'], $dados['TXT_NOME'], $dados['NU_CPF'], $saldo_string,"+".$valor_string, $data_exibicao, "Devolução");

				// Marca o pagamento como cancelado no banco de dados
				$this->sistema->bd->executar('UPDATE TBL_PAG_PENDENTES SET NU_PROCESSADO = 2 WHERE NU_ID = :id AND ID_CLIENTE = :idcliente', array(
					":idcliente" => $this->id, "id" => $id));

				// Envia um email para o indicaor avisando do cancelamento
				$this->sistema->enviar_email_indicacao('<p style="color: #000;">Olá, '.$dados['TXT_NOME'].' !</p><p style="color: #000;">Informamos que seu pedido de resgate de bônus no valor de '.$valor_string.' foi cancelado e, portanto, tal valor foi restituído ao seu saldo.</p><p style="color: #000;"> Para mais informações, logue na sua conta <a href="http://'.$valor_ind['TXT_HOST'].'/" style="color: #000;">clicando aqui!</a></p>', "Cancelamento de Bônus", $dados['TXT_EMAIL'], $valor_ind['TXT_NOME']);
			}
			else{
				// Obtém o usuário e soma o valor cancelado ao seu saldo
				$dados = $this->obter_usuario_por_cpf($dados['CPF_INDICADOR']);
				$saldo = intval($dados["TXT_SALDO"]);
				$saldo_cadastro = intval($dados["TXT_SALDO_CADASTRO"]);
				$valor_temp = $valor;
				if($valor_cadastro > 0){
					$saldo_cadastro += $valor_cadastro;
					$valor_temp -= $valor_cadastro;
					$this->mudar_saldo_cadastro($saldo_cadastro, $dados['NU_CPF']);
				}
				$saldo += $valor_temp;

				// Salva o novo saldo no banco
				$this->mudar_saldo($saldo, $dados['NU_CPF']);

				// Prepara os dados principais para enviar por email e adicionar no histórico
				$valor_string = number_format($valor, 0, ",", "."). " pontos";
				$saldo_string = number_format($saldo, 0, ",", "."). " pontos";
				date_default_timezone_set('America/Sao_Paulo');
				$timestamp = time();
				$data_exibicao = date('d/m/Y H:i:s', $timestamp);
				$data_alteracao = date('Y-m-d H:i:s', $timestamp);

				// Adiciona a alteração no histórico
				$this->adicionar_historico_novo($dados['NU_ID'], $dados['NU_ID'], $dados['TXT_NOME'], $dados['NU_CPF'], $this->simbolo_dinheiro." 0,00", "--", "+".$valor_string, "Devolução", $data_alteracao);
				$this->adicionar_historico_antigo($dados['NU_CPF'], $dados['TXT_NOME'], $dados['NU_CPF'], $saldo_string,"+".$valor_string, $data_exibicao, "Devolução");

				// Devolve 1 ao estoque do prêmio
				$this->sistema->bd->executar('UPDATE TBL_INDICACOES_PRODUTOS SET NU_ESTOQUE = NU_ESTOQUE + 1 WHERE NU_ID = :id AND ID_CLIENTE_FK = :idcliente AND NU_ESTOQUE_INFINITO = 0', array(
					":idcliente" => $this->id, "id" => $id_produto));

				// Marca o pagamento como cancelado no banco de dados
				$this->sistema->bd->executar('UPDATE TBL_PAG_PENDENTES SET NU_PROCESSADO = 2 WHERE NU_ID = :id AND ID_CLIENTE = :idcliente', array(
					":idcliente" => $this->id, "id" => $id));

				// Envia um email para o indicaor avisando do cancelamento
				$this->sistema->enviar_email_indicacao('<p style="color: #000;">Olá, '.$dados['TXT_NOME'].' !</p><p style="color: #000;">Informamos que seu pedido de resgate de bônus no valor de '.$valor_string.' foi cancelado e, portanto, tal valor foi restituído ao seu saldo.</p><p style="color: #000;"> Para mais informações, logue na sua conta <a href="http://'.$valor_ind['TXT_HOST'].'/" style="color: #000;">clicando aqui!</a></p>', "Cancelamento de Bônus", $dados['TXT_EMAIL'], $valor_ind['TXT_NOME']);
			}
		}

		$totais = $this->calcular_pendencias();
		$totais['novosaldo'] = $saldo_string;
		$totais['idproduto'] = $id_produto;

		if($cpf_indicador == "-1"){
			$nome = "Agência Win7";
			$pagamento = $valor;
		}
		else{
			$indicador = $this->obter_indicador_por_cpf($cpf_indicador);
			$nome = $indicador['TXT_NOME'];
			if($id_produto == "-1"){
				
				if ($this->mascara_dinheiro === 'eua') {
					$pagamento = Mascara::converter_para_dolar($valor);
				} else {
					$pagamento = Mascara::converter_para_real($valor);
				}
				
			}
			else{
				$produto = $this->obter_premio($id_produto);
				$pagamento = $produto['nome'];
			}
		}

		$this->sistema->logs->adicionar_log_cancelamento_pagamento($nome, $pagamento, $id);

		return $totais;
	}

	/* Tenta ativar a conta que possui o token especificado */
	function ativar_conta($token){
		try{
			/* Conecta com o banco para verificar se o token existe */
			$dados = $this->sistema->bd->executar("SELECT NU_CPF FROM TBL_INDICACOES WHERE TOKEN_CONTA = :TOKEN_CONTA AND NU_TIPO = 1 AND NU_ATIVO = 0 AND NU_CLIENTE = :ID", array(
				':TOKEN_CONTA' => $token,
				':ID' => $this->id
			), Banco_Dados::FETCH);

			if($this->sistema->bd->quantidade() > 0){
				/* Puxa o CPF do banco para verificar o token */
				$cpf_indicador = $dados['NU_CPF'];

				/* Gera um novo token para o usuario */
				$novo_token = Utilitarios::gerar_token(50);

				/* Verifica se o token existe e altera ele */
				$this->sistema->bd->executar('UPDATE TBL_INDICACOES SET TOKEN_CONTA = :novoToken, NU_ATIVO = :ativaConta  WHERE NU_CPF = :cpf AND NU_CLIENTE = :ID', array(
					':cpf' => $cpf_indicador,
					':novoToken' => $novo_token,
					':ativaConta' => "1",
					':ID' => $this->id
				));

				return Sistema::SUCESSO;
			}
			else
				return Sistema::FALHA;
		}
		catch(Exception $e){
			return Sistema::ERRO_CONEXAO;
		}
	}

	/* Registra um indicador do sistema de indicações padrão */
	function registrar_indicador_normal($usuario, $nome, $email, $telefone, $senha, $atualizar){
	    $email = str_replace(' ', '', $email);
	    $nome = trim($nome);
	    $telefone = trim($telefone);
		$saldo_indicador = 0;
		if($this->comissao_cadastro > 0){
			if($this->usa_pontos == "1"){
				$comissao = $this->comissao_cadastro * $this->ajuste;
			}else {
				$comissao = $this->comissao_cadastro;
			}
				
			if ($this->mascara_dinheiro === 'eua') {
				$valor_string = Mascara::converter_para_dolar($comissao, false);
			} else {
				$valor_string = Mascara::converter_para_real($comissao, false);
			}
			
			$comissao = intval(preg_replace("/[^0-9]/", "", $valor_string));
			$saldo_indicador += $comissao;
		}

		$senha = Utilitarios::hash_str($senha);

		if(isset($_SESSION['indicadorID'])){ // Verifica se o indicador foi indicado por alguém
			$dado = $this->obter_indicador($_SESSION['indicadorID']);
			$ind_cpf = $dado['NU_CPF'];
		}
		else
			$ind_cpf = "";

		$ativacao = Utilitarios::gerar_token(50);

		if($atualizar){
			$sql = "UPDATE TBL_INDICACOES SET TXT_NOME = :TXT_NOME, TXT_EMAIL = :TXT_EMAIL, TOKEN_CONTA = :TOKEN_CONTA, NU_TIPO = :NU_TIPO, TEL_CEL = :TEL_CEL, TXT_SENHA = :TXT_SENHA, TXT_SALDO_CADASTRO = :TXT_SALDO_CADASTRO WHERE NU_CPF = :NU_CPF AND NU_CLIENTE = :ID";
			$params = array(
				':NU_CPF' => $usuario,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':TOKEN_CONTA' => $ativacao,
				':NU_TIPO' => 1,
				':TEL_CEL' => $telefone,
				':TXT_SENHA' => $senha,
				':TXT_SALDO_CADASTRO' => $saldo_indicador,
				':ID' => $this->id
			);
		}
		else{
			$sql = "INSERT INTO TBL_INDICACOES (TXT_NOME, TXT_EMAIL, NU_CPF, TOKEN_CONTA, NU_TIPO, TEL_CEL, TXT_SENHA, NU_CLIENTE, NU_CPF_IND, TXT_SALDO_CADASTRO) VALUES (:TXT_NOME, :TXT_EMAIL, :NU_CPF, :TOKEN_CONTA, :NU_TIPO, :TEL_CEL, :TXT_SENHA, :ID, :CPF_INDICADOR, :TXT_SALDO_CADASTRO)";
			$params = array(
				':NU_CPF' => $usuario,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':TOKEN_CONTA' => $ativacao,
				':NU_TIPO' => 1,
				':TEL_CEL' => $telefone,
				':TXT_SENHA' => $senha,
				':TXT_SALDO_CADASTRO' => $saldo_indicador,
				':ID' => $this->id,
				':CPF_INDICADOR' => $ind_cpf
			);
		}
		$this->sistema->bd->executar($sql, $params);

		// Envia o email de ativação
		$link_at = 'http://'.$this->dominio.'/?t='.$ativacao;
		$mensagem_email = $this->vocabulario[9];
		$mensagem_email = str_replace("#LINK#", $link_at, $mensagem_email);
		$this->sistema->enviar_email_indicacao($mensagem_email, "Ative sua Conta", $email, $this->nome);

		// Envia o email para o dono do sistema, e para nós, avisando do novo registro
		$cpf_cnpj = Mascara::mascara_cpf_cnpj($usuario);
		$cpf_cnpj_str = strlen($usuario) == 11 ? "CPF" : "CNPJ";
		date_default_timezone_set('America/Sao_Paulo');
		$data_assunto = " - ". date('d/m/Y H:i:s');
		$mensagem = '<p style="color: #000;">Um novo <b>indicador</b> acaba de se registrar no sistema '.$this->nome.'!</p>
			<table cellpadding="6" style="padding: 0px 0px 0px 0px;border:1px solid #e2e2e2;border-radius: 9px;margin: auto;">
			<tbody><tr><td><b>Nome:</b></td><td>'.$nome.'</td></tr>
			<tr style="background-color: whitesmoke;"><td><b>'.$cpf_cnpj_str.':</b></td><td>'.$cpf_cnpj.'</td></tr>
			<tr><td><b>E-mail:</b></td><td>'.$email.'</td></tr>
			<tr style="background-color: whitesmoke;"><td><b>Telefone:</b></td><td>'.$telefone.'</td></tr></tbody>
		</table>';
		$this->sistema->enviar_email_indicacao($mensagem,"Novo indicador".$data_assunto, Sistema::email_adm($this->email), $this->nome);

		return -1;
	}

	/* Registra um novo indicador do sistema de faculdades */
	function registrar_indicador_faculdade($usuario, $nome, $email, $telefone, $senha, $atualizar, $parametros){
        $email = str_replace(' ', '', $email);
        $nome = trim($nome);
        $telefone = trim($telefone);
		$saldo_indicador = 0;
		if($this->comissao_cadastro > 0){
			if($this->usa_pontos == "1"){
				$comissao = $this->comissao_cadastro * $this->ajuste;
			}else{
				$comissao = $this->comissao_cadastro;
			}

			if ($this->mascara_dinheiro === 'eua') {
				$valor_string = Mascara::converter_para_dolar($comissao, false);
			} else {
				$valor_string = Mascara::converter_para_real($comissao, false);
			}

			$comissao = intval(preg_replace("/[^0-9]/", "", $valor_string));
			$saldo_indicador += $comissao;
		}

		$senha = Utilitarios::hash_str($senha);

		if(isset($_SESSION['indicadorID'])){ // Verifica se o indicador foi indicado por alguém
			$dado = $this->obter_indicador($_SESSION['indicadorID']);
			$ind_cpf = $dado['NU_CPF'];
		}
		else
			$ind_cpf = "";

		$ativacao = Utilitarios::gerar_token(50);

		if($atualizar){
			$sql = "UPDATE TBL_INDICACOES SET TXT_NOME = :TXT_NOME, TXT_EMAIL = :TXT_EMAIL, TOKEN_CONTA = :TOKEN_CONTA, NU_TIPO = :NU_TIPO, TEL_CEL = :TEL_CEL, TXT_SENHA = :TXT_SENHA, NU_TIPO_FUNC = :FUNC, TXT_SALDO_CADASTRO = :TXT_SALDO_CADASTRO WHERE NU_CPF = :NU_CPF AND NU_CLIENTE = :ID";
			$params = array(
				':NU_CPF' => $usuario,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':TOKEN_CONTA' => $ativacao,
				':NU_TIPO' => 1,
				':TEL_CEL' => $telefone,
				':TXT_SENHA' => $senha,
				':TXT_SALDO_CADASTRO' => $saldo_indicador,
				':ID' => $this->id,
				':FUNC' => $parametros['tipofunc']
			);
		}
		else{
			$sql = "INSERT INTO TBL_INDICACOES (TXT_NOME, TXT_EMAIL, NU_CPF, TOKEN_CONTA, NU_TIPO, TEL_CEL, TXT_SENHA, NU_CLIENTE, NU_CPF_IND, NU_TIPO_FUNC, TXT_SALDO_CADASTRO) VALUES (:TXT_NOME, :TXT_EMAIL, :NU_CPF, :TOKEN_CONTA, :NU_TIPO, :TEL_CEL, :TXT_SENHA, :ID, :CPF_INDICADOR, :FUNC, :TXT_SALDO_CADASTRO)";
			$params = array(
				':NU_CPF' => $usuario,
				':TXT_NOME' => $nome,
				':TXT_EMAIL' => $email,
				':TOKEN_CONTA' => $ativacao,
				':NU_TIPO' => 1,
				':TEL_CEL' => $telefone,
				':TXT_SENHA' => $senha,
				':TXT_SALDO_CADASTRO' => $saldo_indicador,
				':ID' => $this->id,
				':FUNC' => $parametros['tipofunc'],
				':CPF_INDICADOR' => $ind_cpf
			);
		}
		$this->sistema->bd->executar($sql, $params);

		// Envia o email de ativação
		$link_at = 'http://'.$this->dominio.'/?t='.$ativacao;
		$mensagem_email = $this->vocabulario[9];
		$mensagem_email = str_replace("#LINK#", $link_at, $mensagem_email);
		$this->sistema->enviar_email_indicacao($mensagem_email, "Ative sua Conta", $email, $this->nome);

		// Envia o email para o dono do sistema, e para nós, avisando do novo registro
		$cpf_cnpj = Mascara::mascara_cpf_cnpj($usuario);
		$cpf_cnpj_str = strlen($usuario) == 11 ? "CPF" : "CNPJ";
		date_default_timezone_set('America/Sao_Paulo');
		$data_assunto = " - ". date('d/m/Y H:i:s');
		$mensagem = '<p style="color: #000;">Um novo <b>indicador</b> acaba de se registrar no sistema '.$this->nome.'!</p>
		<table cellpadding="6" style="padding: 0px 0px 0px 0px;border:1px solid #e2e2e2;border-radius: 9px;margin: auto;">
		<tbody><tr><td><b>Nome:</b></td><td>'.$nome.'</td></tr>
		<tr style="background-color: whitesmoke;"><td><b>'.$cpf_cnpj_str.':</b></td><td>'.$cpf_cnpj.'</td></tr>
		<tr><td><b>E-mail:</b></td><td>'.$email.'</td></tr>
		<tr style="background-color: whitesmoke;"><td><b>Telefone:</b></td><td>'.$telefone.'</td></tr></tbody>
	</table>';
		$this->sistema->enviar_email_indicacao($mensagem,"Novo indicador".$data_assunto, Sistema::email_adm($this->email), $this->nome);

		return -1;
	}

	/* Registra um novo indicador */
	function registrar_indicador($usuario, $nome, $email, $telefone, $senha, $params){
		$dados = $this->obter_usuario_por_cpf($usuario);

		if($this->sistema->bd->quantidade() > 0){
			if($dados['NU_TIPO'] != 1){
				if($this->tipo == Sistema_Indicacoes::FACULDADES)
					return $this->registrar_indicador_faculdade($usuario, $nome, strtolower($email), $telefone, $senha, true, $params);
				else
					return $this->registrar_indicador_normal($usuario, $nome, strtolower($email), $telefone, $senha, true);
			}
			else
				return 0;
		}
		else{
			if($this->tipo == Sistema_Indicacoes::FACULDADES)
				return $this->registrar_indicador_faculdade($usuario, $nome, strtolower($email), $telefone, $senha, false, $params);
			else
				return $this->registrar_indicador_normal($usuario, $nome, strtolower($email), $telefone, $senha, false);
		}
	}

	/* Envia para o indicador com o cpf especificado um email com instruções de como mudar sua senha*/
	function recuperar_senha($usuario){
		// Procura pelo indicador que possui o CPF especificado
		$dados = $this->obter_indicador_por_cpf($usuario);

		if($this->sistema->bd->quantidade() > 0){
			// Cria uma token para mudança de senha e a salvar no banco de dados
			$email = $dados['TXT_EMAIL'];
			$token = Utilitarios::gerar_token(50);

			$this->sistema->bd->executar("UPDATE TBL_INDICACOES SET TOKEN_SENHA = :TOKEN_SENHA WHERE NU_CPF = :NU_CPF AND NU_CLIENTE = :ID", array(
				':NU_CPF' => $usuario,
				':TOKEN_SENHA' => $token,
				':ID' => $this->id
			));

			// Envia o email com instruções
			$mensagem = '<p style="color: #000;">Conforme solicitado, o seguinte link foi gerado para a modificação de sua senha no sistema de Clube da Vantagens do(a) '.$this->nome.': </p><p style="color: #000;"><a style="color: white;font-size: 16px;background-color: green;padding: 10px 24px 10px 24px;box-sizing: border-box;text-decoration: none;display: inline-block;border-radius: 46px;box-shadow: 0px 6px 10px 3px #d4d4d4;" href="https://'.$this->dominio.'/trocar-senha?s='.$token.'">Clique aqui para alterar sua senha</a><br><p style="color: #000;">ou copie e cole o link abaixo no seu navegador:</p><p>'.$this->dominio.'/trocar-senha?s='.$token.'</p><p style="color: #000;"><i>Desconsidere essa mensagem, caso o pedido de troca de senha não tenha sido feito você.</i></p>';
			$this->sistema->enviar_email_indicacao($mensagem, "Mudança de Senha", $email, $this->nome);

			return -1;
		}
		else{
			return 10;
		}
	}

	/* Modifica a senha do usuário que possui a token especificada.
	 * Tipo 0 = senha de acesso
	 * Tipo 1 = senha de transferência
	 */
	function modificar_senha($token, $senha, $tipo, $id){
		// Procura pela token no banco
		$sql = ($tipo == 0) ? "SELECT * FROM TBL_INDICACOES WHERE TOKEN_SENHA = :TOKEN_SENHA AND NU_CLIENTE = :ID" : "SELECT * FROM TBL_INDICACOES WHERE TOKEN_SENHA2 = :TOKEN_SENHA AND NU_CLIENTE = :ID";
		$this->sistema->bd->executar($sql, array(
			':TOKEN_SENHA' => $token,
			':ID' => $this->id
		));

		if($this->sistema->bd->quantidade() > 0){
			// Gera uma nova token e salva a senha no banco
			$nova_token = Utilitarios::gerar_token(50);
			$sql = ($tipo == 0) ? "UPDATE TBL_INDICACOES SET TOKEN_SENHA = :TOKEN_SENHA_NOVA, TXT_SENHA = :TXT_SENHA, NU_ATIVO = 1 WHERE NU_ID = :NU_ID AND TOKEN_SENHA = :TOKEN_SENHA AND NU_CLIENTE = :ID" : "UPDATE TBL_INDICACOES SET TOKEN_SENHA2 = :TOKEN_SENHA_NOVA, TXT_SENHA_TRANSF = :TXT_SENHA WHERE NU_ID = :NU_ID AND TOKEN_SENHA2 = :TOKEN_SENHA AND NU_CLIENTE = :ID";

			$this->sistema->bd->executar($sql, array(
				':TOKEN_SENHA' => $token,
				':TXT_SENHA' => Utilitarios::hash_str($senha),
				':NU_ID' => $id,
				':TOKEN_SENHA_NOVA' => $nova_token,
				':ID' => $this->id
			));

			return -1;
		}
		else{
			return 0;
		}
	}

	/*
	 * Modifica a senha de transferência
	 */
	function modificar_senha_transferencia($senha, $id){
		$nova_token = Utilitarios::gerar_token(50);
		$sql = "UPDATE TBL_INDICACOES SET TOKEN_SENHA2 = :TOKEN_SENHA_NOVA, TXT_SENHA_TRANSF = :TXT_SENHA WHERE NU_ID = :NU_ID AND NU_CLIENTE = :ID";

		$this->sistema->bd->executar($sql, array(
			':TXT_SENHA' => Utilitarios::hash_str($senha),
			':NU_ID' => $id,
			':TOKEN_SENHA_NOVA' => $nova_token,
			':ID' => $this->id
		));
	}

	// Obtém os dados principais do indicador que são exibidos na tela inicial do sistema de indicações
	function obter_dados_gerais_indicador($id){
		$resultado = $this->obter_indicador($id);
		$saldo = $this->usa_pontos == "1" ?
			number_format($resultado['TXT_SALDO'],0,',','.') :
			$this->simbolo_dinheiro.' '. number_format(floatval($resultado['TXT_SALDO']) / 100,2,",",".");
		$saldo_cadastro = $this->usa_pontos == "1" ?
			number_format($resultado['TXT_SALDO_CADASTRO'],0,',','.') :
			$this->simbolo_dinheiro.' '. number_format(floatval($resultado['TXT_SALDO_CADASTRO']) / 100,2,",",".");

		// Seleciona todos os indicados do indicador desejado
		$sql = "SELECT * FROM TBL_INDICACOES WHERE NU_CPF_IND = :cpf AND NU_CLIENTE = :idcliente";
		$dados = $this->sistema->bd->executar($sql, array(
			":idcliente" => $this->id, ':cpf' => $resultado['NU_CPF']
		), Banco_Dados::FETCH_ALL);

		$fechados = 0;
		$total = 0;
		foreach ($dados as $row){
			$status = $row['TXT_STATUS'];
			$total += 1;
			if($status == 'Fechado')
				$fechados += 1;
		}

		return array(
			"saldo" => $saldo,
			"indicados" => $total,
			"indicadosfechados" => $fechados,
			"saldocadastro" => $saldo_cadastro,
		);
	}

	// Verifica se o indicador com ID especificada possui permissão para visualizar o usuário com id especificada
	function indicador_possui_permissao($id_indicador, $id_visualizar){
		// Obtém o indicador
		$resultado = $this->obter_indicador($id_indicador);
		$cpf_indicador = $resultado['NU_CPF'];

		// Se o indicador não existe, retorna falso
		if($this->sistema->bd->quantidade() == 0){
			return false;
		}

		// Obtém o usuário que será visualizado
		$resultado = $this->obter_usuario($id_visualizar);

		// Se o usuário não existe, retorna falso
		if($this->sistema->bd->quantidade() == 0){
			return false;
		}

		$comissoes = $this->comissoes;
		$niveis = count($comissoes);
		$counter = 1;
		$cpf_original = $resultado['NU_CPF'];
		$indicador_atual = $resultado['NU_CPF_IND'];
		$nome = $resultado['TXT_NOME'];
		$cpf = $cpf_original;

		if($cpf_original != $cpf_indicador){ // Se o usuário a ser visualizado não é o mesmo usuário que está visualizando
			$cpf = $indicador_atual;
			while($counter < $niveis & $cpf != $cpf_indicador & !empty($cpf)){ // Enquanto não ultrapassar o limite da árvore de comissões e não achar o cpf de quem quer visualizar
				$indicador = $this->obter_usuario_por_cpf($cpf);

				if($this->sistema->bd->quantidade() == 0){
					return false;
				}

				$cpf = $indicador['NU_CPF_IND'];
				$counter++;
			}
		}

		if($cpf != $cpf_indicador){
			return false;
		}

		$this->ultimo_nivel = $counter;
		return true;
	}

	// Obtem a lista de indicados do indicador com a primeira ID especificada, restringindo que eles sejam da árvore do segundo indicador especificado
	function obter_indicados_para_indicador($id_indicado, $id_indicador){
		if($id_indicado == "-1"){
			$id_indicado = $id_indicador;
		}
		if(!$this->indicador_possui_permissao($id_indicador, $id_indicado))
			return -1;

		$resultado = $this->obter_indicador($id_indicador);
		$cpf_original = $resultado['NU_CPF'];
		$nome_original = $resultado['TXT_NOME'];

		// Seleciona todos os indicados do indicador desejado
		$resultado = $this->obter_indicador($id_indicado);
		$nome_indicador = $resultado['TXT_NOME'];

		$sql = "SELECT TBL_INDICACOES.*, COUNT(DISTINCT TBL_INDICACOES_COMISSOES_UNICAS.NU_ID) as NU_FECHAMENTOS FROM TBL_INDICACOES LEFT JOIN TBL_INDICACOES_COMISSOES_UNICAS ON TBL_INDICACOES_COMISSOES_UNICAS.ID_INDICADOR = TBL_INDICACOES.NU_ID WHERE TBL_INDICACOES.NU_CLIENTE = :idcliente AND TBL_INDICACOES.NU_CPF_IND = :cpf GROUP BY 1 ORDER BY TBL_INDICACOES.NU_ID";
		$dados = $this->sistema->bd->executar($sql, array(
			":idcliente" => $this->id, ':cpf' => $resultado['NU_CPF']
		), Banco_Dados::FETCH_ALL);
		$rows = array();
		$rows[] = array();
		$rows[0]['nome'] = "Indicados de ".$nome_indicador;

		/* Organiza todos os dados para enviar por json. */
		foreach($dados as $row){
			$qualidade = $row['TXT_QUALIDADE'];
			if(empty($qualidade)){
				$qualidade = $this->sistema->layout->qualidades_cliente[0];
			}
			$tipo = $row['NU_TIPO'] == '0' ? "Indicado" : $tipo = "Indicador";
			$nome = $row['TXT_NOME'];
			$fechamentos = $row['NU_FECHAMENTOS'];

			if ($this->mascara_dinheiro === 'eua') {
				$valor_orcado = Mascara::converter_para_dolar($row['VALOR_COMBINADO']);
			} else {
				$valor_orcado = Mascara::converter_para_real($row['VALOR_COMBINADO']);
			}

			$possui_indicados = $this->possui_indicados($row['NU_CPF']) & $this->ultimo_nivel < count($this->comissoes) - 1  ? "1" : "0";
			$nivel = "1";

			// Montamos a array com os dados dessa indicação específica
			$rows[] = array(
				'id' => $row['NU_ID'],
				'nome' => $nome,
				'data' => $row['DT_PREENCHIMENTO'],
				'status' => $row['TXT_STATUS'],
				'tipo' => $tipo,
				'indicadopor' => $nome_indicador,
				'sub' => $possui_indicados,
				'fechamentos' => $fechamentos,
				'telefone' => $row['TEL_CEL'],
				'email' => $row['TXT_EMAIL'],
				'nivel' => $nivel
			);
		}

		return $rows;
	}

	/* Obtém os pagamentos pendentes do indicador */
	function obter_pagamentos_pendentes_do_indicador($cpf){
		return $this->sistema->bd->executar("SELECT * FROM TBL_PAG_PENDENTES WHERE NU_PROCESSADO = 0 AND CPF_INDICADOR = :cpf AND ID_CLIENTE = :id AND ID_PRODUTO = -1", array(
			":cpf" => $cpf,
			":id" => $this->id
		), Banco_Dados::FETCH_ALL);
	}

	/* Transfere o saldo de um usuário para outro */
	function transferir_saldo($id, $valor, $senha, $cpf){
		$destino = preg_replace('#[^0-9]#','',strip_tags($cpf));
		if($this->usa_pontos == "1"){
			$valor = preg_replace('#[^0-9]#','',strip_tags($valor));
			$valor = intval($valor);
		}
		else{
			$valor = str_replace(".","",$valor);
			$valor = str_replace(",",".",$valor);
			$valor = intval(number_format(floatval($valor),2,"",""));
		}

		$dados = $this->obter_usuario($id);
		$cpf_origem = $dados['NU_CPF'];
		$nome_origem = $dados['TXT_NOME'];

		if($destino == $cpf_origem){
			return 4;
		}

		if($this->sistema->bd->quantidade() > 0 & crypt($senha, $dados['TXT_SENHA_TRANSF']) === $dados['TXT_SENHA_TRANSF']){
			$saldo = intval($dados['TXT_SALDO']);

			if(empty($valor) || $valor == 0){
				return 5;
			}

			if($valor > $saldo){ // Se tentou sacar mais do que tem, ou se o valor é zero, retorna um código de erro
				return 2;
			}

			$dados = $this->obter_usuario_por_cpf($destino);

			if($this->sistema->bd->quantidade() == 0){
				return 3;
			}

			$saldo_destino = intval($dados['TXT_SALDO']);
			$nome_destino = $dados['TXT_NOME'];
			$email_destino = $dados['TXT_EMAIL'];
			$id_destino = $dados['NU_ID'];
			$saldo -= $valor;
			$saldo_destino += $valor;

			// Muda o saldo dos envolvidos no banco
			$this->mudar_saldo($saldo_destino, $destino);
			$this->mudar_saldo($saldo, $cpf_origem);

			// Prepara os dados que serão enviados por email
			if($this->usa_pontos == "1"){
				$vl = intval($saldo);
				$strvl = number_format($vl,0,',','.');
				$saldo = $strvl;

				$vl = intval($saldo_destino);
				$strvl = number_format($vl,0,',','.');
				$saldo_destino = $strvl;

				$vl = intval($valor);
				$strvl = number_format($vl,0,',','.');
				$valor = $strvl . " pontos";

				date_default_timezone_set('America/Sao_Paulo');
				$timestamp = time();
				$dataex = date('d/m/Y H:i:s', $timestamp);
				$data_alteracao = date('Y-m-d H:i:s', $timestamp);

				// Adiciona o histórico de origem
				$this->adicionar_historico_novo($id, $id_destino, $nome_destino, $destino, $this->simbolo_dinheiro." 0,00", "--", "-".$valor, "Transferência", $data_alteracao);
				$this->adicionar_historico_antigo($cpf_origem, $nome_destino, $destino, $saldo,"-".$valor, $dataex, "Transferência");

				// Adiciona o histórico de destino
				$this->adicionar_historico_novo($id_destino, $id, $nome_origem, $cpf_origem, $this->simbolo_dinheiro." 0,00", "--", "+".$valor, "Transferência", $data_alteracao);
				$this->adicionar_historico_antigo($destino, $nome_origem, $cpf_origem, $saldo_destino,"+".$valor, $dataex, "Transferência");

				// Envia o email avisando da transferência
				$mensagem = '<p style="color: #000;">Olá, '.$nome_destino.' !</p><p>Informamos que você recebeu uma transferência de '.$valor.', em nome de '.$nome_origem.', de CPF '.Mascara::mascara_cpf_cnpj($cpf_origem).'.</p><p style="color: #000;"> Para mais informações, logue na sua conta <a href="http://'.$this->dominio.'/" style="color: #000;">clicando aqui!</a></p>';
				$this->sistema->enviar_email_indicacao($mensagem, "Transferência para sua Conta", $email_destino, $this->nome);
				return -1;
			}
			else{
				$vl = floatval(intval($saldo)) / 100;
				$strvl = $this->simbolo_dinheiro.' '. number_format($vl,2,',','.');
				$saldo = $strvl;

				$vl = floatval(intval($saldo_destino)) / 100;
				$strvl = $this->simbolo_dinheiro.' '. number_format($vl,2,',','.');
				$saldo_destino = $strvl;

				$vl = floatval(intval($valor)) / 100;
				$strvl = $this->simbolo_dinheiro.' '. number_format($vl,2,',','.');
				$valor = $strvl;

				date_default_timezone_set('America/Sao_Paulo');
				$timestamp = time();
				$dataex = date('d/m/Y H:i:s', $timestamp);
				$data_alteracao = date('Y-m-d H:i:s', $timestamp);

				// Adiciona o histórico de origem
				$this->adicionar_historico_novo($id, $id_destino, $nome_destino, $destino, $this->simbolo_dinheiro." 0,00", "--", "-".$valor, "Transferência", $data_alteracao);
				$this->adicionar_historico_antigo($cpf_origem, $nome_destino, $destino, $saldo,"-".$valor, $dataex, "Transferência");

				// Adiciona o histórico de destino
				$this->adicionar_historico_novo($id_destino, $id, $nome_origem, $cpf_origem, $this->simbolo_dinheiro." 0,00", "--", "+".$valor, "Transferência", $data_alteracao);
				$this->adicionar_historico_antigo($destino, $nome_origem, $cpf_origem, $saldo_destino,"+".$valor, $dataex, "Transferência");

				// Envia o email avisando da transferência
				$mensagem = '<p style="color: #000;">Olá, '.$nome_destino.' !</p><p>Informamos que você recebeu uma transferência de '.$valor.', em nome de '.$nome_origem.', de CPF '.Mascara::mascara_cpf_cnpj($cpf_origem).'.</p><p style="color: #000;"> Para mais informações, logue na sua conta <a href="http://'.$this->dominio.'/" style="color: #000;">clicando aqui!</a></p>';
				$this->sistema->enviar_email_indicacao($mensagem, "Transferência para sua Conta", $email_destino, $this->nome);
				return -1;
			}
		}
		else{
			return 0;
		}
	}

	/* Faz o resgate de um prêmio */
	function resgatar_premio($id, $id_premio){
		if($this->usa_pontos != "1") return;

		$dados = $this->obter_usuario($id);

		if($this->sistema->bd->quantidade() > 0){ // Se encontrou
			$saldo = intval($dados['TXT_SALDO']);
			$saldo_cadastro = $dados['TXT_SALDO_CADASTRO'] ? intval($dados['TXT_SALDO_CADASTRO']) : 0;
			$cpf = $dados['NU_CPF'];
			$nome = $dados['TXT_NOME'];

			$premio = $this->obter_premio($id_premio);
			$nome_premio = $premio['nome'];
			$pontos = intval($premio['pontos']);
			$estoque = $premio['estoque'] == "--" ? 0 : intval($premio['estoque']) - 1;
			$trocas = intval($premio['trocas']) + 1;
			$resgatenormal = $premio['resgatenormal'];
			$saldo_cadastro_gasto = 0;
			
			if($resgatenormal == 1){
				if($pontos > $saldo) return;
				$saldo -= $pontos;
				// Remove o valor do saldo
				$this->mudar_saldo($saldo, $this->sistema->usuario->cpf);
			}
			else{
				if($pontos > ($saldo + $saldo_cadastro)) return;

				$saldo_cadastro_gasto = 0;
				$pontos_pendentes = $pontos;
				if($pontos_pendentes > $saldo_cadastro){
					$saldo_cadastro_gasto = $saldo_cadastro;
					$pontos_pendentes -= $saldo_cadastro;
					$saldo_cadastro = 0;
				}
				else{
					$saldo_cadastro_gasto = $pontos_pendentes;
					$saldo_cadastro -= $pontos_pendentes;
					$pontos_pendentes = 0;
				}
				if($pontos_pendentes > 0){
					$saldo -= $pontos_pendentes;
					$pontos_pendentes = 0;
				}
				$this->mudar_saldo($saldo, $this->sistema->usuario->cpf);
				$this->mudar_saldo_cadastro($saldo_cadastro, $this->sistema->usuario->cpf);
				
			}
			

			// Insere o pagamento pendente no banco
			$this->sistema->bd->executar("INSERT INTO TBL_PAG_PENDENTES (ID_CLIENTE, CPF_INDICADOR, TXT_VALOR, ID_PRODUTO, TXT_SALDO_CADASTRO) VALUES (:ID_CLIENTE, :CPF_INDICADOR, :TXT_VALOR, :ID_PRODUTO, :SALDO_CADASTRO)", array(
				':ID_CLIENTE' => $this->id,
				':CPF_INDICADOR' => $cpf,
				':TXT_VALOR' => $pontos,
				':ID_PRODUTO' => $id_premio,
				':SALDO_CADASTRO' => $saldo_cadastro_gasto
			));

			$this->sistema->bd->executar("UPDATE TBL_INDICACOES_PRODUTOS SET NU_ESTOQUE = :estoque, NU_TROCAS = :trocas WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2", array(
				':estoque' => $estoque,
				':id' => $id_premio,
				':id2' => $this->id,
				':trocas' => $trocas
			));

			// Formata os dados para envio de email
			$strvl = number_format($saldo,0,',','.') . " pontos";
			$saldo = $strvl;

			$strvl = number_format($pontos,0,',','.');
			$valor = $strvl;

			date_default_timezone_set('America/Sao_Paulo');
			$timestamp = time();
			$dataex = date('d/m/Y H:i:s', $timestamp);
			$data_alteracao = date('Y-m-d H:i:s', $timestamp);

			// Adiciona a mudança de saldo no histórico
			$this->adicionar_historico_novo($id, $id, $nome, $cpf, $this->simbolo_dinheiro." 0,00", "--", "-".$valor." pontos", "Resgate de Bônus", $data_alteracao, $id_premio);
			$this->adicionar_historico_antigo($cpf, $nome, $cpf, $saldo,"-".$valor." pontos", $dataex, "Resgate de Bônus", $id_premio);

			// Envia o email aos administradores avisando do pedido
			date_default_timezone_set('America/Sao_Paulo');
			$data_assunto = " - ". date('d/m/Y H:i:s');
			$mensagem = '<p style="color: #000;">Um novo pedido de resgate de bônus foi feito no Clube de Vantagens '.$this->nome.'!</p>
			<table cellpadding="6" style="padding: 0px 0px 0px 0px;border:1px solid #e2e2e2;border-radius: 9px;margin: auto;">
				<tbody><tr><td><b>Nome:</b></td><td>'.$nome.'</td></tr>
				<tr style="background-color: whitesmoke;"><td><b>CPF:</b></td><td>'.Mascara::mascara_cpf_cnpj($cpf).'</td></tr>
				<tr><td><b>Prêmio:</b></td><td>'.$nome_premio.'</td></tr></tbody>
			</table>';
			$this->sistema->enviar_email_indicacao($mensagem,"Novo pedido de resgate".$data_assunto, Sistema::email_adm($this->email), $this->nome);

			return -1;
		}
		else{
			return 0;
		}
	}

	/* Faz uma solicitação de resgate para o usuário */
	function resgatar_saldo($id, $valor, $senha){
		$valor = str_replace(".","",$valor);
		$valor = str_replace(",",".",$valor);
		$valor = intval(number_format(floatval($valor),2,"",""));

		$dados = $this->obter_usuario($id);

		if($this->sistema->bd->quantidade() > 0 & crypt($senha, $dados['TXT_SENHA_TRANSF']) === $dados['TXT_SENHA_TRANSF']){ // Se encontrou
			$saldo = intval($dados['TXT_SALDO']);
			$cpf = $dados['NU_CPF'];
			$nome = $dados['TXT_NOME'];

			if(empty($valor) || $valor == 0){
				return 4;
			}
			if($valor > $saldo){ // Se tentou sacar mais do que tem, ou se o valor é zero, retorna um código de erro
				return 2;
			}
			$saldo -= $valor;

			// Remove o valor do saldo
			$this->mudar_saldo($saldo, $this->sistema->usuario->cpf);

			// Insere o pagamento pendente no banco
			$this->sistema->bd->executar("INSERT INTO TBL_PAG_PENDENTES (ID_CLIENTE, CPF_INDICADOR, TXT_VALOR) VALUES (:ID_CLIENTE, :CPF_INDICADOR, :TXT_VALOR)", array(
				':ID_CLIENTE' => $this->id,
				':CPF_INDICADOR' => $cpf,
				':TXT_VALOR' => $valor
			));

			// Formata os dados para envio de email
			$vl = floatval(intval($saldo)) / 100;
			$strvl = $this->simbolo_dinheiro.' '. number_format($vl,2,',','.');
			$saldo = $strvl;
			$vl = floatval(intval($valor)) / 100;
			$strvl = $this->simbolo_dinheiro.' '. number_format($vl,2,',','.');
			$valor = $strvl;
			date_default_timezone_set('America/Sao_Paulo');
			$timestamp = time();
			$dataex = date('d/m/Y H:i:s', $timestamp);
			$data_alteracao = date('Y-m-d H:i:s', $timestamp);

			// Adiciona a mudança de saldo no histórico
			$this->adicionar_historico_novo($id, $id, $nome, $cpf, $this->simbolo_dinheiro." 0,00", "--", "-".$valor, "Resgate de Bônus", $data_alteracao);
			$this->adicionar_historico_antigo($cpf, $nome, $cpf, $saldo,"-".$valor, $dataex, "Resgate de Bônus");

			// Envia o email aos administradores avisando do pedido
			date_default_timezone_set('America/Sao_Paulo');
			$data_assunto = " - ". date('d/m/Y H:i:s');
			$mensagem = '<p style="color: #000;">Um novo pedido de resgate de bônus foi feito no sistema '.$this->nome.'!</p><p style="color: #000;">Nome: '.$nome.'<br>CPF: '.Mascara::mascara_cpf_cnpj($cpf).'<br>Valor: '.$valor.'</p>';
			$this->sistema->enviar_email_indicacao($mensagem,"Novo pedido de resgate".$data_assunto, Sistema::email_adm($this->email), $this->nome);

			return -1;
		}
		else{
			return 0;
		}
	}

	/* Obtém o indicador que indicou a pessoa com a ID especificada */
	function obter_superior($id){
		$indicador = $this->obter_indicador($id);

		if($this->sistema->bd->quantidade() > 0 & !empty($indicador['NU_CPF_IND'])){
			return $this->obter_indicador_por_cpf($indicador['NU_CPF_IND']);
		}
		else{
			return -1;
		}
	}

	/* Atualiza os dados de cadastro do indicador */
	function atualizar_dados_indicador($id, $nome, $telefone, $senha){
		$dados = $this->obter_indicador($id);

		if($this->sistema->bd->quantidade() > 0 & crypt($senha, $dados['TXT_SENHA']) === $dados['TXT_SENHA']){
			if(strlen($telefone) < 8 || strlen($nome) <= 1){
				return 0;
			}
			$this->sistema->bd->executar("UPDATE TBL_INDICACOES SET TXT_NOME = :TXT_NOME, TEL_CEL = :TEL_CEL WHERE NU_ID = :NU_ID AND NU_CLIENTE = :ID", array(
				':NU_ID' => $id,
				':TXT_NOME' => $nome,
				':TEL_CEL' => $telefone,
				':ID' => $this->id
			));

			return -1;
		}
		else{
			return 1;
		}
	}

	/* Envia por email um link para mudar a senha de transferência */
	function enviar_link_senha_transferencia($id){
		$token = Utilitarios::gerar_token(50);

		$usuario = $this->obter_indicador($id);

		$this->sistema->bd->executar("UPDATE TBL_INDICACOES SET TOKEN_SENHA2 = :TOKEN_SENHA2 WHERE NU_ID = :NU_ID AND NU_CLIENTE = :ID", array(
			':NU_ID' => $id,
			':TOKEN_SENHA2' => $token,
			':ID' => $this->id
		));

		$mensagem = '<p style="color: #000;">Conforme o solicitado, o seguinte link foi gerado para a modificação de sua senha no sistema '.$this->nome.':</p> <p style="color: #000;"><a href="http://'.$this->dominio.'/trocar-senha?t='.$token.'" style="color: #000; font-size: 14px;">'.$this->dominio.'/trocar-senha?t='.$token.'</p><p style="color: #FFFFFF;">Caso não tenha feito requerimento para a mudança de sua senha, desconsidere este email.</p>';
		$this->sistema->enviar_email_indicacao($mensagem, "Mudança de Senha", $usuario['TXT_EMAIL'], $this->nome);
	}

	/* Envia por email um link para mudar a senha de acesso */
	function enviar_link_senha_acesso($id){
		$token = Utilitarios::gerar_token(50);

		$usuario = $this->obter_indicador($id);

		$this->sistema->bd->executar("UPDATE TBL_INDICACOES SET TOKEN_SENHA = :TOKEN_SENHA WHERE NU_ID = :NU_ID AND NU_CLIENTE = :ID", array(
			':NU_ID' => $id,
			':TOKEN_SENHA' => $token,
			':ID' => $this->id
		));

		$mensagem = '<p style="color: #000;">Conforme o solicitado, o seguinte link foi gerado para a modificação de sua senha no sistema '.$this->nome.':</p> <p style="color: #000;"><a href="http://'.$this->dominio.'/trocar-senha?s='.$token.'" style="color: #000; font-size: 14px;">'.$this->dominio.'/trocar-senha?s='.$token.'</p><p style="color: #FFFFFF;">Caso não tenha feito requerimento para a mudança de sua senha, desconsidere este email.</p>';
		$this->sistema->enviar_email_indicacao($mensagem, "Mudança de Senha", $usuario['TXT_EMAIL'], $this->nome);
	}

	/* Registra um indicado do sistema de indicações padrão */
	function registrar_indicado_normal($usuario, $nome, $email, $telefone, $atualizar){
        $email = str_replace(' ', '', $email);
        $nome = trim($nome);
        $telefone = trim($telefone);
		// Obtém a pessoa que indicou
		$indicador = $this->obter_indicador($_SESSION['indicadorID']);
		$ind_cpf = $indicador['NU_CPF'];
		$nome_indicador = $indicador['TXT_NOME'];
		$email_indicador = $indicador['TXT_EMAIL'];

		// Adiciona o indicado no banco
		$sql = ($atualizar) ? "UPDATE TBL_INDICACOES SET (TXT_NOME = :TXT_NOME, TXT_EMAIL = :TXT_EMAIL, TEL_CEL = :TEL_CEL, NU_CPF = :NU_CPF, NU_CPF_IND = :NU_CPF_IND) WHERE NU_CPF = '$usuario' AND NU_CLIENTE = :ID" : "INSERT INTO TBL_INDICACOES (TXT_NOME, TXT_EMAIL, NU_CPF, TEL_CEL, NU_CPF_IND, NU_CLIENTE) VALUES (:TXT_NOME, :TXT_EMAIL, :NU_CPF, :TEL_CEL, :NU_CPF_IND, :ID)";
		$this->sistema->bd->executar($sql, array(
			':NU_CPF' => $usuario,
			':TXT_NOME' => $nome,
			':TXT_EMAIL' => $email,
			':TEL_CEL' => $telefone,
			':NU_CPF_IND' => $ind_cpf,
			':ID' => $this->id
		));

		// Verifica se é para adicionar nos contatos também, e adiciona se for
		if($this->adicionar_contato == "1"){
			$this->sistema->iniciar_bd_leads();

			$dia = date('Y-m-d');
			$hora = date('H:i');
			$cpf_lead = Mascara::mascara_cpf_cnpj($usuario);
			$dados_extras_lead = "CPF. |$| ".$cpf_lead." |$| Indicador |$| ".$nome_indicador;

			$this->sistema->bd_leads->executar('INSERT INTO TBL_LEADS (NU_TELEFONE1, TXT_EMAIL, ID_CLIENTE_FK, TXT_NOME, DT_DATA_MSG, DT_HORA_MSG, TXT_LEAD_CLIENTE, TXT_LEAD_RAMO, TXT_DADOS_EXTRAS) VALUES (:telefone1, :email, :id, :nome, :data, :hora, :login, :ramo, :campos)', array(
				":telefone1" => $telefone,
				":email" => $email,
				":id" => $this->id,
				":nome" => $nome,
				":data" => $dia,
				":hora" => $hora,
				":login" => $this->cliente,
				":ramo" => $this->ramo,
				":campos" => $dados_extras_lead
			));

			/* INSERIR CAMPOS EXTRAS NO BANCO */
		    if(empty($dados_extras_lead) || $dados_extras_lead == " "){ // Não tem campos extras
		        $dados_extras = array();
		    }
		    else{
		        $dados_extras = $dados_extras_lead;
		        $dados_extras = explode(' |$| ', $dados_extras);
		        $dados_extras = ($dados_extras == false) ? array() : $dados_extras;
		        if(count($dados_extras) % 2 != 0){
		            $dados_extras = array();
		        }
		    }
		    $lastInsertID = $this->sistema->bd_leads->ultima_id();
		    $quantidade_campos = 0;
		    for($contador = 0;$contador < count($dados_extras); $contador += 2){
		        $quantidade_campos++;
		        $nome_ind = $dados_extras[$contador];
		        $conteudo = $dados_extras[$contador+1];
		        $this->sistema->bd_leads->executar('INSERT INTO TBL_LEADS_CAMPOS (NU_ID_LEAD, TXT_NOME, TXT_CONTEUDO, NU_ORDEM) VALUES (:id, :nome, :conteudo, :ordem)', array(
		            ":id" => $lastInsertID,
		            ":nome" => $nome_ind,
		            ":conteudo" => $conteudo,
		            ":ordem" => $quantidade_campos
		        ));
		    }
		    /* FIM DE INSERIR CAMPOS EXTRAS NO BANCO */
		}

		// Envia o email ao indicador avisando do registro
		$mensagem_email = $this->vocabulario[10];
		$mensagem_email = str_replace("#DOMINIO#", $this->dominio, $mensagem_email);
		$mensagem_email = str_replace("#NOME-INDICADO#", $nome, $mensagem_email);
		$mensagem_email = str_replace("#EMAIL-INDICADO#", $email, $mensagem_email);
		$mensagem_email = str_replace("#TELEFONE-INDICADO#", $telefone, $mensagem_email);
		$this->sistema->enviar_email_indicacao($mensagem_email,"Novo indicado", $email_indicador, $this->nome);

		// Envia ao indicado o email confirmando a incrição
		$mensagem_email = $this->vocabulario[11];
		$mensagem_email = str_replace("#NOME-INDICADO#", $nome, $mensagem_email);
		$this->sistema->enviar_email_indicacao($mensagem_email, "Registro feito com sucesso!", $email, $this->nome);

		// Envia um email aos administradores
		$cpf_cnpj = Mascara::mascara_cpf_cnpj($usuario);
		$cpf_cnpj_str = strlen($usuario) == 11 ? "CPF" : "CNPJ";
		date_default_timezone_set('America/Sao_Paulo');
		$data_assunto = " - ". date('d/m/Y H:i:s');
		$mensagem = '<p style="color: #000;">Um indicado acaba de ser registrado no sistema '.$this->nome.'!</p>
		<table cellpadding="6" style="padding: 0px 0px 0px 0px;border:1px solid #e2e2e2;border-radius: 9px;margin: auto;">
		<tbody><tr><td><b>Nome:</b></td><td>'.$nome.'</td></tr>
		<tr style="background-color: whitesmoke;"><td><b>'.$cpf_cnpj_str.':</b></td><td>'.$cpf_cnpj.'</td></tr>
		<tr><td><b>E-mail:</b></td><td>'.$email.'</td></tr>
		<tr style="background-color: whitesmoke;"><td><b>Telefone:</b></td><td>'.$telefone.'</td></tr></tbody>
	</table>';
		$this->sistema->enviar_email_indicacao($mensagem,"Novo indicado".$data_assunto, Sistema::email_adm($this->email), $this->nome);

		return -1;
	}

	/* Registra um novo indicado do sistema de faculdades */
	function registrar_indicado_faculdade($usuario, $nome, $email, $telefone, $atualizar, $parametros){
        $email = str_replace(' ', '', $email);
        $nome = trim($nome);
        $telefone = trim($telefone);
		// Obtém a pessoa que indicou
		$indicador = $this->obter_indicador($_SESSION['indicadorID']);
		$ind_cpf = $indicador['NU_CPF'];
		$nome_indicador = $indicador['TXT_NOME'];
		$email_indicador = $indicador['TXT_EMAIL'];

		// Adiciona o indicado no banco
		$sql = ($atualizar) ? "UPDATE TBL_INDICACOES SET (TXT_NOME = :TXT_NOME, TXT_EMAIL = :TXT_EMAIL, TEL_CEL = :TEL_CEL, NU_CPF = :NU_CPF, NU_CPF_IND = :NU_CPF_IND, TXT_CURSO = :CURSO, TXT_UNIDADE = :UNIDADE, TXT_DATA_PROVA = :DATAPROVA, TXT_BAIRRO = :BAIRRO, TXT_CIDADE = :CIDADE) WHERE NU_CPF = '$usuario' AND NU_CLIENTE = :ID" : "INSERT INTO TBL_INDICACOES (TXT_NOME, TXT_EMAIL, NU_CPF, TEL_CEL, NU_CPF_IND, NU_CLIENTE, TXT_CURSO, TXT_UNIDADE, TXT_DATA_PROVA, TXT_BAIRRO, TXT_CIDADE) VALUES (:TXT_NOME, :TXT_EMAIL, :NU_CPF, :TEL_CEL, :NU_CPF_IND, :ID, :CURSO, :UNIDADE, :DATAPROVA, :BAIRRO,:CIDADE)";
		$this->sistema->bd->executar($sql, array(
			':NU_CPF' => $usuario,
			':TXT_NOME' => $nome,
			':TXT_EMAIL' => $email,
			':TEL_CEL' => $telefone,
			':NU_CPF_IND' => $ind_cpf,
			':ID' => $this->id,
			':CURSO' => $parametros['curso'],
			':UNIDADE' => $parametros['unidade'],
			':DATAPROVA' => $parametros['data-prova'],
			':BAIRRO' => $parametros['bairro'],
			':CIDADE' => $parametros['cidade']
		));

		// Verifica se é para adicionar nos contatos também, e adiciona se for
		if($this->adicionar_contato == "1"){
			$this->sistema->iniciar_bd_leads();

			$dia = date('Y-m-d');
			$hora = date('H:i');
			$cpf_lead = Mascara::mascara_cpf_cnpj($usuario);
			$dados_extras_lead = "Unidade |$| ".$parametros['unidade']." |$| CPF. |$| ".$cpf_lead." |$| Bairro |$| ".$parametros['bairro']." |$| Cidade |$| ".$parametros['cidade']." |$| Curso |$| ".$parametros['curso']." |$| Captador |$| ".$nome_indicador." |$| Data da Prova |$| ".$parametros['data-prova'];

			$this->sistema->bd_leads->executar('INSERT INTO TBL_LEADS (NU_TELEFONE1, TXT_EMAIL, ID_CLIENTE_FK, TXT_NOME, DT_DATA_MSG, DT_HORA_MSG, TXT_LEAD_CLIENTE, TXT_LEAD_RAMO, TXT_DADOS_EXTRAS) VALUES (:telefone1, :email, :id, :nome, :data, :hora, :login, :ramo, :campos)', array(
				":telefone1" => $telefone,
				":email" => $email,
				":id" => $this->id,
				":nome" => $nome,
				":data" => $dia,
				":hora" => $hora,
				":login" => $this->cliente,
				":ramo" => $this->ramo,
				":campos" => $dados_extras_lead
			));

			/* INSERIR CAMPOS EXTRAS NO BANCO */
		    if(empty($dados_extras_lead) || $dados_extras_lead == " "){ // Não tem campos extras
		        $dados_extras = array();
		    }
		    else{
		        $dados_extras = $dados_extras_lead;
		        $dados_extras = explode(' |$| ', $dados_extras);
		        $dados_extras = ($dados_extras == false) ? array() : $dados_extras;
		        if(count($dados_extras) % 2 != 0){
		            $dados_extras = array();
		        }
		    }
		    $lastInsertID = $this->sistema->bd_leads->ultima_id();
		    $quantidade_campos = 0;
		    for($contador = 0;$contador < count($dados_extras); $contador += 2){
		        $quantidade_campos++;
		        $nome = $dados_extras[$contador];
		        $conteudo = $dados_extras[$contador+1];
		        $this->sistema->bd_leads->executar('INSERT INTO TBL_LEADS_CAMPOS (NU_ID_LEAD, TXT_NOME, TXT_CONTEUDO, NU_ORDEM) VALUES (:id, :nome, :conteudo, :ordem)', array(
		            ":id" => $lastInsertID,
		            ":nome" => $nome,
		            ":conteudo" => $conteudo,
		            ":ordem" => $quantidade_campos
		        ));
		    }
		    /* FIM DE INSERIR CAMPOS EXTRAS NO BANCO */
		}

		// Envia o email ao indicador avisando do registro
		$mensagem_email = $this->vocabulario[10];
		$mensagem_email = str_replace("#DOMINIO#", $this->dominio, $mensagem_email);
		$mensagem_email = str_replace("#NOME-INDICADO#", $nome, $mensagem_email);
		$mensagem_email = str_replace("#EMAIL-INDICADO#", $email, $mensagem_email);
		$mensagem_email = str_replace("#TELEFONE-INDICADO#", $telefone, $mensagem_email);
		$this->sistema->enviar_email_indicacao($mensagem_email,"Novo indicado", $email_indicador, $this->nome);

		// Envia ao indicado o email confirmando a incrição
		$mensagem_email = $this->vocabulario[11];
		$mensagem_email = str_replace("#NOME-INDICADO#", $nome, $mensagem_email);
		$mensagem_email = str_replace("#CPF-INDICADO#", $cpf_lead, $mensagem_email);
		$mensagem_email = str_replace("#UNIDADE#", $parametros['unidade'], $mensagem_email);
		$mensagem_email = str_replace("#CURSO#", $parametros['curso'], $mensagem_email);
		$mensagem_email = str_replace("#DATA-PROVA#", $parametros['data-prova'], $mensagem_email);
		$mensagem_email = str_replace("#TELEFONE#", $this->telefone, $mensagem_email);
		$this->sistema->enviar_email_indicacao($mensagem_email, "Registro feito com sucesso!", $email, $this->nome);

		// Envia um email aos administradores
		$cpf_cnpj = Mascara::mascara_cpf_cnpj($usuario);
		$cpf_cnpj_str = strlen($usuario) == 11 ? "CPF" : "CNPJ";
		date_default_timezone_set('America/Sao_Paulo');
		$data_assunto = " - ". date('d/m/Y H:i:s');
		if($this->id == "282" || $this->id == "356"){
			$envio_emails = Sistema::email_redejk($parametros['unidade']);
			$mensagem = '<p style="color: #000;">Um indicado acaba de ser registrado no sistema '.$this->nome.'!</p>
			<table cellpadding="6" style="padding: 0px 0px 0px 0px;border:1px solid #e2e2e2;border-radius: 9px;margin: auto;">
				<tbody><tr><td><b>Nome:</b></td><td>'.$nome.'</td></tr>
				<tr style="background-color: whitesmoke;"><td><b>'.$cpf_cnpj_str.':</b></td><td>'.$cpf_cnpj.'</td></tr>
				<tr><td><b>E-mail:</b></td><td>'.$email.'</td></tr>
				<tr style="background-color: whitesmoke;"><td><b>Telefone:</b></td><td>'.$telefone.'</td></tr>
				<tr><td><b>Unidade:</b></td><td>'.$parametros['unidade'].'</td></tr>
				<tr style="background-color: whitesmoke;"><td><b>Curso:</b></td><td>'.$parametros['curso'].'</td></tr></tbody>
			</table>';

			$this->sistema->enviar_email_indicacao($mensagem,"Novo indicado".$data_assunto,$envio_emails,$this->nome);
		}
		else{
			$mensagem = '<p style="color: #000;">Um indicado acaba de ser registrado no sistema '.$this->nome.'!</p>
			<table cellpadding="6" style="padding: 0px 0px 0px 0px;border:1px solid #e2e2e2;border-radius: 9px;margin: auto;">
				<tbody><tr><td><b>Nome:</b></td><td>'.$nome.'</td></tr>
				<tr style="background-color: whitesmoke;"><td><b>'.$cpf_cnpj_str.':</b></td><td>'.$cpf_cnpj.'</td></tr>
				<tr><td><b>E-mail:</b></td><td>'.$email.'</td></tr>
				<tr style="background-color: whitesmoke;"><td><b>Telefone:</b></td><td>'.$telefone.'</td></tr>
				<tr><td><b>Unidade:</b></td><td>'.$parametros['unidade'].'</td></tr>
				<tr style="background-color: whitesmoke;"><td><b>Curso:</b></td><td>'.$parametros['curso'].'</td></tr></tbody>
			</table>';



			$this->sistema->enviar_email_indicacao($mensagem,"Novo indicado".$data_assunto,Sistema::email_adm($this->email),$this->nome);
		}
		return -1;
	}

	/* Registra um novo indicador */
	function registrar_indicado($usuario, $nome, $email, $telefone, $params){
		$dados = $this->obter_usuario_por_cpf($usuario);

		if($this->sistema->bd->quantidade() > 0){
			return 0;
		}
		else{
			if($this->tipo == Sistema_Indicacoes::FACULDADES)
				return $this->registrar_indicado_faculdade($usuario, $nome, strtolower($email), $telefone, false, $params);
			else
				return $this->registrar_indicado_normal($usuario, $nome, strtolower($email), $telefone, false);
		}
	}
}
?>