<?php
/***
	Esta classe é responsável por controlar os logs
***/
class Sistema_Logs{
	function __construct($sistema){
		$this->sistema = $sistema;
	}

	function adicionar_log($titulo, $usuario, $login, $importancia, $tipo, $descricao, $detalhes, $id_usuario = ""){
		if(empty($id_usuario)){
			$id_usuario = $this->sistema->usuario->id;
		}
		$this->sistema->bd->executar("INSERT INTO TBL_LOG_CLIENTE (ID_CLIENTE_FK, TXT_TITULO, TXT_DETALHES, TXT_NOME_USUARIO, TXT_LOGIN_USUARIO, NU_IMPORTANCIA, TXT_TIPO, TXT_DESCRICAO) VALUES (:id, :titulo, :detalhes, :nome, :login, :importancia, :tipo, :descricao)", array(
			":id" => $id_usuario,
			":titulo" => $titulo,
			":detalhes" => $detalhes,
			":nome" => $usuario,
			":login" => $login,
			":importancia" => $importancia,
			":tipo" => $tipo,
			":descricao" => $descricao
		));
	}

	function adicionar_log_adm($titulo, $usuario, $login, $importancia, $tipo, $descricao, $detalhes){
		$this->sistema->bd->executar("INSERT INTO TBL_LOG_ADM (TXT_TITULO, TXT_DETALHES, TXT_NOME_USUARIO, TXT_LOGIN_USUARIO, NU_IMPORTANCIA, TXT_TIPO, TXT_DESCRICAO) VALUES (:titulo, :detalhes, :nome, :login, :importancia, :tipo, :descricao)", array(
			":titulo" => $titulo,
			":detalhes" => $detalhes,
			":nome" => $usuario,
			":login" => $login,
			":importancia" => $importancia,
			":tipo" => $tipo,
			":descricao" => $descricao
		));
	}

	function obter_entrada($id){
		return $this->sistema->bd->executar("SELECT * FROM TBL_LOG_CLIENTE WHERE ID_CLIENTE_FK = :id AND NU_ID = :id2", array(":id" => $this->sistema->usuario->id, ":id2" => $id), Banco_Dados::FETCH);
	}

	function obter_entrada_adm($id){
		return $this->sistema->bd->executar("SELECT * FROM TBL_LOG_ADM WHERE NU_ID = :id", array(":id" => $id), Banco_Dados::FETCH);
	}

	function adicionar_log_alteracao_contato($contato){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" salvou os dados do contato \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Salvou um contato", $usuario["TXT_NOME"], "--", 0, "Alteração de Contatos", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" salvou os dados do contato \"".$contato['TXT_NOME']."\" do cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do lead: ".$contato['ID_LEAD']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Salvou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Contatos", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" salvou os dados do contato \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Salvou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Contatos", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" salvou os dados do contato \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Salvou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Contatos", $descricao, $detalhes);
		}
	}

	function adicionar_log_alteracao_usuario_arquivos($contato){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" salvou os dados do usuário do sistema de arquivos \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID'];
			$this->adicionar_log("Salvou um usuário", $usuario["TXT_NOME"], "--", 0, "Alteração de Usuários", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" salvou os dados do usuário do sistema de arquivos \"".$contato['TXT_NOME']."\" do cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Salvou um usuário", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Usuários", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" salvou os dados do usuário do sistema de arquivos \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID'];
			$this->adicionar_log("Salvou um usuário", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Usuários", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" salvou os dados do usuário do sistema de arquivos \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID'];
			$this->adicionar_log("Salvou um usuário", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Usuários", $descricao, $detalhes);
		}
	}

	function adicionar_log_delecao_contato($contato){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" enviou o contato \"".$contato['TXT_NOME']."\" para a lixeira.";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Deletou um contato", $usuario["TXT_NOME"], "--", 1, "Alteração de Contatos", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" enviou o contato \"".$contato['TXT_NOME']."\" do cliente \"".$this->sistema->usuario->nome."\" para a lixeira.";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do lead: ".$contato['ID_LEAD']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Deletou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Contatos", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" enviou o contato \"".$contato['TXT_NOME']."\" para a lixeira.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Deletou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Contatos", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" enviou o contato \"".$contato['TXT_NOME']."\" para a lixeira.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Deletou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Contatos", $descricao, $detalhes);
		}
	}

	function adicionar_log_delecao_usuario_arquivos($contato){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" deletou o usuário do sistema de arquivos \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID'];
			$this->adicionar_log("Deletou um usuário", $usuario["TXT_NOME"], "--", 1, "Alteração de Usuários", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" deletou o usuário do sistema de arquivos \"".$contato['TXT_NOME']."\" do cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Deletou um usuário", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Usuários", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" deletou o usuário do sistema de arquivos \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID'];
			$this->adicionar_log("Deletou um usuário", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Usuários", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" deletou o usuário do sistema de arquivos \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID'];
			$this->adicionar_log("Deletou um usuário", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Usuários", $descricao, $detalhes);
		}
	}

	function adicionar_log_restauracao_contato($contato){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" restaurou o contato \"".$contato['TXT_NOME']."\" da lixeira.";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Restaurou um contato", $usuario["TXT_NOME"], "--", 1, "Alteração de Contatos", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" restaurou o contato \"".$contato['TXT_NOME']."\" do cliente \"".$this->sistema->usuario->nome."\" da lixeira.";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do lead: ".$contato['ID_LEAD']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Restaurou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Contatos", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" restaurou o contato \"".$contato['TXT_NOME']."\" da lixeira.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Restaurou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Contatos", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" restaurou o contato \"".$contato['TXT_NOME']."\" da lixeira.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Restaurou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Contatos", $descricao, $detalhes);
		}
	}

	function adicionar_log_alteracao_premio($premio, $nome_antigo){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" salvou os dados do prêmio \"".$nome_antigo."\". Novos dados: <br>Nome: ".$premio['nome']."<br>Estoque: ".$premio['estoque']."<br>Pontos: ".$premio['pontos']."<br>Imagem: ".$premio['link'];
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do prêmio: ".$premio['id'];
			$this->adicionar_log("Salvou um prêmio", $usuario["TXT_NOME"], "--", 1, "Alteração de Prêmios", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" salvou os dados do prêmio \"".$nome_antigo."\" para o cliente \"".$this->sistema->usuario->nome."\". Novos dados: <br>Nome: ".$premio['nome']."<br>Estoque: ".$premio['estoque']."<br>Pontos: ".$premio['pontos']."<br>Imagem: ".$premio['link'];
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do prêmio: ".$premio['id']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Salvou um prêmio", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Prêmios", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);

			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" salvou os dados do prêmio \"".$nome_antigo."\". Novos dados: <br>Nome: ".$premio['nome']."<br>Estoque: ".$premio['estoque']."<br>Pontos: ".$premio['pontos']."<br>Imagem: ".$premio['link'];
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do prêmio: ".$premio['id'];
			$this->adicionar_log("Salvou um prêmio", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Prêmios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);

			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" salvou os dados do prêmio \"".$nome_antigo."\". Novos dados: <br>Nome: ".$premio['nome']."<br>Estoque: ".$premio['estoque']."<br>Pontos: ".$premio['pontos']."<br>Imagem: ".$premio['link'];
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do prêmio: ".$premio['id'];
			$this->adicionar_log("Salvou um prêmio", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Prêmios", $descricao, $detalhes);
		}
	}

	function adicionar_log_novo_premio($premio){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" adicionou um novo prêmio chamado \"".$premio['TXT_NOME']."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do prêmio: ".$premio['NU_ID'];
			$this->adicionar_log("Adicionou um prêmio", $usuario["TXT_NOME"], "--", 1, "Alteração de Prêmios", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" adicionou um novo prêmio chamado \"".$premio['TXT_NOME']."\" para o cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do prêmio: ".$premio['NU_ID']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Adicionou um prêmio", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Prêmios", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" adicionou um novo prêmio chamado \"".$premio['TXT_NOME']."\".";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do prêmio: ".$premio['NU_ID'];
			$this->adicionar_log("Adicionou um prêmio", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Prêmios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" adicionou um novo prêmio chamado \"".$premio['TXT_NOME']."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do prêmio: ".$premio['NU_ID'];
			$this->adicionar_log("Adicionou um prêmio", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Prêmios", $descricao, $detalhes);
		}
	}

	function adicionar_log_delecao_premio($premio){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" deletou o prêmio \"".$premio['TXT_NOME']."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do prêmio: ".$premio['NU_ID'];
			$this->adicionar_log("Deletou um prêmio", $usuario["TXT_NOME"], "--", 1, "Alteração de Prêmios", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" deletou o prêmio \"".$premio['TXT_NOME']."\" do cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do prêmio: ".$premio['NU_ID']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Deletou um prêmio", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Prêmios", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" deletou o prêmio \"".$premio['TXT_NOME']."\".";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do prêmio: ".$premio['NU_ID'];
			$this->adicionar_log("Deletou um prêmio", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Prêmios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" deletou o prêmio \"".$premio['TXT_NOME']."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do prêmio: ".$premio['NU_ID'];
			$this->adicionar_log("Deletou um prêmio", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Prêmios", $descricao, $detalhes);
		}
	}

	function adicionar_log_novo_contato($contato){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" adicionou um novo contato chamado \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Adicionou um contato", $usuario["TXT_NOME"], "--", 0, "Alteração de Contatos", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" adicionou um novo contato chamado \"".$contato['TXT_NOME']."\" para o cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do lead: ".$contato['ID_LEAD']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Adicionou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Contatos", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" adicionou um novo contato chamado \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Adicionou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Contatos", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" adicionou um novo contato chamado \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do lead: ".$contato['ID_LEAD'];
			$this->adicionar_log("Adicionou um contato", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Contatos", $descricao, $detalhes);
		}
	}

	function adicionar_log_novo_usuario_arquivos($contato){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" adicionou um novo usuário do sistema de arquivos, chamado \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID'];
			$this->adicionar_log("Adicionou um usuário", $usuario["TXT_NOME"], "--", 0, "Alteração de Usuários", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" adicionou um novo usuário do sistema de arquivos, chamado \"".$contato['TXT_NOME']."\", para o cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID']."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Adicionou um usuário", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Usuários", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" adicionou um novo usuário do sistema de arquivos, chamado \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID'];
			$this->adicionar_log("Adicionou um usuário", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Usuários", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" adicionou um novo usuário do sistema de arquivos, chamado \"".$contato['TXT_NOME']."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do usuário do sistema de arquivos: ".$contato['NU_ID'];
			$this->adicionar_log("Adicionou um usuário", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Usuários", $descricao, $detalhes);
		}
	}

	function adicionar_log_mudanca_senha(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" alterou sua senha.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Alterou a senha", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Senha", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" alterou sua senha.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Alterou a senha", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 1, "Alteração de Senha", $descricao, $detalhes);
		}
	}

	function adicionar_log_geracao_relatorio_contato(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de contatos.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Gerou relatório de contatos", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de contatos.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Gerou relatório de contatos", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
	}

	function adicionar_log_geracao_relatorio_ligacoes(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de ligações.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Gerou relatório de ligações", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de ligações.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Gerou relatório de ligações", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
	}

	function adicionar_log_geracao_relatorio_ganhos(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de ganhos de comissão.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Gerou relatório de ganhos de comissão", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de ganhos de comissão.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Gerou relatório de ganhos de comissão", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
	}

	function adicionar_log_geracao_relatorio_palavras(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de palavras-chave.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Gerou relatório de palavras-chave", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de palavras-chave.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Gerou relatório de palavras-chave", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
	}

	function adicionar_log_geracao_relatorio_palavras_negativas(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de palavras-chave negativas.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Gerou relatório de palavras-chave negativas", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de palavras-chave negativas.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Gerou relatório de palavras-chave negativas", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
	}

	function adicionar_log_geracao_relatorio_termos_pesquisa(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de termos de pesquisa.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Gerou relatório de termos de pesquisa", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de termos de pesquisa.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Gerou relatório de termos de pesquisa", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
	}

	function adicionar_log_geracao_relatorio_campanhas(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de campanhas.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Gerou relatório de campanhas", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de campanhas.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Gerou relatório de campanhas", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
	}

	function adicionar_log_geracao_relatorio_grupos(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de grupos de anúncios.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Gerou relatório de grupos de anúncios", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de grupos de anúncios.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Gerou relatório de grupos de anúncios", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
	}

	function adicionar_log_geracao_relatorio_indicacoes(){
		if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de lista de indicações.";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario;
			$this->adicionar_log("Gerou relatório de lista de indicações", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" gerou um relatório de lista de indicações.";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id;
			$this->adicionar_log("Gerou relatório de lista de indicações", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Geração de Relatórios", $descricao, $detalhes);
		}
	}

	function adicionar_log_login($usuario, $tipo){
		if($tipo == 0){
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" logou no sistema.";
			$detalhes = "ID do administrador: ".$usuario['ID_ADM'];
			$this->adicionar_log_adm("Logou no sistema", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Sessão", $descricao, $detalhes);
		}
		else if($tipo == 1){
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" logou no sistema.";
			$detalhes = "ID do subusuário: ".$usuario['NU_ID'];
			$this->adicionar_log("Logou no sistema", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Sessão", $descricao, $detalhes, $usuario['ID_CLIENTE_FK']);
		}
		else{
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" logou no sistema.";
			$detalhes = "ID do usuário: ".$usuario['ID_CLIENTE'];
			$this->adicionar_log("Logou no sistema", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Sessão", $descricao, $detalhes, $usuario['ID_CLIENTE']);
		}
	}

	function adicionar_log_logout(){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT * FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" saiu do sistema (logout).";
			$detalhes = "ID do administrador: ".$usuario['ID_ADM'];
			$this->adicionar_log_adm("Saiu do sistema", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Sessão", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT * FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" saiu do sistema (logout).";
			$detalhes = "ID do subusuário: ".$usuario['NU_ID'];
			$this->adicionar_log("Saiu do sistema", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Sessão", $descricao, $detalhes, $usuario['ID_CLIENTE_FK']);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" saiu do sistema (logout).";
			$detalhes = "ID do usuário: ".$usuario['ID_CLIENTE'];
			$this->adicionar_log("Saiu do sistema", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Sessão", $descricao, $detalhes, $usuario['ID_CLIENTE']);
		}
	}

	function adicionar_log_confirmacao_pagamento($nome, $pagamento, $id){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" confirmou o pagamento do resgate de \"".$pagamento."\" do indicador \"".$nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do resgate: ".$id;
			$this->adicionar_log("Confirmou Pagamento", $usuario["TXT_NOME"], "--", 2, "Alteração de Resgate", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" confirmou o pagamento do resgate de \"".$pagamento."\" do indicador \"".$nome."\" para o cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do resgate: ".$id."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Confirmou Pagamento", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Resgate", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" confirmou o pagamento do resgate de \"".$pagamento."\" do indicador \"".$nome."\".";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do resgate: ".$id;
			$this->adicionar_log("Confirmou Pagamento", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Resgate", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" confirmou o pagamento do resgate de \"".$pagamento."\" do indicador \"".$nome."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do resgate: ".$id;
			$this->adicionar_log("Confirmou Pagamento", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Resgate", $descricao, $detalhes);
		}
	}

	function adicionar_log_cancelamento_pagamento($nome, $pagamento, $id){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" cancelou o pagamento do resgate de \"".$pagamento."\" do indicador \"".$nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do resgate: ".$id;
			$this->adicionar_log("Cancelou Resgate", $usuario["TXT_NOME"], "--", 2, "Alteração de Resgate", $descricao, $detalhes);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" cancelou o pagamento do resgate de \"".$pagamento."\" do indicador \"".$nome."\" para o cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do resgate: ".$id."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Cancelou Resgate", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Resgate", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" cancelou o pagamento do resgate de \"".$pagamento."\" do indicador \"".$nome."\".";
			$detalhes = "ID do subusuário: ".$this->sistema->usuario->id_subusuario."<br>ID do resgate: ".$id;
			$this->adicionar_log("Cancelou Resgate", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Resgate", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" cancelou o pagamento do resgate de \"".$pagamento."\" do indicador \"".$nome."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do resgate: ".$id;
			$this->adicionar_log("Cancelou Resgate", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Resgate", $descricao, $detalhes);
		}
	}

	function adicionar_log_alteracao_valor_indicacao($nome_cliente, $id_cliente, $valor_antigo, $valor_novo){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" alterou o valor fechado do indicado \"".$nome_cliente."\" de \"".$valor_antigo."\" para \"".$valor_novo."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do indicado: ".$id_cliente;
			$this->adicionar_log("Alterou valor fechado", $usuario["TXT_NOME"], "--", 2, "Alteração de Indicações", $descricao, $detalhes);

			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" alterou o valor fechado do indicado \"".$nome_cliente."\" de \"".$valor_antigo."\" para \"".$valor_novo."\" para o cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do indicado: ".$id_cliente."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Alterou valor fechado", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Indicações", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" alterou o valor fechado do indicado \"".$nome_cliente."\" de \"".$valor_antigo."\" para \"".$valor_novo."\".";
			$detalhes = "ID do subusuario: ".$this->sistema->usuario->id_subusuario."<br>ID do indicado: ".$id_cliente;
			$this->adicionar_log("Alterou valor fechado", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Indicações", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" alterou o valor fechado do indicado \"".$nome_cliente."\" de \"".$valor_antigo."\" para \"".$valor_novo."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do indicado: ".$id_cliente;
			$this->adicionar_log("Alterou valor fechado", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Indicações", $descricao, $detalhes);
		}
	}

	function adicionar_log_alteracao_cancelamento_indicacao($nome_cliente, $id_cliente){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" removeu o status de \"Fechado\" do indicado \"".$nome_cliente."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do indicado: ".$id_cliente;
			$this->adicionar_log("Removeu o status \"Fechado\"", $usuario["TXT_NOME"], "--", 2, "Alteração de Indicações", $descricao, $detalhes);

			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" removeu o status de \"Fechado\" do indicado \"".$nome_cliente."\" para o cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do indicado: ".$id_cliente."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Removeu o status \"Fechado\"", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Indicações", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" removeu o status de \"Fechado\" do indicado \"".$nome_cliente."\".";
			$detalhes = "ID do subusuario: ".$this->sistema->usuario->id_subusuario."<br>ID do indicado: ".$id_cliente;
			$this->adicionar_log("Removeu o status \"Fechado\"", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Indicações", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" removeu o status de \"Fechado\" do indicado \"".$nome_cliente."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do indicado: ".$id_cliente;
			$this->adicionar_log("Removeu o status \"Fechado\"", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Indicações", $descricao, $detalhes);
		}
	}

	function adicionar_log_alteracao_fechamento_indicacao($nome_cliente, $id_cliente, $valor_novo){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" adicionou um fechamento no indicado \"".$nome_cliente."\", com o valor fechado de \"".$valor_novo."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do indicado: ".$id_cliente;
			$this->adicionar_log("Adicionou um fechamento", $usuario["TXT_NOME"], "--", 2, "Alteração de Indicações", $descricao, $detalhes);

			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" adicionou um fechamento no indicado \"".$nome_cliente."\", com o valor fechado de \"".$valor_novo."\", para o cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do indicado: ".$id_cliente."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Adicionou um fechamento", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Indicações", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" adicionou um fechamento no indicado \"".$nome_cliente."\", com o valor fechado de \"".$valor_novo."\".";
			$detalhes = "ID do subusuario: ".$this->sistema->usuario->id_subusuario."<br>ID do indicado: ".$id_cliente;
			$this->adicionar_log("Adicionou um fechamento", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Indicações", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" adicionou um fechamento no indicado \"".$nome_cliente."\", com o valor fechado de \"".$valor_novo."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do indicado: ".$id_cliente;
			$this->adicionar_log("Adicionou um fechamento", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 2, "Alteração de Indicações", $descricao, $detalhes);
		}
	}

	function adicionar_log_novo_cliente_adm($nome_cliente, $id_cliente){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" criou um novo cliente chamado \"".$nome_cliente."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do cliente: ".$id_cliente;
		$this->adicionar_log_adm("Criou um cliente", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Alteração de Clientes", $descricao, $detalhes);
	}

	function adicionar_log_salvar_dados_gdrive($nome_cliente, $id_cliente){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" salvou os dados do sistema de arquivos do cliente \"".$nome_cliente."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do cliente: ".$id_cliente;
		$this->adicionar_log_adm("Salvou um cliente", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Sistema de Arquivos", $descricao, $detalhes);
	}

	function adicionar_log_salvar_dados_indicacao($nome_cliente, $id_cliente){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" salvou os dados do sistema de indicação do cliente \"".$nome_cliente."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do cliente: ".$id_cliente;
		$this->adicionar_log_adm("Salvou um cliente", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Sistema de Indicações", $descricao, $detalhes);
	}

	function adicionar_log_salvar_dados_cliente($nome_cliente, $id_cliente){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" salvou os dados do cliente \"".$nome_cliente."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do cliente: ".$id_cliente;
		$this->adicionar_log_adm("Salvou um cliente", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Alteração de Clientes", $descricao, $detalhes);
	}

	function adicionar_log_salvar_novo_seguimento($seguimento){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" criou o seguimento \"".$seguimento."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm;
		$this->adicionar_log_adm("Criou um novo seguimento", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 0, "Criação de seguimento", $descricao, $detalhes);
	}

	function adicionar_log_saque_sistema_indicacoes($nome_sistema, $id_cliente){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" solicitou o saque do saldo da Win7 no sistema de indicações do cliente \"".$nome_sistema."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do cliente: ".$id_cliente;
		$this->adicionar_log_adm("Solicitou saque do sistema de indicações", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Sistema de Indicações", $descricao, $detalhes);
	}

	function adicionar_log_resetar_sistema_indicacoes($nome_sistema, $id_cliente){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" resetou o sistema de indicações do cliente \"".$nome_sistema."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do cliente: ".$id_cliente;
		$this->adicionar_log_adm("Resetou um sistema de indicações", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Sistema de Indicações", $descricao, $detalhes);
	}

	function adicionar_log_duplicar_sistema_indicacoes($nome_sistema, $id_cliente){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" duplicou o sistema do cliente \"".$nome_sistema."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do cliente: ".$id_cliente;
		$this->adicionar_log_adm("Duplicou um sistema", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Alteração de Clientes", $descricao, $detalhes);
	}

	function adicionar_log_zeramento_sistema_indicacoes($nome_sistema, $id_cliente){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" zerou o sistema de indicações do cliente \"".$nome_sistema."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do cliente: ".$id_cliente;
		$this->adicionar_log_adm("Zerou um sistema de indicações", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Sistema de Indicações", $descricao, $detalhes);
	}

	function adicionar_log_visualizacao_resultado_gerais(){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" visualizou a página de resultados gerais.";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm;
		$this->adicionar_log_adm("Visualizou a página de resultado gerais", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 0, "Visualização de Páginas", $descricao, $detalhes);
	}

	function adicionar_log_delecao_agendamento_gsuite($nome_cliente, $id_agendamento){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" deletou o agendamento do GSuite para o cliente \"".$nome_cliente."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do agendamento: ".$id_agendamento;
		$this->adicionar_log_adm("Deletou um agendamento", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Alteração do G Suite", $descricao, $detalhes);
	}

	function adicionar_log_alteracao_agendamento_gsuite($nome_cliente, $id_agendamento){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" salvou o agendamento do GSuite para o cliente \"".$nome_cliente."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do agendamento: ".$id_agendamento;
		$this->adicionar_log_adm("Salvou um agendamento", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 1, "Alteração do G Suite", $descricao, $detalhes);
	}

	function adicionar_log_novo_agendamento_gsuite($nome_cliente, $id_agendamento){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" adicionou um novo agendamento do GSuite para o cliente \"".$nome_cliente."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do agendamento: ".$id_agendamento;
		$this->adicionar_log_adm("Adicionou agendamento", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 1, "Alteração do G Suite", $descricao, $detalhes);
	}

	function adicionar_log_execucao_envio_gsuite(){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" forçou a verificação de envio de e-mails do GSuite.";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm;
		$this->adicionar_log_adm("Executou verificação", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 1, "Alteração do G Suite", $descricao, $detalhes);
	}

	function adicionar_log_reenvio_boleto_gsuite($nome_cliente){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" reenviou o boleto do cliente \"".$nome_cliente."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm;
		$this->adicionar_log_adm("Reenviou boleto", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 1, "Alteração do G Suite", $descricao, $detalhes);
	}

	function adicionar_log_geracao_relatorio_todos_contatos(){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" gerou um relatório de todos os contatos.";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm;
		$this->adicionar_log_adm("Gerou relatório de todos os contatos", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 0, "Geração de Relatórios", $descricao, $detalhes);
	}

	function adicionar_log_delecao_admin($dados){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" deletou o administrador \"".$dados['TXT_NOME']."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do administrador deletado: ".$dados['ID_ADM'];
		$this->adicionar_log_adm("Deletou um administrador", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 2, "Alteração de Administradores", $descricao, $detalhes);
	}

	function adicionar_log_alteracao_admin($dados){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" salvou dados do administrador \"".$dados['TXT_NOME']."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do administrador modificado: ".$dados['ID_ADM'];
		$this->adicionar_log_adm("Salvou um administrador", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 1, "Alteração de Administradores", $descricao, $detalhes);
	}

	function adicionar_log_novo_admin($dados){
		$descricao = "O administrador \"".$this->sistema->usuario->nome_adm."\" criou um novo administrador chamado \"".$dados['TXT_NOME']."\".";
		$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do administrador criado: ".$dados['ID_ADM'];
		$this->adicionar_log_adm("Criou um administrador", $this->sistema->usuario->nome_adm, $this->sistema->usuario->login_adm, 1, "Alteração de Administradores", $descricao, $detalhes);
	}

	function adicionar_log_alteracao_indicacao($nome_cliente, $id_cliente){
		if($this->sistema->usuario instanceof Usuario_Adm){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_ADM WHERE ID_ADM = :id", array(':id' => $this->sistema->usuario->id_adm), Banco_Dados::FETCH);
			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" salvou os dados do indicado(r) \"".$nome_cliente."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do indicado(r): ".$id_cliente;
			$this->adicionar_log("Salvou um indicado(r)", $usuario["TXT_NOME"], "--", 0, "Alteração de Indicações", $descricao, $detalhes);

			$descricao = "O administrador \"".$usuario["TXT_NOME"]."\" salvou os dados do indicado(r) \"".$nome_cliente."\" para o cliente \"".$this->sistema->usuario->nome."\".";
			$detalhes = "ID do administrador: ".$this->sistema->usuario->id_adm."<br>ID do indicado(r): ".$id_cliente."<br>ID do cliente: ".$this->sistema->usuario->id;
			$this->adicionar_log_adm("Salvou um indicado(r)", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Indicações", $descricao, $detalhes);
		}
		else if($this->sistema->usuario instanceof Subusuario_Win7){
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_SUBUSUARIOS WHERE NU_ID = :id", array(':id' => $this->sistema->usuario->id_subusuario), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" salvou os dados do indicado(r) \"".$nome_cliente."\".";
			$detalhes = "ID do subusuario: ".$this->sistema->usuario->id_subusuario."<br>ID do indicado(r): ".$id_cliente;
			$this->adicionar_log("Salvou um indicado(r)", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Indicações", $descricao, $detalhes);
		}
		else{
			$usuario = $this->sistema->bd->executar("SELECT TXT_NOME, TXT_LOGIN FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", array(':id' => $this->sistema->usuario->id), Banco_Dados::FETCH);
			$descricao = "O usuário \"".$usuario["TXT_NOME"]."\" salvou os dados do indicado(r) \"".$nome_cliente."\".";
			$detalhes = "ID do usuário: ".$this->sistema->usuario->id."<br>ID do indicado(r): ".$id_cliente;
			$this->adicionar_log("Salvou um indicado(r)", $usuario["TXT_NOME"], $usuario["TXT_LOGIN"], 0, "Alteração de Indicações", $descricao, $detalhes);
		}
	}

	function obter_log($data, $data_inicial, $data_final){
		$filtro = Filtro::filtrar_data($data, "DT_ALTERACAO", $data_inicial, $data_final); // Montamos o filtro SQL de data
	
		$sql = empty($filtro) ? 
		"SELECT * FROM TBL_LOG_CLIENTE WHERE ID_CLIENTE_FK = :id" :
		"SELECT * FROM TBL_LOG_CLIENTE WHERE ".$filtro." AND ID_CLIENTE_FK = :id";
		
		// Fazemos aqui a consulta dos logs
		$dados = $this->sistema->bd->executar($sql,array(':id' => $this->sistema->usuario->id),Banco_Dados::FETCH_ALL);
		
		$resultado = array();
		foreach($dados as $linha){
			$resultado[] = array(
				'id' => $linha['NU_ID'],
				'acao' => $linha['TXT_TITULO'],
				'usuario' => $linha['TXT_NOME_USUARIO'],
				'login' => $linha['TXT_LOGIN_USUARIO'],
				'data' => $linha['DT_ALTERACAO'],
				'importancia' => $this->importancia($linha['NU_IMPORTANCIA']),
				'tipo' => $linha['TXT_TIPO'],
				'descricao' => $linha['TXT_DESCRICAO']
			);
		}

		return $resultado;
	}

	function obter_log_adm($data, $data_inicial, $data_final){
		$filtro = Filtro::filtrar_data($data, "DT_ALTERACAO", $data_inicial, $data_final); // Montamos o filtro SQL de data
	
		$sql = empty($filtro) ? 
		"SELECT * FROM TBL_LOG_ADM" :
		"SELECT * FROM TBL_LOG_ADM WHERE ".$filtro;
		
		// Fazemos aqui a consulta dos logs
		$dados = $this->sistema->bd->executar($sql,array(),Banco_Dados::FETCH_ALL);
		
		$resultado = array();
		foreach($dados as $linha){
			$resultado[] = array(
				'id' => $linha['NU_ID'],
				'acao' => $linha['TXT_TITULO'],
				'usuario' => $linha['TXT_NOME_USUARIO'],
				'login' => $linha['TXT_LOGIN_USUARIO'],
				'data' => $linha['DT_ALTERACAO'],
				'importancia' => $this->importancia($linha['NU_IMPORTANCIA']),
				'tipo' => $linha['TXT_TIPO'],
				'descricao' => $linha['TXT_DESCRICAO']
			);
		}

		return $resultado;
	}

	function importancia($num){
		switch($num){
			case 0:
				return "Baixa";
			case 1:
				return "Média";
			case 2:
				return "Alta";
		}
	}
}
?>