<?php
/***
 * Esta classe guarda dados sobre o cliente da Win7 que está logado no sistema
 ***/

class Usuario_Adm extends Usuario_Win7
{

    public $id_adm;
    public $nome_adm;
    public $filtro_clientes;

    function __construct($id)
    {
        $this->id_adm          = $id;
        $this->id              = -1;
        $this->filtro_clientes = [];
    }

    /* Método responsável por carregar os dados do usuário */
    function carregar(&$bd)
    {
        $this->home          = "home";
        $params              = [':id' => $this->id_adm];
        $dados_adm           = $bd->executar("SELECT * FROM TBL_ADM WHERE ID_ADM = :id", $params, Banco_Dados::FETCH);
        $this->super_adm_adm = $dados_adm['NU_SUPER_ADM'] == "1";

        if ($this->cliente_carregado()) {
            parent::carregar($bd);
            $this->permissao_leads  = $this->permissao_leads != Usuario::PERM_NENHUMA ? intval($dados_adm['NU_PERM_CONTATOS']) : Usuario::PERM_NENHUMA;
            
            $google                 = $dados_adm['NU_PERM_ADWORDS'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
            $this->permissao_google = $this->permissao_google != Usuario::PERM_NENHUMA ? $google : Usuario::PERM_NENHUMA;
            
            $comparacao             = $dados_adm['NU_PERM_COMPARACAO'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
            $this->permissao_comparacao = $this->permissao_comparacao != Usuario::PERM_NENHUMA ? $comparacao : Usuario::PERM_NENHUMA;
            
            $comparacao_adm             = $dados_adm['NU_PERM_COMPARACAO'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
            $this->permissao_comparacao_adm = $this->permissao_comparacao_adm != Usuario::PERM_NENHUMA ? $comparacao_adm : Usuario::PERM_NENHUMA;
            
            $log                    = $dados_adm['NU_PERM_LOG_USUARIOS'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
            $this->permissao_log    = $log;
            
            $ecx                    = $dados_adm['NU_PERM_WIN7FONE'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
            $this->permissao_3cx    = $this->permissao_3cx != Usuario::PERM_NENHUMA ? $ecx : Usuario::PERM_NENHUMA;

            // Ajusta a permissão ao sistema de indicações, caso ele exista
            $params = [':id' => $this->id];
            $dados  = $bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :id", $params, Banco_Dados::FETCH);
            if ($bd->quantidade() > 0) {
                $this->permissao_indicacoes = intval($dados_adm['NU_PERM_INDICACOES']);
                $this->super_adm_indicacoes = $this->super_adm_adm;
            } else {
                $this->permissao_indicacoes = Usuario::PERM_NENHUMA;
            }

            $params = [':id' => $this->id];
            $dados  = $bd->executar("SELECT * FROM TBL_CLI_GDRIVE WHERE ID_FK = :id", $params, Banco_Dados::FETCH);
            if ($bd->quantidade() > 0) {
                $drive                 = $dados_adm['NU_PERM_ARQUIVOS'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
                $this->permissao_drive = $this->permissao_drive != Usuario::PERM_NENHUMA ? $drive : Usuario::PERM_NENHUMA;
            } else {
                $this->permissao_drive = Usuario::PERM_NENHUMA;
            }
        } else {
            $this->permissao_leads      = intval($dados_adm['NU_PERM_CONTATOS']);
            $this->permissao_google     = $dados_adm['NU_PERM_ADWORDS'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
            $this->permissao_comparacao = $dados_adm['NU_PERM_COMPARACAO'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
            $this->permissao_log        = $dados_adm['NU_PERM_LOG_USUARIOS'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
            $this->permissao_3cx        = $dados_adm['NU_PERM_WIN7FONE'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
            $this->permissao_indicacoes = intval($dados_adm['NU_PERM_INDICACOES']);
            $this->permissao_drive      = $dados_adm['NU_PERM_ARQUIVOS'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
        }

        // Permissões de admin
        $this->permissao_leads_adm        = intval($dados_adm['NU_PERM_CONTATOS']);
        $this->permissao_todos_contatos   = $dados_adm['NU_PERM_TODOS_CONTATOS'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
        $this->permissao_resultados       = $dados_adm['NU_PERM_RESULTADOS_GERAIS'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
        $this->permissao_indicacoes_geral = $dados_adm['NU_PERM_INDICACOES_GERAL'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
        $this->permissao_envio_email      = $dados_adm['NU_PERM_SISTEMA_EMAIL'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
        $this->permissao_sistema_clientes = $dados_adm['NU_PERM_SISTEMA_CLIENTES'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
        $this->permissao_gsuite           = $dados_adm['NU_PERM_GSUITE'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;

        $this->nome_adm  = $dados_adm['TXT_NOME'];
        $this->login_adm = $dados_adm['TXT_LOGIN'];
        $this->sidebar   = $dados_adm['NU_SIDEBAR'] == "1";
        $this->acao      = $dados_adm['TXT_ACAO'];

        $timestamp = time();
        date_default_timezone_set('America/Sao_Paulo');
        $data_alteracao = date('Y-m-d H:i:s', $timestamp);
        $bd->executar("UPDATE TBL_ADM SET DT_ULTIMO_LOGIN = :ultimo WHERE ID_ADM = :id", [
            ':id'     => $this->id_adm,
            ':ultimo' => $data_alteracao,
        ]);

        $time   = date('Y-m-d H:i:s', strtotime("-" . Usuario_Win7::TEMPO_ATIVIDADE . " days"));
        $params = [
            ':data'  => $time,
            ':data2' => $time,
        ];
        $sql    = "SELECT
			(SELECT count(*) FROM TBL_CLIENTE WHERE NU_ACESSOS_SISTEMA_DATA <= :data AND NU_CLIENTE_ATIVO = 1) as naofrequentes,
			(SELECT count(*) FROM TBL_CLIENTE WHERE NU_ACESSOS_SISTEMA_DATA > :data2 AND NU_CLIENTE_ATIVO = 0) as frequentes";

        $dados                = $bd->executar($sql, $params, Banco_Dados::FETCH);
        $this->nao_frequentes = intval($dados['naofrequentes']);
        $this->frequentes     = intval($dados['frequentes']);
    }

    /**
     * Retorna os falsos leads do sistema.
     *
     * @param $bd \Banco_Dados
     * @return array
     */
    function obter_falsos_leads(&$bd)
    {
        $falsos_leads = $bd->executar("SELECT * FROM falso_lead", [], Banco_Dados::FETCH_ALL);

        return $falsos_leads;
    }

    function zerar_acao(&$bd)
    {
        $bd->executar("UPDATE TBL_ADM SET TXT_ACAO = '' WHERE ID_ADM = :id", [":id" => $this->id_adm]);
    }

    /* Indica se foi aberto o sistema de algum cliente dentro do painel de admintração */
    function cliente_carregado()
    {
        return $this->id != -1;
    }

    /* Salva o estado atual da sidebar */
    function salvar_sidebar($opcao, $bd)
    {
        $opcao == "0" ? $opcao = 0 : $opcao = 1;
        $params = [
            ':id'      => $this->id_adm,
            ':sidebar' => $opcao,
        ];
        $bd->executar("UPDATE TBL_ADM SET NU_SIDEBAR = :sidebar WHERE ID_ADM = :id", $params);
    }
}

?>