<?php
/***
	Esta classe guarda dados sobre o usuário do sistema de arquivos logado no sistema
***/

class Usuario_Arquivos extends Usuario_Win7{
	public $id;

	function __construct($id){
		$this->id = $id;
	}

	/* Método responsável por carregar os dados do usuário */
	function carregar(&$sistema){
		$dados = $sistema->bd->executar("SELECT * FROM TBL_GDRIVE_USUARIOS WHERE NU_ID = :ID2 AND ID_FK = :ID", array(
			':ID2' => $this->id,
			':ID' => $sistema->drive->id
		), Banco_Dados::FETCH);
		$this->nome = $dados['TXT_NOME'];
		$this->sidebar = $dados['NU_SIDEBAR'] == "1";
		$this->link = $dados['TXT_LINK'];
	}

	/* Salva o estado atual da sidebar */
	function salvar_sidebar($opcao, $bd){
		$opcao == "0" ? $opcao = 0 : $opcao = 1;
		$params = array(
			':id' => $this->id,
			':sidebar' => $opcao
		);
		$bd->executar("UPDATE TBL_GDRIVE_USUARIOS SET NU_SIDEBAR = :sidebar WHERE NU_ID = :id", $params);
	}
}
?>