<?php
/***
	Esta classe guarda dados sobre o indicador logado no sistema
***/

class Usuario_Indicador extends Usuario_Win7{
	public $id;

	function __construct($id){
		$this->id = $id;
	}

	/* Método responsável por carregar os dados do usuário */
	function carregar(&$sistema){
		$dados = $sistema->bd->executar("SELECT * FROM TBL_INDICACOES WHERE NU_ID = :ID2 AND NU_TIPO = 1 AND NU_CLIENTE = :ID", array(
			':ID2' => $this->id,
			':ID' => $sistema->indicacoes->id
		), Banco_Dados::FETCH);
		$this->nome = $dados['TXT_NOME'];
		$this->sidebar = $dados['NU_SIDEBAR'] == "1";
		$this->saldo = $dados['TXT_SALDO'];
		$this->saldo_cadastro = intval($dados['TXT_SALDO_CADASTRO']);
		$this->cpf = $dados['NU_CPF'];
		$this->senha_transf = $dados['TXT_SENHA_TRANSF'];
	}

	/* Salva o estado atual da sidebar */
	function salvar_sidebar($opcao, $bd){
		$opcao == "0" ? $opcao = 0 : $opcao = 1;
		$params = array(
			':id' => $this->id,
			':sidebar' => $opcao
		);
		$bd->executar("UPDATE TBL_INDICACOES SET NU_SIDEBAR = :sidebar WHERE NU_ID = :id", $params);
	}
}
?>