<?php

/***
	Esta classe guarda dados sobre o cliente da Win7 que está logado no sistema
 ***/

class Usuario_Win7 extends Usuario
{
	public $id_adwords;
	public $data_inicio_3cx;
	public $data_inicio_ads;
	public $data_final_3cx;
	public $ids_3cx;
	public $home;
	public $permissao_google;
	public $permissao_comparacao;
	public $permissao_indicacoes;
	public $permissao_drive;
	public $permissao_leads;
	public $permissao_3cx;
	public $consultoria;
	public $descricao;
	public $sidebar;
	public $comissao;
	public $comissao_fixa;
	public $login;
	public $senha;
	public $senha_antiga;
	public $mostrar_somente_campanhas;
	public $permissao_btn_adicionar_lead;
	public $mostrar_cpl;
	public $esconder_ligacoes_efetuadas;
	public $mascara_ddi;

	// Tempo em dias que um usuário deve ficar sem logar para ser considerado sem frequência
	const TEMPO_ATIVIDADE = 5;

	function __construct($id)
	{
		$this->id = $id;
	}

	function achar_pagina_home_permitida()
	{
		$home = $this->home;
		if (!$this->cliente_carregado()) {
			return "home";
		}
		switch ($home) {
			case "ligacoes":
			case "ligacoes-geral":
				if ($this->permissao_3cx != Usuario::PERM_NENHUMA) {
					return $home;
				}
				break;
			case "grupos":
			case "grafico":
			case "campanhas":
			case "geral":
			case "palavras":
				if ($this->permissao_google != Usuario::PERM_NENHUMA) {
					return $home;
				}
				break;
			case "geral-comparacao":
				if ($this->permissao_comparacao != Usuario::PERM_NENHUMA && $this->permissao_google != Usuario::PERM_NENHUMA) {
					return $home;
				}
				break;
			case "arquivos":
				if ($this->permissao_drive != Usuario::PERM_NENHUMA) {
					return $home;
				}
				break;
			case "lixeira":
			case "contatos":
			case "baixar-contatos":
				if ($this->permissao_leads != Usuario::PERM_NENHUMA) {
					return $home;
				}
				break;
			case "indicacoes":
			case "indicacoes-financeiro":
			case "baixar-indicacoes":
			case "premios":
				if ($this->permissao_indicacoes != Usuario::PERM_NENHUMA) {
					return $home;
				}
				break;
		}
		if ($this->permissao_google != Usuario::PERM_NENHUMA) {
			return "geral";
		}
		if ($this->permissao_comparacao != Usuario::PERM_NENHUMA && $this->permissao_google != Usuario::PERM_NENHUMA) {
			return "geral-comparacao";
		}
		if ($this->permissao_leads != Usuario::PERM_NENHUMA) {
			return "contatos";
		}
		if ($this->permissao_3cx != Usuario::PERM_NENHUMA) {
			return "ligacoes";
		}
		if ($this->permissao_drive != Usuario::PERM_NENHUMA) {
			return "arquivos";
		}
		if ($this->permissao_indicacoes != Usuario::PERM_NENHUMA) {
			return "indicacoes";
		}
		return "home";
	}

	/* Método responsável por carregar os dados do usuário */
	function carregar(&$bd)
	{
		$params = array(':id' => $this->id);
		$dados = $bd->executar("SELECT * FROM TBL_CLIENTE WHERE ID_CLIENTE = :id", $params, Banco_Dados::FETCH);
		if ($bd->quantidade() > 0) {
			$this->login = $dados['TXT_LOGIN'];
			// $this->nome = $dados['TXT_NOME_EMPRESA'];
			$this->nome = $dados['TXT_NOME'];
			$this->id_adwords = $dados['NU_ADWORDS'];
			$this->data_inicio_3cx = $dados['DT_VONOINICIO'];
			$this->data_inicio_ads = $dados['DT_INICIOADS'];
			$this->data_final_3cx = $dados['DT_VONOFIM'];
			$exploded = empty($dados['NU_VONOID']) ? false : explode(',', $dados['NU_VONOID']);
			$this->ids_3cx = ($exploded == false) ? array() : $exploded;
			$this->home = $dados['TXT_HOME'];
			$this->permissao_google = $dados['TXT_GOOGLE'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
			$this->permissao_comparacao = $dados['TXT_COMPARACAO'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
			$this->permissao_log = $dados['TXT_LOG'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
			$this->permissao_leads = $dados['TXT_LEADS'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
			$this->permissao_3cx = $dados['TXT_FONE'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
			$this->permissao_whatsapp = $dados['NU_WHATSAPP'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
			$this->permissao_linkclique = $dados['NU_PERM_LINKCLIQUE'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
			$this->permissao_dados_gerais = $dados['NU_ATIVAR_DADOS_GERAIS'] == "1" ? Usuario::PERM_LEITURA : Usuario::PERM_NENHUMA;
			$this->permissao_pausar_campanhas = $dados['NU_PERM_PAUSAR_CAMPANHAS'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
			$this->permissao_btn_adicionar_lead = $dados['NU_PERM_BTN_ADICIONAR_LEAD'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
			$this->mostrar_total_real_ligacoes = $dados['NU_MOSTRAR_TOTAL_REAL_LIGACOES'] == "1";
			$this->limite_custo_lead = $dados['TXT_LIMITE_CUSTO_LEAD'];
			$this->agrupar_ligacoes = $dados['NU_AGRUPAR_LIGACOES'] == "1";
			$this->consultoria = $dados['TXT_CONSULTORIA'] == "1";
			$this->sidebar = $dados['NU_SIDEBAR'] == "1";
			$this->descricao = "Cliente Win7";
			$this->senha = $dados['TXT_SENHA_NOVA'];
			$this->mascara_ddi = $dados['NU_DDI_MASCARA'];
			$this->senha_antiga = $dados['TXT_SENHA'];
			$this->moeda = intval($dados['NU_MOEDA_ADWORDS']);
			// $this->mostrar_somente_campanhas = $dados['NU_MOSTRAR_SOMENTE_CAMPANHAS'] == "1";
			$this->mostrar_somente_campanhas = $dados['NU_MOSTRAR_SOMENTE_CAMPANHAS'];
			$this->mostrar_cpl = $dados['NU_MOSTRAR_CPL'] == "1";
			$this->esconder_ligacoes_efetuadas = $dados['NU_ESCONDER_LIGACOES_EFETUADAS'] == "1";

			if (!($this instanceof Usuario_Adm)) {
				$timestamp = time();
				date_default_timezone_set('America/Sao_Paulo');
				$data_alteracao = date('Y-m-d H:i:s', $timestamp);
				$bd->executar("UPDATE TBL_CLIENTE SET NU_ACESSOS_SISTEMA_DATA = :ultimo WHERE ID_CLIENTE = :id", array(
					':id' => $this->id,
					':ultimo' => $data_alteracao
				));
			}


			$dados = $bd->executar("SELECT * FROM TBL_CAMPANHAS_CLIENTE WHERE ID_CLIENTE_FK = :id", $params, Banco_Dados::FETCH_ALL);
			$this->campanhas_visiveis = array();
			foreach ($dados as $row) {
				$this->campanhas_visiveis[] = $row['ID_CAMPANHA'];
			}
			if (count($this->campanhas_visiveis) == 0)
				// $this->mostrar_somente_campanhas = false;
				$this->mostrar_somente_campanhas = '0';
		}

		/* Carregamos aqui os dados do sistema de indicações caso o cliente possua */
		$dados = $bd->executar("SELECT * FROM TBL_CLI_DADOS WHERE ID_FK = :id", $params, Banco_Dados::FETCH);
		if ($bd->quantidade() > 0) {
			$this->permissao_indicacoes = $dados['NU_ATIVADO'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
			$this->tipo_indicacoes = $dados['TXT_TIPO_SISTEMA_INDICACAO'];
			$this->super_adm_indicacoes = $dados['NU_SUPERADM'] == "1";
			$this->comissao_fixa = $dados['NU_COMISSAO_FIXA'];
			$this->comissao = $dados['TXT_BONUS'];
			$this->distribuir_comissoes = $dados['NU_DISTRIBUIR_COMISSOES'];
			$this->dados_indicacoes = $dados;
		} else {
			$this->super_adm_indicacoes = false;
			$this->permissao_indicacoes = Usuario::PERM_NENHUMA;
		}

		/* Carregamos aqui os dados do sistema do google drive caso o cliente possua */
		$dados = $bd->executar("SELECT * FROM TBL_CLI_GDRIVE WHERE ID_FK = :id", $params, Banco_Dados::FETCH);
		if ($bd->quantidade() > 0) {
			$this->permissao_drive = $dados['NU_ATIVADO'] == "1" ? Usuario::PERM_ESCRITA : Usuario::PERM_NENHUMA;
		} else
			$this->permissao_drive = Usuario::PERM_NENHUMA;
	}

	/* Retorna verdadeiro caso o usuário possua ID do adwords */
	function tem_adwords()
	{
		return !empty($this->id_adwords);
	}

	/* Muda a senha do usuário */
	function mudar_senha($senha, $senha_antiga, $sistema)
	{
		$antiga = empty($this->senha);
		$verificada = $antiga ?
			($this->senha_antiga === md5($senha_antiga)) : // A senha é md5 e está correta?
			(crypt($senha_antiga, $this->senha) === $this->senha); // OU a senha é blowfish e está correta?

		if (!$verificada) { // A senha atual digitada está incorreta
			return "Senha incorreta.";
		}

		$sistema->bd->executar("UPDATE TBL_CLIENTE SET TXT_SENHA_NOVA = :senha, TXT_SENHA = '' WHERE ID_CLIENTE = :id", array(':id' => $this->id, ':senha' => Utilitarios::hash_str($senha)));

		try {
			foreach (Sistema::email_adm() as $email) {
				Sistema::enviar_email_sistema("<p>O cliente " . $this->nome . " acaba de modificar sua senha do Sistema Win7!</p>", "Aviso de Mudança de Senha", $email, "Agência Win7");
			}
		} catch (Exception $e) {
		}

		return "-1";
	}

	/* Salva o estado atual da sidebar */
	function salvar_sidebar($opcao, $bd)
	{
		$opcao == "0" ? $opcao = 0 : $opcao = 1;
		$params = array(
			':id' => $this->id,
			':sidebar' => $opcao
		);
		$bd->executar("UPDATE TBL_CLIENTE SET NU_SIDEBAR = :sidebar WHERE ID_CLIENTE = :id", $params);
	}
}
