<?php 
error_reporting(-1);
require_once (__DIR__ . '/../../../sistemawin7lib/vendor/autoload.php');
require_once(__DIR__ . "/../Sistema_Win7Fone.php");
require_once(__DIR__ . "/../Sistema_Adwords.php");

/* Essa função marca o processo como não executando caso ocorra algum erro. */
function erro_atualizar_resultados($errno, $errstr, $errfile, $errline){
	$bd = new Banco_Dados(false);
	$bd->executar("UPDATE TBL_PROCESSO_RESULTADOS SET NU_EXECUTANDO = 0 WHERE NU_ID = 1");
}
$old_error_handler = set_error_handler("erro_atualizar_resultados");

/* Garante que o script vai rodar indefinidamente */
ignore_user_abort(true);
set_time_limit(0);
error_reporting(-1);

try{
	// Obtém os dados do processo
	$bd = new Banco_Dados(false);
	$sql = "SELECT * FROM TBL_PROCESSO_RESULTADOS WHERE NU_ID = 1";
	$resultado = $bd->executar($sql, array(), Banco_Dados::FETCH);
	$ultima_execucao = strtotime($resultado['ULTIMA_EXECUCAO']);
	$tempo_atual = time();

	// Exemplo: 1617713239 - 1617713239 <= 7200 && "1" == "1"
	if($tempo_atual - $ultima_execucao <= 60 * 60 * 2 && $resultado['NU_EXECUTANDO'] == "1"){
		exit;
	}

	$sql = "UPDATE TBL_PROCESSO_RESULTADOS SET NU_EXECUTANDO = 1 WHERE NU_ID = 1";
	$bd->executar($sql, array(), Banco_Dados::FETCH);

	$interromper = false;
	$tempo_sleep = 0;

	while(true){
		/* Verifica se o processo não é forçado a parar*/
		$sql = "SELECT * FROM TBL_PROCESSO_RESULTADOS WHERE NU_ID = 1";
		$resultado = $bd->executar($sql, array(), Banco_Dados::FETCH);

		if($resultado['NU_PARAR'] == "1" || $resultado['NU_EXECUTANDO'] == "0"){
			break;
		}

		if($tempo_sleep > 0){
			$tempo_sleep -= 5;
			sleep(5);
			continue;
		}

		$clientes = $bd->executar("SELECT * FROM TBL_CLIENTE WHERE NU_CLIENTE_ATIVO = 1", array(), Banco_Dados::FETCH_ALL);

		$today = date("Y-m-d", time());
		$yesterday = date("Y-m-d", time() - (24 * 3600));
		$yesterday_active = intval(date('H', time())) == 2;

		$sistema_win7fone = new Sistema_Win7Fone(-1, $bd);
		//$adwords = new Sistema_Adwords($bd);

		foreach($clientes as $cliente){
			/* Verifica se o processo não é forçado a parar*/
			$sql = "SELECT * FROM TBL_PROCESSO_RESULTADOS WHERE NU_ID = 1";
			$resultado = $bd->executar($sql, array(), Banco_Dados::FETCH);
			if($resultado['NU_PARAR'] == "1" || $resultado['NU_EXECUTANDO'] == "0"){
				$interromper = true;
				break;
			}

			/* Atualiza a data de última execução do processo */
			$now = date("Y-m-d H:i:s", time());
			$cur_timestamp = time();
			$sql = "UPDATE TBL_PROCESSO_RESULTADOS SET ULTIMA_EXECUCAO = :execucao WHERE NU_ID = 1";
			$bd->executar($sql, array(":execucao" => $now));

			$id = $cliente['ID_CLIENTE'];
			//$id_adwords = $cliente['NU_ADWORDS'];

			$sistema_win7fone->id = $id;
			$ligacoes_hoje = $sistema_win7fone->contar_ligacoes("TODAY", '', '');
			$nao_atendidas_hoje = $ligacoes_hoje[1];
			$ligacoes_hoje = $ligacoes_hoje[0];

			/*if(!empty($id_adwords)){
				try{
					$rows = $adwords->resultado_geral($id_adwords, "TODAY", '', '');
					if(!empty($rows) & count($rows) > 0){
						$rows = $rows[0];
						$cliques_hoje = $rows["clicks"];
					}
					else{
						$cliques_hoje = "0";
					}
				}
				catch(Exception $e){
					$cliques_hoje = "0";
				}
			}
			else{
				$cliques_hoje = "0";
			}*/

			if($yesterday_active){
				$ligacoes_ontem = $sistema_win7fone->contar_ligacoes("YESTERDAY", '', '');
        $nao_atendidas_ontem = $ligacoes_ontem[1];
        $ligacoes_ontem = $ligacoes_ontem[0];

				/*if(!empty($id_adwords)){
					try{
						$rows = $adwords->resultado_geral($id_adwords, "YESTERDAY", '', '');
						if(!empty($rows) & count($rows) > 0){
							$rows = $rows[0];
							$cliques_ontem = $rows["clicks"];
						}
						else{
							$cliques_ontem = "0";
						}
					}
					catch(Exception $e){
						$cliques_ontem = "0";
					}
				}
				else{
					$cliques_ontem = "0";
				}*/
			}

			$sql = "SELECT * FROM TBL_DADOS_RESULTADOS WHERE DT_DIA = '".$today."' AND ID_FK = ".$id."";
			$resultado = $bd->executar($sql, array(), Banco_Dados::FETCH);
			if($bd->quantidade() > 0){
				$sql = "UPDATE TBL_DADOS_RESULTADOS SET NU_LIGACOES = :ligacoes, NU_CLIQUES = :cliques, NU_LIGACOES_NAO_ATENDIDAS = :naoatendidas WHERE NU_ID = :id";
				$bd->executar($sql, array(
					":ligacoes" => $ligacoes_hoje,
					":cliques" => "0",
					":id" => $resultado["NU_ID"],
          ":naoatendidas" => $nao_atendidas_hoje
				));
			}
			else{
				$sql = "INSERT INTO TBL_DADOS_RESULTADOS (NU_LIGACOES, NU_CLIQUES, DT_DIA, ID_FK, NU_LIGACOES_NAO_ATENDIDAS) VALUES (:ligacoes, :cliques, :dia, :id, :naoatendidas)";
				$bd->executar($sql, array(
					":ligacoes" => $ligacoes_hoje,
					":cliques" => "0",
					":dia" => $today,
					":id" => $id,
          ":naoatendidas" => $nao_atendidas_hoje
				));
			}

			if($yesterday_active){
				$sql = "SELECT * FROM TBL_DADOS_RESULTADOS WHERE DT_DIA = '".$yesterday."' AND ID_FK = ".$id."";
				$resultado = $bd->executar($sql, array(), Banco_Dados::FETCH);
				if($bd->quantidade() > 0){
					$sql = "UPDATE TBL_DADOS_RESULTADOS SET NU_LIGACOES = :ligacoes, NU_CLIQUES = :cliques, NU_LIGACOES_NAO_ATENDIDAS = :naoatendidas WHERE NU_ID = :id";
					$bd->executar($sql, array(
						":ligacoes" => $ligacoes_ontem,
						":cliques" => "0",
						":id" => $resultado["NU_ID"],
            ":naoatendidas" => $nao_atendidas_ontem
					));
				}
				else{
					$sql = "INSERT INTO TBL_DADOS_RESULTADOS (NU_LIGACOES, NU_CLIQUES, DT_DIA, ID_FK, NU_LIGACOES_NAO_ATENDIDAS) VALUES (:ligacoes, :cliques, :dia, :id, :naoatendidas)";
					$bd->executar($sql, array(
						":ligacoes" => $ligacoes_ontem,
						":cliques" => "0",
						":dia" => $yesterday,
						":id" => $id,
            ":naoatendidas" => $nao_atendidas_ontem
					));
				}
			}
		}

		if($interromper == true){
			break;
		}

		/* Obtém a data de execução */
		$sql = "SELECT * FROM TBL_PROCESSO_RESULTADOS WHERE NU_ID = 1";
		$resultado = $bd->executar($sql, array(), Banco_Dados::FETCH);
		$ultima_execucao = $resultado['ULTIMA_EXECUCAO'];

		/* Caso a última data de execução não bata, é porque existe outro processo rodando.
		   Ocorre, portanto, que o script atual deve ser parado */
		if($ultima_execucao != $now){
			break;
		}

		$tempo_sleep = 120;
	}

	/* Caso o loop while tenha sido finalizado, marca o processo como não executando */
	$sql = "UPDATE TBL_PROCESSO_RESULTADOS SET NU_EXECUTANDO = 0 WHERE NU_ID = 1";
	$bd->executar($sql, array(), Banco_Dados::FETCH);
}
catch(Exception $e){
	/* Caso ocorra algum erro, marca o processo como não executando */
	$bd = new Banco_Dados(false);
	$sql = "UPDATE TBL_PROCESSO_RESULTADOS SET NU_EXECUTANDO = 0 WHERE NU_ID = 1";
	$bd->executar($sql, array());
}
?>