<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::GOOGLE_DRIVE);
$sistema = new Sistema(true);

$url = $sistema->usuario->link;
$query_str = parse_url($url, PHP_URL_QUERY);
parse_str($query_str, $query_params);
?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->drive->cor2; ?>">
	<title>Home - <?php echo $sistema->drive->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->drive->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/skin-blue-light.min.css">
	<link rel="stylesheet" href="css/custom.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
	<?php $sistema->layout->exibir_css_drive();?>
</head>

<body class="hold-transition skin-blue-light sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<?php $sistema->layout->exibir_modal_adicionar_indicado();?>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('home');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Home
			<small>Visualize seus arquivos</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="home"><i class="fa green-text fa-home"></i> Home</a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xs-12">
					<div class="box">
						<iframe src="https://drive.google.com/embeddedfolderview?id=<?php echo $query_params['id']; ?>#list"></iframe>
					</div>
				</div>
			</div>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="js/bootstrap.min.js"></script>
<script src="js/adminlte.min.js"></script>

</body>
</html>