<?php
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("../senha-transferencia");

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

if($sistema->indicacoes->usa_pontos != "1"){
	echo "-2Permissão Insuficiente";
	exit;
}

try{
	$produto = $sistema->bd->executar("SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2", array(
		":id" => $_POST['id'],
		":id2" => $sistema->indicacoes->id
	), Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){ // Os dados não foram encontrados, então a ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	if((intval($produto['NU_ESTOQUE']) == 0 && $produto['NU_ESTOQUE_INFINITO'] == "0") || $produto['NU_DELETADO'] == "1"){
		echo "-2Produto Indisponível!";
		exit;
	}

	$dados = $sistema->indicacoes->obter_usuario($sistema->usuario->id);
	$saldo = intval($dados['TXT_SALDO']);
	$saldo_cadastro = intval($dados['TXT_SALDO_CADASTRO']);
	$pontos = intval($produto['NU_PONTOS']);
	$nome = $produto['TXT_NOME'];
	$descricao = $produto['TXT_DESCRICAO'];

	if($produto['NU_RESGATE_NORMAL'] == "1"){
		if($pontos > $saldo){
			echo "-2Saldo Insuficiente!";
			exit;
		}
	}
	else{
		if($pontos > ($saldo + $saldo_cadastro)){
			echo "-2Saldo Insuficiente!";
			exit;
		}
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
	<span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title"><b>Confirmação</b></h4>
</div>

<div class="modal-body">
	<?php echo $descricao;?> <br><br>
	<span class="text-red">Tem certeza de que deseja resgatar uma unidade do prêmio <b>"<?php echo $nome;?>"</b>?</span>
</div>
<div class="modal-footer">
	<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Não</button>
	<a class="btn btn-primary" href="javascript:void(0);" onclick="salvar_resgate_premio();">Sim</a>
</div>
<div class="overlay preloader">
	<i class="fa fa-refresh fa-spin"></i>
</div>

<script>
function salvar_resgate_premio(){
	var dados = "id=<?php echo $_POST['id']; ?>";
	jQuery.ajax({
		type: "POST",
		url: "action/salvar_modal_resgate_premio",
		data: dados,
		success: function(data){
			$('.preloader').css({display:"none"});
			if(data == '-1') {window.location.href = "./"; return;}
			if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
			fechar_modal_confirmacao();
			mudarPontos(JSON.parse(data));
			toastr.clear(); toastr.success("Pedido de resgate feito com sucesso."); return;
		},
		beforeSend: function(){
			$('.preloader').css({display:"block"});
		},
		complete: function(){
			$('.preloader').css({display:"none"});
		},
		error: function(){
			$('.preloader').css({display:"none"});
			toastr.clear(); toastr.error("Houve um erro ao pedir resgate."); return;
		}
	});
}
</script>