<?php
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true, true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("../senha-transferencia");

if($sistema->indicacoes->permissao_inscricoes == "0"){
	echo "-2Não foi possível realizar o cadastro";
	exit;
}

try{
	$usuario = preg_replace('#[^0-9]#','',strip_tags($_POST['usuario-indicado']));
	$nome = $_POST['nome-indicado'];
	$email = $_POST['email-indicado'];
	$telefone = $_POST['telefone-indicado'];

	if(strlen($telefone) < 8 || strlen($nome) <= 1){
		echo "-2Dados incorretos";
		exit;
	}

	if(strlen($usuario) == 11 & !Utilitarios::cpf_cnpj_valido($usuario)){
		echo "-2Dados incorretos";
		exit;
	}
	else if($sistema->indicacoes->permissao_cnpj_indicado == "0" & !Utilitarios::cpf_cnpj_valido($usuario)){
		echo "-2Dados incorretos";
		exit;
	}
	else if(strlen($usuario) == 14 & !Utilitarios::cpf_cnpj_valido($usuario)){
		echo "-2Dados incorretos";
		exit;
	}
	else if(strlen($usuario) != 11 & strlen($usuario) != 14){
		echo "-2Dados incorretos";
		exit;
	}

	if($sistema->indicacoes->proibir_cpf == "1"){
		$dados = $sistema->bd->executar("SELECT ID_LEAD FROM TBL_LEADS WHERE (TXT_CPF = :TXT_CPF OR TXT_CPF = :NU_CPF) AND ID_CLIENTE_FK = :ID",array(
			':NU_CPF' => $usuario,
			':TXT_CPF' => Mascara::mascara_cpf_cnpj($usuario),
			':ID' => $sistema->indicacoes->id
		), Banco_Dados::FETCH);
		if($sistema->bd->quantidade() > 0){
			echo "-2Registro já existe!";
			exit;
		}
	}

	$params = array();
	if($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES){
		$params['curso'] = $_POST['curso-indicado'];
		$params['unidade'] = $_POST['unidade-indicado'];
		$params['bairro'] = $_POST['bairro-indicado'];
		$params['data-prova'] = $_POST['data-prova-indicado'];
		$params['cidade'] = $_POST['cidade-indicado'];
	}

	$_SESSION['indicadorID'] = $sistema->usuario->id;
	$resultado = $sistema->indicacoes->registrar_indicado($usuario, $nome, $email, $telefone, $params);

	if($resultado == 0){
		echo "-2Registro já existe!";
		exit;
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}

?>