<?php
/***
	Este arquivo exibe a tela de login padrão do sistema win7, 
	que é acessada por nossos clientes.
***/

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema();

// Caso o cliente já esteja logado, enviamos ele para a home
if($sistema->sessao->logado()) $sistema->redirecionar("home");
?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<title>Recuperar Senha -  <?php echo $sistema->indicacoes->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="css/custom-not-logged.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->exibir_css_indicacao_index();?>
</head>

<body class="hold-transition login-page" style="height: auto;">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<div class="login-box">
		<div class="login-logo">
			<a href="./"><img src="<?php echo $sistema->indicacoes->logo; ?>" width="150"></a>
		</div>
		<div class="login-box-body">
			<p class="text-center">Preencha o campo abaixo com seu <?php if($sistema->indicacoes->text_cpf_cnpj_alternativo){echo $sistema->indicacoes->text_cpf_cnpj_alternativo;} else {echo 'CPF';} ?>, e lhe enviaremos um e-mail com instruções de como recuperar sua senha.</p>
			<form action="action/recuperar_senha" method="post" onsubmit="return validarForm();">
				<div class="form-group has-feedback">
					<input id="usuario" name="usuario" type="text" class="form-control" alt="Usuário" placeholder="<?php 

					if($sistema->indicacoes->text_cpf_cnpj_alternativo){echo $sistema->indicacoes->text_cpf_cnpj_alternativo.":";} else {
						if ($sistema->indicacoes->permissao_cnpj_indicador == "1") { echo "CPF ou CNPJ:"; } else { echo "CPF:"; }
					}
					
					?>" onkeydown='mascaraMutuario(this,cpfCnpj)' onchange='mascaraMutuario(this,cpfCnpj)' required>
        			<span class="glyphicon glyphicon-user form-control-feedback"></span>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<button type="submit" class="btn btn-primary btn-block btn-flat">Enviar</button>
					</div>
				</div>
			</form>
		</div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/toastr.min.js"></script>
	<script src="js/basico-esqueceu"></script>
</body>
</html>