<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("senha-transferencia");

?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<title>Histórico - <?php echo $sistema->indicacoes->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/datatables.min.css"/>
	<link rel="stylesheet" href="css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/skin-blue-light.min.css">
	<link rel="stylesheet" href="css/custom1.0.0.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
	<?php $sistema->layout->exibir_css_indicacao();?>
</head>

<body class="hold-transition skin-blue-light sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<?php $sistema->layout->exibir_modal_adicionar_indicado();?>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('historico');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Histórico
			<small>Visualize todas as suas mudanças de saldo</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="historico"><i class="fa green-text fa-list"></i> Histórico </a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<div class="col-xs-12">
					<div class="box">
						<div class="box-body">
							<div id="tabelaIndicacoes" class="tabela">
								<table id="tbIndicacoes" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>
							</div>
						</div>
						<div class="overlay preloader">
							<i class="fa fa-refresh fa-spin"></i>
						</div>
          </div>
				</div>
			</div>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="js/datatables.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/adminlte.min.js"></script>
<script src="js/toastr.min.js"></script>
<script src="js/moment.min.js"></script>
<script src="js/datetime-moment.js"></script>
<script src="js/date.js"></script>
<script src="js/historico2.0.3.js"></script>

</body>
</html>