<?php
/***
	Este arquivo exibe a tela de login padrão do sistema win7, 
	que é acessada por nossos clientes.
***/

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema();

if(isset($_SESSION['indicadorID']) & ctype_digit($_SESSION['indicadorID'])){
	try{
		$indicador = $sistema->indicacoes->obter_indicador($_SESSION['indicadorID']);

		if($sistema->bd->quantidade() == 0){
			unset($_SESSION['indicadorID']);
			$_SESSION['login'] = 7;
			$sistema->redirecionar("./");
		}
	}
	catch(Exception $e){
		unset($_SESSION['indicadorID']);
		$_SESSION['login'] = 6;
		$sistema->redirecionar("./");
	}
}
else{
	$sistema->redirecionar("./");
}

if($sistema->indicacoes->cadastro_indicado == "1"){
	$sistema->redirecionar("./indicador");
}

$titulo = $sistema->indicacoes->vocabulario[20];
$titulo = str_replace("#NOME-CLIENTE#", $sistema->indicacoes->nome, $titulo);
$imagem_social = empty($sistema->indicacoes->imagem_social) ? $sistema->indicacoes->logo : $sistema->indicacoes->imagem_social;
$erro_cadastro = $sistema->indicacoes->vocabulario[23];
$erro_cadastro = str_replace("#TELEFONE#", $sistema->indicacoes->telefone, $erro_cadastro);
?>

<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<meta name="description" content="<?php echo $sistema->indicacoes->vocabulario[22]; ?>" /> 
	<meta property="og:title" content="<?php echo $titulo;?>" />
	<meta property="og:type" content="website"/>
	<meta property="og:image" content="<?php echo $imagem_social;?>"/>
	<meta property="og:description" content="<?php echo $sistema->indicacoes->vocabulario[22];?>" />
	<title><?php echo $titulo;?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/custom-not-logged.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->exibir_css_indicacao_index();?>
</head>

<body class="hold-transition login-page" style="height: auto;">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<div class="register-box">
		<div class="register-logo">
			<a href="./"><img src="<?php echo $sistema->indicacoes->logo; ?>" width="150"></a>
		</div>
		<div class="register-box-body">
			<?php if($sistema->indicacoes->permissao_inscricoes == "0"){ ?>
			<?php echo $erro_cadastro; ?>
			<?php } else if (isset($_SESSION['cadastro-sucesso-indicado'])){ ?>
			<?php
				echo 'Cadastro feito com sucesso! Agradecemos pelo seu registro, em breve entraremos em contato por email.';
				unset($_SESSION['cadastro-sucesso-indicado'])
			 ?>
			<?php } else { ?>
			<?php if(isset($_SESSION['erro-cadastro-indicado'])) { ?>
			<div class="alert alert-danger alert-dismissible">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
				<?php
				switch($_SESSION['erro-cadastro-indicado']){
					case 0:
						if($sistema->indicacoes->text_cpf_cnpj_alternativo){
							echo "Seu formulário NÃO foi cadastrado, pois já encontramos um registro com o ".$sistema->indicacoes->text_cpf_cnpj_alternativo." digitado.<br> Por favor, tente novamente e digite um ".$sistema->indicacoes->text_cpf_cnpj_alternativo." único não cadastrado.";
						} else {
							echo 'Seu formulário NÃO foi cadastrado, pois já encontramos um registro com o número de CPF digitado.<br> Por favor, tente novamente e digite um CPF único não cadastrado.';
						}
						break;
					case 1:
						echo "Houve um erro ao cadastrar seu formulário no banco! Por favor, tente novamente.";
						break;
					case 2:
						echo "Por favor, tente novamente e digite seus dados de forma correta.";
						break;
					case 3:
						echo $erro_cadastro;
						break;
				}
				?>
			</div>
			<?php unset($_SESSION['erro-cadastro-indicado']); } ?>
			<p>Você foi indicado por <b><?php echo $indicador['TXT_NOME']; ?></b>, para participar da promoção <?php echo $sistema->indicacoes->nome; ?>.<br>Preencha o formulário abaixo e aguarde nosso contato!<hr>
			<form action="action/cadastrar_indicado" method="post" onsubmit="return validarFormCadIndicacao();">
				<div class="row">
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Nome Completo:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<input type="text" class="form-control pull-right" id="nome-indicado" name="nome-indicado" alt="Nome" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Email:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
							<input type="text" class="form-control pull-right" id="email-indicado" name="email-indicado" alt="Email" placeholder="exemplo@gmail.com" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Telefone:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-phone"></i></div>
							<input type="text" class="form-control pull-right telefone" id="telefone-indicado" name="telefone-indicado" alt="Telefone" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>
							<?php 
								if($sistema->indicacoes->text_cpf_cnpj_alternativo){echo $sistema->indicacoes->text_cpf_cnpj_alternativo.":";}
								else { if ($sistema->indicacoes->permissao_cnpj_indicador == "1") { echo "CPF ou CNPJ:"; } else { echo "CPF:"; }}
							?>
						</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<input id="usuario-indicado" name="usuario-indicado" type="text" class="form-control" alt="Usuário" onkeydown='mascaraMutuario(this,cpfCnpj)' onchange='mascaraMutuario(this,cpfCnpj)' autocomplete="off" autocorrect="off" autocapitalize="off" required>
						</div>
					</div></div>
					<?php if($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES & ($sistema->indicacoes->id == "282" || $sistema->indicacoes->id == "356" || $sistema->indicacoes->id == "205")) {?>
					<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
						<label>Bairro:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-building"></i></div>
							<input type="text" class="form-control pull-right" id="bairro-indicado" name="bairro-indicado" alt="Bairro" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
						<label>Cidade:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-building"></i></div>
							<input type="text" class="form-control pull-right" id="cidade-indicado" name="cidade-indicado" alt="Cidade" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
						<label>Data da Prova:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
							<input type="text" class="form-control pull-right datepicker" id="data-prova-indicado" name="data-prova-indicado" alt="Cidade" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Curso:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-certificate"></i></div>
							<select name="curso-indicado" id="curso-indicado" class="form-control pull-right" required>
								<option value="" disabled="true" selected>Não Selecionado</option>
								<option value="Administração">Administração</option>
								<option value="Análise e Desenvolvimento de Sistemas">Análise e Desenvolvimento de Sistemas</option>
								<option value="Contabilidade">Contabilidade</option>
								<option value="Enfermagem">Enfermagem</option>
								<option value="Fisioterapia">Fisioterapia</option>
								<option value="Gestão Financeira">Gestão Financeira</option>
								<option value="História">História</option>
								<option value="Letras">Letras</option>
								<option value="Logística">Logística</option>
								<option value="Marketing">Marketing</option>
								<option value="Pedagogia">Pedagogia</option>
								<option value="Pilotagem">Pilotagem</option>
								<option value="Publicidade e Propaganda">Publicidade e Propaganda</option>
								<option value="Radiologia">Radiologia</option>
								<option value="Recursos Humanos">Recursos Humanos</option>
								<option value="Redes de Computadores">Redes de Computadores</option>
								<option value="Segurança da Informação">Segurança da Informação</option>
								<option value="Sistemas de Informação">Sistemas de Informação</option>
							</select>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Unidade:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-building"></i></div>
							<select name="unidade-indicado" id="unidade-indicado" class="form-control pull-right" required>
								<option value="" disabled="true" selected>Não Selecionado</option>
							</select>
						</div>
					</div></div>
					<?php } ?>
					<?php if($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES & ($sistema->indicacoes->id == "298")) {?>
					<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
						<label>Bairro:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-building"></i></div>
							<input type="text" class="form-control pull-right" id="bairro-indicado" name="bairro-indicado" alt="Bairro" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
						<label>Cidade:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-building"></i></div>
							<input type="text" class="form-control pull-right" id="cidade-indicado" name="cidade-indicado" alt="Cidade" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
						<label>Data da Prova:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-calendar"></i></div>
							<input type="text" class="form-control pull-right datepicker" id="data-prova-indicado" name="data-prova-indicado" alt="Cidade" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Curso:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-certificate"></i></div>
							<select name="curso-indicado" id="curso-indicado" class="form-control pull-right" required>
								<option value="" disabled="true" selected>Não Selecionado</option>
								<option value="Administração">Administração</option>
								<option value="Administração Pública">Administração Pública</option>
								<option value="Análise e Desenvolvimento de Sistemas">Análise e Desenvolvimento de Sistemas</option>
								<option value="Ciências Contábeis">Ciências Contábeis</option>
								<option value="Enfermagem">Enfermagem</option>
								<option value="Gestão Ambiental">Gestão Ambiental</option>
								<option value="Gestão Financeira">Gestão Financeira</option>
								<option value="História">História</option>
								<option value="Letras">Letras</option>
								<option value="Lógistica">Lógistica</option>
								<option value="Pedagogia">Pedagogia</option>
								<option value="Publicidade e Propaganda">Publicidade e Propaganda</option>
								<option value="Radiologia">Radiologia</option>
								<option value="Recursos Humanos">Recursos Humanos</option>
								<option value="Redes de Computadores">Redes de Computadores</option>
								<option value="Segurança da Informação">Segurança da Informação</option>
								<option value="Sistemas de Informação">Sistemas de Informação</option>
							</select>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Unidade:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-building"></i></div>
							<select name="unidade-indicado" id="unidade-indicado" class="form-control pull-right" required>
								<option value="" disabled="true" selected>Não Selecionado</option>
								<option value="504 Sul">504 Sul</option>
							</select>
						</div>
					</div></div>
					<?php } ?>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<button type="submit" class="btn btn-primary btn-block btn-flat">Realizar meu Cadastro</button>
					</div>
				</div>
			</form>
			<?php } ?>
		</div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/toastr.min.js"></script>
	<script src="js/jquery.mask.min.js"></script>
	<script src="js/bootstrap-datepicker.min.js"></script>
	<script src="js/bootstrap-datepicker.pt-BR.min.js"></script>
	<script src="js/basico-indicado"></script>
	<?php if($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES & ($sistema->indicacoes->id == "282" || $sistema->indicacoes->id == "356" || $sistema->indicacoes->id == "205")) { ?><script src="js/basico-faculdade-indicado"></script> <?php } ?>
</body>
</html>