<?php
/***
	Este arquivo exibe a tela de login padrão do sistema win7, 
	que é acessada por nossos clientes.
***/

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema();

if(isset($_SESSION['indicadorID'])){
	try{
		$indicador = $sistema->indicacoes->obter_indicador($_SESSION['indicadorID']);

		if($sistema->bd->quantidade() == 0){
			unset($_SESSION['indicadorID']);
			$_SESSION['login'] = 7;
			$sistema->redirecionar("./");
		}

		$registro1 = $sistema->indicacoes->vocabulario[24];
		$registro1 = str_replace("#NOME-INDICADOR#", $indicador['TXT_NOME'], $registro1);
	}
	catch(Exception $e){
		unset($_SESSION['indicadorID']);
		$_SESSION['login'] = 6;
		$sistema->redirecionar("./");
	}
}

$termos = $sistema->indicacoes->vocabulario[16];
$termos = str_replace("#LINK-TERMOS#", $sistema->indicacoes->termos, $termos);
$titulo = $sistema->indicacoes->vocabulario[19];
$titulo = str_replace("#NOME-CLIENTE#", $sistema->indicacoes->nome, $titulo);
$imagem_social = empty($sistema->indicacoes->imagem_social) ? $sistema->indicacoes->logo : $sistema->indicacoes->imagem_social;
$erro_cadastro = $sistema->indicacoes->vocabulario[23];
$erro_cadastro = str_replace("#TELEFONE#", $sistema->indicacoes->telefone, $erro_cadastro);
$registro2 = $sistema->indicacoes->vocabulario[25];
?>

<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<meta name="description" content="<?php echo $sistema->indicacoes->vocabulario[21]; ?>" /> 
	<meta property="og:title" content="<?php echo $titulo;?>" />
	<meta property="og:type" content="website"/>
	<meta property="og:image" content="<?php echo $imagem_social;?>"/>
	<meta property="og:description" content="<?php echo $sistema->indicacoes->vocabulario[21];?>" />
	<title><?php echo $titulo;?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/custom-not-logged.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->exibir_css_indicacao_index();?>
</head>

<body class="hold-transition login-page" style="height: auto;">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
	<div class="register-box">
		<div class="register-logo">
			<a href="./"><img src="<?php echo $sistema->indicacoes->logo; ?>" width="150"></a>
		</div>
		<div class="register-box-body">
			<?php if($sistema->indicacoes->permissao_inscricoes == "0"){ ?>
			<?php echo $erro_cadastro; ?>
			<?php } else if (isset($_SESSION['cadastro-sucesso-indicador'])){ ?>
			<?php
				echo 'Cadastro feito com sucesso!<br> É necessário ativar sua conta, através de um link que mandamos ao email cadastrado.<br> Não esqueça de verificar a caixa de spam!<br><a href="./">Clique aqui</a> para ir para a tela de login.';
				unset($_SESSION['cadastro-sucesso-indicador'])
			 ?>
			<?php } else { ?>
			<?php if(isset($_SESSION['erro-cadastro-indicador'])) { ?>
			<div class="alert alert-danger alert-dismissible">
				<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
				<?php
				switch($_SESSION['erro-cadastro-indicador']){
					case 0:
						if($sistema->indicacoes->text_cpf_cnpj_alternativo){
							echo "Seu formulário NÃO foi cadastrado, pois já encontramos um registro com o ".$sistema->indicacoes->text_cpf_cnpj_alternativo." digitado.<br> Por favor, tente novamente e digite um ".$sistema->indicacoes->text_cpf_cnpj_alternativo." único não cadastrado.";
						} else {
							echo 'Seu formulário NÃO foi cadastrado, pois já encontramos um registro com o número de CPF digitado.<br> Por favor, tente novamente e digite um CPF único não cadastrado.';
						}
						break;
					case 1:
						echo "Houve um erro ao cadastrar seu formulário no banco! Por favor, tente novamente.";
						break;
					case 2:
						echo "Por favor, tente novamente e digite seus dados de forma correta.";
						break;
					case 3:
						echo "Por favor, aceite os termos de uso para concluir seu cadastro!";
						break;
					case 4:
						echo $erro_cadastro;
						break;
				}
				?>
			</div>
			<?php unset($_SESSION['erro-cadastro-indicador']); } ?>
			<?php if(isset($_SESSION['indicadorID'])) { echo $registro1; } echo $registro2; if(isset($_SESSION['indicadorID']) || !empty($registro2)) { echo "<hr>"; } ?>
			<form action="action/cadastrar_indicador" method="post" onsubmit="return validarFormCadIndicador();">
				<div class="row">
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Nome Completo:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<input type="text" class="form-control pull-right" id="nome" name="nome" alt="Nome" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Telefone:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-phone"></i></div>
							<input type="text" class="form-control pull-right telefone" id="telefone" name="telefone" alt="Telefone" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Email:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
							<input type="text" class="form-control pull-right" id="email" name="email" alt="Email" placeholder="exemplo@gmail.com" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Redigite o Email:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-envelope"></i></div>
							<input type="text" class="form-control pull-right" id="email2" name="email2" alt="Email2" placeholder="exemplo@gmail.com" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Senha:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-lock"></i></div>
							<input type="password" class="form-control pull-right senha1 senhas" id="senha1" name="senha1" alt="Senha" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Redigite a Senha:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-lock"></i></div>
							<input type="password" class="form-control pull-right senha2 senhas" id="senha2" name="senha2" alt="Senha2" required/>
						</div>
					</div></div>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>
							<?php 
								if($sistema->indicacoes->text_cpf_cnpj_alternativo){echo $sistema->indicacoes->text_cpf_cnpj_alternativo.":";}
								else { if ($sistema->indicacoes->permissao_cnpj_indicador == "1") { echo "CPF ou CNPJ:"; } else { echo "CPF:"; }}
							?>
						</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<input id="usuario" name="usuario" type="text" class="form-control" alt="Usuário" onkeydown='mascaraMutuario(this,cpfCnpj)' onchange='mascaraMutuario(this,cpfCnpj)' autocomplete="off" autocorrect="off" autocapitalize="off" required>
						</div>
					</div></div>
					<?php if ($sistema->indicacoes->tipo == Sistema_Indicacoes::FACULDADES) { ?>
					<div class="col-xs-12 col-sm-6"><div class="form-group">
						<label>Tipo de Indicador:</label>
						<div class="input-group">
							<div class="input-group-addon"><i class="fa fa-user"></i></div>
							<select name="tipofunc" id="tipofunc" class="form-control pull-right">
								<?php $sistema->layout->select_tipos_funcionario_faculdade(); ?>
							</select>
						</div>
					</div></div>
					<?php } ?>
					<?php if ($sistema->indicacoes->ativar_termos == "1") { ?>
					<div class="col-xs-12">
						<div class="checkbox">
							<label>
								<input type="checkbox" id="aceitar-termos" name="aceitar-termos" value="Sim"> <?php echo $termos; ?>
							</label>
						</div>
					</div>
					<?php } ?>
				</div>
				<div class="row">
					<div class="col-xs-12">
						<button type="submit" class="btn btn-primary btn-block btn-flat">Realizar meu Cadastro</button>
					</div>
				</div>
			</form>
			<hr>
			Surgiu alguma dúvida? Ligue para <?php echo $sistema->indicacoes->telefone; ?>.
			<?php } ?>
		</div>
	</div>
	<script src="js/jquery.min.js"></script>
	<script src="js/bootstrap.min.js"></script>
	<script src="js/toastr.min.js"></script>
	<script src="js/jquery.mask.min.js"></script>
	<script src="js/basico-indicador"></script>
</body>
</html>