<?php
header("Content-type: text/javascript");
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

if (session_status() == PHP_SESSION_NONE) {
    require_once(__DIR__ . "/../../classes/Sistema.php");
	set_sistema(Sistema::INDICACOES);
	$sistema = new Sistema();
}
?>

function mudar_acesso(){
	jQuery.ajax({
		type: "POST",
		url: "action/enviar_senha_acesso",
		data: [],
		success: function(data){
			$('.preloader').css({display:"none"});
			if(data == '-1') {window.location.href = "./"; return;}
			if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
			toastr.clear(); toastr.success("Email enviado com sucesso!");
		},
		beforeSend: function(){
			$('.preloader').css({display:"block"});
		},
		complete: function(){
			$('.preloader').css({display:"none"});
		},
		error: function(){
			$('.preloader').css({display:"none"});
			toastr.clear(); toastr.error("Não foi possível enviar o email! Tente novamente."); return;
		}
	});
}

function mudar_transferencia(){
	jQuery.ajax({
		type: "POST",
		url: "action/enviar_senha_transferencia",
		data: [],
		success: function(data){
			$('.preloader').css({display:"none"});
			if(data == '-1') {window.location.href = "./"; return;}
			if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
			toastr.clear(); toastr.success("Email enviado com sucesso!");
		},
		beforeSend: function(){
			$('.preloader').css({display:"block"});
		},
		complete: function(){
			$('.preloader').css({display:"none"});
		},
		error: function(){
			$('.preloader').css({display:"none"});
			toastr.clear(); toastr.error("Não foi possível enviar o email! Tente novamente."); return;
		}
	});
}

jQuery('#formAtualizarDados').submit(function(){
	if(validarForm()){
		var dados = jQuery('#formAtualizarDados').serialize();
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_dados",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				toastr.clear(); toastr.success("Dados salvos com sucesso!");
				$('.nome-indicado-cabecalho').html($('#nome').val());
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Não foi possível atualizar seus dados! Tente novamente."); return;
			}
		});
		return false;
	}
	return false;
});

var maskBehavior = function (val) {
  return val.replace(/\D/g, '').length === 11 ? '(00) 00000-0000' : '(00) 0000-00009';
},
options = {onKeyPress: function(val, e, field, options) {
		field.mask(maskBehavior.apply({}, arguments), options);
	}
};
<?php  

switch ($sistema->indicacoes->mascara_dinheiro) {
	case 'brasil':
		$mascara = "$('#telefone').mask(maskBehavior, options);";
		break;

	case 'eua':
		$mascara = "$('#telefone').mask('(000) 000-0000');";
		break;
	
	default:
		$mascara = "$('#telefone').mask(maskBehavior, options);";
		break;
}
echo $mascara;
?>

function validarForm(){
	var nome     = $('#nome').val();
	var telefone = $('#telefone').val();

	if (nome == "") {
		$('#nome').focus();
		toastr.clear(); toastr.error('O campo NOME está vazio!');
		return false;
	};

	if (telefone == "") {
		$('#telefone').focus();
		toastr.clear(); 
		toastr.error('<?php if($sistema->indicacoes->text_cpf_cnpj_alternativo){echo "O campo ".$sistema->indicacoes->text_cpf_cnpj_alternativo." está vazio!";}
										else { echo "O campo CPF/CNPJ está vazio!"; }
									?>');
		return false;
	}
	
	return true;
}