<?php
require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::INDICACOES);
$sistema = new Sistema(true);

if(empty($sistema->usuario->senha_transf)) $sistema->redirecionar("senha-transferencia");

if($sistema->indicacoes->permissao_transferencias != "1"){
	$sistema->redirecionar("./");
}

$saldo = $sistema->indicacoes->usa_pontos == "1" 
	? number_format($sistema->usuario->saldo,0,',','.') 
	:	$sistema->indicacoes->simbolo_dinheiro.' '. number_format(floatval($sistema->usuario->saldo) / 100,2,",",".");

?>
<!DOCTYPE html>
<html>
<head>
<!-- Google Tag Manager -->
<script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
})(window,document,'script','dataLayer','GTM-T9DQW4X');</script>
<!-- End Google Tag Manager -->
	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
	<meta name='theme-color' content="<?php echo $sistema->indicacoes->cor2; ?>">
	<title>Transferência - <?php echo $sistema->indicacoes->nome; ?></title>
	<link rel="icon" type="image/ico" href="<?php echo $sistema->indicacoes->favicon; ?>" />
	<link rel="stylesheet" href="css/bootstrap.min.css">
	<link rel="stylesheet" href="css/datatables.min.css"/>
	<link rel="stylesheet" href="css/bootstrap-xl-xxl.css">
	<link rel="stylesheet" href="css/font-awesome.min.css">
	<link rel="stylesheet" href="css/ionicons.min.css">
	<link rel="stylesheet" href="css/AdminLTE.min.css">
	<link rel="stylesheet" href="css/skin-blue-light.min.css">
	<link rel="stylesheet" href="css/custom1.0.0.css">
	<link rel="stylesheet" href="css/toastr.min.css">
	<link rel="stylesheet" href="css/bootstrap-datepicker.min.css">
	<link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">
	<?php $sistema->layout->criar_meta_tags();?>
	<?php $sistema->layout->exibir_css_indicacao();?>
</head>

<body class="hold-transition skin-blue-light sidebar-mini <?php if($sistema->usuario->sidebar) {echo "sidebar-collapse"; }?>">
<!-- Google Tag Manager (noscript) -->
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-T9DQW4X"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
<!-- End Google Tag Manager (noscript) -->
<div class="modal fade" id="modal-sistema"><div class="modal-dialog modal-lg"><div class="modal-content" id="modal-sistema-conteudo"></div></div></div>
<?php $sistema->layout->exibir_modal_adicionar_indicado();?>
<div class="wrapper">
	<?php $sistema->layout->exibir_cabecalho('transferencia');?>

	<div class="content-wrapper">
		<!-- Content Header (Page header) -->
		<section class="content-header">
			<h1>
			Transferência
			<small>Transfira seus bônus para outros usuários</small>
			</h1>
			<ol class="breadcrumb">
				<li><a href="transferencia"><i class="fa green-text fa-exchange"></i> Transferência </a></li>
			</ol>
		</section>

		<section class="content container-fluid">
			<div class="row">
				<?php if(isset($_SESSION['errotransferencia'])) { ?>
				<div class="col-xs-12"><div class="alert alert-danger alert-dismissible">
					<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
					<?php
					switch($_SESSION['errotransferencia']){
						case 0:
							echo 'A senha de transferência digitada está incorreta!';
							break;
						case 1:
							echo 'A transferência não foi completada devido a um erro no servidor!';
							break;
						case 2:
							echo 'O seu saldo não é suficiente para fazer a transferência solicitada!';
							break;
						case 3:
						case 4:
							if($sistema->indicacoes->text_cpf_cnpj_alternativo){
								echo $sistema->indicacoes->text_cpf_cnpj_alternativo.' Incorreto';
							} else {
								echo 'CPF Incorreto';
							}
							break;
						case 5:
							echo 'O valor não pode ser vazio!';
							break;
					}
					?>
				</div></div>
				<?php unset($_SESSION['errotransferencia']); } ?>
				<?php if(isset($_SESSION['transferenciasucesso'])) { ?>
				<div class="col-xs-12"><div class="alert alert-success alert-dismissible">
					<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
					<?php
					switch($_SESSION['transferenciasucesso']){
						case 0:
							echo "Transferência realizada com sucesso!";
							break;
					}
					?>
				</div></div>
				<?php unset($_SESSION['transferenciasucesso']); } ?>
				<div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-xs-12">
					<div class="info-box">
						<span class="info-box-icon bg-green"><i class="fa fa-gift"></i></span>
						<div class="info-box-content">
							<span class="info-box-text"><?php echo $sistema->indicacoes->vocabulario[5]; ?></span>
							<span class="info-box-number"><?php echo $saldo; ?></span>
						</div>
					</div>
				</div>
				<div class="col-xs-12">
					<form action="action/transferir_saldo" method="post" onsubmit="return validarForm();" enctype="multipart/form-data">
					<div class="box">
						<div class="box-header with-border">
							Digite abaixo os dados da transferência.
          				</div>
          				<div class="box-body">
          					
							<div class="row">
								<div class="col-xs-12 col-md-6 col-lg-3 col-xl-2">
									<div class="form-group">
										<label><?php 
											if($sistema->indicacoes->text_cpf_cnpj_alternativo){echo $sistema->indicacoes->text_cpf_cnpj_alternativo;}
											else { if ($sistema->indicacoes->permissao_cnpj_indicador == "1") { echo "CPF ou CNPJ"; } else { echo "CPF"; }}
											?> de Destino:</label>
										<div class="input-group">
											<div class="input-group-addon"><i class="fa fa-user"></i></div>
											<input id="usuario" name="usuario" type="text" class="form-control" alt="Usuário" onkeydown='mascaraMutuario(this,cpfCnpj)' onchange='mascaraMutuario(this,cpfCnpj)' required>
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-md-6 col-lg-3 col-xl-2">
									<div class="form-group">
										<label>Valor:</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-gift"></i>
											</div>
											<input type="text" class="form-control pull-right" name="valor" id="valor" required>
										</div>
									</div>
								</div>
								<div class="col-xs-12 col-md-6 col-lg-3 col-xl-2">
									<div class="form-group">
										<label>Senha de Transferência:</label>
										<div class="input-group date">
											<div class="input-group-addon">
												<i class="fa fa-lock"></i>
											</div>
											<input type="password" class="form-control pull-right" name="senha" id="senha" required>
										</div>
									</div>
								</div>
							</div>
          				</div>
          				<div class="box-footer">
  							<button type="submit" class="btn btn-primary text-center" >Realizar Transferência</button>
  						</div>
          			</div>
          			</form>
				</div>
			</div>
		</section>
	</div>
	<?php $sistema->layout->exibir_rodape();?>
</div>

<script src="js/bootstrap.min.js"></script>
<script src="js/adminlte.min.js"></script>
<script src="js/toastr.min.js"></script>
<script src="js/basico-transferencia"></script>

</body>
</html>