<?php 
header("Content-type: text/javascript");
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

if (session_status() == PHP_SESSION_NONE) {
    require_once(__DIR__ . "/../classes/Sistema.php");
	set_sistema(Sistema::WIN7);
	$sistema = new Sistema();
	
	if(!$sistema->sessao->logado()) {
		echo "window.location.href = './';";
		exit;
	}
}
?>

$('.datepicker').datepicker({
	format: 'dd/mm/yyyy',
	endDate: '0d',
	autoclose: true,
	language: 'pt-BR'
});

$('.datepicker').mask('00/00/0000');

$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
$('#tabelaCampanhas').html('<table id="tbCampanhas" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
$('#tbCampanhas').dataTable({
	"data": [],
	"order": [[ 2, 'desc' ]],
	"columns": [{ "title": "Nome da Campanha"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "Cliques Inválidos"},{ "title": "% Acessos / Anúncios"},{ "title": "% em primeira Posição"},{ "title": "% entre os 4 primeiros"},{ "title": "Custo Por Clique"},{ "title": "Custo Total"}],
	"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
	responsive: true
});

<?php if($sistema->usuario->permissao_pausar_campanhas != Usuario::PERM_NENHUMA) { ?>
var opcaoSelecionada = 0;
var idSelecionado = 0;
var nomeSelecionado = "";

$("#botao-confirmacao").click(function() {
	processar_status_campanha();
});

function processar_status_campanha(){
	var dados = "id="+idSelecionado;
	var endereco = "",textoSucesso = "",editar="";
	if(opcaoSelecionada == 0){
		endereco = "action/salvar_modal_resumir_campanha";
		textoSucesso = "Campanha resumida com sucesso!";
		editar = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='abrir_modal_pausar("+idSelecionado+", \""+nomeSelecionado+"\")' class='btn btn-default text-blue' title='Clique para pausar a campanha.'><i class='fa fa-pause'></i></a></div>";
	}
	else{
		endereco = "action/salvar_modal_pausar_campanha";
		textoSucesso = "Campanha pausada com sucesso!";
		editar = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='abrir_modal_resumir("+idSelecionado+", \""+nomeSelecionado+"\")' class='btn btn-default text-green' title='Clique para resumir a campanha.'><i class='fa fa-play'></i></a></div>";
	}
	jQuery.ajax({
		type: "POST",
		url: endereco,
		data: dados,
		success: function(data){
			$('.preloader').css({display:"none"});
			if(data == '-1') {window.location.href = "./"; return;}
			if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
			$('#modal-confirmacao').modal('hide');
			var table = $('#tbCampanhas').DataTable();
			var tableRow = table.row(".id"+idSelecionado);
			var rowData = tableRow.data();
			if (rowData == null){
				return;
			}
			rowData[rowData.length-2] = editar;
			tableRow.data(rowData);
			tableRow.invalidate();
			table.draw(false);
			toastr.clear(); toastr.success(textoSucesso); return;
		},
		beforeSend: function(){
			$('.preloader').css({display:"block"});
		},
		complete: function(){
			$('.preloader').css({display:"none"});
		},
		error: function(){
			$('.preloader').css({display:"none"});
			toastr.clear(); toastr.error("Houve um erro ao tentar fazer a alteração."); return;
		}
	});
}

function abrir_modal_pausar(idCampanha, nomeCampanha){
	$('#conteudo-confirmacao').html("Tem certeza de que deseja pausar a campanha \""+nomeCampanha+"\"?")
	opcaoSelecionada = 1;
	idSelecionado = idCampanha;
	nomeSelecionado = nomeCampanha;
	$('#modal-confirmacao').modal();
}

function abrir_modal_resumir(idCampanha, nomeCampanha){
	$('#conteudo-confirmacao').html("Tem certeza de que deseja resumir a campanha \""+nomeCampanha+"\"?")
	opcaoSelecionada = 0;
	idSelecionado = idCampanha;
	nomeSelecionado = nomeCampanha;
	$('#modal-confirmacao').modal();
}

<?php } ?>

var ultimosDados = null;

function carregar_dados(){
	$(document).ready(function() {
		var dados = jQuery('#formCampanhas').serialize();
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_campanhas",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				var json = JSON.parse(data);
				var table_data = [];
				var dados;
				var colunas;
				var consultoria = json[0] == "1";
				ultimosDados = data;
				for (var i=1; i < json.length; i++){
					dados = json[i];
					
					var editar = dados.paused == "t" ? "<div class='btn-group'><a href= 'javascript:void(0);' onclick='abrir_modal_resumir("+dados.campaignID+", \""+dados.campaign+"\")' class='btn btn-default text-green' title='Clique para resumir a campanha.'><i class='fa fa-play'></i></a></div>" : "<div class='btn-group'><a href= 'javascript:void(0);' onclick='abrir_modal_pausar("+dados.campaignID+", \""+dados.campaign+"\")' class='btn btn-default text-blue' title='Clique para pausar a campanha.'><i class='fa fa-pause'></i></a></div>";

					let estatusCampanha = dados.campaignState === 'enabled' ? 'Ativa' : 'Pausada' ;

					if(consultoria)
						table_data[i-1] = ["",dados.campaign, dados.impressions, dados.clicks, dados.invalid, dados.ctr, dados.imprAbsTop+"%", dados.imprTop+"%", dados.avgCPC, dados.cost<?php if($sistema->usuario->permissao_pausar_campanhas != Usuario::PERM_NENHUMA) { ?>, estatusCampanha, editar<?php } ?>,dados.campaignID];
					else
						table_data[i-1] = ["",dados.campaign, dados.impressions, dados.clicks, dados.invalid, dados.ctr, dados.imprAbsTop+"%", dados.imprTop+"%"<?php if($sistema->usuario->permissao_pausar_campanhas != Usuario::PERM_NENHUMA) { ?>, estatusCampanha, editar<?php } ?>,dados.campaignID];
				}
				if(consultoria)
					colunas = [
						{},{ "title": "Nome da Campanha", "responsivePriority": 1},{ "title": "Qnt. Anúncios", "responsivePriority": 3},{ "title": "Acessos ao site", "responsivePriority": 4},{ "title": "Cliques Inválidos", "responsivePriority": 5},{ "title": "% Acessos / Anúncios", "responsivePriority": 8},{ "title": "% em primeira Posição", "responsivePriority": 9},{ "title": "% entre os 4 primeiros", "responsivePriority": 10},{ "title": "Custo Por Clique", "responsivePriority": 11},{ "title": "Custo Total", "responsivePriority": 12} <?php if($sistema->usuario->permissao_pausar_campanhas != Usuario::PERM_NENHUMA) { ?>,{"title": "Status", "responsivePriority": 2},{"title": "Opções", "className": "table-buttons", "responsivePriority": 2}<?php } ?>
					];
				else
					colunas = [
						{},{ "title": "Nome da Campanha", "responsivePriority": 1},{ "title": "Qnt. Anúncios", "responsivePriority": 3},{ "title": "Acessos ao site", "responsivePriority": 4},{ "title": "Cliques Inválidos", "responsivePriority": 5},{ "title": "% Acessos / Anúncios", "responsivePriority": 8},{ "title": "% em primeira Posição", "responsivePriority": 9},{ "title": "% entre os 4 primeiros", "responsivePriority": 10}<?php if($sistema->usuario->permissao_pausar_campanhas != Usuario::PERM_NENHUMA) { ?>,{"title": "Status", "responsivePriority": 2},{"title": "Opções", "className": "table-buttons", "responsivePriority": 2}<?php } ?>
					];
				var qtdColunas = colunas.length;
				$(document).ready(function() {
					$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
					$('#tabelaCampanhas').html('<table id="tbCampanhas" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
					if(json.length >= 2){
						$("#tbCampanhas").append(
							$('<tfoot style="display: table-header-group;" />').append(`<tr>${colunas.map((i) => "<th></th>").join("")}</tr>`)
						);
						$('#tbCampanhas tfoot tr th').each(function (index) {
							$(this).html('<input type="text" style="width: 100%" class="form-control" placeholder="" />');
						});
					}
					$('#tbCampanhas').dataTable({
						"data": table_data,
						"order": [[ 3, 'desc' ]],
						"columns": colunas,
						"language": {
							"decimal": ",",
    					"thousands": "."
						},
						"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
						"columnDefs": [<?php if($sistema->usuario->permissao_pausar_campanhas != Usuario::PERM_NENHUMA) { ?>{"targets": colunas.length - 1, "orderable": false},<?php } ?>{className: 'control', orderable: false, targets: 0, width: "5%"}],
						initComplete: function () {
							// Apply the search
							//this.api()
							//	.columns([4,7])
							//	.every(function () {
							//		var column = this;
              //      var select = $('<select class="form-control"><option value=""></option></select>')
              //          .appendTo($(column.footer()).empty())
              //          .on('change', function () {
              //              var val = $.fn.dataTable.util.escapeRegex($(this).val());
              //              column.search(val ? '^' + val + '$' : '', true, false).draw();
              //          });
              //      column
              //          .data()
              //          .unique()
              //          .sort()
              //          .each(function (d, j) {
              //              select.append('<option value="' + d + '">' + d + '</option>');
              //          });
							//		var that = this;
							//		$('input', this.footer()).on('keyup change clear', function () {
							//			if (that.search() !== this.value) {
							//				that.search(this.value).draw();
							//			}
							//		});
							//		
							//	});
							this.api()
								.columns([0,1,2,3,4,5,6,7,8,9,10])
								.every(function () {
									var that = this;
									$('input', this.footer()).on('keyup change clear', function () {
										if (that.search() !== this.value) {
											that.search(this.value).draw();
										}
									});
								});
						},
						responsive: {
						    details: {
						    	type: 'column',
						        display: $.fn.dataTable.Responsive.display.modal( {
						            header: function ( row ) {
						                return '<span style="margin-right: 10px"><b>Dados da Campanha</b></span>';
						            }
						        } ),
						        renderer: function ( api, rowIdx, columns ) {
						        	text = "";
						        	<?php if($sistema->usuario->permissao_pausar_campanhas != Usuario::PERM_NENHUMA) { ?>text += columns[qtdColunas - 2].data + "<br>";<?php } ?>
						        	for(i = 0;i < columns.length;i++){
						        		column = columns[i];
						        		<?php if($sistema->usuario->permissao_pausar_campanhas != Usuario::PERM_NENHUMA) { ?>if(i == qtdColunas - 2) { continue; }<?php } ?>
						        		if(i > 0) text += "<br>";
						        		text += "<b>" + column.title + ": </b>" + column.data;
						        	}
						        	return text;
						        }
						    }
						},
						<?php if($sistema->usuario->permissao_pausar_campanhas != Usuario::PERM_NENHUMA) { ?>"createdRow": function ( row, data, index ) {
							$(row).addClass("id"+data[data.length-1]);
						},<?php } ?>
						"deferRender": true
					});
				});
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
			}
		});
	});
}

function isJsonString(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}

function carregar_excel(){
	if(ultimosDados == null || isJsonString(ultimosDados) == false){
		$('.preloader').css({display:"none"});
		toastr.clear(); toastr.error("Não há dados para baixar."); return;
		return;
	}
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			carregar_excel_2();
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		carregar_excel_2();
	}
}

function carregar_excel_2(){
	$(document).ready(function() {
		var formData = new FormData(document.getElementById('formCampanhas'));
		formData.append("json", ultimosDados);
		jQuery.ajax({
			type: "POST",
			url: "action/baixar_campanhas_validar",
			data: formData,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				window.location.href = "./action/baixar_campanhas";
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao baixar."); return;
			},
			cache: false,
	        contentType: false,
	        processData: false
		});
	});
}

function atualizar(){
	var valor = $('#data').val();
	if(valor == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	else{
		$('.datadiv').addClass("hide");
		carregar_dados();
		salvarFiltro(valor,'','');
	}
}

pegarFiltro(function(filtro,data1,data2){
	$('#data').val(filtro);
	$('#datainicial').val(data1);
	$('#datafinal').val(data2);
	if(filtro == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	carregar_dados();
});

$('#data, #switch').change(function(){ atualizar(); });
$('#datapersonalizada').click(function(){
	salvarFiltro($('#data').val(),$('#datainicial').val(),$('#datafinal').val());
	carregar_dados();
});