$('.datepicker').datepicker({
	format: 'dd/mm/yyyy',
	endDate: '0d',
	autoclose: true,
	language: 'pt-BR'
});

$('.datepicker').mask('00/00/0000');

$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
$('#tabelaGrupos').html('<table id="tbGrupos" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
$('#tbGrupos').dataTable({
	"data": [],
	"order": [[ 2, 'desc' ]],
	"columns": [{ "title": "Nome do Grupo"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "Contatos recebidos"},{ "title": "% Contatos / Acessos"},{ "title": "% Acessos / Anúncios"},{ "title": "Posição Média"},{ "title": "Opções"}],
	"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
	"columnDefs": [{"targets": 7, "orderable": false}],
	responsive: true
});

function abrir_palavras(id, nome){
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			abrir_palavras_2(id, nome);
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		abrir_palavras_2(id, nome);
	}
}

function abrir_palavras_2(id, nome){
	$(document).ready(function(){
		jQuery.ajax({
			type: "POST",
			url: "action/abrir_palavras",
			data: {'id' : id, 'nome' : nome},
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				if(data == '-3') {window.location.href = "./palavras"; return;}
				toastr.clear(); toastr.error(data.substring(2)); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao carregar as palavras-chave."); return;
			}
		});
	});
}

var ultimosDados = null;

function carregar_dados(){
	$(document).ready(function() {
		var dados = jQuery('#formGrupos').serialize();
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_grupos",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				var json = JSON.parse(data);
				var table_data = [];
				var dados;
				var colunas;
				var consultoria = json[0] == "1";
				ultimosDados = data;
				for (var i=1; i < json.length; i++){
					dados = json[i];
					var opcao = "<div class='btn-group'><a href= 'javascript:void(0);' onclick='abrir_palavras("+dados.adGroupID+", \""+dados.adGroup+"\");' class='btn btn-default text-orange' title='Clique para ver as palavras-chave.'><i class='fa fa-list'></i></a></div>";
					if(consultoria)
						table_data[i-1] = ["",dados.adGroup, dados.impressions, dados.clicks, dados.convertedClicks, dados.clickConversionRate, dados.ctr, dados.avgPosition, dados.avgCPC, dados.cost,opcao];
					else
						table_data[i-1] = ["",dados.adGroup, dados.impressions, dados.clicks, dados.convertedClicks, dados.clickConversionRate, dados.ctr, dados.avgPosition,opcao];
				}
				if(consultoria)
					colunas = [
						{},{ "title": "Nome do Grupo"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "Contatos recebidos"},{ "title": "% Contatos / Acessos"},{ "title": "% Acessos / Anúncios"},{ "title": "Posição Média"},{ "title": "Custo Por Clique"},{ "title": "Custo Total"},{ "title": "Opções", "className": "table-buttons"}
					];
				else
					colunas = [
						{},{ "title": "Nome do Grupo"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "Contatos recebidos"},{ "title": "% Contatos / Acessos"},{ "title": "% Acessos / Anúncios"},{ "title": "Posição Média"},{ "title": "Opções", "className": "table-buttons"}
					];
				var max_colunas = colunas.length - 1;
				$(document).ready(function() {
					$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
					$('#tabelaGrupos').html('<table id="tbGrupos" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
					$('#tbGrupos').dataTable({
						"data": table_data,
						"order": [[ 3, 'desc' ]],
						"columns": colunas,
						"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
						"columnDefs": [{"targets": colunas.length - 1, "orderable": false}, {className: 'control', orderable: false, targets: 0, width: "5%"}],
						responsive: {
						    details: {
						    	type: 'column',
						        display: $.fn.dataTable.Responsive.display.modal( {
						            header: function ( row ) {
						                return '<span style="margin-right: 10px"><b>Dados do Grupo</b></span>';
						            }
						        } ),
						        renderer: function ( api, rowIdx, columns ) {
						        	text = "";
						        	text += columns[columns.length-1].data + "<br>";
						        	for(i = 0;i < columns.length;i++){
						        		column = columns[i];
						        		if(i == columns.length - 1) { continue; }
						        		if(i > 0) text += "<br>";
						        		text += "<b>" + column.title + ": </b>" + column.data;
						        	}
						        	return text;
						        }
						    }
						},
						"deferRender": true
					});
				});
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
			}
		});
	});
}

function atualizar(){
	var valor = $('#data').val();
	if(valor == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	else{
		$('.datadiv').addClass("hide");
		carregar_dados();
		salvarFiltro(valor,'','');
	}
}

function isJsonString(str) {
    try {
        JSON.parse(str);
    } catch (e) {
        return false;
    }
    return true;
}

function carregar_excel(){
	if(ultimosDados == null || isJsonString(ultimosDados) == false){
		$('.preloader').css({display:"none"});
		toastr.clear(); toastr.error("Não há dados para baixar."); return;
		return;
	}
	if($('.dtr-bs-modal').hasClass("in")){
		$('.dtr-bs-modal').one('hidden.bs.modal', function () {
			carregar_excel_2();
		});
		$('.dtr-bs-modal').modal('hide');
	}
	else{
		carregar_excel_2();
	}
}

function carregar_excel_2(){
	$(document).ready(function() {
		var formData = new FormData($('#formGrupos'));
		formData.append("json", ultimosDados);
		jQuery.ajax({
			type: "POST",
			url: "action/baixar_grupos_validar",
			data: formData,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				window.location.href = "./action/baixar_grupos";
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao baixar."); return;
			},
			cache: false,
	        contentType: false,
	        processData: false
		});
	});
}

pegarFiltro(function(filtro,data1,data2){
	$('#data').val(filtro);
	$('#datainicial').val(data1);
	$('#datafinal').val(data2);
	if(filtro == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	carregar_dados();
});

$('#data, #switch').change(function(){ atualizar(); });
$('#datapersonalizada').click(function(){
	salvarFiltro($('#data').val(),$('#datainicial').val(),$('#datafinal').val());
	carregar_dados();
});