$('.datepicker').datepicker({
	format: 'dd/mm/yyyy',
	endDate: '0d',
	autoclose: true,
	language: 'pt-BR'
});

$('.datepicker').mask('00/00/0000');

$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
$('#tabelaPalavras').html('<table id="tbPalavras" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
$('#tbPalavras').dataTable({
	"data": [],
	"order": [[ 2, 'desc' ]],
	"columns": [{"title": "Palavras-chave"},{"title": "Qnt. Anúncios"},{"title": "Acessos ao site"},{"title": "Contatos recebidos"},{"title": "% Contatos / Acessos"},{"title": "% Acessos / Anúncios"},{"title": "Posição Média"}
	],
	"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
	responsive: true
});

function carregar_dados(){
	$(document).ready(function() {
		var dados = jQuery('#formPalavras').serialize();
		jQuery.ajax({
			type: "POST",
			url: "action/atualizar_palavras",
			data: dados,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				var json = JSON.parse(data);
				var table_data = [];
				var dados;
				var colunas;
				var consultoria = json[0] == "1";
				for (var i=1; i < json.length; i++){
					dados = json[i];
					if(consultoria)
						table_data[i-1] = ["",dados.keyword, dados.impressions, dados.clicks, dados.convertedClicks, dados.clickConversionRate, dados.ctr, dados.avgPosition, dados.avgCPC, dados.cost];
					else
						table_data[i-1] = ["",dados.keyword, dados.impressions, dados.clicks, dados.convertedClicks, dados.clickConversionRate, dados.ctr, dados.avgPosition];
				}
				if(consultoria)
					colunas = [
						{},{ "title": "Palavras-chave"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "Contatos recebidos"},{ "title": "% Contatos / Acessos"},{ "title": "% Acessos / Anúncios"},{ "title": "Posição Média"},{ "title": "Custo Por Clique"},{ "title": "Custo Total"}
					];
				else
					colunas = [
						{},{ "title": "Palavras-chave"},{ "title": "Qnt. Anúncios"},{ "title": "Acessos ao site"},{ "title": "Contatos recebidos"},{ "title": "% Contatos / Acessos"},{ "title": "% Acessos / Anúncios"},{ "title": "Posição Média"}
					];
				$(document).ready(function() {
					$.fn.dataTable.moment( 'DD/MM/YYYY HH:mm:ss');
					$('#tabelaPalavras').html('<table id="tbPalavras" style="width: 100%;" class="table table-striped table-bordered dataTable no-footer cell-border nowrap responsive compact"></table>');
					$('#tbPalavras').dataTable({
						"data": table_data,
						"order": [[ 3, 'desc' ]],
						"columns": colunas,
						"columnDefs": [{className: 'control', orderable: false, targets: 0, width: "5%"}],
						"lengthMenu": [[25, 50, 100, -1], ["25","50","100", "todas"]],
						responsive: {
						    details: {
						    	type: 'column',
						        display: $.fn.dataTable.Responsive.display.modal( {
						            header: function ( row ) {
						                return '<span style="margin-right: 10px"><b>Dados das Palavras-chave</b></span>';
						            }
						        } ),
						        renderer: function ( api, rowIdx, columns ) {
						        	text = "";
						        	for(i = 0;i < columns.length;i++){
						        		column = columns[i];
						        		if(i > 0) text += "<br>";
						        		text += "<b>" + column.title + ": </b>" + column.data;
						        	}
						        	return text;
						        }
						    }
						},
						"deferRender": true
					});
				});
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao atualizar"); return;
			}
		});
	});
}

function atualizar(){
	var valor = $('#data').val();
	if(valor == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	else{
		$('.datadiv').addClass("hide");
		carregar_dados();
		salvarFiltro(valor,'','');
	}
}

pegarFiltro(function(filtro,data1,data2){
	$('#data').val(filtro);
	$('#datainicial').val(data1);
	$('#datafinal').val(data2);
	if(filtro == "CUSTOM_DATE")
		$('.datadiv').removeClass("hide");
	carregar_dados();
});

$('#data, #switch, #grupo').change(function(){ atualizar(); });
$('#datapersonalizada').click(function(){
	salvarFiltro($('#data').val(),$('#datainicial').val(),$('#datafinal').val());
	carregar_dados();
});