<?php
/*
 * Este arquivo é responsável por montar a modal que serve para editar o contato especificado.
 */

require_once(__DIR__ . "/../classes/Sistema.php");
require_once(__DIR__ . "/../classes/Sistema_Win7Fone.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_3cx == Usuario::PERM_NENHUMA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$sistema_win7fone = new Sistema_Win7Fone($sistema->usuario->id, $sistema->bd);
}
catch(EcxServerException $e){
	echo "-2".$e->getMessage();
	exit;
}

$resultado = $sistema_win7fone->obter_ligacao($_POST['id']);
if($resultado == -1){
	echo "-2ID Inválida";
	exit;
}
?>
<div class="modal-header">
	<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
	<span aria-hidden="true">&times;</span></button>
	<h4 class="modal-title"><b>Dados da Ligação</b></h4>
</div>
<div class="modal-body">
	<div class="row">
	<?php foreach($resultado as $caminho) { ?>
	<div class="col-xs-12 col-sm-6 col-md-4"><div class="panel panel-default caixas-segmento" style="display: none;"><div class="panel-heading">Caminho <?php echo $caminho['ordem']; ?><?php if(!empty($caminho['audio']) & file_exists($caminho['caminho-audio-absoluto'])) { ?><a href= '<?php echo "./action/recording?dl=". urlencode($caminho['caminho-audio']); ?>' class="text-green" title="Clique para fazer download da gravação"><i class='fa fa-download pull-right' style="font-size: 23px;"></i></a>
			<div id="jquery_jplayer_<?php echo $caminho['ordem']; ?>" class="jp-jplayer"></div>
			<div id="jp_container_<?php echo $caminho['ordem']; ?>" class="jp-audio" role="application" aria-label="media player">
				<div class="jp-type-single">
					<div class="jp-gui jp-interface">
						<div class="jp-controls-holder">
							<div class="jp-controls">
								<button class="jp-play" role="button" tabindex="0">play</button>
							</div>
						</div>
					</div>
					<div class="jp-no-solution">
						<span>Atualização Necessária</span>
						Para reproduzir essa gravação, é necessário atualizar seu browser ou baixar a <a href="http://get.adobe.com/flashplayer/" target="_blank">Plugin Flash</a>.
					</div>
				</div>
			</div>
			<script type="text/javascript">
			$(document).ready(function(){
			  $("#jquery_jplayer_<?php echo $caminho['ordem']; ?>").jPlayer({
				ready: function () {
				  $(this).jPlayer("setMedia", {
					title: "Gravação",
					mp3: "<?php echo "./action/recording?d=". urlencode($caminho['caminho-audio']); ?>"
				  });
				},
				cssSelectorAncestor: "#jp_container_<?php echo $caminho['ordem']; ?>",
				swfPath: "./js/jquery.jplayer.swf",
				solution:"flash,html",
				supplied: "mp3",
				useStateClassSkin: true,
				autoBlur: false,
				smoothPlayBar: false,
				keyEnabled: true,
				remainingDuration: true,
				toggleDuration: true
			  });
			});
			</script>
		<?php }?></div>

		<div class="panel-body"><div class="row">
			<div class="col-xs-12">
				<p><b>Origem:</b> <?php echo $caminho['origem']; ?><br><b>Destino:</b> <?php echo $caminho['destino']; ?><br><?php echo $caminho['atendida']; ?></p>
			</div>
			<div class="col-xs-12">
				<p><b>Tempo de Espera:</b> <?php echo $caminho['espera']; ?><br><b>Duração da Chamada:</b> <?php echo $caminho['duracao']; ?></p>
			</div>
			<div class="col-xs-12">
				<p><?php echo $caminho['resultado']; ?></p>
			</div>
		</div></div>
	</div></div>
	<?php } ?>
	</div>





</div>
<div class="modal-footer">
	<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
</div>
<div class="overlay preloader">
	<i class="fa fa-refresh fa-spin"></i>
</div>