<?php
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes == Usuario::PERM_NENHUMA || $sistema->indicacoes->usa_pontos != "1") {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$sql = "SELECT * FROM TBL_INDICACOES_PRODUTOS WHERE NU_ID = :id AND ID_CLIENTE_FK = :id2 AND NU_DELETADO = 0";
	$params = array(
		':id' => $_POST['id'],
		':id2' => $sistema->usuario->id
	);
	$premio = $sistema->bd->executar($sql, $params, Banco_Dados::FETCH);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado, ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	$nome = $premio['TXT_NOME'];
	$estoque = $premio['NU_ESTOQUE'];
	$pontos = $premio['NU_PONTOS'];
	$descricao = $premio['TXT_DESCRICAO'];
	$imagem = $premio['TXT_IMAGEM'];
	$link = "https://" . $sistema->indicacoes->dominio . "/arquivos/". $imagem;
	$estoque_infinito = $premio['NU_ESTOQUE_INFINITO'] == "0" ? "" : "checked='checked'";
	$resgate_normal = $premio['NU_RESGATE_NORMAL'] == "0" ? "" : "checked='checked'";
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<form action="" method="POST" id="formPremioModal">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Editar Prêmio:</b> <?php echo $nome; ?></h4>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12"><div class="form-group">
				<div class="checkbox">
					<label>
						<input type="checkbox" name="estoqueinfinito" id="estoqueinfinito" value="Sim" <?php echo $estoque_infinito;?>>
						Não limitar estoque&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					</label>
					<label>
						<input type="checkbox" name="resgatenormal" id="resgatenormal" value="Sim" <?php echo $resgate_normal;?>>
						Resgate apenas por pontos normais&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					</label>
				</div>
			</div></div>
		</div>
		<div class="row">
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Nome:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-user"></i></div>
					<input type="text" class="form-control pull-right"  id="nome" name="nome" alt="Nome" maxlength="20" value="<?php echo $nome;?>" <?php if($sistema->usuario->permissao_indicacoes == Usuario::PERM_LEITURA){echo "readonly"; } ?> required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Estoque:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-cube"></i></div>
					<input type="text" class="form-control pull-right numero"  id="estoque" name="estoque" alt="Estoque" value="<?php echo $estoque;?>" <?php if($sistema->usuario->permissao_indicacoes == Usuario::PERM_LEITURA || $premio['NU_ESTOQUE_INFINITO'] == "1"){echo "readonly"; } ?> required/>
				</div>
			</div></div>
			<div class="col-xs-12 col-sm-6 col-md-4"><div class="form-group">
				<label>Pontos:</label>
				<div class="input-group">
					<div class="input-group-addon"><i class="fa fa-gift"></i></div>
					<input type="text" class="form-control pull-right numero"  id="pontos" name="pontos" alt="Pontos" value="<?php echo $pontos;?>" <?php if($sistema->usuario->permissao_indicacoes == Usuario::PERM_LEITURA){echo "readonly"; } ?> required/>
				</div>
			</div></div>
			<div class="col-xs-12"><div class="form-group">
				<label for="exampleInputFile">Imagem do Prêmio (130 x 130, max 512kb):</label><br>
				<img src="<?php echo $link; ?>" style="margin-bottom: 5px; width: 50px;">
				<input type="file" id="imagem" name="imagem">
			</div></div>
		</div>
		<div class="row">
			<div class="col-xs-12"><div class="form-group">
				<label>Descrição:</label>
				<textarea name="descricao" id="descricao" class="form-control" rows="3" <?php if($sistema->usuario->permissao_indicacoes == Usuario::PERM_LEITURA){echo "readonly"; } ?> required><?php echo $descricao;?></textarea>
			</div></div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
		<?php if($sistema->usuario->permissao_indicacoes == Usuario::PERM_ESCRITA){ ?><button type="submit" name="action" class="btn btn-primary">Salvar Prêmio</button><?php } ?>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>

<script>
$('#estoqueinfinito').on( "change", function(){
	if(document.getElementById('estoqueinfinito').checked){
		$("#estoque").prop("readonly", true);
		$("#estoque").prop("required", false);
	}
	else{
		$("#estoque").prop("readonly", false);
		$("#estoque").prop("required", true);
	}
});
$(document).ready(function(){
	$('#formPremioModal').submit(function(e){
		e.preventDefault();
		var arquivo = $('#imagem');

		if(arquivo.val() != ''){
			var fileName = arquivo.prop("files")[0].name;
			var extension = fileName.substr( (fileName.lastIndexOf('.') +1) );

			if(extension != "jpg" && extension != "jpeg" && extension != "png"){
				toastr.clear(); toastr.error("Por favor, selecione uma imagem válida."); return;
				return false;
			}
			
			if(arquivo.prop("files")[0].size > 1024 * 512){
				toastr.clear(); toastr.error("O tamanho máximo da imagem é 512kb."); return;
				return false;
			}
		}

		var formData = new FormData(this);
		formData.append('id', <?php echo $_POST['id']; ?>);
		jQuery.ajax({
			type: "POST",
			url: "action/salvar_modal_premio",
			data: formData,
			success: function(data){
				$('.preloader').css({display:"none"});
				if(data == '-1') {window.location.href = "./"; return;}
				if(data.substring(0,2) == "-2") {toastr.clear(); toastr.error(data.substring(2)); return;}
				fechar_modal();
				atualizar_linhas(JSON.parse(data));
				toastr.clear(); toastr.success("Prêmio salvo com sucesso."); return;
			},
			beforeSend: function(){
				$('.preloader').css({display:"block"});
			},
			complete: function(){
				$('.preloader').css({display:"none"});
			},
			error: function(){
				$('.preloader').css({display:"none"});
				toastr.clear(); toastr.error("Houve um erro ao salvar prêmio."); return;
			},
			cache: false,
	        contentType: false,
	        processData: false
		});
		return false;
	});
});
$('.numero').mask('000000000000');
</script>