<?php
/*
 * Este arquivo é responsável por atualizar a página de "Gráfico Geral" do sistema.
 * Para isso, ele faz uma pesquisa dos dados gerais do adwords usando a API, e os prepara
 * para serem colocados no gráfico, emitindo um JSON ao final.
 */

use Win7\Ads\Repository\CampaignRepository;
use Win7\App;

require_once(__DIR__ . "/../classes/Sistema.php");
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às campanhas do google
if ($sistema->usuario->permissao_google == Usuario::PERM_NENHUMA) {
    echo "-2Permissão insuficiente para ver esta página!";
    exit;
}

// Validamos aqui se o filtro de pesquisa está correto
if (!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])) {
    echo "-2Filtro de pesquisa inválido";
    exit;
}

/* Esvazia-se as datas customizadas caso o filtro não seja personalizado */
if ($_POST['data'] != "CUSTOM_DATE") {
    $_POST['datainicial'] = "";
    $_POST['datafinal']   = "";
}

try {
    if ($sistema->usuario->tem_adwords()) { // Verificamos se o cliente tem adwords configurado
        App::initialize();
        $repository = App::getContainer()->get(CampaignRepository::class);
        $periodo    = $_POST['periodo'];

        switch ($periodo) {
            case "semanalmente":
                $rows = $repository->getWeeklyCustomerMetrics($sistema->get_filtro_ads());
                break;
            case "mensalmente":
                $rows = $repository->getMonthlyCustomerMetrics($sistema->get_filtro_ads());
                break;
            default:
                $rows = $repository->getDailyCustomerMetrics($sistema->get_filtro_ads());
        }

        $resultado = [];

        foreach ($rows as $row) {
            $metrics = $row['metrics'];

            switch ($periodo) {
                case "semanalmente":
                    $periodo_data = $row['segments']['week'];
                    break;
                case "mensalmente":
                    $periodo_data = $row['segments']['month'];
                    break;
                default:
                    $periodo_data = $row['segments']['date'];
            }

            if (!array_key_exists($periodo_data, $resultado)) {
                $resultado[$periodo_data] = [
                    "impressions"     => 0,
                    "clicks"          => 0,
                    "invalid"         => 0,
                    "convertedClicks" => 0,
                    "convRate"        => 0.0,
                    "ctr"             => 0.0,
                    "qtd"             => 0,
                ];

                if ($sistema->usuario->consultoria) {
                    $resultado[$periodo_data]['avgCPC'] = 0.0;
                    $resultado[$periodo_data]['cost']   = 0.0;
                }
            }

            $resultado[$periodo_data]["qtd"]             = $resultado[$periodo_data]["qtd"] + 1;
            $resultado[$periodo_data]["impressions"]     += (int)$metrics['impressions'];
            $resultado[$periodo_data]["clicks"]          += (int)$metrics['clicks'];
            $resultado[$periodo_data]["invalidClicks"]   += (int)$metrics['invalidClicks'];
            $resultado[$periodo_data]["convertedClicks"] += (int)$metrics['conversions'];
            $resultado[$periodo_data]["convRate"]        += (float)$metrics['conversionsFromInteractionsRate'];
            $resultado[$periodo_data]["ctr"]             += (float)$metrics['ctr'];

            if ($sistema->usuario->consultoria) {
                $resultado[$periodo_data]["avgCPC"] += (int)$metrics['averageCpc'];
                $resultado[$periodo_data]["cost"]   += (int)$metrics['costMicros'];
            }
        }

        if ($periodo === 'diariamente') {
            $datas    = Filtro::filtrar_ads($_POST['data'], $_POST['datainicial'], $_POST['datafinal']);
            $begin    = new DateTime($datas[0]);
            $end      = new DateTime($datas[1]);
            $interval = DateInterval::createFromDateString('1 day');
            $period   = new DatePeriod($begin, $interval, $end);

            foreach ($period as $dt) {
                $date = $dt->format("Y-m-d");

                if (!array_key_exists($date, $resultado)) {
                    $resultado[$date] = [
                        "impressions"     => 0,
                        "clicks"          => 0,
                        "invalid"         => 0,
                        "convertedClicks" => 0,
                        "convRate"        => 0.0,
                        "ctr"             => 0.0,
                        "qtd"             => 0,
                    ];

                    if ($sistema->usuario->consultoria) {
                        $resultado[$date]['avgCPC'] = 0.0;
                        $resultado[$date]['cost']   = 0.0;
                    }
                }
            }
        }

        $resultado2 = [];
        foreach ($resultado as $key => $row) {
            $row["convRate"] = number_format($row["convRate"] / $row["qtd"], 2, '.', ',') . "%";
            $row["ctr"]      = number_format($row["ctr"] / $row["qtd"], 2, '.', ',') . "%";

            if ($sistema->usuario->consultoria) {
                $avgCPC        = floatval($row["avgCPC"]) / $row["qtd"] / 1000000;
                $avgCPC        = number_format($avgCPC, 2);
                $cost          = floatval($row["cost"]) / 1000000;
                $cost          = number_format($cost, 2);
                $row["cost"]   = $cost;
                $row["avgCPC"] = $avgCPC;
            }

            $row["period-time"] = strtotime($key);
            $row["period"]      = $key . " 0:00:00";

            $resultado2[] = $row;
        }

        $resultado = $resultado2;

        usort($resultado, function ($a, $b) {
            return $a["period-time"] - $b["period-time"];
        });

        // Adicionamos ao resultado uma flag que indicará se o cliente é de consultoria,a moeda e se é somente campanha
        array_unshift($resultado, [
            $sistema->usuario->consultoria,
            $sistema->usuario->moeda,
            $sistema->usuario->mostrar_somente_campanhas >= '1',
        ]);

        echo json_encode_alt($resultado);
    } else { // Nesse caso, o cliente não tem adwords configurado, retornamos então um resultado vazio
        echo json_encode_alt([$sistema->usuario->consultoria]);
        exit;
    }
} catch (Exception $e) {
    $sistema->adwords->tratar_excecao($e);
}
?>