<?php
/*
 * Este arquivo retorna um json com a lista de pagamento pendentes.
 */
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_indicacoes != Usuario::PERM_ESCRITA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

// Validamos aqui se o filtro de pesquisa está correto
if(!Filtro::validar($_POST['data'], $_POST['datainicial'], $_POST['datafinal'])){
	echo "-2Filtro de pesquisa inválido";
	exit;
}

try {
	$rows = $sistema->indicacoes->obter_lista_pagamentos($_POST['data'], $_POST['datainicial'], $_POST['datafinal']);
	echo json_encode_alt($rows);
}
catch (Exception $e) {
	echo "-2Houve um erro com o servidor";
	exit;
}
?>