<?php
/*
 * Este arquivo é responsável por enviar um contato especificado para a lixeira.
 */
 
require_once(__DIR__ . "/../classes/Sistema.php"); 
set_sistema(Sistema::WIN7);
$sistema = new Sistema(true, true);

// Redireciona o cliente para a home caso ele não tenha permissão de acesso às indicações
if($sistema->usuario->permissao_leads != Usuario::PERM_ESCRITA) {echo "-2Permissão insuficiente para ver esta página!"; exit;}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	$sistema->iniciar_bd_leads();

	$dados = $sistema->bd_leads->executar("SELECT * FROM TBL_LEADS WHERE ID_LEAD = :id AND ID_CLIENTE_FK = :id2", array(':id' => $_POST['id'], "id2" => $sistema->usuario->id), Banco_Dados::FETCH);

	if($sistema->bd_leads->quantidade() == 0){ // Nenhum dado foi encontrado, ID é inválida
		echo "-2ID inválida!";
		exit;
	}

	$sistema->logs->adicionar_log_delecao_contato($dados);
	
	// Faz-se o envio do contato para a lixeira aqui, setando o campo de lixeira para "1"
	$sistema->bd_leads->executar('UPDATE TBL_LEADS SET NU_LIXEIRA = :lixeira WHERE ID_LEAD = :id AND ID_CLIENTE_FK = :id2', array(
		":lixeira" => "1",
		":id" => $_POST['id'],
		":id2" => $sistema->usuario->id
	));
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>