<?php
require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!$sistema->usuario->super_adm_adm) {
	echo "-2Permissão Insuficiente";
	exit;
}

if(!ctype_digit($_POST['id'])){ // se a id não for um número retorna um erro
	echo "-2ID inválida!";
	exit;
}

try{
	/* Fazemos aqui a consulta dos dados do lead especificado */
	$dados = $sistema->logs->obter_entrada_adm($_POST['id']);

	if($sistema->bd->quantidade() == 0){ // Nenhum dado foi encontrado, ID é inválida
		echo "-2ID inválida!";
		exit;
	}
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>
<form action="" method="POST" id="formContato">
	<div class="modal-header">
		<button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
		<span aria-hidden="true">&times;</span></button>
		<h4 class="modal-title"><b>Descrição da entrada de log:</b> <?php echo $nome; ?></h4>
	</div>
	<div class="modal-body">
		<div class="row">
			<div class="col-xs-12 col-md-6" style="word-wrap: break-word;">
				<?php echo $dados['TXT_DESCRICAO']; ?>
			</div>
			<div class="col-xs-12 col-md-6" style="border-left: 1px solid #e5e5e5;">
				<b>Mais detalhes:</b><br><?php echo $dados['TXT_DETALHES']; ?>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button type="button" class="btn btn-default pull-left" data-dismiss="modal">Fechar</button>
	</div>
	<div class="overlay preloader">
		<i class="fa fa-refresh fa-spin"></i>
	</div>
</form>