<?php
/*
 * Este arquivo lê os administradores do sistema no banco de dados e envia o resultado por meio de JSON.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

if(!$sistema->usuario->super_adm_adm) {
	echo "-2Permissão Insuficiente";
	exit;
}

try{
	$params = array();
	$sql = "SELECT * FROM TBL_ADM";
	$adms = $sistema->bd->executar($sql, $params, Banco_Dados::FETCH_ALL);

	// Monta os dados que serão enviado via JSON
	$resultado = array();
	foreach($adms as $linha){
		$data_alteracao = $linha['DT_ULTIMO_LOGIN'];
		if(Utilitarios::data_padrao_valida($data_alteracao)){
			$data_alteracao = strtotime($data_alteracao);
			$data_alteracao = date('d/m/Y H:i:s', $data_alteracao);
		}
		else{
			$data_alteracao = "Nunca";
		}

		// Adiciona o cliente na array que será enviada por meio de JSON
		$resultado[] = array(
			"id" => $linha['ID_ADM'],
			"nome" => $linha['TXT_NOME'],
			"login" => $linha['TXT_LOGIN'],
			"acesso" => $data_alteracao,
			"email" => $linha['TXT_EMAIL'],
			"whatsapp" => empty($linha['TXT_WHATSAPP']) ? "Não Possui" : $linha['TXT_WHATSAPP'],
			"superadm" => $linha['NU_SUPER_ADM'] == "1" ? "Sim" : "Não"
		);
	}

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>