<?php
/*
 * Este arquivo lê os cliente da agência no banco de dados e envia o resultado por meio de JSON.
 */

require_once(__DIR__ . "/../../classes/Sistema.php"); 
set_sistema(Sistema::WIN7_ADM);
$sistema = new Sistema(true, true, false);

try{

	if (isset($_POST['apenasAtivos']) && isset($_POST['apenasImportantes'])) {
		$sql = "SELECT * FROM TBL_CLIENTE WHERE NU_CLIENTE_ATIVO = 1 AND NU_CLIENTE_IMPORTANTE = 1";

	} else if (isset($_POST['apenasAtivos'])) {
		$sql = "SELECT * FROM TBL_CLIENTE WHERE NU_CLIENTE_ATIVO = 1";

	} else if (isset($_POST['apenasImportantes'])) {
		$sql = "SELECT * FROM TBL_CLIENTE WHERE NU_CLIENTE_IMPORTANTE = 1";
		
	} else {
		$sql = "SELECT * FROM TBL_CLIENTE";
	}

	$params = array();
	// $sql = "SELECT * FROM TBL_CLIENTE";
	$adicoes = 0;

	$clientes = $sistema->bd->executar($sql, $params, Banco_Dados::FETCH_ALL);

	// Monta os dados que serão enviado via JSON
	$resultado = array();

	foreach($clientes as $linha){
		
		// Adiciona o cliente na array que será enviada por meio de JSON
		$resultado[] = array(
			"id" => $linha['ID_CLIENTE'],
			"nome" => $linha['TXT_NOME_EMPRESA'],
			"ativo" => $linha['NU_CLIENTE_ATIVO'],
			"cli_importante" => $linha['NU_CLIENTE_IMPORTANTE'],
		);
	}

	echo json_encode_alt($resultado);
}
catch(Exception $e){
	echo "-2Houve um erro com o servidor";
	exit;
}
?>